/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.balanceinv.workbench.steps.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvContext;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.MatchInfo;
import kd.scmc.im.business.balanceinv.pojo.SupplyQtyInfo;
import kd.scmc.im.business.balanceinv.pojo.SupplyRelation;
import kd.scmc.im.business.balanceinv.pojo.SupplySafeQtyInfo;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.business.balanceinv.workbench.steps.impl.AbstractBalanceInvWorkBenchStep;

public class BalanceInvWorkBenchMatchStep
extends AbstractBalanceInvWorkBenchStep {
    public static final String SPLITKEY = "$";
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private Map<Long, Integer> unitPrecisionCache = new HashMap<Long, Integer>();
    Map<Long, List<UnMatchInfo>> entryIdUnMatchMap = new HashMap<Long, List<UnMatchInfo>>();
    int matchCount = 0;
    int unMatchCount = 0;
    int demandOrder = 0;

    public BalanceInvWorkBenchMatchStep(BalanceInvContext ctx) {
        this.ctx = ctx;
    }

    public BalanceInvWorkBenchMatchStep() {
    }

    @Override
    public void innerExecute() {
        this.matchDemandAndSupply();
        this.setProcessData(this.matchCount + this.unMatchCount);
        this.addInfoMessage(String.format(ResManager.loadKDString((String)"\u5339\u914d\u6570\u636e\u91cf\uff1a%1$s\u6761\uff0c\u672a\u5339\u914d\u6570\u636e\u91cf\uff1a%2$s\u6761\u3002", (String)"BalanceInvMatchStep_0", (String)"scmc-im-business", (Object[])new Object[0]), this.matchCount, this.unMatchCount));
        this.ctx.getDemandBillCol().clear();
        this.ctx.getSupplyBillGroupedMap().clear();
        this.ctx.getEntryId2SupplyQtyMap().clear();
    }

    public void matchDemandAndSupply() {
        DynamicObjectCollection demandBills = this.ctx.getDemandBillCol();
        if (demandBills == null || demandBills.isEmpty()) {
            return;
        }
        List<String> demandNullMatchFields = this.ctx.getScheme().getDemandNullMatchFields();
        List<String> supplyNullMatchFields = this.ctx.getScheme().getSupplyNullMatchFields();
        Map demandBillGroupedMap = demandBills.stream().collect(Collectors.groupingBy(demandBill -> demandBill.getString("entryentity.flexmetricid"), Collectors.toList()));
        for (Map.Entry demandBillGroupedEntry : demandBillGroupedMap.entrySet()) {
            this.demandOrder = 0;
            List demandBillList = demandBillGroupedEntry.getValue();
            String matchKey = demandBillGroupedEntry.getKey();
            for (DynamicObject demandBill2 : demandBillList) {
                ++this.demandOrder;
                BigDecimal originDemandBaseQty = demandBill2.getBigDecimal("entryentity.demandqty");
                if (originDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                String allMatchKey = demandBill2.getString("entryentity.demandorg") + SPLITKEY + demandBill2.getString("allmatchfieldkey");
                List<DynamicObject> supplyBills = this.ctx.getSupplyNullGroupedMap().get(allMatchKey);
                if (supplyBills != null && !supplyBills.isEmpty()) {
                    for (DynamicObject supplyBill : supplyBills) {
                        BigDecimal curDemandBaseQty = this.getCurrentDemandBaseQty(demandBill2);
                        if (curDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0) break;
                        this.matchOneBill(demandBill2, supplyBill, originDemandBaseQty);
                    }
                }
                HashSet<String> supplyNullFields = new HashSet<String>();
                String demandNullMatchKey = BalanceInvWorkBenchMatchStep.getDemandNullMatchKey(demandNullMatchFields, supplyNullMatchFields, demandBill2, supplyNullFields);
                if (demandBill2.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) > 0 && !supplyNullFields.isEmpty() && (supplyBills = this.ctx.getSupplyBillGroupedMap().get(demandBill2.getString("entryentity.demandorg") + SPLITKEY + matchKey)) != null && !supplyBills.isEmpty()) {
                    for (DynamicObject supplyBill : supplyBills) {
                        BigDecimal curDemandBaseQty = this.getCurrentDemandBaseQty(demandBill2);
                        if (curDemandBaseQty.compareTo(BigDecimal.ZERO) <= 0) break;
                        String supplyNullMatchKey = this.getSupplyNullMatchKey(supplyBill, supplyNullMatchFields, supplyNullFields);
                        if (!demandNullMatchKey.equals(supplyNullMatchKey)) continue;
                        this.matchOneBill(demandBill2, supplyBill, originDemandBaseQty);
                    }
                }
                if (demandBill2.getBigDecimal("entryentity.demandqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                this.dealUnMatchBill(demandBill2, originDemandBaseQty);
            }
        }
        boolean needReserve = BalanceInvExecuteHelper.getNeedReserve();
        if (needReserve) {
            this.doReserveWithNewTx();
        }
    }

    private BigDecimal getCurrentDemandBaseQty(DynamicObject demandBill) {
        BigDecimal currentDemandQty = demandBill.getBigDecimal("entryentity.demandqty");
        long entryId = demandBill.getLong("entryentity.billentryid");
        BigDecimal pureDemandQty = this.ctx.getEntryPurDemandQtyMap().get(entryId);
        if (pureDemandQty != null) {
            currentDemandQty = currentDemandQty.subtract(pureDemandQty);
        }
        return currentDemandQty;
    }

    private void dealUnMatchBill(DynamicObject demandBill, BigDecimal originDemandBaseQty) {
        ++this.unMatchCount;
        DynamicObject unMatchResultEntry = BalanceInvExecuteHelper.addNoSupplyMatchResultEntry(demandBill, originDemandBaseQty, demandBill.getBigDecimal("entryentity.demandqty"), this.demandOrder);
        this.ctx.getMatchDetailEntries().add(unMatchResultEntry);
        BigDecimal demandQty = demandBill.getBigDecimal("entryentity.demandqty");
        UnMatchInfo unMatchInfo = BalanceInvExecuteHelper.buildUnMatchInfo(demandBill, demandQty);
        unMatchInfo.setMatchEntryInfo(unMatchResultEntry);
        this.entryIdUnMatchMap.putIfAbsent(unMatchInfo.getEntryId(), new ArrayList());
        this.entryIdUnMatchMap.get(unMatchInfo.getEntryId()).add(unMatchInfo);
        BalanceInvExecuteHelper.getGroupedUnMatchInfoWithAdviseType("pm_requirapplybill", this.entryIdUnMatchMap);
    }

    private static String getDemandNullMatchKey(List<String> demandNullMatchFields, List<String> supplyNullMatchFields, DynamicObject demandBill, Set<String> supplyNullFields) {
        StringBuilder nullMatchBuilder = new StringBuilder();
        for (int i = 0; i < demandNullMatchFields.size(); ++i) {
            String field = demandNullMatchFields.get(i);
            Object value = BalanceInvExecuteHelper.getValue(demandBill, field);
            if (value == null || StringUtils.isEmpty((String)value.toString()) || value instanceof Long && (Long)value == 0L) {
                supplyNullFields.add(supplyNullMatchFields.get(i));
                nullMatchBuilder.append("null");
            } else {
                nullMatchBuilder.append(demandBill.getString(field));
            }
            nullMatchBuilder.append(SPLITKEY);
        }
        return nullMatchBuilder.toString();
    }

    private String getSupplyNullMatchKey(DynamicObject supplyBill, List<String> supplyNullMatchFields, Set<String> supplyNullFields) {
        StringBuilder matchValueSb = new StringBuilder();
        for (String field : supplyNullMatchFields) {
            if (BalanceInvExecuteHelper.getValue(supplyBill, field) == null || supplyNullFields.contains(field)) {
                matchValueSb.append("null");
            } else {
                matchValueSb.append(supplyBill.getString(field));
            }
            matchValueSb.append(SPLITKEY);
        }
        return matchValueSb.toString();
    }

    private void matchOneBill(DynamicObject demandBill, DynamicObject supplyBill, BigDecimal originDemandBaseQty) {
        SupplyQtyInfo supplyQtyInfo = this.ctx.getEntryId2SupplyQtyMap().get(supplyBill.getLong("entryentity.billentryid"));
        if (supplyQtyInfo == null) {
            return;
        }
        BalanceInventoryScheme balanceScheme = this.ctx.getScheme();
        long demandOrgId = demandBill.getLong("entryentity.demandorg");
        SupplyRelation supplyRelation = balanceScheme.getSupplyRelationMap().get(demandOrgId);
        BigDecimal supplyBaseQty = this.getSupplyBaseQty(supplyRelation, supplyBill, supplyQtyInfo);
        if (supplyBaseQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal curDemandBaseQty = this.getCurrentDemandBaseQty(demandBill);
        BigDecimal matchBaseQty = curDemandBaseQty.compareTo(supplyBaseQty) <= 0 ? curDemandBaseQty : supplyBaseQty;
        BigDecimal matchQty = BigDecimal.ZERO;
        BigDecimal matchQty2nd = BigDecimal.ZERO;
        if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.unit") != null) {
            matchQty = BalanceInvExecuteHelper.calculateQtyByBaseQty(matchBaseQty, supplyBill.getLong("entryentity.material"), supplyBill.getLong("entryentity.unit"), supplyBill.getLong("entryentity.baseunit"), this.unitPrecisionCache);
        }
        if (BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.assistunit") != null && BalanceInvExecuteHelper.getValue(supplyBill, "entryentity.originassitqty") != null && supplyBill.getBigDecimal("entryentity.originassitqty").compareTo(BigDecimal.ZERO) != 0) {
            matchQty2nd = matchBaseQty.multiply(supplyBill.getBigDecimal("entryentity.originassitqty")).divide(supplyBill.getBigDecimal("entryentity.originbaseqty"), BalanceInvExecuteHelper.getUnitPrecision(supplyBill.getLong("entryentity.assistunit"), this.unitPrecisionCache), RoundingMode.HALF_UP);
        }
        BigDecimal demandBaseQty = demandBill.getBigDecimal("entryentity.demandqty");
        MatchInfo matchInfo = new MatchInfo(matchQty, matchBaseQty, matchQty2nd, originDemandBaseQty, demandBaseQty);
        demandBill.set("entryentity.demandqty", (Object)demandBaseQty.subtract(matchBaseQty));
        supplyQtyInfo.setBaseQty(supplyQtyInfo.getBaseQty().subtract(matchBaseQty));
        supplyQtyInfo.setQty(supplyQtyInfo.getQty().subtract(matchQty));
        supplyQtyInfo.setQty2nd(supplyQtyInfo.getQty2nd().subtract(matchQty2nd));
        SupplySafeQtyInfo safeQtyInfo = supplyQtyInfo.getSafeQtyInfo();
        if (safeQtyInfo != null) {
            safeQtyInfo.setTotalQty(safeQtyInfo.getTotalQty().subtract(matchBaseQty));
        }
        ++this.matchCount;
        DynamicObject newEntry = BalanceInvExecuteHelper.addMatchResultEntry(demandBill, supplyBill, matchInfo, this.demandOrder);
        this.ctx.getMatchDetailEntries().add(newEntry);
    }

    private BigDecimal getSupplyBaseQty(SupplyRelation supplyRelation, DynamicObject supplyBill, SupplyQtyInfo supplyQtyInfo) {
        boolean safeInvCanSupply = true;
        if (supplyRelation != null && supplyRelation.getSupplyOrg2ProviderMap().containsKey(supplyBill.getLong("entryentity.supplyorgunit"))) {
            safeInvCanSupply = supplyRelation.getSupplyOrg2ProviderMap().get(supplyBill.getLong("entryentity.supplyorgunit"));
        }
        BigDecimal supplyBaseQty = supplyQtyInfo.getBaseQty();
        if (BalanceInvContext.get().getDebugMode()) {
            this.logger.info("\u4f9b\u5e94\u5355\u5206\u5f55ID\uff1a" + supplyBill.getLong("entryentity.billentryid") + "\uff0c\u4f9b\u5e94\u6570\u91cf\uff1a" + supplyBaseQty.toPlainString());
        }
        if (!safeInvCanSupply && supplyQtyInfo.getSafeQtyInfo() != null) {
            BigDecimal usableQty = supplyQtyInfo.getSafeQtyInfo().getUsableQty();
            BigDecimal bigDecimal = supplyBaseQty = supplyBaseQty.compareTo(usableQty) > 0 ? usableQty : supplyBaseQty;
            if (BalanceInvContext.get().getDebugMode()) {
                this.logger.info("\u4f9b\u5e94\u5355\u5206\u5f55ID\uff1a" + supplyBill.getLong("entryentity.billentryid") + "\uff0c\u5b89\u5168\u5e93\u5b58\u4e0d\u53ef\u4f9b\uff0c\u6263\u9664\u5b89\u5168\u5e93\u5b58\u540e\u53ef\u4f9b\u5e94\u6570\u91cf\uff1a" + supplyBaseQty.toPlainString());
            }
        }
        return supplyBaseQty;
    }

    private void doReserveWithNewTx() {
        block16: {
            try (TXHandle txHandle = TX.required((String)"balanceinv_reserve");){
                try {
                    String errorMsg = BalanceInvExecuteHelper.doReserve(this.ctx.getMatchDetailEntries());
                    if (StringUtils.isNotEmpty((String)errorMsg)) {
                        this.addWarnMessage(errorMsg);
                    }
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    this.logger.error((Throwable)e);
                    this.addWarnMessage(ResManager.loadKDString((String)"\u8c03\u7528\u9884\u7559\u670d\u52a1\u5931\u8d25\uff1a", (String)"BalanceInvMatchStep_1", (String)"scmc-im-business", (Object[])new Object[0]) + "\n");
                    if (this.ctx.getDebugMode()) {
                        this.addWarnMessage(BalanceInvExecuteHelper.getExceptionMessage(e));
                        break block16;
                    }
                    this.addWarnMessage(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"BalanceInvStepExecutor_1", (String)"scmc-im-business", (Object[])new Object[0]));
                }
            }
        }
    }
}

