/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.CommonVerifyHelper;
import kd.scmc.im.business.helper.TrackContractHelper;
import kd.scmc.im.consts.APVerifyAsstEntryModel;
import kd.scmc.im.consts.APVerifyEntryModel;
import kd.scmc.im.enums.PrecisionAccountEnum;

public class APVerifyHelper {
    protected static final Log logger = LogFactory.getLog(APVerifyHelper.class);

    public static void processAPVerifyResult(List<Map<String, Object>> disposeList) {
        if (disposeList == null || disposeList.isEmpty()) {
            return;
        }
        boolean mscommon = CommonVerifyHelper.isMscommon(disposeList.get(0));
        boolean isVerify = true;
        Map<Long, APVerifyEntryModel> verifyEntryModelMap = APVerifyHelper.buildVerifyModel(disposeList, isVerify);
        ArrayList<Object[]> purInBillParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> purReceBillParamList = new ArrayList<Object[]>();
        HashMap<Long, List<Object[]>> paramListOrgMap = new HashMap<Long, List<Object[]>>(verifyEntryModelMap.size());
        ArrayList<Object[]> purContractParamList = new ArrayList<Object[]>(verifyEntryModelMap.size());
        for (APVerifyEntryModel verifyEntryModel : verifyEntryModelMap.values()) {
            APVerifyHelper.addPurInBillRWParam(verifyEntryModel, purInBillParamList, mscommon);
            APVerifyHelper.addPurReceBillRWParam(verifyEntryModel, purReceBillParamList, mscommon);
            APVerifyHelper.addPurBillRWParam(verifyEntryModel, paramListOrgMap);
            APVerifyHelper.addPurContractRWParam(verifyEntryModel, purContractParamList);
        }
        List<Object[]> conmWbParam = TrackContractHelper.trackContractInfo(purContractParamList, "conm_purcontract");
        try (TXHandle h = TX.required();){
            try {
                List<Object[]> paramListPass;
                ShardingHintContext ctx;
                ArrayList<Long> entryId;
                ArrayList<Long> ids;
                String sql;
                if (!purInBillParamList.isEmpty()) {
                    sql = " update t_im_purinbillentry_r set  funverifyqty = funverifyqty-?, fverifyqty = fverifyqty+?,   funverifybaseqty = funverifybaseqty-?, fverifybaseqty = fverifybaseqty+?,  fremainjoinpriceqty = fremainjoinpriceqty-?, fjoinpriceqty = fjoinpriceqty+?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty-?, fjoinpricebaseqty = fjoinpricebaseqty+?  where fentryid=? and fid = ?";
                    ids = new ArrayList<Long>(purInBillParamList.size());
                    entryId = new ArrayList<Long>(purInBillParamList.size());
                    for (Object[] throwable : purInBillParamList) {
                        ids.add((Long)throwable[9]);
                        entryId.add((Long)throwable[8]);
                    }
                    ctx = ShardingHintContext.createAndSet((String)"t_im_purinbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});
                    Throwable throwable = null;
                    try {
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purInBillParamList);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ctx != null) {
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                ctx.close();
                            }
                        }
                    }
                    APVerifyHelper.checkBillBaseqty(ids, entryId, "im_purinbill");
                }
                if (!purReceBillParamList.isEmpty()) {
                    sql = "update t_im_purrecbillentry_r set  funverifyqty = funverifyqty-?, fverifyqty = fverifyqty+?,   funverifybaseqty = funverifybaseqty-?, fverifybaseqty = fverifybaseqty+?,  fremainjoinpriceqty = fremainjoinpriceqty-?, fjoinpriceqty = fjoinpriceqty+?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty-?, fjoinpricebaseqty = fjoinpricebaseqty+?  where fentryid=? and fid =?";
                    ids = new ArrayList(purReceBillParamList.size());
                    entryId = new ArrayList(purReceBillParamList.size());
                    for (Object[] objectArray : purReceBillParamList) {
                        ids.add((Long)objectArray[9]);
                        entryId.add((Long)objectArray[8]);
                    }
                    ctx = ShardingHintContext.createAndSet((String)"t_im_purrecbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});
                    Throwable throwable = null;
                    try {
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purReceBillParamList);
                    }
                    catch (Throwable throwable5) {
                        Throwable throwable6 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ctx != null) {
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                ctx.close();
                            }
                        }
                    }
                    APVerifyHelper.checkBillBaseqty(ids, entryId, "im_purreceivebill");
                }
                if (!paramListOrgMap.isEmpty() && (paramListPass = APVerifyHelper.queryEntryIds(paramListOrgMap)).size() > 0) {
                    paramListPass.sort((o1, o2) -> {
                        if (o1[2] instanceof Long && o2[2] instanceof Long) {
                            return ((Long)o1[2]).compareTo((Long)o2[2]);
                        }
                        return 0;
                    });
                    if (!"purself".equals(disposeList.get(0).get("verifyrelation"))) {
                        sql = "update t_pm_purorderbillentry_r set fpayablepriceqty = fpayablepriceqty+?,fpayablebaseqty = fpayablebaseqty+?, fpayableamount= fpayableamount+? where fentryid=? and fid = ?";
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramListPass);
                    }
                }
                if (conmWbParam != null && conmWbParam.size() > 0) {
                    sql = "update t_conm_purcontractentry_r set fpayablepriceqty = fpayablepriceqty+?,fpayablebaseqty = fpayablebaseqty+?,fpayableamount= fpayableamount+?  where fentryid=?";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, conmWbParam);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private static void checkBillBaseqty(List<Long> ids, List<Long> entryId, String billEntity) {
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and("billentry.id", "in", entryId);
        QFilter qFilterBlue = new QFilter("billentry.unverifybaseqty", "<", (Object)BigDecimal.ZERO);
        qFilterBlue.and("billentry.verifybaseqty", ">", (Object)BigDecimal.ZERO);
        QFilter qFilterRed = new QFilter("billentry.unverifybaseqty", ">", (Object)BigDecimal.ZERO);
        qFilterRed.and("billentry.verifybaseqty", "<", (Object)BigDecimal.ZERO);
        QFilter all = qFilterBlue.or(qFilterRed);
        qFilter.and(all);
        boolean isHasErrorBill = QueryServiceHelper.exists((String)billEntity, (QFilter[])qFilter.toArray());
        if (isHasErrorBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u8d85\u989d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"APVerifyHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private static List<Object[]> queryEntryIds(Map<Long, List<Object[]>> paramListOrgMap) {
        if (logger.isDebugEnabled()) {
            logger.debug("APVerifyHelper\u7684queryEntryIds\u4f20\u5165\u53c2\u6570\u4e3a" + SerializationUtils.toJsonString(paramListOrgMap));
        }
        ArrayList<Long> entryIdList = new ArrayList<Long>(paramListOrgMap.size());
        for (List<Object[]> purBillParams : paramListOrgMap.values()) {
            for (Object[] purBillParam : purBillParams) {
                Long entryId = (Long)purBillParam[3];
                entryIdList.add(entryId);
            }
        }
        QFilter entryIdFilter = new QFilter("billentry.id", "in", entryIdList);
        if (logger.isDebugEnabled()) {
            logger.debug("APVerifyHelper\u7684queryEntryIds\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + entryIdFilter);
        }
        HashMap<Long, ArrayList<Long>> settleOrgIdAndEntryIdMap = new HashMap<Long, ArrayList<Long>>(16);
        HashMap entryIdAndMaterialUnitMap = new HashMap(16);
        List<String> selectorsList = Arrays.asList("id", "billentry.id entryid", "billentry.material.masterid masterid", "billentry.unit unit", "billentry.baseunit baseunit", "billentry.unit.precisionaccount precisionaccount", "billentry.unit.precision precision", "billentry.entrysettleorg entrysettleorg");
        String selectFields = String.join((CharSequence)",", selectorsList);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"getpurorderbillmainentryid", (String)"pm_purorderbill", (String)selectFields, (QFilter[])new QFilter[]{entryIdFilter}, (String)"");
        Iterator iterator = null;
        try {
            for (Row data : ds) {
                Long entryId = data.getLong("entryid");
                Long entrySettleOrgId = data.getLong("entrysettleorg");
                ArrayList<Long> fEntryIds = (ArrayList<Long>)settleOrgIdAndEntryIdMap.get(entrySettleOrgId);
                if (fEntryIds == null) {
                    fEntryIds = new ArrayList<Long>();
                    settleOrgIdAndEntryIdMap.put(entrySettleOrgId, fEntryIds);
                }
                fEntryIds.add(entryId);
                Long unit = data.getLong("unit");
                Long baseunit = data.getLong("baseunit");
                if (unit == null || baseunit == null || unit.equals(baseunit)) continue;
                String precisionAccount = (String)data.get("precisionaccount");
                HashMap<String, Number> materialAndUnitMap = new HashMap<String, Number>();
                materialAndUnitMap.put("masterid", data.getLong("masterid"));
                materialAndUnitMap.put("unit", unit);
                materialAndUnitMap.put("baseunit", baseunit);
                materialAndUnitMap.put("precisionaccount", PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
                materialAndUnitMap.put("precision", data.getInteger("precision"));
                entryIdAndMaterialUnitMap.put(entryId, materialAndUnitMap);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        entryIdList = null;
        if (logger.isDebugEnabled()) {
            logger.debug("APVerifyHelper\u7684queryEntryIds\u7ed3\u7b97\u7ec4\u7ec7\u6620\u5c04: entrySettleOrgMapping:" + SerializationUtils.toJsonString(settleOrgIdAndEntryIdMap));
        }
        ArrayList<Object[]> paramListPass = new ArrayList<Object[]>();
        for (Map.Entry entry : paramListOrgMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            List paramList = (List)entry.getValue();
            Iterator paramListIterator = paramList.iterator();
            List entryIds = (List)settleOrgIdAndEntryIdMap.get(orgId);
            while (paramListIterator.hasNext()) {
                Object[] param = (Object[])paramListIterator.next();
                Object o = param[3];
                if (entryIds == null || !entryIds.contains(o)) continue;
                paramListPass.add(param);
            }
        }
        settleOrgIdAndEntryIdMap = null;
        paramListOrgMap = null;
        if (logger.isDebugEnabled()) {
            logger.debug("APVerifyHelper\u7684queryEntryIds\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u7684\u6838\u9500\u53c2\u6570 " + SerializationUtils.toJsonString(paramListPass));
        }
        for (Object[] objectArray : paramListPass) {
            Long entryId = (Long)objectArray[3];
            Map materialAndUnitInfo = (Map)entryIdAndMaterialUnitMap.get(entryId);
            if (materialAndUnitInfo == null) {
                objectArray[0] = objectArray[1];
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("APVerifyHelper\u7684queryEntryIds\u5355\u4f4d\u6362\u7b97\u5f53\u524d\u884c\u7269\u6599\u5355\u4f4d\u4fe1\u606f" + SerializationUtils.toJsonString((Object)materialAndUnitInfo));
                logger.debug("APVerifyHelper\u7684queryEntryIds\u5355\u4f4d\u6362\u7b97\u524d\u53c2\u6570" + SerializationUtils.toJsonString((Object)objectArray));
            }
            Long masterid = (Long)materialAndUnitInfo.get("masterid");
            Long unitId = (Long)materialAndUnitInfo.get("unit");
            Long baseunitId = (Long)materialAndUnitInfo.get("baseunit");
            Integer precisionaccount = (Integer)materialAndUnitInfo.get("precisionaccount");
            Integer precision = (Integer)materialAndUnitInfo.get("precision");
            BigDecimal baseQty = (BigDecimal)objectArray[1];
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)masterid, (Long)baseunitId, (Long)unitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                objectArray[0] = baseQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), (int)precision, precisionaccount);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("APVerifyHelper\u7684queryEntryIds\u5355\u4f4d\u6362\u7b97\u540e\u53c2\u6570" + SerializationUtils.toJsonString((Object)objectArray));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("APVerifyHelper\u7684queryEntryIds\u8fd4\u56de\u53c2\u6570" + SerializationUtils.toJsonString(paramListPass));
        }
        return paramListPass;
    }

    public static void processAPUnVerifyResult(List<Map<String, Object>> disposeList) {
        if (disposeList == null || disposeList.isEmpty()) {
            return;
        }
        boolean mscommon = CommonVerifyHelper.isMscommon(disposeList.get(0));
        boolean isVerify = false;
        Map<Long, APVerifyEntryModel> verifyEntryModelMap = APVerifyHelper.buildVerifyModel(disposeList, isVerify);
        ArrayList<Object[]> purInBillParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> purReceBillParamList = new ArrayList<Object[]>();
        HashMap<Long, List<Object[]>> paramListOrgMap = new HashMap<Long, List<Object[]>>(verifyEntryModelMap.size());
        ArrayList<Object[]> purContractParamList = new ArrayList<Object[]>(verifyEntryModelMap.size());
        for (APVerifyEntryModel verifyEntryModel : verifyEntryModelMap.values()) {
            APVerifyHelper.addPurInBillRWParam(verifyEntryModel, purInBillParamList, mscommon);
            APVerifyHelper.addPurReceBillRWParam(verifyEntryModel, purReceBillParamList, mscommon);
            APVerifyHelper.addPurBillRWParam(verifyEntryModel, paramListOrgMap);
            APVerifyHelper.addPurContractRWParam(verifyEntryModel, purContractParamList);
        }
        List<Object[]> conmWbParam = TrackContractHelper.trackContractInfo(purContractParamList, "conm_purcontract");
        try (TXHandle h = TX.required();){
            try {
                List<Object[]> paramListPass;
                ShardingHintContext ctx;
                ArrayList<Long> ids;
                String sql;
                if (!purInBillParamList.isEmpty()) {
                    sql = "update t_im_purinbillentry_r set  funverifyqty = funverifyqty+?,fverifyqty = fverifyqty-?,  funverifybaseqty = funverifybaseqty+?,fverifybaseqty = fverifybaseqty-?,  fremainjoinpriceqty = fremainjoinpriceqty+?, fjoinpriceqty = fjoinpriceqty-?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty+?, fjoinpricebaseqty = fjoinpricebaseqty-?  where fentryid=? and fid = ?";
                    ids = new ArrayList<Long>(purInBillParamList.size());
                    for (Object[] throwable : purInBillParamList) {
                        ids.add((Long)throwable[9]);
                    }
                    ctx = ShardingHintContext.createAndSet((String)"t_im_purinbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});
                    Throwable throwable = null;
                    try {
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purInBillParamList);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ctx != null) {
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                ctx.close();
                            }
                        }
                    }
                }
                if (!purReceBillParamList.isEmpty()) {
                    sql = "update t_im_purrecbillentry_r set  funverifyqty = funverifyqty+?,fverifyqty = fverifyqty-?,  funverifybaseqty = funverifybaseqty+?,fverifybaseqty = fverifybaseqty-?,  fremainjoinpriceqty = fremainjoinpriceqty+?, fjoinpriceqty = fjoinpriceqty-?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty+?, fjoinpricebaseqty = fjoinpricebaseqty-?  where fentryid=? and fid = ?";
                    ids = new ArrayList(purReceBillParamList.size());
                    for (Object[] objectArray : purReceBillParamList) {
                        ids.add((Long)objectArray[9]);
                    }
                    ctx = ShardingHintContext.createAndSet((String)"t_im_purrecbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});
                    Throwable throwable = null;
                    try {
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, purReceBillParamList);
                    }
                    catch (Throwable throwable5) {
                        Throwable throwable6 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ctx != null) {
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                ctx.close();
                            }
                        }
                    }
                }
                if (!paramListOrgMap.isEmpty() && (paramListPass = APVerifyHelper.queryEntryIds(paramListOrgMap)).size() > 0) {
                    paramListPass.sort((o1, o2) -> {
                        if (o1[3] instanceof Long && o2[3] instanceof Long) {
                            return ((Long)o1[3]).compareTo((Long)o2[3]);
                        }
                        return 0;
                    });
                    if (!"purself".equals(disposeList.get(0).get("verifyrelation"))) {
                        sql = "update t_pm_purorderbillentry_r set fpayablepriceqty = fpayablepriceqty-?,fpayablebaseqty = fpayablebaseqty-?, fpayableamount= fpayableamount-? where fentryid=?  and fid = ?";
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramListPass);
                    }
                }
                if (conmWbParam != null && conmWbParam.size() > 0) {
                    sql = "update t_conm_purcontractentry_r set fpayablepriceqty = fpayablepriceqty-?,fpayablebaseqty = fpayablebaseqty-?,fpayableamount= fpayableamount-?  where fentryid=?";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, conmWbParam);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private static Map<Long, APVerifyEntryModel> buildVerifyModel(List<Map<String, Object>> disposeList, Boolean isVerify) {
        Object ctx;
        Object unVerifyEntryModelAsstEntry;
        HashMap<Long, APVerifyEntryModel> verifyEntryModelMap = new HashMap<Long, APVerifyEntryModel>(disposeList.size());
        ArrayList<Long> inForPo = new ArrayList<Long>();
        ArrayList<Long> reForPo = new ArrayList<Long>();
        HashSet<Long> inEntityIds = new HashSet<Long>();
        HashSet<Long> reEntityIds = new HashSet<Long>();
        for (Map<String, Object> dispose : disposeList) {
            Long entryModelPk;
            APVerifyEntryModel unVerifyEntryModel;
            if (logger.isDebugEnabled()) {
                logger.debug("\u6784\u5efa\u6838\u9500\u6a21\u578b\u5165\u53c2dispose: Key:" + StringUtils.join((Object[])dispose.keySet().toArray(), (String)",") + " Value:" + StringUtils.join((Object[])dispose.values().toArray(), (String)","));
            }
            APVerifyEntryModel entryModel = APVerifyHelper.getVerifyEntryModel(dispose);
            if (logger.isDebugEnabled()) {
                logger.debug("\u6784\u5efa\u6838\u9500\u6a21\u578b: entryModel:" + entryModel.toString());
            }
            if ((unVerifyEntryModel = (APVerifyEntryModel)verifyEntryModelMap.get(entryModelPk = entryModel.getEntryPk())) != null) {
                entryModel.setVerifyQty(entryModel.getVerifyQty().add(unVerifyEntryModel.getVerifyQty()));
                entryModel.setVerifyBaseQty(entryModel.getVerifyBaseQty().add(unVerifyEntryModel.getVerifyBaseQty()));
                entryModel.setVerifyAmt(entryModel.getVerifyAmt().add(unVerifyEntryModel.getVerifyAmt()));
                unVerifyEntryModelAsstEntry = unVerifyEntryModel.getAsstEntrys();
                if (!unVerifyEntryModelAsstEntry.isEmpty()) {
                    entryModel.getAsstEntrys().addAll(unVerifyEntryModelAsstEntry);
                }
            }
            APVerifyHelper.setAsstAllQty(entryModel);
            verifyEntryModelMap.put(entryModelPk, entryModel);
            if ("im_purinbill".equals(entryModel.getEntity()) && !inForPo.contains(entryModelPk)) {
                inForPo.add(entryModelPk);
                inEntityIds.add(entryModel.getEntityId());
                continue;
            }
            if (!"im_purreceivebill".equals(entryModel.getEntity()) || reForPo.contains(entryModelPk)) continue;
            reForPo.add(entryModelPk);
            reEntityIds.add(entryModel.getEntityId());
        }
        Map<Long, List<Long>> purInApEntryMap = APVerifyHelper.getApEntryList("im_purinbill", inForPo, inEntityIds);
        Map<Long, List<Long>> purrceApEntryMap = APVerifyHelper.getApEntryList("im_purreceivebill", reForPo, reEntityIds);
        if (!inForPo.isEmpty()) {
            QFilter inForPoQF = new QFilter("billentry.id", "in", inForPo);
            inForPoQF = inForPoQF.and(new QFilter("id", "in", inEntityIds));
            DynamicObjectCollection inForPoBills = new DynamicObjectCollection();
            ctx = ShardingHintContext.createAndSet((String)"t_im_purinbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, inEntityIds)});
            unVerifyEntryModelAsstEntry = null;
            try {
                inForPoBills = QueryServiceHelper.query((String)"im_purinbill", (String)"id,billentry.id,billentry.mainbillentity,billentry.mainbillid,billentry.mainbillentryid,billentry.material.masterid as billentry.material,billentry.unit.precision,billentry.unit.precisionaccount,billentry.remainjoinpriceqty,billentry.remainjoinpricebaseqty,billentry.joinpriceqty,billentry.joinpricebaseqty,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid", (QFilter[])inForPoQF.toArray());
            }
            catch (Throwable throwable) {
                unVerifyEntryModelAsstEntry = throwable;
                throw throwable;
            }
            finally {
                if (ctx != null) {
                    if (unVerifyEntryModelAsstEntry != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)unVerifyEntryModelAsstEntry).addSuppressed(throwable);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
            if (inForPoBills != null && !inForPoBills.isEmpty()) {
                for (Throwable inForPoBill2 : inForPoBills) {
                    APVerifyHelper.addEntryModelInfo(isVerify, verifyEntryModelMap, (DynamicObject)inForPoBill2, purInApEntryMap);
                }
            }
        }
        if (!reForPo.isEmpty()) {
            Throwable inForPoBill2;
            QFilter reForPoQF = new QFilter("billentry.id", "in", reForPo);
            reForPoQF = reForPoQF.and(new QFilter("id", "in", reEntityIds));
            DynamicObjectCollection reForPoBills = new DynamicObjectCollection();
            ctx = ShardingHintContext.createAndSet((String)"t_im_purreceivebill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, reEntityIds)});
            inForPoBill2 = null;
            try {
                reForPoBills = QueryServiceHelper.query((String)"im_purreceivebill", (String)"id,billentry.id,billentry.mainbillentity,billentry.mainbillid,billentry.mainbillentryid,billentry.material.masterid as billentry.material,billentry.unit.precision,billentry.unit.precisionaccount,billentry.remainjoinpriceqty,billentry.remainjoinpricebaseqty,billentry.joinpriceqty,billentry.joinpricebaseqty,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid", (QFilter[])reForPoQF.toArray());
            }
            catch (Throwable throwable) {
                inForPoBill2 = throwable;
                throw throwable;
            }
            finally {
                if (ctx != null) {
                    if (inForPoBill2 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable) {
                            inForPoBill2.addSuppressed(throwable);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
            if (reForPoBills != null && !reForPoBills.isEmpty()) {
                for (Throwable inForPoBill2 : reForPoBills) {
                    APVerifyHelper.addEntryModelInfo(isVerify, verifyEntryModelMap, (DynamicObject)inForPoBill2, purrceApEntryMap);
                }
            }
        }
        return verifyEntryModelMap;
    }

    private static void setAsstAllQty(APVerifyEntryModel entryModel) {
        BigDecimal asstAllPriceQty = BigDecimal.ZERO;
        BigDecimal asstAllPriceBaseQty = BigDecimal.ZERO;
        for (APVerifyAsstEntryModel asstEntry : entryModel.getAsstEntrys()) {
            BigDecimal asstVerifyQty = asstEntry.getAsstVerifyQty();
            asstAllPriceQty = asstAllPriceQty.add(asstVerifyQty);
            asstAllPriceBaseQty = asstAllPriceBaseQty.add(asstEntry.getAsstVerifyBaseQty());
        }
        entryModel.setAsstAllPriceQty(asstAllPriceQty);
        entryModel.setAsstAllPriceBaseQty(asstAllPriceBaseQty);
    }

    private static void addEntryModelInfo(Boolean isVerify, Map<Long, APVerifyEntryModel> verifyEntryModelMap, DynamicObject inForPoBillEntry, Map<Long, List<Long>> apEntryMap) {
        Long entryId = inForPoBillEntry.getLong("billentry.id");
        APVerifyEntryModel apVerifyEntryModel = verifyEntryModelMap.get(entryId);
        List<Long> apEntrylist = apEntryMap.get(entryId);
        if (apVerifyEntryModel == null) {
            return;
        }
        Long entityId = inForPoBillEntry.getLong("id");
        apVerifyEntryModel.setEntityId(entityId);
        String mainbillentity = inForPoBillEntry.getString("billentry.mainbillentity");
        Long mainbillentryid = inForPoBillEntry.getLong("billentry.mainbillentryid");
        Long mainbillid = inForPoBillEntry.getLong("billentry.mainbillid");
        APVerifyHelper.setRwJoinPirceQty(isVerify, inForPoBillEntry, apVerifyEntryModel, apEntrylist);
        if (0L != mainbillentryid && "pm_purorderbill".equals(mainbillentity)) {
            apVerifyEntryModel.setMainbillid(mainbillid);
            apVerifyEntryModel.setMainBillEntryid(mainbillentryid);
        }
        String conbillentity = inForPoBillEntry.getString("billentry.conbillentity");
        Long conbillid = inForPoBillEntry.getLong("billentry.conbillid");
        Long conbillentryid = inForPoBillEntry.getLong("billentry.conbillentryid");
        if (0L != conbillid && 0L != conbillentryid && "conm_purcontract".equals(conbillentity)) {
            apVerifyEntryModel.setConbillentity(conbillentity);
            apVerifyEntryModel.setConbillid(conbillid);
            apVerifyEntryModel.setConbillentryid(conbillentryid);
        }
    }

    private static void setRwJoinPirceQty(Boolean isVerify, DynamicObject inForPoBillEntry, APVerifyEntryModel apVerifyEntryModel, List<Long> apEntrylist) {
        String verifyRelation = apVerifyEntryModel.getVerifyRelation();
        if ("purself".equals(verifyRelation)) {
            return;
        }
        boolean isAllBotpGenArEntry = true;
        List asstEntrys = apVerifyEntryModel.getAsstEntrys();
        if (apEntrylist != null && !apEntrylist.isEmpty()) {
            for (APVerifyAsstEntryModel asstEntry : asstEntrys) {
                Long asstEntryPk = asstEntry.getAsstEntryPk();
                if (apEntrylist.contains(asstEntryPk)) {
                    asstEntry.setBotpGen(true);
                    continue;
                }
                isAllBotpGenArEntry = false;
            }
        } else {
            isAllBotpGenArEntry = false;
        }
        if (isAllBotpGenArEntry) {
            return;
        }
        BigDecimal needJoinPriceQty = BigDecimal.ZERO;
        BigDecimal needJoinPriceBaseQty = BigDecimal.ZERO;
        BigDecimal verifyQty = apVerifyEntryModel.getVerifyQty();
        Long measureunit = apVerifyEntryModel.getMeasureunit();
        Long materialid = inForPoBillEntry.getLong("billentry.material");
        Integer precision = inForPoBillEntry.getInt("billentry.unit.precision");
        Integer precisionaccount = inForPoBillEntry.getInt("billentry.unit.precisionaccount");
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        for (APVerifyAsstEntryModel asstEntry : asstEntrys) {
            BigDecimal unit2ndRate;
            if (asstEntry.isBotpGen()) continue;
            Long asstmeasureunit = asstEntry.getAsstmeasureunit();
            BigDecimal asstVerifyQty = asstEntry.getAsstVerifyQty();
            if (measureunit != null && asstmeasureunit != null && !measureunit.equals(asstmeasureunit) && (unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv(materialid, measureunit, asstmeasureunit, cacheMap)) != null && BigDecimal.ZERO.compareTo(unit2ndRate) != 0 && BigDecimal.ONE.compareTo(unit2ndRate) != 0 && BigDecimal.ZERO.compareTo(verifyQty) != 0) {
                asstVerifyQty = asstVerifyQty.divide(unit2ndRate, (int)precision, PrecisionAccountEnum.getEnumByVal((int)precisionaccount));
            }
            needJoinPriceQty = needJoinPriceQty.add(asstVerifyQty);
            needJoinPriceBaseQty = needJoinPriceBaseQty.add(asstEntry.getAsstVerifyBaseQty());
        }
        if (isVerify.booleanValue()) {
            BigDecimal remainJoinPriceBaseQty = inForPoBillEntry.getBigDecimal("billentry.remainjoinpricebaseqty");
            BigDecimal remainJoinPriceQty = inForPoBillEntry.getBigDecimal("billentry.remainjoinpriceqty");
            if (remainJoinPriceBaseQty.abs().compareTo(needJoinPriceBaseQty.abs()) < 0 && remainJoinPriceQty.abs().compareTo(needJoinPriceQty.abs()) < 0) {
                apVerifyEntryModel.setJoinPriceQty(remainJoinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(remainJoinPriceBaseQty);
            } else {
                apVerifyEntryModel.setJoinPriceQty(needJoinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(needJoinPriceBaseQty);
            }
        } else {
            BigDecimal joinPriceQty = inForPoBillEntry.getBigDecimal("billentry.joinpriceqty");
            BigDecimal joinPriceBaseQty = inForPoBillEntry.getBigDecimal("billentry.joinpricebaseqty");
            if (joinPriceBaseQty.abs().compareTo(needJoinPriceBaseQty.abs()) < 0 && joinPriceQty.abs().compareTo(needJoinPriceQty.abs()) < 0) {
                apVerifyEntryModel.setJoinPriceQty(joinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(joinPriceBaseQty);
            } else {
                apVerifyEntryModel.setJoinPriceQty(needJoinPriceQty);
                apVerifyEntryModel.setJoinPriceBaseQty(needJoinPriceBaseQty);
            }
        }
    }

    private static APVerifyEntryModel getVerifyEntryModel(Map<String, Object> dispose) {
        List asstDataList;
        Object isbotp;
        Object verifybaseqty;
        Object verifyqty;
        APVerifyEntryModel entryModel = new APVerifyEntryModel();
        entryModel.setEntity((String)dispose.get("entity"));
        entryModel.setEntityId((Long)dispose.get("pk"));
        entryModel.setEntryPk((Long)dispose.get("entrypk"));
        entryModel.setOrgid((Long)dispose.get("orgid"));
        entryModel.setVerifyRelation((String)dispose.get("verifyrelation"));
        entryModel.setVerifyType((String)dispose.get("verifytype"));
        Object verifyamt = dispose.get("verifyamt");
        Object measureunit = dispose.get("measureunit");
        if (measureunit != null) {
            entryModel.setMeasureunit((Long)measureunit);
        }
        if (verifyamt != null) {
            entryModel.setVerifyAmt((BigDecimal)verifyamt);
        }
        if ((verifyqty = dispose.get("verifyqty")) != null) {
            entryModel.setVerifyQty((BigDecimal)verifyqty);
        }
        if ((verifybaseqty = dispose.get("verifybaseqty")) != null) {
            entryModel.setVerifyBaseQty((BigDecimal)verifybaseqty);
        }
        if ((isbotp = dispose.get("isbotp")) != null) {
            entryModel.setBotp(((Boolean)isbotp).booleanValue());
        }
        Object iswrittenoffverify = dispose.get("iswrittenoffverify");
        if (isbotp != null) {
            entryModel.setIswrittenoffverify(((Boolean)iswrittenoffverify).booleanValue());
        }
        if ((asstDataList = (List)dispose.get("asstdata")) != null && !asstDataList.isEmpty()) {
            for (Map asstData : asstDataList) {
                Object asstverifybaseqty;
                APVerifyAsstEntryModel asstEntry = new APVerifyAsstEntryModel();
                asstEntry.setAsstEntity((String)asstData.get("asstentity"));
                asstEntry.setAsstEntryPk((Long)asstData.get("asstentrypk"));
                asstEntry.setAsstmeasureunit((Long)asstData.get("asstmeasureunit"));
                Object asstverifyqty = asstData.get("asstverifyqty");
                if (asstverifyqty != null) {
                    asstEntry.setAsstVerifyQty((BigDecimal)asstverifyqty);
                }
                if ((asstverifybaseqty = asstData.get("asstverifybaseqty")) != null) {
                    asstEntry.setAsstVerifyBaseQty((BigDecimal)asstverifybaseqty);
                }
                entryModel.getAsstEntrys().add(asstEntry);
            }
        }
        return entryModel;
    }

    private static void addPurBillRWParam(APVerifyEntryModel verifyEntryModel, Map<Long, List<Object[]>> paramListOrgMap) {
        Long mainBillEntryid = verifyEntryModel.getMainBillEntryid();
        Long mainBillId = verifyEntryModel.getMainbillid();
        if (mainBillEntryid != null && mainBillEntryid != 0L) {
            BigDecimal verifyQty = verifyEntryModel.getAsstAllPriceQty();
            BigDecimal verifyBaseQty = verifyEntryModel.getAsstAllPriceBaseQty();
            BigDecimal verifyAmt = verifyEntryModel.getVerifyAmt();
            Long orgid = verifyEntryModel.getOrgid();
            Object[] qtyParam = new Object[]{verifyQty, verifyBaseQty, verifyAmt, mainBillEntryid, mainBillId};
            List<Object[]> purBillQtyParamList = paramListOrgMap.get(orgid);
            if (purBillQtyParamList == null) {
                purBillQtyParamList = new ArrayList<Object[]>();
                paramListOrgMap.put(orgid, purBillQtyParamList);
            }
            purBillQtyParamList.add(qtyParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u6dfb\u52a0\u91c7\u8d2d\u8ba2\u5355\u53cd\u5199\u53c2\u6570: outForOrderParam:" + SerializationUtils.toJsonString(purBillQtyParamList));
            }
        }
    }

    private static void addPurReceBillRWParam(APVerifyEntryModel verifyEntryModel, List<Object[]> paramList, boolean mscommon) {
        String entity = verifyEntryModel.getEntity();
        if (!"im_purreceivebill".equals(entity)) {
            return;
        }
        long entryPk = verifyEntryModel.getEntryPk();
        long entityId = verifyEntryModel.getEntityId();
        BigDecimal verifyQty = verifyEntryModel.getVerifyQty();
        BigDecimal verifyBaseQty = verifyEntryModel.getVerifyBaseQty();
        if (mscommon) {
            verifyQty = BigDecimal.ZERO;
            verifyBaseQty = BigDecimal.ZERO;
        }
        BigDecimal joinPriceQty = verifyEntryModel.getJoinPriceQty();
        BigDecimal joinPriceBaseQty = verifyEntryModel.getJoinPriceBaseQty();
        Object[] param = new Object[]{verifyQty, verifyQty, verifyBaseQty, verifyBaseQty, joinPriceQty, joinPriceQty, joinPriceBaseQty, joinPriceBaseQty, entryPk, entityId};
        paramList.add(param);
    }

    private static void addPurInBillRWParam(APVerifyEntryModel verifyEntryModel, List<Object[]> paramList, boolean notUpdVerify) {
        String entity = verifyEntryModel.getEntity();
        if (!"im_purinbill".equals(entity)) {
            return;
        }
        long entryPk = verifyEntryModel.getEntryPk();
        long entityId = verifyEntryModel.getEntityId();
        BigDecimal verifyQty = verifyEntryModel.getVerifyQty();
        BigDecimal verifyBaseQty = verifyEntryModel.getVerifyBaseQty();
        if (notUpdVerify) {
            verifyQty = BigDecimal.ZERO;
            verifyBaseQty = BigDecimal.ZERO;
        }
        BigDecimal joinPriceQty = verifyEntryModel.getJoinPriceQty();
        BigDecimal joinPriceBaseQty = verifyEntryModel.getJoinPriceBaseQty();
        Object[] param = new Object[]{verifyQty, verifyQty, verifyBaseQty, verifyBaseQty, joinPriceQty, joinPriceQty, joinPriceBaseQty, joinPriceBaseQty, entryPk, entityId};
        paramList.add(param);
    }

    private static Map<Long, List<Long>> getApEntryList(String billType, List<Long> entryIds, Set<Long> entityIds) {
        return CommonVerifyHelper.getSpecEntryList(billType, entityIds, entryIds, "ap_finapbill", "detailentry");
    }

    private static void addPurContractRWParam(APVerifyEntryModel verifyEntryModel, List<Object[]> purContractParamList) {
        Long mainBillEntryid = verifyEntryModel.getMainBillEntryid();
        Long conbillEntryid = verifyEntryModel.getConbillentryid();
        if (mainBillEntryid != null && mainBillEntryid != 0L || conbillEntryid != null && conbillEntryid != 0L) {
            Long measureunit = verifyEntryModel.getMeasureunit();
            BigDecimal verifyQty = verifyEntryModel.getAsstAllPriceQty();
            BigDecimal verifyBaseQty = verifyEntryModel.getAsstAllPriceBaseQty();
            BigDecimal verifyAmt = verifyEntryModel.getVerifyAmt();
            Long orgid = verifyEntryModel.getOrgid();
            Long mainbillid = verifyEntryModel.getMainbillid();
            Long conbillid = verifyEntryModel.getConbillid();
            Object[] qtyParam = new Object[]{verifyQty, verifyBaseQty, measureunit, verifyAmt, orgid, mainBillEntryid, mainbillid, conbillid, conbillEntryid};
            purContractParamList.add(qtyParam);
        }
    }
}

