/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.CommonVerifyHelper;
import kd.scmc.im.consts.ARVerifyAsstEntryModel;
import kd.scmc.im.consts.ARVerifyEntryModel;
import kd.scmc.im.enums.PrecisionAccountEnum;

public class ARVerifyHelper {
    protected static final Log logger = LogFactory.getLog(ARVerifyHelper.class);
    private static final String AR_REVCFMBILL = "ar_revcfmbill";
    private static final String AR_FINARBILL = "ar_finarbill";

    public static void processARVerifyJoinQtyResult(List<Map<String, Object>> disposeList) {
        block29: {
            if (disposeList == null || disposeList.isEmpty()) {
                return;
            }
            ArrayList<Object[]> saleOutBillParamList = new ArrayList<Object[]>(16);
            for (Map<String, Object> disposeParam : disposeList) {
                Long entryPk = (Long)disposeParam.get("entryid");
                Long entityId = (Long)disposeParam.get("id");
                BigDecimal joinPriceQty = (BigDecimal)disposeParam.get("qty");
                BigDecimal joinPriceBaseQty = (BigDecimal)disposeParam.get("baseqty");
                Object[] param = new Object[]{joinPriceQty, joinPriceQty, joinPriceBaseQty, joinPriceBaseQty, entryPk, entityId};
                saleOutBillParamList.add(param);
            }
            try (TXHandle h = TX.required();){
                try {
                    if (saleOutBillParamList.isEmpty()) break block29;
                    String sql = "update t_im_saloutbillentry_r set  fremainjoinpriceqty = fremainjoinpriceqty-?,fjoinpriceqty = fjoinpriceqty+?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty-?,fjoinpricebaseqty = fjoinpricebaseqty+?  where fentryid=? and fid = ?";
                    ArrayList<Long> ids = new ArrayList<Long>(saleOutBillParamList.size());
                    for (Object[] ob : saleOutBillParamList) {
                        ids.add((Long)ob[4]);
                    }
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_im_saloutbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});){
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, saleOutBillParamList);
                    }
                }
                catch (Exception ex) {
                    h.markRollback();
                    throw ex;
                }
            }
        }
    }

    public static void processARVerifyResult(List<Map<String, Object>> disposeList) {
        if (disposeList == null || disposeList.isEmpty()) {
            return;
        }
        boolean mscommon = CommonVerifyHelper.isMscommon(disposeList.get(0));
        Map<Long, ARVerifyEntryModel> verifyEntryModelMap = ARVerifyHelper.buildVerifyModel(disposeList, true);
        ArrayList<Object[]> saleOutBillParamList = new ArrayList<Object[]>();
        HashMap<Long, List<Object[]>> entryModelDataMap = new HashMap<Long, List<Object[]>>(verifyEntryModelMap.size());
        for (ARVerifyEntryModel verifyEntryModel : verifyEntryModelMap.values()) {
            ARVerifyHelper.addSaleOutBillRWParam(verifyEntryModel, saleOutBillParamList, mscommon);
            ARVerifyHelper.addSaleBillRWParam(verifyEntryModel, entryModelDataMap);
        }
        List<Object[]> paramListPass = ARVerifyHelper.dealSalOderWBQty(entryModelDataMap, BigDecimal.ONE);
        try (TXHandle h = TX.required();){
            try {
                String sql;
                if (!saleOutBillParamList.isEmpty()) {
                    sql = "update t_im_saloutbillentry_r set  funverifyqty = funverifyqty-?,fverifyqty = fverifyqty+?,  funverifybaseqty = funverifybaseqty-?,fverifybaseqty = fverifybaseqty+?,  fremainjoinpriceqty = fremainjoinpriceqty-?,fjoinpriceqty = fjoinpriceqty+?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty-?,fjoinpricebaseqty = fjoinpricebaseqty+?  where fentryid=? and fid = ?";
                    ArrayList<Long> ids = new ArrayList<Long>(saleOutBillParamList.size());
                    ArrayList<Long> entryId = new ArrayList<Long>(saleOutBillParamList.size());
                    for (Object[] ob : saleOutBillParamList) {
                        ids.add((Long)ob[9]);
                        entryId.add((Long)ob[8]);
                    }
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_im_saloutbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});){
                        logger.info("processARVerifyResult\u2014\u2014SQL:" + sql);
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, saleOutBillParamList);
                    }
                    ARVerifyHelper.checkBillBaseQty(ids, entryId, "im_saloutbill");
                }
                if (!entryModelDataMap.isEmpty() && paramListPass.size() > 0) {
                    sql = "update t_sm_salorderentry_r set  FConfirmQty =  ?, FConfirmBaseQty = ?,FConfirmAmount = ? where fentryid = ? and fid = ?";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramListPass);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private static void checkBillBaseQty(List<Long> ids, List<Long> entryId, String billEntity) {
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and("billentry.id", "in", entryId);
        QFilter qFilterBlue = new QFilter("billentry.unverifybaseqty", "<", (Object)BigDecimal.ZERO);
        qFilterBlue.and("billentry.verifybaseqty", ">", (Object)BigDecimal.ZERO);
        QFilter qFilterRed = new QFilter("billentry.unverifybaseqty", ">", (Object)BigDecimal.ZERO);
        qFilterRed.and("billentry.verifybaseqty", "<", (Object)BigDecimal.ZERO);
        QFilter all = qFilterBlue.or(qFilterRed);
        qFilter.and(all);
        boolean isHasErrorBill = QueryServiceHelper.exists((String)billEntity, (QFilter[])qFilter.toArray());
        if (isHasErrorBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u5199\u8d85\u989d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"APVerifyHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    private static List<Object[]> dealSalOderWBQty(Map<Long, List<Object[]>> entryModelDataMap, BigDecimal direction) {
        if (entryModelDataMap.isEmpty()) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ARVerifyHelper#dealSalOderWBQty\u53c2\u6570paramListOrgMap.size=" + entryModelDataMap.size());
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(entryModelDataMap.size());
        QFilter filter = new QFilter("billentry.id", "in", entryModelDataMap.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("ARVerifyHelper#dealSalOderWBQty\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8fc7\u6ee4\u6761\u4ef6\u4e3a:" + filter);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getsalebillmainentryid", (String)"sm_salorder", (String)ARVerifyHelper.getSelectFields(), (QFilter[])filter.toArray(), (String)"");){
            for (Row row : ds) {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u6839\u636e\u6838\u9500\u6a21\u578b\u7684\u6838\u5fc3\u5355\u636e\u884cid\u67e5\u53d6\u7684\u9500\u552e\u8ba2\u5355\u884c\u6570\u636e:" + row);
                }
                BigDecimal cfmQty = row.getBigDecimal("confirmqty");
                BigDecimal cfmBaseQty = row.getBigDecimal("confirmbaseqty");
                BigDecimal cfmAmount = row.getBigDecimal("confirmamount");
                Object[] paramObj = new Object[5];
                paramObj[3] = row.getLong("entryid");
                paramObj[4] = row.getLong("id");
                Long entryid = row.getLong("entryid");
                List<Object[]> list = entryModelDataMap.get(entryid);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u6838\u9500\u6a21\u578b\u8fd4\u56de\u7684\u53cd\u5199\u5b57\u6bb5\u503c:" + SerializationUtils.toJsonString(list));
                }
                BigDecimal sumBaseQty = BigDecimal.ZERO;
                for (Object[] modelEntry : list) {
                    if (modelEntry[4] == null || !modelEntry[4].equals(row.getLong("entrysettleorg"))) continue;
                    sumBaseQty = sumBaseQty.add((BigDecimal)modelEntry[1]);
                    cfmAmount = cfmAmount.add(((BigDecimal)modelEntry[3]).multiply(direction));
                }
                paramObj[1] = cfmBaseQty.add(sumBaseQty.multiply(direction));
                paramObj[2] = cfmAmount;
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)row.getLong("masterid"), (Long)row.getLong("baseunit"), (Long)row.getLong("unit"));
                if (muConv != null && muConv.getInt("numerator") != 0 && StringUtils.isNotEmpty((CharSequence)row.getString("precisionaccount"))) {
                    Integer precision = row.getInteger("precision");
                    Integer precisionaccount = PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(row.getString("precisionaccount")));
                    cfmQty = ((BigDecimal)paramObj[1]).multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), (int)precision, precisionaccount);
                }
                paramObj[0] = cfmQty;
                paramList.add(paramObj);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u53cd\u5199\u9500\u552e\u8ba2\u5355\u53c2\u6570paramObj:" + SerializationUtils.toJsonString((Object)paramObj));
            }
            ArrayList<Object[]> arrayList = paramList;
            return arrayList;
        }
    }

    private static String getSelectFields() {
        List<String> selectors = Arrays.asList("id", "billentry.id entryid", "billentry.material.masterid masterid", "billentry.unit unit", "billentry.baseunit baseunit", "billentry.unit.precisionaccount precisionaccount", "billentry.unit.precision precision", "billentry.entrysettleorg entrysettleorg", "billentry.joinpriceqty arqty", "billentry.basearqty basearqty", "billentry.aramount aramount", "billentry.confirmqty confirmqty", "billentry.confirmbaseqty confirmbaseqty", "billentry.confirmamount confirmamount");
        return String.join((CharSequence)",", selectors);
    }

    public static void processARUnVerifyResult(List<Map<String, Object>> disposeList) {
        if (disposeList == null || disposeList.isEmpty()) {
            return;
        }
        boolean mscommon = CommonVerifyHelper.isMscommon(disposeList.get(0));
        Map<Long, ARVerifyEntryModel> verifyEntryModelMap = ARVerifyHelper.buildVerifyModel(disposeList, false);
        ArrayList<Object[]> saleOutBillParamList = new ArrayList<Object[]>();
        HashMap<Long, List<Object[]>> entryModelDataMap = new HashMap<Long, List<Object[]>>(verifyEntryModelMap.size());
        for (ARVerifyEntryModel verifyEntryModel : verifyEntryModelMap.values()) {
            ARVerifyHelper.addSaleOutBillRWParam(verifyEntryModel, saleOutBillParamList, mscommon);
            ARVerifyHelper.addSaleBillRWParam(verifyEntryModel, entryModelDataMap);
        }
        List<Object[]> paramListPass = ARVerifyHelper.dealSalOderWBQty(entryModelDataMap, BigDecimal.ONE.negate());
        try (TXHandle h = TX.required();){
            try {
                String sql;
                if (!saleOutBillParamList.isEmpty()) {
                    sql = "update t_im_saloutbillentry_r set  funverifyqty = funverifyqty+?,fverifyqty = fverifyqty-?,  funverifybaseqty = funverifybaseqty+?,fverifybaseqty = fverifybaseqty-?,  fremainjoinpriceqty = fremainjoinpriceqty+?,fjoinpriceqty = fjoinpriceqty-?,  fremainjoinpricebaseqty = fremainjoinpricebaseqty+?,fjoinpricebaseqty = fjoinpricebaseqty-?   where fentryid=? and fid =?";
                    ArrayList<Long> ids = new ArrayList<Long>(saleOutBillParamList.size());
                    for (Object[] ob : saleOutBillParamList) {
                        ids.add((Long)ob[9]);
                    }
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_im_saloutbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});){
                        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, saleOutBillParamList);
                    }
                }
                if (!entryModelDataMap.isEmpty() && paramListPass.size() > 0) {
                    sql = "update t_sm_salorderentry_r set FConfirmQty = ?, FConfirmBaseQty = ?, FConfirmAmount = ? where fentryid = ? and fid = ?";
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramListPass);
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    private static Map<Long, ARVerifyEntryModel> buildVerifyModel(List<Map<String, Object>> disposeList, boolean isVerify) {
        Object unVerifyEntryModel;
        HashMap<Long, ARVerifyEntryModel> verifyEntryModelMap = new HashMap<Long, ARVerifyEntryModel>(disposeList.size());
        HashSet<Long> entityIds = new HashSet<Long>(16);
        ArrayList<Long> outForSale = new ArrayList<Long>(disposeList.size());
        for (Map<String, Object> dispose : disposeList) {
            Long entryModelPk;
            if (logger.isDebugEnabled()) {
                logger.debug("\u6784\u5efa\u6838\u9500\u6a21\u578b\u5165\u53c2dispose: " + SerializationUtils.toJsonString(dispose));
            }
            ARVerifyEntryModel entryModel = ARVerifyHelper.buildVerifyEntryModel(dispose);
            if (logger.isDebugEnabled()) {
                logger.debug("\u6784\u5efa\u6838\u9500\u6a21\u578b: entryModel:" + SerializationUtils.toJsonString((Object)entryModel));
            }
            if ((unVerifyEntryModel = (ARVerifyEntryModel)verifyEntryModelMap.get(entryModelPk = entryModel.getEntryPk())) != null) {
                entryModel.setVerifyQty(entryModel.getVerifyQty().add(unVerifyEntryModel.getVerifyQty()));
                entryModel.setVerifyBaseQty(entryModel.getVerifyBaseQty().add(unVerifyEntryModel.getVerifyBaseQty()));
                entryModel.setVerifyAmt(entryModel.getVerifyAmt().add(unVerifyEntryModel.getVerifyAmt()));
                entryModel.setConfirmamt(entryModel.getConfirmamt().add(unVerifyEntryModel.getConfirmamt()));
                List unVerifyEntryModelAsstEntry = unVerifyEntryModel.getAsstEntrys();
                if (!unVerifyEntryModelAsstEntry.isEmpty()) {
                    entryModel.getAsstEntrys().addAll(unVerifyEntryModelAsstEntry);
                }
            }
            ARVerifyHelper.setAsstAllQty(entryModel);
            verifyEntryModelMap.put(entryModel.getEntryPk(), entryModel);
            entityIds.add(entryModel.getEntityId());
            outForSale.add(entryModel.getEntryPk());
        }
        Map<Long, List<Long>> saleOutApEntryMap = ARVerifyHelper.getArEntryList("im_saloutbill", outForSale, entityIds);
        QFilter outForSaleQf = new QFilter("billentry.id", "in", verifyEntryModelMap.keySet());
        outForSaleQf = outForSaleQf.and(new QFilter("id", "in", entityIds));
        DynamicObjectCollection outForSaleBills = new DynamicObjectCollection();
        ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_im_saloutbill", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, entityIds)});
        unVerifyEntryModel = null;
        try {
            outForSaleBills = QueryServiceHelper.query((String)"im_saloutbill", (String)"id,billentry.id,billentry.mainbillentity,billentry.mainbillid,billentry.mainbillentryid,billentry.material.masterid as billentry.material,billentry.unit.precision,billentry.unit.precisionaccount,billentry.remainjoinpriceqty,billentry.remainjoinpricebaseqty,billentry.joinpriceqty,billentry.joinpricebaseqty,billentry.conbillentity,billentry.conbillid,billentry.conbillentryid", (QFilter[])outForSaleQf.toArray());
        }
        catch (Throwable unVerifyEntryModelAsstEntry) {
            unVerifyEntryModel = unVerifyEntryModelAsstEntry;
            throw unVerifyEntryModelAsstEntry;
        }
        finally {
            if (ctx != null) {
                if (unVerifyEntryModel != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable unVerifyEntryModelAsstEntry) {
                        ((Throwable)unVerifyEntryModel).addSuppressed(unVerifyEntryModelAsstEntry);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        if (outForSaleBills == null || outForSaleBills.isEmpty()) {
            return verifyEntryModelMap;
        }
        for (DynamicObject outForSaleBill : outForSaleBills) {
            Long entryId = outForSaleBill.getLong("billentry.id");
            ARVerifyEntryModel arVerifyEntryModel = (ARVerifyEntryModel)verifyEntryModelMap.get(entryId);
            if (arVerifyEntryModel == null) continue;
            List<Long> arEntrylist = saleOutApEntryMap.get(entryId);
            ARVerifyHelper.setRwJoinPirceQty(isVerify, outForSaleBill, arVerifyEntryModel, arEntrylist);
            Long entityId = outForSaleBill.getLong("id");
            arVerifyEntryModel.setEntityId(entityId);
            Long mainbillid = outForSaleBill.getLong("billentry.mainbillid");
            String mainbillentity = outForSaleBill.getString("billentry.mainbillentity");
            Long mainbillentryid = outForSaleBill.getLong("billentry.mainbillentryid");
            if (0L != mainbillentryid && "sm_salorder".equals(mainbillentity)) {
                arVerifyEntryModel.setMainbillid(mainbillid);
                arVerifyEntryModel.setMainBillEntryid(mainbillentryid);
            }
            String conbillentity = outForSaleBill.getString("billentry.conbillentity");
            Long conbillid = outForSaleBill.getLong("billentry.conbillid");
            Long conbillentryid = outForSaleBill.getLong("billentry.conbillentryid");
            if (0L == conbillid || 0L == conbillentryid || !"conm_salcontract".equals(conbillentity)) continue;
            arVerifyEntryModel.setConbillentity(conbillentity);
            arVerifyEntryModel.setConbillid(conbillid);
            arVerifyEntryModel.setConbillentryid(conbillentryid);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b8c\u6210\u6784\u5efa\u6838\u9500\u6a21\u578b: verifyEntryModelMap:" + SerializationUtils.toJsonString(verifyEntryModelMap));
        }
        return verifyEntryModelMap;
    }

    private static void setAsstAllQty(ARVerifyEntryModel entryModel) {
        BigDecimal asstAllPriceQty = BigDecimal.ZERO;
        BigDecimal asstAllPriceBaseQty = BigDecimal.ZERO;
        for (ARVerifyAsstEntryModel asstEntry : entryModel.getAsstEntrys()) {
            BigDecimal asstVerifyQty = asstEntry.getAsstVerifyQty();
            asstAllPriceQty = asstAllPriceQty.add(asstVerifyQty);
            asstAllPriceBaseQty = asstAllPriceBaseQty.add(asstEntry.getAsstVerifyBaseQty());
        }
        entryModel.setAsstAllPriceQty(asstAllPriceQty);
        entryModel.setAsstAllPriceBaseQty(asstAllPriceBaseQty);
    }

    private static void setRwJoinPirceQty(Boolean isVerify, DynamicObject outForSaleBillentry, ARVerifyEntryModel arVerifyEntryModel, List<Long> arEntrylist) {
        String verifyRelation = arVerifyEntryModel.getVerifyRelation();
        if ("salself".equals(verifyRelation)) {
            return;
        }
        boolean botp = arVerifyEntryModel.isBotp();
        if (botp) {
            return;
        }
        boolean isAllBotpGenArEntry = true;
        List asstEntrys = arVerifyEntryModel.getAsstEntrys();
        if (arEntrylist != null && !arEntrylist.isEmpty()) {
            for (ARVerifyAsstEntryModel asstEntry : asstEntrys) {
                Long asstEntryPk = asstEntry.getAsstEntryPk();
                if (arEntrylist.contains(asstEntryPk)) {
                    asstEntry.setBotpGen(true);
                    continue;
                }
                isAllBotpGenArEntry = false;
            }
        } else {
            isAllBotpGenArEntry = false;
        }
        if (isAllBotpGenArEntry) {
            return;
        }
        BigDecimal needJoinPriceQty = BigDecimal.ZERO;
        BigDecimal needJoinPriceBaseQty = BigDecimal.ZERO;
        BigDecimal verifyQty = arVerifyEntryModel.getVerifyQty();
        Long measureunit = arVerifyEntryModel.getMeasureunit();
        Long materialid = outForSaleBillentry.getLong("billentry.material");
        Integer precision = outForSaleBillentry.getInt("billentry.unit.precision");
        Integer precisionaccount = outForSaleBillentry.getInt("billentry.unit.precisionaccount");
        Set<Long> asstHasArfinaBills = ARVerifyHelper.dealAsstUpBillIsArBill(asstEntrys);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u4e0a\u6e38\u662f\u5e94\u6536\u5355\u7684\u5355\u636e: dealAsstUpBillIsArBill:" + asstHasArfinaBills);
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>(16);
        for (ARVerifyAsstEntryModel asstEntry : asstEntrys) {
            if (!asstEntry.isBotpGen() && (asstEntry.isHasfinar() || asstHasArfinaBills.contains(asstEntry.getAsstEntryPk()))) {
                BigDecimal unit2ndRate;
                Long asstmeasureunit = asstEntry.getAsstmeasureunit();
                BigDecimal asstVerifyQty = asstEntry.getAsstVerifyQty();
                if (measureunit != null && asstmeasureunit != null && !measureunit.equals(asstmeasureunit) && (unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv(materialid, measureunit, asstmeasureunit, cacheMap)) != null && BigDecimal.ZERO.compareTo(unit2ndRate) != 0 && BigDecimal.ONE.compareTo(unit2ndRate) != 0 && BigDecimal.ZERO.compareTo(verifyQty) != 0) {
                    asstVerifyQty = asstVerifyQty.divide(unit2ndRate, (int)precision, PrecisionAccountEnum.getEnumByVal((int)precisionaccount));
                }
                needJoinPriceQty = needJoinPriceQty.add(asstVerifyQty);
                needJoinPriceBaseQty = needJoinPriceBaseQty.add(asstEntry.getAsstVerifyBaseQty());
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\u83b7\u53d6\u5269\u4f59\u5e94\u6536\u6570\u91cf:  asstEntry:" + SerializationUtils.toJsonString((Object)asstEntry));
            logger.debug("\u83b7\u53d6\u5269\u4f59\u5e94\u6536\u6570\u91cf:  needJoinPriceQty:" + needJoinPriceQty);
        }
        if (isVerify.booleanValue()) {
            BigDecimal remainJoinPriceBaseQty = outForSaleBillentry.getBigDecimal("billentry.remainjoinpricebaseqty");
            BigDecimal remainJoinPriceQty = outForSaleBillentry.getBigDecimal("billentry.remainjoinpriceqty");
            if (remainJoinPriceBaseQty.abs().compareTo(needJoinPriceBaseQty.abs()) < 0 && remainJoinPriceQty.abs().compareTo(needJoinPriceQty.abs()) < 0) {
                arVerifyEntryModel.setJoinPriceQty(remainJoinPriceQty);
                arVerifyEntryModel.setJoinPriceBaseQty(remainJoinPriceBaseQty);
            } else {
                arVerifyEntryModel.setJoinPriceQty(needJoinPriceQty);
                arVerifyEntryModel.setJoinPriceBaseQty(needJoinPriceBaseQty);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u6838\u9500-\u8bbe\u7f6e\u5269\u4f59\u5e94\u6536\u6570\u91cf:  remainJoinPriceQty:" + remainJoinPriceQty + " needJoinPriceQty:" + needJoinPriceQty);
            }
        } else {
            BigDecimal joinPriceQty = outForSaleBillentry.getBigDecimal("billentry.joinpriceqty");
            BigDecimal joinPriceBaseQty = outForSaleBillentry.getBigDecimal("billentry.joinpricebaseqty");
            if (joinPriceBaseQty.abs().compareTo(needJoinPriceQty.abs()) < 0 && joinPriceQty.abs().compareTo(needJoinPriceBaseQty.abs()) < 0) {
                arVerifyEntryModel.setJoinPriceQty(joinPriceQty);
                arVerifyEntryModel.setJoinPriceBaseQty(joinPriceBaseQty);
            } else {
                arVerifyEntryModel.setJoinPriceQty(needJoinPriceQty);
                arVerifyEntryModel.setJoinPriceBaseQty(needJoinPriceBaseQty);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u53cd\u6838\u9500-\u8bbe\u7f6e\u5269\u4f59\u5e94\u6536\u6570\u91cf: joinPriceBaseQty:" + joinPriceBaseQty + " needJoinPriceQty:" + needJoinPriceQty);
            }
        }
    }

    private static Set<Long> dealAsstUpBillIsArBill(List<ARVerifyAsstEntryModel> asstEntrys) {
        Map<Long, Long> billMapping = ARVerifyHelper.getBillMapping(asstEntrys);
        return CommonVerifyHelper.getUpEntryList(AR_REVCFMBILL, AR_FINARBILL, billMapping.values());
    }

    private static Map<Long, Long> getBillMapping(List<ARVerifyAsstEntryModel> asstEntrys) {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashMap<Long, Long> billMapping = new HashMap<Long, Long>(16);
        for (ARVerifyAsstEntryModel asstEntry : asstEntrys) {
            String asstEntity = asstEntry.getAsstEntity();
            if (!AR_REVCFMBILL.equals(asstEntity)) continue;
            entryIds.add(asstEntry.getAsstEntryPk());
        }
        QFilter qFilter = new QFilter("entry.id", "in", entryIds);
        DynamicObjectCollection revcfmbills = QueryServiceHelper.query((String)AR_REVCFMBILL, (String)"id,entry.id", (QFilter[])qFilter.toArray());
        for (DynamicObject ref : revcfmbills) {
            long entryId = ref.getLong("entry.id");
            long id = ref.getLong("id");
            billMapping.put(entryId, id);
        }
        return billMapping;
    }

    private static void addSaleBillRWParam(ARVerifyEntryModel verifyEntryModel, Map<Long, List<Object[]>> paramListOrgMap) {
        Long mainBillEntryid = verifyEntryModel.getMainBillEntryid();
        if (mainBillEntryid != null && mainBillEntryid != 0L) {
            BigDecimal verifyQty = verifyEntryModel.getAsstAllPriceQty();
            BigDecimal verifyBaseQty = verifyEntryModel.getAsstAllPriceBaseQty();
            BigDecimal verifyAmt = verifyEntryModel.getVerifyAmt();
            BigDecimal confirmAmt = verifyEntryModel.getConfirmamt();
            Long orgid = verifyEntryModel.getOrgid();
            Object[] qtyParam = new Object[]{verifyQty, verifyBaseQty, verifyAmt, confirmAmt, orgid};
            List<Object[]> saleBillQtyParamList = paramListOrgMap.get(mainBillEntryid);
            if (saleBillQtyParamList == null) {
                saleBillQtyParamList = new ArrayList<Object[]>();
                paramListOrgMap.put(mainBillEntryid, saleBillQtyParamList);
            }
            saleBillQtyParamList.add(qtyParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u6dfb\u52a0\u9500\u552e\u8ba2\u5355\u53cd\u5199\u53c2\u6570: outForOrderParam:" + SerializationUtils.toJsonString(saleBillQtyParamList));
            }
        }
    }

    private static void addSaleOutBillRWParam(ARVerifyEntryModel verifyEntryModel, List<Object[]> paramList, boolean notUpdVerify) {
        String entity = verifyEntryModel.getEntity();
        if (!"im_saloutbill".equals(entity)) {
            return;
        }
        long entryPk = verifyEntryModel.getEntryPk();
        long entityId = verifyEntryModel.getEntityId();
        BigDecimal verifyQty = verifyEntryModel.getVerifyQty();
        BigDecimal verifyBaseQty = verifyEntryModel.getVerifyBaseQty();
        if (notUpdVerify) {
            verifyQty = BigDecimal.ZERO;
            verifyBaseQty = BigDecimal.ZERO;
        }
        BigDecimal joinPriceQty = verifyEntryModel.getJoinPriceQty();
        BigDecimal joinPriceBaseQty = verifyEntryModel.getJoinPriceBaseQty();
        if (verifyEntryModel.isNoUpdateJoinQty().booleanValue()) {
            joinPriceQty = BigDecimal.ZERO;
            joinPriceBaseQty = BigDecimal.ZERO;
        }
        Object[] param = new Object[]{verifyQty, verifyQty, verifyBaseQty, verifyBaseQty, joinPriceQty, joinPriceQty, joinPriceBaseQty, joinPriceBaseQty, entryPk, entityId};
        if (logger.isDebugEnabled()) {
            logger.debug("\u6dfb\u52a0\u9500\u552e\u51fa\u5e93\u5355\u53cd\u5199\u53c2\u6570: addSaleOutBillRWParam:" + SerializationUtils.toJsonString((Object)param));
        }
        paramList.add(param);
    }

    private static ARVerifyEntryModel buildVerifyEntryModel(Map<String, Object> dispose) {
        List asstDataList;
        Object isbotp;
        Object verifybaseqty;
        Object verifyqty;
        Object confirmamt;
        ARVerifyEntryModel entryModel = new ARVerifyEntryModel();
        entryModel.setEntity((String)dispose.get("entity"));
        entryModel.setEntityId((Long)dispose.get("pk"));
        entryModel.setEntryPk((Long)dispose.get("entrypk"));
        entryModel.setOrgid((Long)dispose.get("orgid"));
        entryModel.setVerifyRelation((String)dispose.get("verifyrelation"));
        entryModel.setVerifyType((String)dispose.get("verifytype"));
        Object verifyamt = dispose.get("verifyamt");
        entryModel.setMeasureunit((Long)dispose.get("measureunit"));
        if (verifyamt != null) {
            entryModel.setVerifyAmt((BigDecimal)verifyamt);
        }
        if ((confirmamt = dispose.get("confirmamt")) != null) {
            entryModel.setConfirmamt((BigDecimal)confirmamt);
        }
        if ((verifyqty = dispose.get("verifyqty")) != null) {
            entryModel.setVerifyQty((BigDecimal)verifyqty);
        }
        if ((verifybaseqty = dispose.get("verifybaseqty")) != null) {
            entryModel.setVerifyBaseQty((BigDecimal)verifybaseqty);
        }
        if ((isbotp = dispose.get("isbotp")) != null) {
            entryModel.setBotp(((Boolean)isbotp).booleanValue());
        }
        Object iswrittenoffverify = dispose.get("iswrittenoffverify");
        if (isbotp != null) {
            entryModel.setIswrittenoffverify(((Boolean)iswrittenoffverify).booleanValue());
        }
        if ((asstDataList = (List)dispose.get("asstdata")) != null && !asstDataList.isEmpty()) {
            for (Map asstData : asstDataList) {
                Object hasfinar;
                Object asstverifybaseqty;
                ARVerifyAsstEntryModel asstEntry = new ARVerifyAsstEntryModel();
                asstEntry.setAsstEntity((String)asstData.get("asstentity"));
                asstEntry.setAsstEntryPk((Long)asstData.get("asstentrypk"));
                asstEntry.setAsstmeasureunit((Long)asstData.get("asstmeasureunit"));
                Object asstverifyqty = asstData.get("asstverifyqty");
                if (asstverifyqty != null) {
                    asstEntry.setAsstVerifyQty((BigDecimal)asstverifyqty);
                }
                if ((asstverifybaseqty = asstData.get("asstverifybaseqty")) != null) {
                    asstEntry.setAsstVerifyBaseQty((BigDecimal)asstverifybaseqty);
                }
                if ((hasfinar = asstData.get("hasfinar")) != null) {
                    asstEntry.setHasfinar(((Boolean)hasfinar).booleanValue());
                }
                entryModel.getAsstEntrys().add(asstEntry);
            }
        }
        boolean notWriteBackJoinQty = CommonVerifyHelper.isNotWriteBackJoinQty(dispose);
        entryModel.setNoUpdateJoinQty(Boolean.valueOf(notWriteBackJoinQty));
        return entryModel;
    }

    private static Map<Long, List<Long>> getArEntryList(String billType, List<Long> entryIds, Set<Long> entityIds) {
        return CommonVerifyHelper.getSpecEntryList(billType, entityIds, entryIds, AR_REVCFMBILL, "entry");
    }
}

