/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ApplyBillCloseHelper {
    private static final String TRANSAPPLYBASEQTY = "transapplybaseqty";
    private static final String TRANSAPPLYQTY = "transapplyqty";
    private static final String SM_SALORDER = "sm_salorder";
    private static final String CLOSE_STATUS = "D";
    private static final String ROWBILL_STATUS = "rowbillstatus";
    private static final String DELIVERBASEQTYUP = "deliverbaseqtyup";

    public static DynamicObject[] rebuildSaleOrders(DynamicObject[] dataEntities, boolean isUnClose) {
        DynamicObject[] salOrders;
        HashSet<Object> pks = new HashSet<Object>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Object pkValue = dataEntity.getPkValue();
            if (pkValue == null) continue;
            pks.add(pkValue);
        }
        if (pks.size() == 0) {
            return new DynamicObject[0];
        }
        dataEntities = BusinessDataServiceHelper.load((String)"im_transapply", (String)"id,billentry.rowbillstatus,billentry.srcbillentity,billentry.srcbillid,billentry.srcbillentryid,billentry.remaintransoutbaseqty", (QFilter[])new QFilter("id", "in", pks).toArray());
        HashSet<Object> srcBillIds = new HashSet<Object>(dataEntities.length);
        HashMap<Object, BigDecimal> returnBaseQty = new HashMap<Object, BigDecimal>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                Object srcBillId;
                Object rowBillStatus = entry.get(ROWBILL_STATUS);
                Object srcBillEntity = entry.get("srcbillentity");
                if (!isUnClose && CLOSE_STATUS.equals(rowBillStatus) || isUnClose && !CLOSE_STATUS.equals(rowBillStatus) || !SM_SALORDER.equals(srcBillEntity) || (srcBillId = entry.get("srcbillid")) == null || (Long)srcBillId == 0L) continue;
                srcBillIds.add(srcBillId);
                Object srcBillEntryId = entry.get("srcbillentryid");
                if (srcBillEntryId == null || (Long)srcBillEntryId == 0L) continue;
                BigDecimal remainTransOutBaseQty = entry.getBigDecimal("remaintransoutbaseqty");
                returnBaseQty.put(srcBillEntryId, remainTransOutBaseQty);
            }
        }
        if (srcBillIds.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("id", "in", srcBillIds);
        for (DynamicObject salOrder : salOrders = BusinessDataServiceHelper.load((String)SM_SALORDER, (String)"billno,billentry.transapplyqty,billentry.transapplybaseqty,billentry.qty,billentry.baseqty,billentry.deliverbaseqtyup,billentry.deliverqtyup", (QFilter[])filter.toArray())) {
            DynamicObjectCollection entries = salOrder.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entries) {
                BigDecimal deliverBaseQtyUp;
                Object entryPk = entry.getPkValue();
                BigDecimal remainTransOutBaseQty = (BigDecimal)returnBaseQty.get(entryPk);
                if (remainTransOutBaseQty == null || BigDecimal.ZERO.compareTo(remainTransOutBaseQty) == 0) continue;
                BigDecimal transApplyBaseQty = entry.getBigDecimal(TRANSAPPLYBASEQTY);
                transApplyBaseQty = isUnClose ? transApplyBaseQty.add(remainTransOutBaseQty) : transApplyBaseQty.subtract(remainTransOutBaseQty);
                if (transApplyBaseQty.compareTo(deliverBaseQtyUp = entry.getBigDecimal(DELIVERBASEQTYUP)) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u6e38\u9500\u552e\u8ba2\u5355\u7684\u5df2\u8c03\u62e8\u7533\u8bf7\u6570\u91cf\u5927\u4e8e\u53d1\u8d27\u4e0a\u9650\u6570\u91cf\uff0c\u4e0d\u80fd\u53cd\u5173\u95ed\u3002", (String)"ApplyBillCloseHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
                }
                entry.set(TRANSAPPLYBASEQTY, (Object)transApplyBaseQty);
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                if (BigDecimal.ZERO.compareTo(baseQty) == 0) continue;
                BigDecimal transApplyQty = transApplyBaseQty.multiply(qty.divide(baseQty, 10, 4));
                entry.set(TRANSAPPLYQTY, (Object)transApplyQty);
            }
        }
        return salOrders;
    }
}

