/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class BillUnitAndQtytHelper {
    private static final Log log = LogFactory.getLog(BillUnitAndQtytHelper.class);

    public static void setBizQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        BillUnitAndQtytHelper.setBizQtyAndUnit(bill, rowindex, fieldName, newValue, false);
    }

    public static void setBizQtyAndUnitWithAuditQty(IDataModel bill, int rowindex, String fieldName, Object newValue) {
        BillUnitAndQtytHelper.setBizQtyAndUnit(bill, rowindex, fieldName, newValue, true);
    }

    private static void setBizQtyAndUnit(IDataModel bill, int rowindex, String fieldName, Object newValue, boolean isBaseAuditQty) {
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowindex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        switch (fieldName) {
            case "auditqty": 
            case "qty": {
                BillUnitAndQtytHelper.changeQty(bill, rowindex, (BigDecimal)newValue, material);
                break;
            }
            case "unit": {
                if (isBaseAuditQty) {
                    BillUnitAndQtytHelper.changeUnitByAuditQty(bill, rowindex, (DynamicObject)newValue, material);
                    break;
                }
                BillUnitAndQtytHelper.changeUnit(bill, rowindex, (DynamicObject)newValue, material);
                break;
            }
        }
    }

    private static void changeQty(IDataModel bill, int rowindex, BigDecimal qty, DynamicObject material) {
        DynamicObject unit = (DynamicObject)bill.getValue("unit", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        BillUnitAndQtytHelper.setBaseQtyValue(bill, rowindex, material, qty, baseUnit, unit);
    }

    private static void changeUnit(IDataModel bill, int rowindex, DynamicObject unit, DynamicObject material) {
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)bill.getValue("qty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        qty = PrecisionAccountHelper.dealWithprecision(unit, qty);
        bill.setValue("qty", (Object)qty, rowindex);
        BillUnitAndQtytHelper.setBaseQtyValue(bill, rowindex, material, qty, baseUnit, unit);
    }

    private static void changeUnitByAuditQty(IDataModel bill, int rowindex, DynamicObject unit, DynamicObject material) {
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)bill.getValue("qty", rowindex);
        qty = PrecisionAccountHelper.dealWithprecision(unit, qty);
        bill.setValue("qty", (Object)qty, rowindex);
        BigDecimal auditQty = (BigDecimal)bill.getValue("auditqty", rowindex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowindex);
        BillUnitAndQtytHelper.setBaseQtyValue(bill, rowindex, material, auditQty, baseUnit, unit);
    }

    private static void setBaseQtyValue(IDataModel bill, int rowindex, DynamicObject material, BigDecimal qty, DynamicObject baseUnit, DynamicObject unit) {
        boolean isTransBill;
        String formId = bill.getDataEntityType().getName();
        boolean bl = isTransBill = formId != null && (formId.equals("im_adjustbill") || formId.equals("im_assembbill") || formId.equals("im_disassemblebill"));
        if (isTransBill) {
            qty = BigDecimal.ZERO.max(qty);
        }
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv(material, unit, qty, baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"baseqty");
        bill.beginInit();
        if (isTransBill) {
            bill.setValue("qty", (Object)qty, rowindex);
        }
        bill.setValue("baseqty", (Object)baseQty, rowindex);
        bill.endInit();
    }

    public static void showQtyErrorTip(BigDecimal qtyAmount) {
        CommonUtils.showQtyErrorTip((BigDecimal)qtyAmount);
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId, IPageCache pageCache) {
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            return Constants.ZERO;
        }
        StringBuilder cachekeySb = new StringBuilder("unitRateCache_").append("_").append(materialId).append("_").append(srcUnitId).append("_").append(desUnitId);
        String cachekey = cachekeySb.toString();
        String rateCache = pageCache.get(cachekey);
        if (StringUtils.isNotBlank((CharSequence)rateCache)) {
            return new BigDecimal(rateCache);
        }
        BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv(materialId, srcUnitId, desUnitId);
        unitRate = unitRate == null ? BigDecimal.ZERO : unitRate;
        pageCache.put(cachekey, unitRate.toString());
        return unitRate;
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId, Map<String, String> cacheMap) {
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            return Constants.ZERO;
        }
        StringBuilder cachekeySb = new StringBuilder("unitRateCache_").append("_").append(materialId).append("_").append(srcUnitId).append("_").append(desUnitId);
        String cachekey = cachekeySb.toString();
        String rateCache = cacheMap.get(cachekey);
        if (StringUtils.isNotBlank((CharSequence)rateCache)) {
            return new BigDecimal(rateCache);
        }
        BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv(materialId, srcUnitId, desUnitId);
        unitRate = unitRate == null ? BigDecimal.ZERO : unitRate;
        cacheMap.put(cachekey, unitRate.toString());
        return unitRate;
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = Constants.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = Constants.ONE;
        } else {
            try {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e24\u4e2a\u5355\u4f4d\u7684\u6362\u7b97\u7387\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        if (unitRate == null) {
            unitRate = Constants.ZERO;
        }
        return unitRate;
    }

    public static Map<String, Object> getQty(DynamicObject material, BigDecimal baseQty, DynamicObject baseUnit, DynamicObject unit, BigDecimal unitRate, DynamicObject bizUnit, BigDecimal bizUnitRate, DynamicObject priceUnit, BigDecimal priceUnitRate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal qty = Constants.ZERO;
        BigDecimal qtyBizUnit = Constants.ZERO;
        BigDecimal priceQty = Constants.ZERO;
        if (material != null && baseUnit != null) {
            Long baseUnitId = (Long)baseUnit.getPkValue();
            DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz(material);
            if (unit == null) {
                unit = MaterialHelper.getMaterialBizUnit(material);
            }
            if (unit != null && (unitRate == null || unitRate.compareTo(BigDecimal.ZERO) == 0)) {
                unitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), baseUnitId);
            }
            if (bizUnit == null) {
                bizUnit = MaterialHelper.getMaterialBizUnit(material);
            }
            if (bizUnit != null && (bizUnitRate == null || bizUnitRate.compareTo(BigDecimal.ZERO) == 0)) {
                bizUnitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)bizUnit.getPkValue(), baseUnitId);
            }
            if (priceUnit == null) {
                priceUnit = MaterialHelper.getMaterialPriceUnit(material);
            }
            if (priceUnit != null && (priceUnitRate == null || priceUnitRate.compareTo(BigDecimal.ZERO) == 0)) {
                priceUnitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)priceUnit.getPkValue(), baseUnitId);
            }
        }
        if (baseQty != null) {
            if (unitRate != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                qty = baseQty.divide(unitRate, 10, 4);
            }
            if (bizUnitRate != null && bizUnitRate.compareTo(BigDecimal.ZERO) != 0) {
                qtyBizUnit = baseQty.divide(bizUnitRate, 10, 4);
            }
            if (priceUnitRate != null && priceUnitRate.compareTo(BigDecimal.ZERO) != 0) {
                priceQty = baseQty.divide(priceUnitRate, 10, 4);
            }
        }
        map.put("qty", qty);
        map.put("unit", unit);
        map.put("qtybizunit", qtyBizUnit);
        map.put("bizunit", bizUnit);
        map.put("bizunitrate", bizUnitRate);
        map.put("priceqty", priceQty);
        map.put("priceunit", priceUnit);
        map.put("priceunitrate", priceUnitRate);
        return map;
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                String precisionAccount = desUnit.getString("precisionaccount");
                if (StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

