/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.consts.BizTypeConst;
import kd.bd.sbd.enums.BizCategoryEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.BillTypeParameterHelper;
import kd.scmc.im.enums.StatusEnum;

public class BizTypeHelper {
    public static List<String> getMaterialQFilterByBizCategory(String bizCategory) {
        ArrayList<String> materialTypes = new ArrayList<String>();
        if (!BizCategoryEnum.BZ.getValue().equals(bizCategory) && !BizCategoryEnum.WW.getValue().equals(bizCategory)) {
            if (BizCategoryEnum.FY.getValue().equals(bizCategory)) {
                materialTypes.add("7");
            } else if (BizCategoryEnum.ZC.getValue().equals(bizCategory)) {
                materialTypes.add("8");
            } else if (BizCategoryEnum.VMI.getValue().equals(bizCategory) || BizCategoryEnum.ZY.getValue().equals(bizCategory) || BizCategoryEnum.FX.getValue().equals(bizCategory) || BizCategoryEnum.JS.getValue().equals(bizCategory) || BizCategoryEnum.ST.getValue().equals(bizCategory)) {
                // empty if block
            }
        }
        return materialTypes;
    }

    public static List<DynamicObject> getBizTypeByEntityID(String formId) {
        QFilter qFilter1 = new QFilter("billentity.billform", "=", (Object)formId);
        QFilter qFilter3 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter qFilter4 = new QFilter("enable", "=", (Object)"1");
        LinkedHashMap newBizType = (LinkedHashMap)BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (String)BizTypeConst.getAllSelector(), (QFilter[])new QFilter[]{qFilter1, qFilter3, qFilter4}, (String)"number");
        Collection values = newBizType.values();
        DynamicObject[] bizTypes = values.toArray(new DynamicObject[values.size()]);
        return Arrays.asList(bizTypes);
    }

    public static DynamicObject getBillType(String formId, List<DynamicObject> bizTypes, DynamicObject billType) {
        DynamicObject dy = null;
        if (billType != null) {
            DynamicObject paramBizType;
            DynamicObject typeParam = BillTypeParameterHelper.getBillTypeParameter(formId, (Long)billType.getPkValue());
            DynamicObject dynamicObject = paramBizType = typeParam == null ? null : typeParam.getDynamicObject("biztype");
            if (paramBizType != null) {
                for (int i = 0; i < bizTypes.size(); ++i) {
                    String pk = String.valueOf(bizTypes.get(i).getPkValue());
                    String paramPk = String.valueOf(paramBizType.getPkValue());
                    if (!paramPk.equals(pk)) continue;
                    dy = paramBizType;
                }
            }
        }
        return dy;
    }

    public static DynamicObject getBizTypeByBillType(String formId, DynamicObject billType) {
        DynamicObjectCollection paramBizTypes;
        DynamicObject typeParam = BillTypeParameterHelper.getBillTypeParameter(formId, (Long)billType.getPkValue());
        DynamicObjectCollection dynamicObjectCollection = paramBizTypes = typeParam == null ? null : typeParam.getDynamicObjectCollection("entryentity");
        if (paramBizTypes == null || paramBizTypes.size() == 0) {
            return null;
        }
        HashSet<Object> bizNumSet = new HashSet<Object>(paramBizTypes.size());
        Iterator iterator = paramBizTypes.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            DynamicObject biztypenumber = next.getDynamicObject("biztypenumber");
            if (biztypenumber == null) {
                iterator.remove();
                continue;
            }
            Object number = biztypenumber.get("number");
            if ("380".equals(number) || "370".equals(number)) {
                iterator.remove();
                continue;
            }
            bizNumSet.add(biztypenumber.getPkValue());
        }
        if (paramBizTypes.size() == 0) {
            return null;
        }
        Map bizTypeMap = BusinessDataServiceHelper.loadFromCache((Object[])bizNumSet.toArray(), (String)"bd_biztype");
        if (bizTypeMap == null) {
            return null;
        }
        for (DynamicObject paramBizType : paramBizTypes) {
            if (paramBizType == null) continue;
            DynamicObject biz = paramBizType.getDynamicObject("biztypenumber");
            if ((biz = (DynamicObject)bizTypeMap.get(biz.getPkValue())) == null || !"1".equals(biz.get("enable")) || !paramBizType.getBoolean("isdefault")) continue;
            return biz;
        }
        return null;
    }

    public static List<Object> getBizTypeIds(Object billType, String formId) {
        DynamicObject typeParam = BillTypeParameterHelper.getBillTypeParameter(formId, (Long)billType);
        DynamicObjectCollection paramBizTypes = typeParam == null ? null : typeParam.getDynamicObjectCollection("entryentity");
        ArrayList<Object> bizTypes = new ArrayList<Object>(16);
        if (paramBizTypes == null || paramBizTypes.size() == 0) {
            return bizTypes;
        }
        for (DynamicObject paramBizType : paramBizTypes) {
            if (paramBizType.get("biztypenumber_id") == null || paramBizType.getLong("biztypenumber_id") == 0L) continue;
            bizTypes.add(paramBizType.getLong("biztypenumber_id"));
        }
        return bizTypes;
    }
}

