/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class FarmProductsHelper {
    private static final String FARMPURBILLTYPENUM = "im_PurInBill_FARM_BT_S";
    private static final String FARMPURRECBILLTYPENUM = "im_PurRecBill_FARM_BT_S";

    public static void materialSelect(IDataModel bill, ListShowParameter showParameter) {
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType(bill.getDataEntity());
        if (!isFarmBillType) {
            return;
        }
        QFilter qFilter = new QFilter("masterid.farmproducts", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    public static void changeMaterial(IDataModel model, DynamicObject material, int rowIndex) {
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType(model.getDataEntity());
        if (!isFarmBillType) {
            return;
        }
        if (material == null) {
            model.setValue("deductiblerate", null, rowIndex);
            return;
        }
        DynamicObject masterId = material.getDynamicObject("masterid");
        Object deductibleRate = masterId.get("deductiblerate");
        model.setValue("deductiblerate", deductibleRate, rowIndex);
    }

    public static void setDeductibleRate(DynamicObject data) {
        String formId = data.getDataEntityType().getName();
        if (!"im_purinbill".equals(formId)) {
            return;
        }
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType(data);
        if (!isFarmBillType) {
            return;
        }
        DynamicObjectCollection entryList = data.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entryList) {
            DynamicObject material;
            Object deductibleRate;
            BigDecimal entryDeductibleRate;
            DynamicObject materialInfo = entry.getDynamicObject("material");
            if (materialInfo == null || null != (entryDeductibleRate = entry.getBigDecimal("deductiblerate")) && entryDeductibleRate.compareTo(BigDecimal.ZERO) != 0 || null == (deductibleRate = (material = materialInfo.getDynamicObject("masterid")).get("deductiblerate"))) continue;
            entry.set("deductiblerate", deductibleRate);
        }
    }

    public static boolean isFarmBillType(DynamicObject data) {
        String formId = data.getDataEntityType().getName();
        if (!"im_purinbill".equals(formId) && !"im_purreceivebill".equals(formId)) {
            return false;
        }
        DynamicObject billType = data.getDynamicObject("billtype");
        if (null == billType) {
            return false;
        }
        String billTypeNum = billType.getString("number");
        return FARMPURBILLTYPENUM.equals(billTypeNum) || FARMPURRECBILLTYPENUM.equals(billTypeNum);
    }

    public static void clearFarmFields(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            boolean farmBillType = FarmProductsHelper.isFarmBillType(bill);
            if (farmBillType) {
                return;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                entry.set("deductiblerate", (Object)BigDecimal.ZERO);
                entry.set("curdeductibleamt", (Object)BigDecimal.ZERO);
                entry.set("intercostamt", (Object)BigDecimal.ZERO);
            }
        }
    }
}

