/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.consts.AdjustBillConst;
import kd.scmc.im.consts.LotInTrackModel;

public class ImLotInTrackHelper {
    private static final String[] insertDBFields = new String[]{"fid", "forgid", "fbiztime", "fmaterialmasterid", "flotnumber", "fproducedate", "fexpirydate", "fcreatorid", "fcreatetime", "fmodifierid", "fmodifytime"};
    private static final String[] updateDBFields = new String[]{"fbiztime", "fmodifierid", "fmodifytime"};
    private static final int MAX_RECORD_NUM = 512;

    public static void dealLotInTrack(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Map<String, LotInTrackModel> prepareDatas = ImLotInTrackHelper.prepareData(dataEntities);
        ImLotInTrackHelper.batchUpdate(prepareDatas);
    }

    private static void batchUpdate(Map<String, LotInTrackModel> prepareDatas) {
        if (prepareDatas.isEmpty()) {
            return;
        }
        int size = prepareDatas.size();
        if (size >= 512) {
            HashMap<String, Object> datas = new HashMap<String, LotInTrackModel>(512);
            for (Map.Entry<String, LotInTrackModel> entry : prepareDatas.entrySet()) {
                datas.put(entry.getKey(), entry.getValue());
                if (datas.size() < 512) continue;
                ImLotInTrackHelper.updateTable(datas);
                datas = new HashMap(512);
            }
            if (!datas.isEmpty()) {
                ImLotInTrackHelper.updateTable(datas);
            }
        } else {
            ImLotInTrackHelper.updateTable(prepareDatas);
        }
    }

    private static void updateTable(Map<String, LotInTrackModel> prepareDatas) {
        ImLotInTrackHelper.queryExistData(prepareDatas);
        int size = prepareDatas.size();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(size);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(size);
        List<Long> lockRecords = ImLotInTrackHelper.getSqlParams(prepareDatas, updateParams, insertParams);
        ImLotInTrackHelper.storeDB(insertParams, updateParams, lockRecords);
    }

    private static void storeDB(List<Object[]> insertParams, List<Object[]> updateParams, List<Long> lockRecords) {
        if (!insertParams.isEmpty()) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into ").append("t_im_lotintrack").append('(');
            insertSql.append(String.join((CharSequence)",", insertDBFields));
            insertSql.append(") VALUES(");
            ArrayList<String> params = new ArrayList<String>(insertDBFields.length);
            for (int i = 0; i < insertDBFields.length; ++i) {
                params.add("?");
            }
            insertSql.append(String.join((CharSequence)",", params));
            insertSql.append(')');
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)insertSql.toString(), insertParams);
        }
        if (!updateParams.isEmpty()) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("update ").append("t_im_lotintrack").append(" set ");
            ArrayList<String> updateFileds = new ArrayList<String>(updateDBFields.length);
            for (String dbField : updateDBFields) {
                updateFileds.add(new StringBuffer(dbField).append("= ?").toString());
            }
            updateSql.append(String.join((CharSequence)",", updateFileds));
            updateSql.append(" where fid =?");
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql.toString(), updateParams);
        }
    }

    private static List<Long> getSqlParams(Map<String, LotInTrackModel> prepareDatas, List<Object[]> updateParams, List<Object[]> insertParams) {
        ArrayList<Long> checkRecords = new ArrayList<Long>();
        Date now = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        int prepareDatasSize = prepareDatas.size();
        long[] longIds = DB.genLongIds((String)"t_im_lotintrack", (int)prepareDatasSize);
        for (LotInTrackModel model : prepareDatas.values()) {
            Long id = model.getId();
            if (id == null) {
                Object[] insertParam = new Object[]{longIds[--prepareDatasSize], model.getOrgId(), model.getBizTime(), model.getMaterial(), model.getLotNumber(), model.getProduceDate(), model.getExpiryDate(), userId, now, userId, now};
                insertParams.add(insertParam);
                continue;
            }
            Object[] updateParam = new Object[]{model.getBizTime(), userId, now, id};
            updateParams.add(updateParam);
        }
        return checkRecords;
    }

    private static void queryExistData(Map<String, LotInTrackModel> prepareDatas) {
        String[] keys;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        for (String key : keys = LotInTrackModel.getDbDimensions()) {
            sql.append(key).append(',');
        }
        sql.append("fid");
        sql.append(",fbiztime");
        sql.append(" FROM ").append("t_im_lotintrack").append(" where ");
        ArrayList<Object> params = new ArrayList<Object>(prepareDatas.size() * keys.length);
        ImLotInTrackHelper.buildDimensionFilter(prepareDatas, keys, params, sql);
        DataSet datas = DB.queryDataSet((String)ImLotInTrackHelper.class.getName(), (DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), (Object[])params.toArray());
        for (Row row : datas) {
            Long id = row.getLong("fid");
            Object[] values = new Object[keys.length];
            int i = 0;
            for (String dimension : keys) {
                values[i] = row.get(dimension);
                ++i;
            }
            String key = LotInTrackModel.getKey((Object[])values);
            LotInTrackModel lotInTrackModel = prepareDatas.get(key);
            if (lotInTrackModel == null) continue;
            lotInTrackModel.setId(id);
        }
    }

    public static void buildDimensionFilter(Map<String, LotInTrackModel> prepareDatas, String[] keys, List<Object> params, StringBuilder filters) {
        int count = 0;
        for (LotInTrackModel k : prepareDatas.values()) {
            StringBuffer filterSql = new StringBuffer();
            filterSql.append('(');
            Object[] values = k.getDimensions();
            boolean needAnd = false;
            for (int i = 0; i < keys.length; ++i) {
                if (values[i] == null) continue;
                if (needAnd) {
                    filterSql.append(" and ");
                }
                filterSql.append(keys[i]).append("=? ");
                params.add(values[i]);
                needAnd = true;
            }
            filterSql.append(')');
            if (count != 0) {
                filters.append(" or ");
            }
            ++count;
            filters.append(filterSql);
        }
    }

    private static Map<String, LotInTrackModel> prepareData(DynamicObject[] dataEntities) {
        HashMap<String, LotInTrackModel> lotInTrackMap = new HashMap<String, LotInTrackModel>(512);
        List<DynamicObject> list = ImLotInTrackHelper.getBillList(dataEntities);
        if (list == null || list.isEmpty()) {
            return lotInTrackMap;
        }
        for (DynamicObject inBill : list) {
            DynamicObjectCollection entrys;
            String billName = inBill.getDataEntityType().getName();
            if ("im_adjustbill".equals(billName)) {
                entrys = inBill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    DynamicObjectCollection entitys = entry.getDynamicObjectCollection("afterentity");
                    for (DynamicObject entity : entitys) {
                        DynamicObject materialInvInfo = entity.getDynamicObject("material1");
                        if (null == materialInvInfo || !materialInvInfo.getBoolean("enablelot") && !materialInvInfo.getBoolean("enableshelflifemgr")) continue;
                        LotInTrackModel lotInTrackModel = new LotInTrackModel();
                        lotInTrackModel.setOrgId(Long.valueOf(inBill.getDynamicObject("org").getLong("id")));
                        Date bizTime = inBill.getDate("biztime");
                        lotInTrackModel.setBizTime(bizTime);
                        lotInTrackModel.setMaterial(Long.valueOf(materialInvInfo.getLong("masterid.id")));
                        lotInTrackModel.setLotNumber(entity.getString("lotnumber1"));
                        lotInTrackModel.setProduceDate(entity.getDate("producedate1"));
                        lotInTrackModel.setExpiryDate(entity.getDate("expirydate1"));
                        String key = lotInTrackModel.getKey();
                        LotInTrackModel oldLotInTrackModel = (LotInTrackModel)lotInTrackMap.get(key);
                        if (oldLotInTrackModel == null) {
                            lotInTrackMap.put(key, lotInTrackModel);
                            continue;
                        }
                        oldLotInTrackModel.setBizTime(bizTime);
                    }
                }
                continue;
            }
            entrys = inBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                DynamicObject materialInvInfo = entry.getDynamicObject("material");
                if (null == materialInvInfo || !materialInvInfo.getBoolean("enablelot") && !materialInvInfo.getBoolean("enableshelflifemgr")) continue;
                LotInTrackModel lotInTrackModel = new LotInTrackModel();
                lotInTrackModel.setOrgId(Long.valueOf(inBill.getDynamicObject("org").getLong("id")));
                Date bizTime = inBill.getDate("biztime");
                lotInTrackModel.setBizTime(bizTime);
                lotInTrackModel.setMaterial(Long.valueOf(entry.getDynamicObject("material").getLong("masterid.id")));
                lotInTrackModel.setLotNumber(entry.getString("lotnumber"));
                lotInTrackModel.setProduceDate(entry.getDate("producedate"));
                lotInTrackModel.setExpiryDate(entry.getDate("expirydate"));
                String key = lotInTrackModel.getKey();
                LotInTrackModel oldLotInTrackModel = (LotInTrackModel)lotInTrackMap.get(key);
                if (oldLotInTrackModel == null) {
                    lotInTrackMap.put(key, lotInTrackModel);
                    continue;
                }
                oldLotInTrackModel.setBizTime(bizTime);
            }
        }
        return lotInTrackMap;
    }

    private static List<DynamicObject> getBillList(DynamicObject[] dataEntities) {
        DynamicObject invscheme;
        Boolean notUpdate;
        List<DynamicObject> billList = new ArrayList<DynamicObject>(dataEntities.length);
        String billName = dataEntities[0].getDynamicObjectType().getName();
        boolean existInvscheme = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)billName), "invscheme");
        if (existInvscheme && !billName.equals("im_initbill") && (notUpdate = Boolean.valueOf((invscheme = dataEntities[0].getDynamicObject("invscheme")).getBoolean("isnotupdate"))).booleanValue()) {
            return billList;
        }
        switch (billName) {
            case "im_purreceivebill": 
            case "im_productinbill": 
            case "im_purinbill": 
            case "im_ospurinbill": 
            case "im_otherinbill": 
            case "im_transinbill": 
            case "im_locationtransfer": 
            case "im_assembbill": 
            case "im_initbill": 
            case "im_disassemblebill": 
            case "im_mdc_mftmanuinbill": 
            case "im_mdc_omcmplinbill": {
                billList = Arrays.asList(dataEntities);
                break;
            }
            case "im_transdirbill": {
                billList = ImLotInTrackHelper.transFormMaterial(dataEntities);
                break;
            }
            case "im_adjustbill": {
                for (DynamicObject dataEntitie : dataEntities) {
                    DynamicObject bizType = dataEntitie.getDynamicObject("biztype");
                    boolean isTrack = ImLotInTrackHelper.trackByBizType(bizType);
                    if (!isTrack) continue;
                    billList.add(dataEntitie);
                }
                break;
            }
        }
        return billList;
    }

    private static List<DynamicObject> transFormMaterial(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject cloneDataEntity = (DynamicObject)OrmUtils.clone((IDataEntityBase)dataEntity, (boolean)false, (boolean)true);
            String transType = cloneDataEntity.getString("transtype");
            if ("B".equals(transType)) {
                DynamicObject org = cloneDataEntity.getDynamicObject("org");
                DynamicObjectCollection entrys = cloneDataEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    DynamicObject inMaterial;
                    DynamicObject material = entry.getDynamicObject("material");
                    if (null == material || null == (inMaterial = ImLotInTrackHelper.getInMaterial(org, material))) continue;
                    entry.set("material", (Object)inMaterial);
                    entry.set("lotnumber", entry.get("inlotnumber"));
                }
            } else {
                return Arrays.asList(dataEntities);
            }
            list.add(cloneDataEntity);
        }
        return list;
    }

    private static boolean trackByBizType(DynamicObject bizType) {
        if (Objects.isNull(bizType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImLotInTrackHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        Long bizTypeId = bizType.getLong("id");
        return AdjustBillConst.BIZTYPE_MATERIALADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_LOTADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_OTHERADJUST.equals(bizTypeId) || AdjustBillConst.BIZTYPE_INSPECTADJUST.equals(bizTypeId);
    }

    private static DynamicObject getInMaterial(DynamicObject org, DynamicObject material) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_materialinventoryinfo");
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        DynamicObject[] materialinventory = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)String.join((CharSequence)",", selectorSet), (QFilter[])new QFilter[]{new QFilter("masterid.id", "=", (Object)material.getLong("masterid.id")), baseDataFilter});
        DynamicObject materialInfo = materialinventory[0];
        String privateCtrlStrategy = "7";
        for (DynamicObject dynamicObject : materialinventory) {
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if (!privateCtrlStrategy.equals(ctrlStrategy)) continue;
            materialInfo = dynamicObject;
        }
        return materialInfo;
    }
}

