/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.QFBuilder;

public class InitExecHelper {
    public static final String STATUS_FAIL = "0";
    public static final String STATUS_SUCCESS = "1";

    public static JSONArray batchInitExecute(Map<String, List<String>> orgIdWhsIdMap, String execId, String executeType) {
        JSONArray jsonArray = new JSONArray();
        if (CollectionUtils.isEmpty(orgIdWhsIdMap)) {
            return jsonArray;
        }
        for (Map.Entry<String, List<String>> orgIdWhsId : orgIdWhsIdMap.entrySet()) {
            long orgId = Long.parseLong(orgIdWhsId.getKey());
            List<String> whsIdList = orgIdWhsId.getValue();
            for (String whsId : whsIdList) {
                JSONObject jsonObject = InitExecHelper.initExecute(orgId, Long.parseLong(whsId), execId, executeType);
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }

    public static JSONObject initExecute(long orgId, long whsId, String execId, String executeType) {
        String msg;
        JSONObject jsonObject = new JSONObject();
        boolean orgIsExists = QueryServiceHelper.exists((String)"bos_org", (Object)orgId);
        if (!orgIsExists) {
            jsonObject.put("errorMessage", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitExecHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
            jsonObject.put("isSuccess", (Object)Boolean.FALSE);
            return jsonObject;
        }
        DynamicObject dymOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        String orgName = dymOrg.getString("name");
        if (StringUtils.isEmpty((CharSequence)execId)) {
            jsonObject.put("errorMessage", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitExecHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            jsonObject.put("isSuccess", (Object)Boolean.FALSE);
            jsonObject.put("org", (Object)orgId);
            jsonObject.put("orgname", (Object)orgName);
            return jsonObject;
        }
        OpLogAppInfo appLogInfo = InitExecHelper.getAppLogInfo(execId);
        if (whsId == 0L && "2".equals(executeType)) {
            appLogInfo.setStatus(STATUS_FAIL);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25,\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a\u3002", "InitExecHelper_2", "scmc-im-business"), new String[0]);
            InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
            jsonObject.put("errorMessage", (Object)ResManager.loadKDString((String)"\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitExecHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
            jsonObject.put("isSuccess", (Object)Boolean.FALSE);
            jsonObject.put("org", (Object)orgId);
            jsonObject.put("orgname", (Object)orgName);
            return jsonObject;
        }
        if (whsId > 0L && "2".equals(executeType) && StringUtils.isNotEmpty((CharSequence)(msg = InitExecHelper.checkWarehose(orgId, whsId, execId)))) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"InitExecHelper_4", (String)"scmc-im-business", (Object[])new Object[0]), msg);
            appLogInfo.setStatus(STATUS_FAIL);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\uff0c%s", "InitExecHelper_4", "scmc-im-business"), new String[]{msg});
            InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
            jsonObject.put("errorMessage", (Object)errorMessage);
            jsonObject.put("isSuccess", (Object)Boolean.FALSE);
            jsonObject.put("org", (Object)orgId);
            jsonObject.put("orgname", (Object)orgName);
            return jsonObject;
        }
        String successMessage = "";
        if ("init".equals(execId)) {
            String msg2 = InitExecHelper.checkBillAndWarehouse(orgId, whsId);
            if (StringUtils.isNotEmpty((CharSequence)msg2)) {
                String errorMessage = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"InitExecHelper_4", (String)"scmc-im-business", (Object[])new Object[0]), msg2);
                appLogInfo.setStatus(STATUS_FAIL);
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\uff0c%s", "InitExecHelper_4", "scmc-im-business"), new String[]{msg2});
                InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
                jsonObject.put("errorMessage", (Object)errorMessage);
                jsonObject.put("isSuccess", (Object)Boolean.FALSE);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                if (whsId > 0L) {
                    DynamicObject dymWhs = BusinessDataServiceHelper.loadSingle((Object)whsId, (String)"bd_warehouse");
                    String whsName = dymWhs == null ? "" : dymWhs.getString("name");
                    jsonObject.put("warehouse", (Object)whsId);
                    jsonObject.put("warehousename", (Object)whsName);
                }
                return jsonObject;
            }
            successMessage = ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitExecHelper_6", (String)"scmc-im-business", (Object[])new Object[0]);
            appLogInfo.setStatus(STATUS_SUCCESS);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", "InitExecHelper_6", "scmc-im-business"), new String[0]);
        } else if ("uninit".equals(execId)) {
            Long[] finishInitWarehouseIDs = WarehouseHelper.getAllFinishInitWarehouseIDs(orgId);
            if (CommonUtils.isNull((Object)finishInitWarehouseIDs)) {
                String errorMessage = ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u3002", (String)"InitExecHelper_7", (String)"scmc-im-business", (Object[])new Object[0]);
                appLogInfo.setStatus(STATUS_FAIL);
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u3002", "InitExecHelper_7", "scmc-im-business"), new String[0]);
                InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
                jsonObject.put("errorMessage", (Object)errorMessage);
                jsonObject.put("isSuccess", (Object)Boolean.FALSE);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                return jsonObject;
            }
            successMessage = ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitExecHelper_9", (String)"scmc-im-business", (Object[])new Object[0]);
            appLogInfo.setStatus(STATUS_SUCCESS);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", "InitExecHelper_9", "scmc-im-business"), new String[0]);
        }
        try (TXHandle h = TX.required((String)"InitExecHelper");){
            try {
                InitExecHelper.updInitStatus(orgId, whsId, execId);
                jsonObject.put("isSuccess", (Object)Boolean.TRUE);
                jsonObject.put("successMessage", (Object)successMessage);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                if (whsId > 0L) {
                    DynamicObject dymWhs = BusinessDataServiceHelper.loadSingle((Object)whsId, (String)"bd_warehouse");
                    String whsName = dymWhs == null ? "" : dymWhs.getString("name");
                    jsonObject.put("warehouse", (Object)whsId);
                    jsonObject.put("warehousename", (Object)whsName);
                }
            }
            catch (KDBizException ex) {
                h.markRollback();
                jsonObject.put("errorMessage", (Object)ex.getMessage());
                jsonObject.put("isSuccess", (Object)Boolean.FALSE);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                JSONObject jSONObject = jsonObject;
                if (h != null) {
                    if (var13_14 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var13_14.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return jSONObject;
            }
        }
        InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
        return jsonObject;
    }

    public static void updInitStatus(long orgID, long whsId, String execId) {
        ArrayList<DynamicObject> initObjList = new ArrayList<DynamicObject>();
        QFilter qFilter1 = new QFilter("org.id", "=", (Object)orgID);
        QFilter qFilter2 = null;
        if (whsId > 0L) {
            qFilter2 = new QFilter("warehouse.id", "in", (Object)whsId);
            DynamicObject initObj = BusinessDataServiceHelper.loadSingle((String)"im_warehousesetup", (String)"id, finishinitdate, initstatus", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            if (initObj != null && "init".equals(execId)) {
                initObj.set("initstatus", (Object)"B");
                initObj.set("finishinitdate", (Object)new Date(System.currentTimeMillis()));
                initObjList.add(initObj);
            }
            if (initObj != null && "uninit".equals(execId)) {
                initObj.set("initstatus", (Object)"A");
                initObj.set("finishinitdate", null);
                initObjList.add(initObj);
            }
        } else if ("init".equals(execId)) {
            qFilter2 = new QFilter("initstatus", "=", (Object)"A");
            DynamicObject[] warehouses = BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"id,warehouse.id,finishinitdate, initstatus", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            if (warehouses != null && warehouses.length > 0) {
                for (DynamicObject wh : warehouses) {
                    wh.set("initstatus", (Object)"B");
                    wh.set("finishinitdate", (Object)new Date(System.currentTimeMillis()));
                    initObjList.add(wh);
                }
            }
        } else {
            qFilter2 = new QFilter("initstatus", "=", (Object)"B");
            DynamicObject[] warehouses = BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"id,warehouse.id,finishinitdate, initstatus", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            if (warehouses != null && warehouses.length > 0) {
                for (DynamicObject wh : warehouses) {
                    wh.set("initstatus", (Object)"A");
                    wh.set("finishinitdate", null);
                    initObjList.add(wh);
                }
            }
        }
        if (!CollectionUtils.isEmpty(initObjList)) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)initObjList.toArray()[0]).getDataEntityType(), (Object[])initObjList.toArray());
        }
    }

    public static OpLogAppInfo getAppLogInfo(String execId) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizObjID("im_init");
        appLogInfo.setBizAppID("=9Q86DR2P+Q");
        appLogInfo.setUserID(Long.valueOf(UserServiceHelper.getCurrentUserId()));
        appLogInfo.setOpTime(new Date());
        if (execId.equals("init")) {
            appLogInfo.setOpName("init", new MultiLangEnumBridge("\u7ed3\u675f\u521d\u59cb\u5316", "InitExecHelper_10", "scmc-im-business"));
        } else {
            appLogInfo.setOpName("uninit", new MultiLangEnumBridge("\u53cd\u521d\u59cb\u5316", "InitExecHelper_11", "scmc-im-business"));
        }
        return appLogInfo;
    }

    public static void saveApplogInfo(AppLogInfo appLogInfo, String opDescription) {
        appLogInfo.setOpDescription(opDescription);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addLog(appLogInfo);
    }

    public static void saveApplogInfo(AppLogInfo appLogInfo) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addLog(appLogInfo);
    }

    public static String checkWarehose(long orgId, long whsId, String execId) {
        boolean isFinish;
        DynamicObject dymWhs = BusinessDataServiceHelper.loadSingle((Object)whsId, (String)"bd_warehouse");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        if (org == null || dymWhs == null || StringUtils.isEmpty((CharSequence)execId)) {
            return null;
        }
        String whsName = dymWhs.getString("name");
        String orgName = org.getString("name");
        if ("init".equals(execId)) {
            if (!InitExecHelper.isExistInWHSetUp(dymWhs, orgId)) {
                return CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSESET_NOTEXIT(), (Object[])new Object[]{orgName, whsName});
            }
            boolean isFinish2 = WarehouseHelper.isFinishInit(orgId, Long.valueOf(dymWhs.getPkValue().toString()));
            if (isFinish2) {
                return CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSE_INIT(), (Object[])new Object[]{orgName, whsName});
            }
        } else if ("uninit".equals(execId) && !(isFinish = WarehouseHelper.isFinishInit(orgId, Long.valueOf(dymWhs.getPkValue().toString())))) {
            return CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_WAREHOUSE_UNINIT(), (Object[])new Object[]{orgName, whsName});
        }
        return null;
    }

    public static boolean isExistInWHSetUp(DynamicObject dymWhs, long invOrgID) {
        QFilter filters = new QFilter("org", "=", (Object)invOrgID);
        filters.and(new QFilter("warehouse", "=", dymWhs.getPkValue()));
        return QueryServiceHelper.exists((String)"im_warehousesetup", (QFilter[])new QFilter[]{filters});
    }

    public static String checkBillAndWarehouse(long orgID, long whsId) {
        QFBuilder accBuilder4Check = new QFBuilder();
        accBuilder4Check.add("org", "=", (Object)orgID);
        if (whsId == 0L) {
            Long[] unFinishInitWarehouseIDs = WarehouseHelper.getAllUnFinishInitWarehouseIDs(orgID);
            if (CommonUtils.isNull((Object)unFinishInitWarehouseIDs)) {
                return ResManager.loadKDString((String)"\u8be5\u5e93\u5b58\u7ec4\u7ec7\u65e0\u672a\u521d\u59cb\u5316\u4ed3\u5e93\u3002", (String)"InitExecHelper_12", (String)"scmc-im-business", (Object[])new Object[0]);
            }
            accBuilder4Check.add("billentry.warehouse", "in", (Object)unFinishInitWarehouseIDs);
        } else {
            accBuilder4Check.add("billentry.warehouse", "=", (Object)whsId);
        }
        accBuilder4Check.add("billstatus", "!=", (Object)"C");
        if (QueryServiceHelper.exists((String)"im_initbill", (QFilter[])accBuilder4Check.toArray())) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u521d\u59cb\u5e93\u5b58\u5355\u3002", (String)"InitExecHelper_13", (String)"scmc-im-business", (Object[])new Object[0]);
        }
        return null;
    }

    public static String checkInitBill(long orgID) {
        QFBuilder accBuilder4Check = new QFBuilder();
        accBuilder4Check.add("org", "=", (Object)orgID);
        Long[] unFinishInitWarehouseIDs = WarehouseHelper.getAllUnFinishInitWarehouseIDs(orgID);
        if (CommonUtils.isNull((Object)unFinishInitWarehouseIDs)) {
            return ResManager.loadKDString((String)"\u8be5\u5e93\u5b58\u7ec4\u7ec7\u65e0\u672a\u521d\u59cb\u5316\u4ed3\u5e93\u3002", (String)"InitExecHelper_12", (String)"scmc-im-business", (Object[])new Object[0]);
        }
        accBuilder4Check.add("billentry.warehouse", "in", (Object)unFinishInitWarehouseIDs);
        accBuilder4Check.add("billstatus", "!=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.helper.InitExecHelper", (String)"im_initbill", (String)"billentry.warehouse.name", (QFilter[])accBuilder4Check.toArray(), null);
        HashSet<String> wareHouseNames = new HashSet<String>(64);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String name = next.getString("billentry.warehouse.name");
            wareHouseNames.add(name);
        }
        if (wareHouseNames.isEmpty()) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (String wareHouseName : wareHouseNames) {
            nameBuilder.append(wareHouseName);
            nameBuilder.append(",");
        }
        String msg = nameBuilder.toString();
        if (msg.length() == 0) {
            return null;
        }
        msg = msg.substring(0, msg.lastIndexOf(","));
        return String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%s\u201d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u521d\u59cb\u5e93\u5b58\u5355\u3002", (String)"InitExecHelper_14", (String)"scmc-im-business", (Object[])new Object[0]), msg);
    }

    public static JSONObject initExecute(long orgId, long whsId, String execId) {
        JSONObject jsonObject = new JSONObject();
        boolean orgIsExists = QueryServiceHelper.exists((String)"bos_org", (Object)orgId);
        if (!orgIsExists) {
            jsonObject.put("errorMessage", (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitExecHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
            jsonObject.put("isSuccess", (Object)Boolean.FALSE);
            return jsonObject;
        }
        DynamicObject dymOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        String orgName = dymOrg.getString("name");
        if (StringUtils.isEmpty((CharSequence)execId)) {
            jsonObject.put("errorMessage", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitExecHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            jsonObject.put("isSuccess", (Object)Boolean.FALSE);
            jsonObject.put("org", (Object)orgId);
            jsonObject.put("orgname", (Object)orgName);
            return jsonObject;
        }
        OpLogAppInfo appLogInfo = InitExecHelper.getAppLogInfo(execId);
        String successMessage = "";
        if ("init".equals(execId)) {
            String msg = InitExecHelper.checkInitBill(orgId);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                String errorMessage = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"InitExecHelper_4", (String)"scmc-im-business", (Object[])new Object[0]), msg);
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\uff0c%s", "InitExecHelper_4", "scmc-im-business"), new String[]{msg});
                appLogInfo.setStatus(STATUS_FAIL);
                InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
                jsonObject.put("errorMessage", (Object)errorMessage);
                jsonObject.put("isSuccess", (Object)Boolean.FALSE);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                if (whsId > 0L) {
                    DynamicObject dymWhs = BusinessDataServiceHelper.loadSingle((Object)whsId, (String)"bd_warehouse");
                    String whsName = dymWhs == null ? "" : dymWhs.getString("name");
                    jsonObject.put("warehouse", (Object)whsId);
                    jsonObject.put("warehousename", (Object)whsName);
                }
                return jsonObject;
            }
            appLogInfo.setStatus(STATUS_SUCCESS);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", "InitExecHelper_6", "scmc-im-business"), new String[0]);
            successMessage = ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitExecHelper_6", (String)"scmc-im-business", (Object[])new Object[0]);
        } else if ("uninit".equals(execId)) {
            Long[] finishInitWarehouseIDs = WarehouseHelper.getAllFinishInitWarehouseIDs(orgId);
            if (CommonUtils.isNull((Object)finishInitWarehouseIDs)) {
                String errorMessage = ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u3002", (String)"InitExecHelper_7", (String)"scmc-im-business", (Object[])new Object[0]);
                appLogInfo.setStatus(STATUS_FAIL);
                appLogInfo.setOpDesc(new MultiLangEnumBridge("\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u3002", "InitExecHelper_7", "scmc-im-business"), new String[0]);
                InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
                jsonObject.put("errorMessage", (Object)errorMessage);
                jsonObject.put("isSuccess", (Object)Boolean.FALSE);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                return jsonObject;
            }
            appLogInfo.setStatus(STATUS_SUCCESS);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", "InitExecHelper_9", "scmc-im-business"), new String[0]);
            successMessage = ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"InitExecHelper_9", (String)"scmc-im-business", (Object[])new Object[0]);
        }
        try (TXHandle h = TX.required((String)"InitExecHelper");){
            try {
                InitExecHelper.updInitStatus(orgId, whsId, execId);
                jsonObject.put("isSuccess", (Object)Boolean.TRUE);
                jsonObject.put("successMessage", (Object)successMessage);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                if (whsId > 0L) {
                    DynamicObject dymWhs = BusinessDataServiceHelper.loadSingle((Object)whsId, (String)"bd_warehouse");
                    String whsName = dymWhs == null ? "" : dymWhs.getString("name");
                    jsonObject.put("warehouse", (Object)whsId);
                    jsonObject.put("warehousename", (Object)whsName);
                }
            }
            catch (KDBizException ex) {
                h.markRollback();
                jsonObject.put("errorMessage", (Object)ex.getMessage());
                jsonObject.put("isSuccess", (Object)Boolean.FALSE);
                jsonObject.put("org", (Object)orgId);
                jsonObject.put("orgname", (Object)orgName);
                JSONObject jSONObject = jsonObject;
                if (h != null) {
                    if (var12_12 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return jSONObject;
            }
        }
        InitExecHelper.saveApplogInfo((AppLogInfo)appLogInfo);
        return jsonObject;
    }
}

