/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class InvBillCalcHelper {
    @Deprecated
    public static DynamicObjectCollection qtyCalc(DynamicObjectCollection entrycoll, String entityID) {
        int size = entrycoll.size();
        HashMap<String, String> cacheMap = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)entrycoll.get(i);
            InvBillCalcHelper.entryAuxptyQtyCalc(entry, entityID, cacheMap);
        }
        return entrycoll;
    }

    public static void entryAuxptyQtyCalc(DynamicObject entry, String entityID, Map<String, String> cacheMap) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_INV()));
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        BigDecimal baseqty = entry.getBigDecimal("baseqty");
        DynamicObject billUnit2nd = entry.getDynamicObject("unit2nd");
        if (billUnit2nd == null) {
            return;
        }
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)material.getPkValue(), (Long)billUnit2nd.getPkValue(), (Long)baseUnit.getPkValue(), cacheMap);
        if (unit2ndRate == null || Constants.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        unit2ndRate = unit2ndRate.setScale(10);
        BigDecimal qtyUnit2nd = BigDecimal.ZERO;
        if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0) {
            qtyUnit2nd = baseqty.divide(unit2ndRate, billUnit2nd.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)billUnit2nd.getInt("precisionaccount")));
        }
        entry.set("qtyunit2nd", (Object)qtyUnit2nd);
    }
}

