/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import org.apache.commons.lang3.StringUtils;

public class InvBillHelper {
    public static boolean isOutEntry(String billName, String entryName) {
        if (StringUtils.isEmpty((CharSequence)billName) || StringUtils.isEmpty((CharSequence)entryName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\uff0c\u6216\u8005\u5355\u636e\u4f53\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u51fa\u5e93\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"InvBillHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        boolean isOut = false;
        switch (billName) {
            case "im_saloutbill": 
            case "im_otheroutbill": 
            case "im_materialreqoutbill": 
            case "im_transoutbill": 
            case "im_transdirbill": 
            case "im_locationtransfer": {
                isOut = true;
                break;
            }
            case "im_assembbill": {
                if (!"afterentity".equals(entryName)) break;
                isOut = true;
                break;
            }
            case "im_adjustbill": 
            case "im_disassemblebill": {
                if (!"billentry".equals(entryName)) break;
                isOut = true;
                break;
            }
        }
        return isOut;
    }

    public static boolean isInEntry(String billName, String entryName) {
        if (StringUtils.isEmpty((CharSequence)billName) || StringUtils.isEmpty((CharSequence)entryName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\uff0c\u6216\u8005\u5355\u636e\u4f53\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u5165\u5e93\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"InvBillHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        boolean isIn = false;
        switch (billName) {
            case "im_initbill": 
            case "im_purreceivebill": 
            case "im_purinbill": 
            case "im_otherinbill": 
            case "im_transinbill": 
            case "im_transdirbill": 
            case "im_locationtransfer": 
            case "im_productinbill": {
                isIn = true;
                break;
            }
            case "im_assembbill": {
                if (!"billentry".equals(entryName)) break;
                isIn = true;
                break;
            }
            case "im_adjustbill": 
            case "im_disassemblebill": {
                if (!"afterentity".equals(entryName)) break;
                isIn = true;
                break;
            }
        }
        return isIn;
    }

    public static boolean isVirtualBill(DynamicObject bill) {
        String formId;
        switch (formId = bill.getDynamicObjectType().getName()) {
            case "im_purinbill": 
            case "im_transinbill": 
            case "im_saloutbill": 
            case "im_transoutbill": {
                return bill.getBoolean("isvirtualbill");
            }
        }
        return false;
    }

    public static boolean isInitBill(DynamicObject bill) {
        String formId;
        switch (formId = bill.getDynamicObjectType().getName()) {
            case "im_purinbill": 
            case "im_saloutbill": {
                return bill.getBoolean("isinitbill");
            }
        }
        return false;
    }

    public static QFilter getConfigureCodeFilter(Object masterId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("material.status", "=", (Object)"C");
        qFilter.and("material.enable", "=", (Object)"1");
        qFilter.and("material.id", "=", masterId);
        return qFilter;
    }

    public static QFilter getTrackNumberFilter() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("trackstatus", "=", (Object)"0");
        return qFilter;
    }

    public static void handleDefaultValueAfterImport(IDataModel bill, Map<String, Object> sourceData, Map<String, DynamicObject> materialCacheMap) {
        List listData = (List)sourceData.get("billentry");
        if (listData == null) {
            return;
        }
        ArrayList materialNums = new ArrayList(16);
        for (Object row : listData) {
            Map materialMap = (Map)row.get("material");
            if (materialMap == null || !StringUtils.isNotBlank((CharSequence)((String)materialMap.get("number")))) continue;
            Object number = materialMap.get("number");
            materialNums.add(number);
        }
        Map materialDymMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,name,isdisposable", (QFilter[])new QFilter("number", "in", materialNums).toArray());
        for (DynamicObject materialDym : materialDymMap.values()) {
            materialCacheMap.put(materialDym.getString("ID"), materialDym);
        }
        DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
        LineTypeParam lineTypeParam = bizType == null ? null : BillTypeMaterialHelper.getOneLineTypeByBillType(bizType.getLong("id"));
        DynamicObjectCollection billEntries = bill.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < billEntries.size(); ++i) {
            boolean isDisposable;
            DynamicObject cacheMaterial;
            DynamicObject masterObj;
            DynamicObject billEntry = (DynamicObject)billEntries.get(i);
            DynamicObject material = billEntry.getDynamicObject("material");
            if (material == null || (masterObj = material.getDynamicObject("masterid")) == null || (cacheMaterial = materialCacheMap.get(masterObj.getString("id"))) == null) continue;
            if (billEntry.get("linetype") == null && lineTypeParam != null) {
                Long lineTypeId = lineTypeParam.getDeafaultLineType();
                bill.setValue("linetype", (Object)lineTypeId, i);
            }
            if ((isDisposable = cacheMaterial.getBoolean("isdisposable")) && billEntry.get("materialname") != null) continue;
            bill.setValue("materialname", (Object)cacheMaterial.getString("name"), i);
        }
    }
}

