/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.AccCacheHelper;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.enums.StatusEnum;
import kd.scmc.im.utils.ArrayUtils;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.QFBuilder;

public class InvBillStatusHelper {
    private static final Long ACC_ID = 544603717274490880L;
    private static final Map<String, String> mdcBillTypeMap = InvBalanceConst.getMdcBillTypeMap();
    private static final Map<String, String> IMBillTableMap = InvBalanceConst.getIMBillTableMap();
    private static final String BIZ_DOMAIN = "biztype.domain";
    private static final String NOT_VIRTUAL_BILL = "0";
    private static final String NO_SETTLE_STATUS = "A";
    private static final String NO_SETTLE_MSG = "nosettle";
    private static final String SETTLE_FAIL_STATUS = "B";
    private static final String SETTLE_FAIL_MSG = "settlefail";
    private static final String updateBookDate = "1";

    public static Map<String, String> getUnAuditBill(Long ownerID, Date beginDate, Date endDate) {
        DynamicObject[] dsDycs;
        HashMap unAuditBillsMap = new HashMap(16);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("billstatus", "!=", (Object)StatusEnum.AUDIT.getValue());
        if (null != beginDate) {
            qfBuilder.add("biztime", ">", (Object)beginDate);
        }
        Date closeDate = DateUtils.getDayStartTime((Date)DateUtils.addOneDay((Date)endDate));
        qfBuilder.add("biztime", "<", (Object)closeDate);
        block0: for (DynamicObject dsDyc : dsDycs = AccCacheHelper.getDynDS(ACC_ID)) {
            String srcBill;
            DynamicObject billDyc = dsDyc.getDynamicObject("srcbill");
            if (billDyc == null || "im_initbill".equals(srcBill = billDyc.getString("number"))) continue;
            String billName = billDyc.getLocaleString("name").getLocaleValue();
            DynamicObjectCollection fieldmapentity = dsDyc.getDynamicObjectCollection("mappingentity");
            for (DynamicObject dataModel : fieldmapentity) {
                DynamicObjectCollection bills;
                String acctf = dataModel.getString("targetfield");
                String billf = dataModel.getString("sourcefield");
                if (!"owner".equals(acctf) || !StringUtils.isNotBlank((CharSequence)acctf) || !StringUtils.isNotBlank((CharSequence)billf)) continue;
                if (billf.contains("afterentity")) {
                    billf = "billentry." + billf;
                }
                QFilter billFilter = new QFilter(billf, "=", (Object)ownerID);
                if (mdcBillTypeMap.get(srcBill) != null) {
                    billFilter.and("billtype.number", "=", (Object)mdcBillTypeMap.get(srcBill));
                }
                if ((bills = QueryServiceHelper.query((String)srcBill, (String)"billno", (QFilter[])((QFilter[])ArrayUtils.concatAll((Object[])qfBuilder.toArray(), (Object[][])new QFilter[][]{billFilter.toArray()})))).isEmpty()) continue block0;
                Map billNoDycMap = ArrayUtils.getDynamicObjectMap((String)"billno", (DynamicObject[])((DynamicObject[])bills.toArray((Object[])new DynamicObject[0])));
                Set originalBillNos = (Set)unAuditBillsMap.get(billName);
                if (originalBillNos != null) {
                    originalBillNos.addAll(billNoDycMap.keySet());
                    continue block0;
                }
                unAuditBillsMap.put(billName, new HashSet(billNoDycMap.keySet()));
                continue block0;
            }
        }
        HashMap<String, String> unAuditBillNoStrMap = new HashMap<String, String>(16);
        for (Map.Entry item : unAuditBillsMap.entrySet()) {
            unAuditBillNoStrMap.put((String)item.getKey(), StringUtils.join((Object[])((Set)item.getValue()).toArray(new String[0]), (String)","));
        }
        return unAuditBillNoStrMap;
    }

    public static Map<String, Set<Long>> checkBizBillStatus(Map<String, Object> queryInfo) {
        Long ownerId = (Long)queryInfo.get("ownerId");
        Date beginDate = (Date)queryInfo.get("beginDate");
        Date endDate = (Date)queryInfo.get("endDate");
        String billStatus = (String)queryInfo.get("billStatus");
        String isUpdate = (String)queryInfo.get("isUpdate");
        HashMap<String, Set<Long>> submitBillIds = new HashMap<String, Set<Long>>(16);
        if (!StatusEnum.SAVE.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus)) {
            return submitBillIds;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("billstatus", "=", (Object)billStatus);
        if (null != beginDate) {
            qfBuilder.add("bookdate", ">", (Object)beginDate);
        }
        Date closeDate = DateUtils.getDayStartTime((Date)DateUtils.addOneDay((Date)endDate));
        qfBuilder.add("bookdate", "<", (Object)closeDate);
        List<DymAccDSMappingBill> updateBillFromDymAccDS = DymAccDataSourceHelper.getUpdateBillFromDymAccDS(false);
        HashSet<String> dymAccs = new HashSet<String>(updateBillFromDymAccDS.size());
        for (DymAccDSMappingBill dymAccDSMappingBill : updateBillFromDymAccDS) {
            Map<String, String> mapping;
            String ownerKey;
            String srcBill = dymAccDSMappingBill.getSrcbill();
            if (!InvBalanceConst.getBalBillList().contains(srcBill) || StringUtils.isEmpty((CharSequence)(ownerKey = (mapping = dymAccDSMappingBill.getMapping()).get("owner")))) continue;
            String billOwnerKey = srcBill + "#" + ownerKey;
            dymAccs.add(billOwnerKey);
        }
        ArrayList<OrmInput> allBillOrmInputs = new ArrayList<OrmInput>(dymAccs.size());
        for (String billOwnerKey : dymAccs) {
            String[] split = billOwnerKey.split("#");
            String srcBill = split[0];
            String ownerKey = split[1];
            QFilter billFilter = new QFilter(ownerKey, "=", (Object)ownerId);
            if (mdcBillTypeMap.get(srcBill) != null) {
                billFilter.and("billtype.number", "=", (Object)mdcBillTypeMap.get(srcBill));
            }
            OrmInput billOrmInput = new OrmInput(InvBillStatusHelper.class.getName() + "checkBizBillStatus", srcBill, "billno, '" + srcBill + "' as billkey, id", (QFilter[])ArrayUtils.concatAll((Object[])qfBuilder.toArray(), (Object[][])new QFilter[][]{billFilter.toArray()}));
            allBillOrmInputs.add(billOrmInput);
        }
        Algo algo = Algo.create((String)InvBillStatusHelper.class.getName());
        DataSet unionDataSet = algo.createDataSet((Input[])allBillOrmInputs.toArray(new OrmInput[0]));
        for (Row row : unionDataSet) {
            String billKey = row.getString("billkey");
            Long billId = row.getLong("id");
            HashSet<Long> billIds = (HashSet<Long>)submitBillIds.get(billKey);
            if (billIds == null) {
                billIds = new HashSet<Long>(16);
                billIds.add(billId);
                submitBillIds.put(billKey, billIds);
                continue;
            }
            billIds.add(billId);
        }
        if ((StatusEnum.SUBMIT.getValue().equals(billStatus) || StatusEnum.SAVE.getValue().equals(billStatus)) && updateBookDate.equals(isUpdate)) {
            InvBillStatusHelper.updateBookDate(submitBillIds, closeDate);
        }
        return submitBillIds;
    }

    public static Map<String, Set<Long>> checkBillSettleStatus(Map<String, Object> queryInfo) {
        Long ownerId = (Long)queryInfo.get("ownerId");
        Date beginDate = (Date)queryInfo.get("beginDate");
        Date endDate = (Date)queryInfo.get("endDate");
        String settleStatus = (String)queryInfo.get("settleStatus");
        HashMap<String, Set<Long>> settleBillMap = new HashMap<String, Set<Long>>(16);
        HashSet<String> settleCfgBill = new HashSet<String>(16);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        if (null != beginDate) {
            qfBuilder.add("bookdate", ">", (Object)beginDate);
        }
        Date closeDate = DateUtils.getDayStartTime((Date)DateUtils.addOneDay((Date)endDate));
        qfBuilder.add("bookdate", "<", (Object)closeDate);
        qfBuilder.add(new QFilter("isvirtualbill", "=", (Object)NOT_VIRTUAL_BILL).or(BIZ_DOMAIN, "=", (Object)"6"));
        List<String> excludeBillS = Arrays.asList("im_locationtransfer", "im_assembbill", "im_disassemblebill", "im_adjustbill");
        ArrayList balBillList = new ArrayList(InvBalanceConst.getBalBillList());
        balBillList.removeAll(excludeBillS);
        QFilter settleFilter = new QFilter("bill", "in", balBillList);
        Map settleCfgMap = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlecfg", (String)"bill", (QFilter[])settleFilter.toArray());
        for (Map.Entry settleCfg : settleCfgMap.entrySet()) {
            DynamicObject settleCfgValue = (DynamicObject)settleCfg.getValue();
            if (settleCfgValue == null) continue;
            String string = settleCfgValue.getString("bill_id");
            settleCfgBill.add(string);
        }
        List<DymAccDSMappingBill> billsFromDymAcc = DymAccDataSourceHelper.getUpdateBillFromDymAccDS(false);
        HashSet<String> dymAccs = new HashSet<String>(billsFromDymAcc.size());
        for (DymAccDSMappingBill dymAccDSMappingBill : billsFromDymAcc) {
            Map<String, String> mapping;
            String ownerKey;
            String srcBill = dymAccDSMappingBill.getSrcbill();
            if (!settleCfgBill.contains(srcBill) || StringUtils.isEmpty((CharSequence)(ownerKey = (mapping = dymAccDSMappingBill.getMapping()).get("owner")))) continue;
            String billOwnerKey = srcBill + "#" + ownerKey;
            dymAccs.add(billOwnerKey);
        }
        if (dymAccs.isEmpty()) {
            return new HashMap<String, Set<Long>>();
        }
        ArrayList<OrmInput> allBillOrmInputs = new ArrayList<OrmInput>(dymAccs.size());
        for (String billOwnerKey : dymAccs) {
            String[] split = billOwnerKey.split("#");
            String srcBill = split[0];
            String ownerKey = split[1];
            QFilter billFilter = new QFilter(ownerKey, "=", (Object)ownerId);
            if (mdcBillTypeMap.get(srcBill) != null) {
                billFilter.and("billtype.number", "=", (Object)mdcBillTypeMap.get(srcBill));
            }
            OrmInput billOrmInput = new OrmInput(InvBillStatusHelper.class.getName() + "checkBillSettleStatus", srcBill, "'" + srcBill + "' as billkey, id", (QFilter[])ArrayUtils.concatAll((Object[])qfBuilder.toArray(), (Object[][])new QFilter[][]{billFilter.toArray()}));
            allBillOrmInputs.add(billOrmInput);
        }
        Algo algo = Algo.create((String)InvBillStatusHelper.class.getName());
        DataSet unionDataSet = algo.createDataSet((Input[])allBillOrmInputs.toArray(new OrmInput[0]));
        for (Row row : unionDataSet) {
            String billKey = row.getString("billkey");
            Long billId = row.getLong("id");
            HashSet<Long> billIds = (HashSet<Long>)settleBillMap.get(billKey);
            if (billIds == null) {
                billIds = new HashSet<Long>(16);
                billIds.add(billId);
                settleBillMap.put(billKey, billIds);
                continue;
            }
            billIds.add(billId);
        }
        return InvBillStatusHelper.checkSettleStatus(settleBillMap, settleStatus);
    }

    private static Map<String, Set<Long>> checkSettleStatus(Map<String, Set<Long>> settleBillMap, String settleStatus) {
        HashMap<String, Set<Long>> checkFailedBillMap = new HashMap<String, Set<Long>>(16);
        Map settleResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"validateSettle", (Object[])new Object[]{settleBillMap});
        for (Map.Entry settleResult : settleResultMap.entrySet()) {
            boolean settleFail;
            String settleMsg = (String)settleResult.getKey();
            boolean noSettle = NO_SETTLE_STATUS.equals(settleStatus) && NO_SETTLE_MSG.equals(settleMsg);
            boolean bl = settleFail = SETTLE_FAIL_STATUS.equals(settleStatus) && SETTLE_FAIL_MSG.equals(settleMsg);
            if (!noSettle && !settleFail) continue;
            Set checkFailBillSet = (Set)settleResult.getValue();
            for (Map.Entry<String, Set<Long>> billMap : settleBillMap.entrySet()) {
                String formId = billMap.getKey();
                Set<Long> billIds = billMap.getValue();
                HashSet<Long> failBillIds = new HashSet<Long>(billIds);
                billIds.removeAll(checkFailBillSet);
                failBillIds.removeAll(billIds);
                if (failBillIds.isEmpty()) continue;
                checkFailedBillMap.put(formId, failBillIds);
            }
        }
        return checkFailedBillMap;
    }

    private static void updateBookDate(Map<String, Set<Long>> submitBillIds, Date closeDate) {
        DBRoute scmRoute = new DBRoute("scm");
        boolean enableBookEqualsBiz = SystemCallParamHelper.isEnable("sbs_scmcapplevelparam", "INV0004");
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        if (enableBookEqualsBiz) {
            params.add(new Object[]{closeDate, closeDate});
        } else {
            params.add(new Object[]{closeDate});
        }
        for (Map.Entry<String, String> item : IMBillTableMap.entrySet()) {
            String billName = item.getKey();
            String table = item.getValue();
            Set<Long> billIds = submitBillIds.get(billName);
            if (billIds == null || billIds.isEmpty()) continue;
            StringBuilder sqlBuilder = new StringBuilder("update ").append(table).append(" set fbookdate = ? ");
            if (enableBookEqualsBiz) {
                switch (billName) {
                    case "im_productinbill": 
                    case "im_mdc_mftmanuinbill": 
                    case "im_mdc_mftreturnbill": {
                        sqlBuilder.append(", fbiztimes = ? ");
                        break;
                    }
                    default: {
                        sqlBuilder.append(", fbiztime = ? ");
                    }
                }
            }
            String updateSql = sqlBuilder.toString();
            HashSet<Long> splitIds = new HashSet<Long>(16);
            for (Long billId : billIds) {
                splitIds.add(billId);
                if (splitIds.size() != 1000) continue;
                String whereSql = InvBillStatusHelper.getWhereSql(billIds, billName);
                InvBillStatusHelper.executeMethod(scmRoute, params, updateSql + whereSql);
                splitIds.clear();
            }
            if (splitIds.isEmpty()) continue;
            String whereSql = InvBillStatusHelper.getWhereSql(billIds, billName);
            InvBillStatusHelper.executeMethod(scmRoute, params, updateSql + whereSql);
        }
    }

    public static Map<Long, Map<String, Object>> chechOsPurinBill(Date startDate, Date endDate, List<Long> onwerIds, int top) {
        QFilter osPurInFilter = new QFilter("billentry.osunverifybaseqty", "!=", (Object)BigDecimal.ZERO);
        osPurInFilter.and("billentry.subtype", "in", Arrays.asList("M", SETTLE_FAIL_STATUS, "F"));
        osPurInFilter.and("bookdate", ">=", (Object)startDate);
        osPurInFilter.and("bookdate", "<=", (Object)endDate);
        osPurInFilter.and("billstatus", "=", (Object)"C");
        osPurInFilter.and("billentry.owner", "in", onwerIds);
        DataSet osPurinDs = QueryServiceHelper.queryDataSet((String)"InvBillStatusHelper.chechOsPurinBill", (String)"im_ospurinbill", (String)"id,billno,org", (QFilter[])osPurInFilter.toArray(), (String)"", (int)top);
        HashMap<Long, Map<String, Object>> results = new HashMap<Long, Map<String, Object>>(16);
        for (Row row : osPurinDs) {
            Long billId = row.getLong("id");
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put("billno", row.getString("billno"));
            resultMap.put("org", row.getLong("org"));
            results.put(billId, resultMap);
        }
        return results;
    }

    private static void executeMethod(DBRoute scmRoute, List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)scmRoute, (String)sql, params);
    }

    private static String getWhereSql(Set<Long> billIds, String billName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" where fid in ");
        sqlBuilder.append(billIds.toString().replace('[', '(').replace(']', ')'));
        if ("im_purinbill".equals(billName) || "im_saloutbill".equals(billName)) {
            sqlBuilder.append(" and fisinitbill = '0'");
        }
        return sqlBuilder.toString();
    }
}

