/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class InvCheckRecInBillMatBaseQtyHelper {
    private static Log logger = LogFactory.getLog(InvCheckRecInBillMatBaseQtyHelper.class);
    private static final String CHECK_QTY_PARAM = "isCheckRecInBillNum";
    private static final String CHECK_QTY_LOCK_PRE = "im/lock_qty/%s";
    public static final String ENTITY_PM_PURORDERBILL = "pm_purorderbill";
    public static final String ENTITY_SCTM_SCPO = "sctm_scpo";
    private static final Long WL_PURCHASE_ADD_ID = 688850502762584064L;
    private static final Long BIZTYPE_WTDX_ID_WX1101 = 1006426561370713088L;

    public static void checkBaseQtyList(DynamicObject[] bills, String operationKey) {
    }

    private static Map<Long, DynamicObjectCollection> queryToMapByMainBillId(Set<Long> mainBillIdSet, String entityType) {
        QFilter[] qFiltersIn;
        String selectFieldsIn;
        DynamicObjectCollection entryList;
        HashMap<Long, DynamicObjectCollection> dynCollInMap = new HashMap<Long, DynamicObjectCollection>(64);
        QFilter mainBillIdFilter = new QFilter("billentry.mainbillid", "in", mainBillIdSet);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)"A");
        if (!"im_mdc_omcmplinbill".equals(entityType)) {
            QFilter isVirtualBillFilter = new QFilter("isvirtualbill", "=", (Object)"0");
            statusFilter.and(isVirtualBillFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)(entryList = QueryServiceHelper.query((String)entityType, (String)(selectFieldsIn = "biztype, ischargeoffed, ischargeoff, billentry.baseqty baseqty, billentry.id entryid, billentry.mainbillentryid mainbillentryid, billentry.srcbillentity srcbillentity"), (QFilter[])(qFiltersIn = new QFilter[]{mainBillIdFilter, statusFilter}))))) {
            for (DynamicObject entry : entryList) {
                long mainBillEntryId = entry.getLong("mainbillentryid");
                DynamicObjectCollection list = (DynamicObjectCollection)dynCollInMap.get(mainBillEntryId);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    list = new DynamicObjectCollection();
                }
                list.add((Object)entry);
                dynCollInMap.put(mainBillEntryId, list);
            }
        }
        return dynCollInMap;
    }

    private static BigDecimal sumInBaseQty(DynamicObjectCollection entryPurInDbList, boolean isPurReceive, BigDecimal totalPurInBaseQty, Long entryId) {
        if (CollectionUtils.isEmpty((Collection)entryPurInDbList)) {
            return totalPurInBaseQty;
        }
        for (DynamicObject entryPurIn : entryPurInDbList) {
            boolean entityOsAndPurInFlag;
            if (entryId.longValue() == entryPurIn.getLong("entryid")) continue;
            String srcBillEntity = entryPurIn.getString("srcbillentity");
            Long bizTypeId = entryPurIn.getLong("biztype");
            boolean isChargeOffed = entryPurIn.getBoolean("ischargeoffed");
            boolean isChargeOff = entryPurIn.getBoolean("ischargeoff");
            BigDecimal baseQty = entryPurIn.getBigDecimal("baseqty");
            if ((ENTITY_PM_PURORDERBILL.equals(srcBillEntity) || ENTITY_SCTM_SCPO.equals(srcBillEntity)) && !isChargeOffed) {
                totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
            }
            if (!isPurReceive && "im_purreceivebill".equals(srcBillEntity) && !isChargeOffed) {
                totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
            }
            if (WL_PURCHASE_ADD_ID.equals(bizTypeId) && !isChargeOff) {
                totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
            }
            boolean bl = entityOsAndPurInFlag = "im_purinbill".equals(srcBillEntity) || "im_ospurinbill".equals(srcBillEntity);
            if (WL_PURCHASE_ADD_ID.equals(bizTypeId) && !isChargeOffed && entityOsAndPurInFlag && isChargeOff) {
                totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
            }
            if (!BIZTYPE_WTDX_ID_WX1101.equals(bizTypeId)) continue;
            if (!isChargeOffed) {
                totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
            }
            if (!isChargeOff) {
                totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
            }
            if (!"im_mdc_omcmplinbill".equals(srcBillEntity) || isChargeOffed || !isChargeOff) continue;
            totalPurInBaseQty = totalPurInBaseQty.add(baseQty);
        }
        return totalPurInBaseQty;
    }

    private static boolean isCheckQty() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = true;
        try (DataSet switchSet = DB.queryDataSet((String)InvCheckRecInBillMatBaseQtyHelper.class.getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{CHECK_QTY_PARAM});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"0".equals(value)) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }
}

