/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.business.helper.DymAccDSMappingBill;
import kd.scmc.im.business.helper.DymAccDataSourceHelper;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvCountSchemeConst;
import kd.scmc.im.utils.DateUtils;

public class InvCountSchemeAuditHelper {
    private static final String TRASCEIVER_RECEIVE = "0";
    private static final String TRASCEIVER_SEND = "1";
    private static final String TRASCEIVER_RECEIVE_AND_SEND = "2";
    private static String algoKey = InvCountSchemeAuditHelper.class.getName();
    protected static final List<String> invList = Arrays.asList("lotnumber", "qtyunit2nd", "creator", "auditor", "auditdate");
    private static String[] invFormIds = new String[]{"im_transinbill", "im_transoutbill", "im_transdirbill", "im_mdc_mftmanuinbill", "im_mdc_mftreturnorder", "im_saloutbill", "im_purreceivebill", "im_mdc_mftfeedorder", "im_purinbill", "im_productinbill", "im_otheroutbill", "im_disassemblebill", "im_otherinbill", "im_materialreqoutbill", "im_mdc_omcmplinbill", "im_locationtransfer", "im_mdc_omoutbill", "im_assembbill", "im_mdc_omreturnbill", "im_adjustbill", "im_mdc_omfeedbill", "im_mdc_mftproorder", "im_mdc_mftreturnbill"};
    private static final Set<String> invBillSet = new HashSet<String>(32);

    public static DataSet handleEndDateInvAccToInvCountOp(DynamicObject invCountSchemeObj, Set<QFilter> setQFilter) {
        ArrayList<QFilter> listInvBalanceQFilter = new ArrayList<QFilter>(setQFilter.size());
        for (QFilter qFilter : setQFilter) {
            listInvBalanceQFilter.add(qFilter.copy());
        }
        QFilter billDateFilter = InvcountSchemeHelper.getBillDateFilter(invCountSchemeObj);
        setQFilter.add(billDateFilter);
        DataSet billDataSetFromBeforeEndDate = InvCountSchemeAuditHelper.getBeforeEndDateUpdateBill(setQFilter);
        String[] balanceUpdateKeys = null;
        balanceUpdateKeys = "im_invacc".equals(InvAccConst.getBalTb()) ? InvCountSchemeConst.getInvbalanceDimensionField() : InvCountSchemeConst.getDymaccModelDimensionExcludeQty();
        DataSet dataSet = InvCountSchemeAuditHelper.getBeforeEndDateInvQty(listInvBalanceQFilter, invCountSchemeObj, billDataSetFromBeforeEndDate, balanceUpdateKeys);
        String[] dataSetFiledsExcludeBgn = InvcountSchemeHelper.removeFiled(InvcountSchemeHelper.getDataSetFieldArray(dataSet), InvCountSchemeAuditHelper.getBgnQtyField());
        dataSet = dataSet.select(InvcountSchemeHelper.arraysToString(InvcountSchemeHelper.addFileds(dataSetFiledsExcludeBgn, "bgnqty as qty", "bgnbaseqty as baseqty", "bgnqty2nd as qtyunit2nd")));
        return dataSet;
    }

    private static DataSet getBeforeEndDateInvQty(List<QFilter> listInvBalanceQFilter, DynamicObject invCountSchemeObj, DataSet billDataSetFromBeforeEndDate, String[] balanceUpdateKeys) {
        DataSet invBalanceDataSet = InvCountSchemeAuditHelper.getInvBalanceDataSet(listInvBalanceQFilter, invCountSchemeObj, balanceUpdateKeys);
        String[] invBalanceField = InvcountSchemeHelper.getDataSetFieldArray(invBalanceDataSet);
        if (invBalanceDataSet.copy().isEmpty()) {
            invBalanceDataSet = InvcountSchemeHelper.addSumColumn(billDataSetFromBeforeEndDate.groupBy(InvcountSchemeHelper.removeFiled(invBalanceField, "bgnqty", "bgnbaseqty", "bgnqty2nd", "endperiod")), InvCountSchemeConst.getRecandsendfield()).finish();
            HashMap<String, String> mapperbgn = new HashMap<String, String>();
            mapperbgn.put("bgnqty", "inqty - outqty");
            mapperbgn.put("bgnbaseqty", "inbaseqty - outbaseqty");
            mapperbgn.put("bgnqty2nd", "inqty2nd - outqty2nd");
            invBalanceDataSet = InvcountSchemeHelper.handleNullFiledAsZero(invBalanceDataSet, InvCountSchemeConst.getRecandsendfield());
            invBalanceDataSet = invBalanceDataSet.select(InvcountSchemeHelper.mapperFileds(InvcountSchemeHelper.removeFiled(invBalanceField, "endperiod"), mapperbgn, new String[0]));
            return invBalanceDataSet;
        }
        DataSet invBalanceToStartDateBillDataSet = InvcountSchemeHelper.addJoinColumn(billDataSetFromBeforeEndDate.copy().leftJoin(invBalanceDataSet.copy()), balanceUpdateKeys).select(billDataSetFromBeforeEndDate.getRowMeta().getFieldNames(), new String[]{"0 as bgnqty", "0 as bgnbaseqty", "0 as bgnqty2nd"}).finish().select(InvcountSchemeHelper.addFileds(InvcountSchemeHelper.addFileds(balanceUpdateKeys, InvCountSchemeConst.getRecandsendfield()), "bgnqty", "bgnbaseqty", "bgnqty2nd", "biztime")).removeFields(new String[]{"biztime"});
        invBalanceDataSet = invBalanceDataSet.select(InvcountSchemeHelper.addFileds(balanceUpdateKeys, InvCountSchemeConst.getBalrecAndSendfield()));
        invBalanceDataSet = invBalanceToStartDateBillDataSet.union(invBalanceDataSet);
        HashMap<String, String> mapperbgn = new HashMap<String, String>();
        mapperbgn.put("bgnqty", "(bgnqty + inqty) - outqty");
        mapperbgn.put("bgnbaseqty", "(bgnbaseqty + inbaseqty) - outbaseqty");
        mapperbgn.put("bgnqty2nd", "(bgnqty2nd + inqty2nd) - outqty2nd");
        invBalanceDataSet = InvcountSchemeHelper.handleNullFiledAsZero(invBalanceDataSet, InvCountSchemeConst.getRecandsendfield()).select(invBalanceDataSet.getRowMeta().getFieldNames());
        invBalanceDataSet = invBalanceDataSet.select(InvcountSchemeHelper.mapperFileds(invBalanceDataSet.getRowMeta().getFieldNames(), mapperbgn, new String[0]));
        invBalanceDataSet = InvcountSchemeHelper.addSumColumn(invBalanceDataSet.groupBy(balanceUpdateKeys), InvCountSchemeAuditHelper.getBgnQtyField()).finish();
        return invBalanceDataSet;
    }

    private static DataSet getInvBalanceDataSet(List<QFilter> listQFilter, DynamicObject invCountSchemeObj, String[] balanceUpdateKeys) {
        Date endDate = invCountSchemeObj.getDate("enddate");
        String accessNode = invCountSchemeObj.getString("accessnode");
        if ("end".equals(accessNode)) {
            endDate = DateUtils.getDayEndTime((Date)endDate);
        }
        ArrayList<QFilter> listFinalQFilter = new ArrayList<QFilter>();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        Integer startTime = Integer.valueOf(format.format(endDate));
        listFinalQFilter.add(new QFilter("endperiod", ">=", (Object)startTime).and("period", "<", (Object)startTime));
        listFinalQFilter.addAll(listQFilter);
        if (!BalanceUpdateHandle.isNewPeriodBal()) {
            listFinalQFilter.add(new QFilter("balancetype", "=", (Object)Character.valueOf('1')));
        }
        for (QFilter qFilter : listFinalQFilter) {
            if (!"lotnum".equals(qFilter.getProperty())) continue;
            qFilter.__setProperty("lotnumber");
        }
        String[] InvBalanceSelectFileds = InvcountSchemeHelper.addFileds(InvcountSchemeHelper.addFileds(balanceUpdateKeys, InvcountSchemeHelper.getInvBalacneEndQtyFieldAsBgnQty()), "endperiod");
        String entityInvbalance = "im_invbalance";
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            entityInvbalance = "im_inv_periodbalance";
        }
        DataSet invBalance = QueryServiceHelper.queryDataSet((String)InvCountSchemeAuditHelper.class.getClass().getName(), (String)entityInvbalance, (String)InvcountSchemeHelper.arraysToString(InvBalanceSelectFileds), (QFilter[])listFinalQFilter.toArray(new QFilter[listFinalQFilter.size()]), (String)"");
        invBalance = invBalance.select(InvcountSchemeHelper.addFileds(balanceUpdateKeys, InvCountSchemeAuditHelper.getBgnQtyField()));
        return invBalance;
    }

    private static String[] getBgnQtyField() {
        return new String[]{"bgnqty", "bgnbaseqty", "bgnqty2nd"};
    }

    private static DataSet getBeforeEndDateUpdateBill(Set<QFilter> setQFilter) {
        List<DymAccDSMappingBill> dymAccDSMappingBillList = DymAccDataSourceHelper.getUpdateBillFromDymAccDS(false);
        DataSet billSet = InvCountSchemeAuditHelper.getBillDataSet(dymAccDSMappingBillList, setQFilter);
        return InvCountSchemeAuditHelper.filterNoUpdateField(billSet);
    }

    private static DataSet getBillDataSet(List<DymAccDSMappingBill> listDymAccDSMappingBill, Set<QFilter> setQFilter) {
        DataSet billSet = null;
        DataSet schemeAddBillSet = null;
        DataSet schemeSubBillSet = null;
        Algo algo = Algo.create((String)algoKey);
        ArrayList<OrmInput> billAddIos = new ArrayList<OrmInput>(listDymAccDSMappingBill.size());
        ArrayList<OrmInput> billSubIos = new ArrayList<OrmInput>(listDymAccDSMappingBill.size());
        for (DymAccDSMappingBill dymAccDSMappingBill : listDymAccDSMappingBill) {
            String formId = dymAccDSMappingBill.getSrcbill();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            boolean isNeedInvScheme = true;
            if ("im_adjustbill".equals(formId) || "im_locationtransfer".equals(formId) || "im_assembbill".equals(formId) || "im_disassemblebill".equals(formId)) {
                isNeedInvScheme = false;
            } else if (!MetaDataHelper.isExistField((IDataEntityType)mainEntityType, "invscheme")) continue;
            InvCountSchemeAuditHelper.setSelectedFiledsByFromId(dymAccDSMappingBill, isNeedInvScheme);
            if (isNeedInvScheme) {
                Field[] fields;
                OrmInput billInput = InvCountSchemeAuditHelper.getBillInput(setQFilter, dymAccDSMappingBill, formId);
                RowMeta rowMeta = billInput.getRowMeta();
                for (Field field : fields = rowMeta.getFields()) {
                    DataType dataType = field.getDataType();
                    if (dataType != DataType.UnknownType) continue;
                    field.setDataType((DataType)DataType.NullType);
                }
                if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                    billAddIos.add(billInput);
                    continue;
                }
                if (!"SUB".equals(dymAccDSMappingBill.getUpdateType())) continue;
                billSubIos.add(billInput);
                continue;
            }
            billSet = InvCountSchemeAuditHelper.handleUpdateBillNotSceme(setQFilter, billSet, dymAccDSMappingBill, formId);
        }
        if (!billAddIos.isEmpty()) {
            schemeAddBillSet = InvCountSchemeAuditHelper.handleBillDataSet(algo.createDataSet((Input[])billAddIos.toArray(new OrmInput[billAddIos.size()])), "ADD");
        }
        if (!billSubIos.isEmpty()) {
            schemeSubBillSet = InvCountSchemeAuditHelper.handleBillDataSet(algo.createDataSet((Input[])billSubIos.toArray(new OrmInput[billSubIos.size()])), "SUB");
        }
        if (billSet != null) {
            String[] fieldNames = null;
            if (schemeAddBillSet != null) {
                fieldNames = schemeAddBillSet.getRowMeta().getFieldNames();
            } else if (fieldNames == null && schemeSubBillSet != null) {
                fieldNames = schemeSubBillSet.getRowMeta().getFieldNames();
            } else if (fieldNames == null) {
                return billSet;
            }
            billSet = billSet.select(fieldNames);
            return billSet.union(schemeAddBillSet).union(schemeSubBillSet);
        }
        if (schemeAddBillSet != null) {
            return schemeAddBillSet.union(schemeSubBillSet);
        }
        return schemeSubBillSet;
    }

    private static DataSet filterNoUpdateField(DataSet billSet) {
        ArrayList<Object[]> lineData = new ArrayList<Object[]>(16);
        RowMeta rowMeta = billSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        for (Row row : billSet) {
            ArrayList<Object> tempData = new ArrayList<Object>(rowMeta.getFieldCount());
            String noUpdateInvFields = row.getString("noupdateinvfields");
            boolean updateField = null != noUpdateInvFields && !noUpdateInvFields.isEmpty();
            List<String> noUpdateInvNumFieldList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(noUpdateInvFields);
            for (String fieldName : fieldNames) {
                Object value = row.get(fieldName);
                if (updateField && noUpdateInvNumFieldList.contains(fieldName)) {
                    value = 0L;
                }
                tempData.add(value);
            }
            lineData.add(tempData.toArray());
        }
        CollectionInput inputs = new CollectionInput(rowMeta, lineData);
        return Algo.create((String)InvCountSchemeAuditHelper.getAlgoKeyAndMethodName()).createDataSet(new Input[]{inputs});
    }

    private static String getAlgoKeyAndMethodName() {
        return Thread.currentThread().getStackTrace()[2].toString();
    }

    private static DataSet handleUpdateBillRecByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, Set<QFilter> listQFilter, boolean isNeedInvScheme) {
        ArrayList<QFilter> recListQFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : listQFilter) {
            recListQFilter.add(qFilter.copy());
        }
        String formId = dymAccDSMappingBill.getSrcbill();
        recListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (dymAccDSMappingBill.getqFilter() != null) {
            recListQFilter.add(dymAccDSMappingBill.getqFilter());
        }
        if (isNeedInvScheme) {
            recListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_RECEIVE, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        Map<String, String> selectFiledMap = dymAccDSMappingBill.getMapping();
        for (QFilter qFilter : recListQFilter) {
            String property;
            String qFilterName = qFilter.getProperty();
            String[] propertyList = qFilterName.split("\\.");
            if (propertyList.length == 1) {
                property = selectFiledMap.get(qFilterName);
                if (property == null) continue;
                qFilter.__setProperty(property);
                continue;
            }
            property = selectFiledMap.get(propertyList[0]);
            if (property == null) continue;
            if ("material".equals(propertyList[0])) {
                property = InvCountSchemeAuditHelper.transferMaterialKey(property);
            }
            qFilter.__setProperty(property + "." + propertyList[1]);
        }
        DataSet billSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)formId, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])recListQFilter.toArray(new QFilter[recListQFilter.size()]), (String)"id asc");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
        billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
        billSet = billSet.addField("qty", "inqty");
        billSet = billSet.addField("baseqty", "inbaseqty");
        billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "transnumber", String.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "configuredcode", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "tracknumber", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "expirydate", Timestamp.class);
        return billSet;
    }

    private static String transferMaterialKey(String property) {
        return property.replaceAll("materialmasterid1", "material1.masterid").replaceAll("materialmasterid", "material.masterid");
    }

    private static DataSet handleUpdateBillSendByRecAndSendType(DymAccDSMappingBill dymAccDSMappingBill, Set<QFilter> setQFilter, boolean isNeedInvScheme) {
        String formId = dymAccDSMappingBill.getSrcbill();
        ArrayList<QFilter> sendListQFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : setQFilter) {
            sendListQFilter.add(qFilter.copy());
        }
        sendListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (dymAccDSMappingBill.getqFilter() != null) {
            sendListQFilter.add(dymAccDSMappingBill.getqFilter());
        }
        if (isNeedInvScheme) {
            sendListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
            sendListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_SEND, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        Map<String, String> selectFiledMap = dymAccDSMappingBill.getMapping();
        for (QFilter qFilter : sendListQFilter) {
            String property;
            String qFilterName = qFilter.getProperty();
            String[] propertyList = qFilterName.split("\\.");
            if (propertyList.length == 1) {
                property = selectFiledMap.get(qFilterName);
                if (property == null) continue;
                qFilter.__setProperty(property);
                continue;
            }
            property = selectFiledMap.get(propertyList[0]);
            if (property == null) continue;
            if ("material".equals(propertyList[0])) {
                property = InvCountSchemeAuditHelper.transferMaterialKey(property);
            }
            qFilter.__setProperty(property + "." + propertyList[1]);
        }
        DataSet dataSet12 = QueryServiceHelper.queryDataSet((String)algoKey, (String)formId, (String)dymAccDSMappingBill.getSelectedFileds(), (QFilter[])sendListQFilter.toArray(new QFilter[sendListQFilter.size()]), (String)"id asc");
        dataSet12 = dataSet12.addField("qty", "outqty");
        dataSet12 = dataSet12.addField("baseqty", "outbaseqty");
        dataSet12 = dataSet12.addField("qtyunit2nd", "outqty2nd");
        dataSet12 = dataSet12.addField(TRASCEIVER_RECEIVE, "inqty");
        dataSet12 = dataSet12.addField(TRASCEIVER_RECEIVE, "inbaseqty");
        dataSet12 = dataSet12.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        dataSet12 = InvcountSchemeHelper.changFiledDataType(dataSet12, "transnumber", String.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType(dataSet12, "configuredcode", Long.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType(dataSet12, "tracknumber", Long.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType(dataSet12, "producedate", Timestamp.class);
        dataSet12 = InvcountSchemeHelper.changFiledDataType(dataSet12, "expirydate", Timestamp.class);
        return dataSet12;
    }

    private static void setSelectedFiledsByFromId(DymAccDSMappingBill dymAccDSMappingBill, boolean isNeedInvScheme) {
        String formId = dymAccDSMappingBill.getSrcbill();
        String[] columnFileds = InvcountSchemeHelper.addFileds(InvCountSchemeConst.getDymaccModelDimensionExcludeQty(), InvCountSchemeConst.getQtyfileds());
        Map<String, String> mapping = dymAccDSMappingBill.getMapping();
        Set<String> keySet = mapping.keySet();
        ArrayList<String> selectFiledFromDB = new ArrayList<String>(20);
        if (invBillSet.isEmpty()) {
            InvCountSchemeAuditHelper.initInvBillSet();
        }
        if (invBillSet.contains(formId)) {
            String materilaField = mapping.get("material").replace("material.masterid", "materialmasterid").replace("material1.masterid", "materialmasterid1");
            mapping.put("material", materilaField);
        }
        for (String columnFiled : columnFileds) {
            if ("lotnumber".equals(columnFiled)) {
                selectFiledFromDB.add(mapping.get("lotnum") + " as lotnumber");
            }
            if ("qtyunit2nd".equals(columnFiled)) {
                selectFiledFromDB.add(mapping.get("qty2nd") + " as qtyunit2nd");
            }
            if (keySet.contains(columnFiled)) {
                selectFiledFromDB.add(mapping.get(columnFiled) + " as " + columnFiled);
                continue;
            }
            if (invList.contains(columnFiled)) continue;
            Object defaultValue = InvCountSchemeAuditHelper.getFieldDefaultValue(columnFiled);
            selectFiledFromDB.add(defaultValue + " as " + columnFiled);
        }
        selectFiledFromDB.add("id");
        selectFiledFromDB.add("billno");
        selectFiledFromDB.add("billstatus");
        selectFiledFromDB.add("biztime");
        selectFiledFromDB.add("biztype");
        selectFiledFromDB.add("creator");
        selectFiledFromDB.add("auditor");
        selectFiledFromDB.add("'" + formId + "' as billType");
        selectFiledFromDB.add("billentry.noupdateinvfields as noupdateinvfields");
        if (isNeedInvScheme) {
            selectFiledFromDB.add("invscheme");
            selectFiledFromDB.add("invscheme.transceivertype.id as transnumber");
        } else {
            selectFiledFromDB.add("0 as invscheme");
            if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                switch (formId) {
                    case "im_adjustbill": {
                        selectFiledFromDB.add("'transrec' as transnumber");
                        break;
                    }
                    case "im_assembbill": {
                        selectFiledFromDB.add("'assembbillrec' as transnumber");
                        break;
                    }
                    case "im_disassemblebill": {
                        selectFiledFromDB.add("'disassemblebillrec' as transnumber");
                        break;
                    }
                    case "im_locationtransfer": {
                        selectFiledFromDB.add("'locationtransferbillrec' as transnumber");
                        break;
                    }
                }
            } else if ("SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                switch (formId) {
                    case "im_adjustbill": {
                        selectFiledFromDB.add("'transsend' as transnumber");
                        break;
                    }
                    case "im_assembbill": {
                        selectFiledFromDB.add("'assembbillsend' as transnumber");
                        break;
                    }
                    case "im_disassemblebill": {
                        selectFiledFromDB.add("'disassemblebillsend' as transnumber");
                        break;
                    }
                    case "im_locationtransfer": {
                        selectFiledFromDB.add("'locationtransferbillsend' as transnumber");
                        break;
                    }
                }
            }
        }
        dymAccDSMappingBill.setSelectedFileds(String.join((CharSequence)",", selectFiledFromDB.toArray(new String[selectFiledFromDB.size()])));
    }

    private static Object getFieldDefaultValue(String columnFiled) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        Map allFields = dt.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(columnFiled);
        if (property instanceof BasedataProp || property instanceof QtyProp) {
            return 0;
        }
        if (property instanceof TextProp || property instanceof ItemClassTypeProp) {
            return null;
        }
        if (property instanceof DateProp) {
            return null;
        }
        return null;
    }

    private static OrmInput getBillInput(Set<QFilter> listQFilter, DymAccDSMappingBill dymAccDSMappingBill, String formId) {
        ArrayList<QFilter> recListQFilter = new ArrayList<QFilter>(10);
        for (QFilter qFilter : listQFilter) {
            recListQFilter.add(qFilter.copy());
        }
        recListQFilter.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (dymAccDSMappingBill.getqFilter() != null) {
            recListQFilter.add(dymAccDSMappingBill.getqFilter());
        }
        recListQFilter.add(new QFilter("invscheme.isnotupdate", "=", (Object)Character.valueOf('0')));
        if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_RECEIVE, TRASCEIVER_RECEIVE_AND_SEND}));
        } else {
            recListQFilter.add(new QFilter("invscheme.transceivertype.transceiver", "in", (Object)new String[]{TRASCEIVER_SEND, TRASCEIVER_RECEIVE_AND_SEND}));
        }
        Map<String, String> selectFiledMap = dymAccDSMappingBill.getMapping();
        for (QFilter qFilter : recListQFilter) {
            String property;
            String qFilterName = qFilter.getProperty();
            String[] propertyList = qFilterName.split("\\.");
            if (propertyList.length == 1) {
                property = selectFiledMap.get(qFilterName);
                if (property == null) continue;
                qFilter.__setProperty(property);
                continue;
            }
            property = selectFiledMap.get(propertyList[0]);
            if (property == null) continue;
            if ("material".equals(propertyList[0])) {
                property = InvCountSchemeAuditHelper.transferMaterialKey(property);
            }
            qFilter.__setProperty(property + "." + propertyList[1]);
        }
        return new OrmInput(algoKey, formId, dymAccDSMappingBill.getSelectedFileds(), recListQFilter.toArray(new QFilter[recListQFilter.size()]));
    }

    protected static DataSet handleUpdateBillNotSceme(Set<QFilter> setQFilter, DataSet billSet, DymAccDSMappingBill dymAccDSMappingBill, String formId) {
        try {
            if ("ADD".equals(dymAccDSMappingBill.getUpdateType())) {
                billSet = billSet != null ? billSet.union(InvCountSchemeAuditHelper.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, setQFilter, false)) : InvCountSchemeAuditHelper.handleUpdateBillRecByRecAndSendType(dymAccDSMappingBill, setQFilter, false);
            } else if ("SUB".equals(dymAccDSMappingBill.getUpdateType())) {
                billSet = billSet != null ? billSet.union(InvCountSchemeAuditHelper.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, setQFilter, false)) : InvCountSchemeAuditHelper.handleUpdateBillSendByRecAndSendType(dymAccDSMappingBill, setQFilter, false);
            }
        }
        catch (AlgoException algoException) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u95f4\u6570\u636eunion\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c%1s\u201d\u7684\u4f59\u989d\u89c4\u5219\u6620\u5c04\u914d\u7f6e%2s\u3002", (String)"DymAccDataSource_0", (String)"scmc-im-business", (Object[])new Object[0]), formId, algoException.getMessage()));
        }
        catch (Exception e) {
            throw e;
        }
        return billSet;
    }

    private static DataSet handleBillDataSet(DataSet billSet, String str) {
        if ("ADD".contentEquals(str)) {
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outbaseqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "outqty2nd");
            billSet = billSet.addField("qty", "inqty");
            billSet = billSet.addField("baseqty", "inbaseqty");
            billSet = billSet.addField("qtyunit2nd", "inqty2nd");
        } else {
            billSet = billSet.addField("qty", "outqty");
            billSet = billSet.addField("baseqty", "outbaseqty");
            billSet = billSet.addField("qtyunit2nd", "outqty2nd");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inbaseqty");
            billSet = billSet.addField(TRASCEIVER_RECEIVE, "inqty2nd");
        }
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "transnumber", String.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "billType", String.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "outqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "outbaseqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "outqty2nd", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "inqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "inbaseqty", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "inqty2nd", BigDecimal.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "configuredcode", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "tracknumber", Long.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "producedate", Timestamp.class);
        billSet = InvcountSchemeHelper.changFiledDataType(billSet, "expirydate", Timestamp.class);
        billSet = billSet.orderBy(new String[]{"id asc"});
        return billSet;
    }

    private static void initInvBillSet() {
        for (String invFormId : invFormIds) {
            invBillSet.add(invFormId);
        }
    }
}

