/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.msbd.datacontrol.business.builder.CtrlStrategyBulider;
import kd.mpscmm.msbd.datacontrol.business.helper.DataCtrlServiceHelper;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlStrategyInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.ModelMapping;
import kd.mpscmm.msbd.datacontrol.business.untils.ExpressionUtils;
import kd.scmc.im.business.helper.AppParameterHelper;
import org.apache.commons.collections4.MapUtils;

public class InvDataCtrlHelper {
    private final Log log = LogFactory.getLog(InvDataCtrlHelper.class);
    private final Map<String, DcSchemeFilter> filterMap = new HashMap<String, DcSchemeFilter>(4);

    public InvDataCtrlHelper() {
        this.buildDefaultFilterMap();
    }

    public QFilter getF7QFilterByStrategy(Map<String, Map<String, Object>> schemeParams, Long dataCtrlStrategyId) {
        try {
            DynamicObject strategyDym = this.loadDataCtrlStrategy(dataCtrlStrategyId);
            if (null == strategyDym) {
                return null;
            }
            String expression = this.buildExpression(strategyDym, null);
            if (StringUtils.isBlank((CharSequence)(expression = this.filterExpression(schemeParams, expression)))) {
                return null;
            }
            this.log.info("schemeParams:{}", schemeParams);
            return DataCtrlServiceHelper.getQfilterByScheme(schemeParams, (String)"id", (String)expression);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return null;
        }
    }

    public Map<String, Set<Long>> getDataByStrategy(Map<String, Map<String, Object>> schemeParams, Long dataCtrlStrategyId) {
        try {
            DynamicObject strategyDym = this.loadDataCtrlStrategy(dataCtrlStrategyId);
            if (null == strategyDym) {
                return Collections.emptyMap();
            }
            String expression = this.buildExpression(strategyDym, null);
            if (StringUtils.isBlank((CharSequence)(expression = this.filterExpression(schemeParams, expression)))) {
                return Collections.emptyMap();
            }
            return DataCtrlServiceHelper.getCtrlDataByScheme(schemeParams, (String)expression);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    public QFilter getF7QFilterByStrategy(DynamicObject entity, String formId, String ctrlField) {
        try {
            if (null == entity || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return null;
            }
            DynamicObject strategyDym = this.loadDataCtrlStrategy(formId, ctrlField = this.getFullFiledPath(formId, ctrlField));
            if (null == strategyDym) {
                return null;
            }
            String entityKey = strategyDym.getString("bizbill.number");
            Map<String, Map<String, Object>> dataCtrlSchemeParam = this.buildSchemeParams(entity, entityKey, ctrlField, null, null);
            return this.getF7QFilterByStrategy(dataCtrlSchemeParam, strategyDym.getLong("id"));
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return null;
        }
    }

    private DynamicObject loadDataCtrlStrategy(String formId, String ctrlField) {
        List<String> entityTypeList = this.getEntityTypeList(formId);
        QFilter qFilter = new QFilter("bizbill", "in", entityTypeList);
        qFilter.and("ctrlField", "=", (Object)ctrlField);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
        if (resultMap.isEmpty()) {
            return null;
        }
        HashMap<String, DynamicObject> dataCtrlMap = new HashMap<String, DynamicObject>(4);
        for (DynamicObject dataCtrlDym : resultMap.values()) {
            String bizbill = dataCtrlDym.getString("bizbill.number");
            dataCtrlMap.put(bizbill, dataCtrlDym);
        }
        for (String entityType : entityTypeList) {
            if (!dataCtrlMap.containsKey(entityType)) continue;
            return (DynamicObject)dataCtrlMap.get(entityType);
        }
        return null;
    }

    private List<DynamicObject> loadDataCtrlStrategyList(String formId, String ctrlField) {
        List<String> entityTypeList = this.getEntityTypeList(formId);
        QFilter qFilter = new QFilter("bizbill", "in", entityTypeList);
        qFilter.and("ctrlField", "=", (Object)ctrlField);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
        if (resultMap.isEmpty()) {
            return null;
        }
        return new ArrayList<DynamicObject>(resultMap.values());
    }

    public QFilter getF7QFilterByStrategyList(DynamicObject entity, String formId, String ctrlField) {
        try {
            if (null == entity || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return null;
            }
            List<DynamicObject> strategyDymList = this.loadDataCtrlStrategyList(formId, ctrlField);
            if (CollectionUtils.isEmpty(strategyDymList)) {
                return null;
            }
            HashMap<String, Map<String, Object>> schemeParams = new HashMap<String, Map<String, Object>>();
            StringBuilder expressionFinal = new StringBuilder();
            for (DynamicObject strategyDym : strategyDymList) {
                String entityKey = strategyDym.getString("bizbill.number");
                Map<String, Map<String, Object>> dataCtrlSchemeParam = this.buildSchemeParams(entity, entityKey, ctrlField, null, null);
                String expression = this.buildExpression(strategyDym, null);
                if (StringUtils.isBlank((CharSequence)(expression = this.filterExpression(dataCtrlSchemeParam, expression)))) continue;
                schemeParams.putAll(dataCtrlSchemeParam);
                expressionFinal.append("&").append(expression);
            }
            if (expressionFinal.length() == 0) {
                return null;
            }
            String expressionStr = expressionFinal.substring(1, expressionFinal.length());
            String qFilterProp = "id";
            String[] ctrlFieldSplit = ctrlField.split("\\.");
            if ("masterid".equals(ctrlFieldSplit[ctrlFieldSplit.length - 1])) {
                qFilterProp = "masterid";
            }
            return DataCtrlServiceHelper.getQfilterByScheme(schemeParams, (String)qFilterProp, (String)expressionStr);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return null;
        }
    }

    private DynamicObject loadDataCtrlStrategy(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
    }

    private String buildExpression(DynamicObject strategyDym, Set<String> checkSchemeNumList) {
        StringBuilder expression = new StringBuilder();
        DynamicObjectCollection entryRows = strategyDym.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryRows) {
            String schemeNum = entryRow.getString("datactrlscheme.number");
            String leftbracket = entryRow.getString("leftbracket");
            String rightbracket = entryRow.getString("rightbracket");
            String logic = entryRow.getString("logic");
            if (checkSchemeNumList != null && !checkSchemeNumList.contains(schemeNum)) continue;
            expression.append(leftbracket).append(schemeNum).append(rightbracket).append(logic);
        }
        String expressionStr = expression.toString();
        if (0 == expressionStr.length()) {
            return null;
        }
        if (expressionStr.endsWith("&") || expressionStr.endsWith("|")) {
            expressionStr = expressionStr.substring(0, expression.length() - 1);
        }
        return expressionStr;
    }

    private String filterExpression(Map<String, Map<String, Object>> params, String expression) {
        if (this.filterMap.isEmpty()) {
            return expression;
        }
        HashSet<String> removeSchemeNumSet = new HashSet<String>(4);
        for (Map.Entry<String, Map<String, Object>> entry : params.entrySet()) {
            String schemeNum = entry.getKey();
            Map<String, Object> paramVal = entry.getValue();
            DcSchemeFilter filter = this.filterMap.get(schemeNum);
            if (null == filter || filter.filter(paramVal)) continue;
            removeSchemeNumSet.add(schemeNum);
        }
        if (removeSchemeNumSet.isEmpty()) {
            return expression;
        }
        for (String schemeNum : removeSchemeNumSet) {
            params.remove(schemeNum);
            expression = ExpressionUtils.removeString((String)expression, (String)schemeNum);
        }
        return expression;
    }

    private void buildDefaultFilterMap() {
        this.addFilter(new DcSchemeFilter(){

            @Override
            public Set<String> supportDataCtrlNum() {
                return new HashSet<String>(Arrays.asList("invop_wh_ctrl", "invop_auxwh_ctrl", "auxinvop_auxwh_ctrl"));
            }

            @Override
            public boolean filter(Map<String, Object> dcSchemeParam) {
                Object org = dcSchemeParam.get("org");
                if (org == null && (org = dcSchemeParam.get("auxorg")) == null) {
                    return false;
                }
                ArrayList<Long> orgIds = new ArrayList<Long>();
                if (org instanceof Long) {
                    orgIds.add((Long)org);
                } else {
                    orgIds.addAll((Collection)org);
                }
                AppParam appParam = new AppParam("=9Q86DR2P+Q", "05", (Long)orgIds.get(0), Long.valueOf(0L));
                Object warehouseIsolate = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"fwarehouseisolate");
                if (warehouseIsolate instanceof Boolean) {
                    return (Boolean)warehouseIsolate;
                }
                return true;
            }
        });
        this.addFilter(new DcSchemeFilter(){

            @Override
            public Set<String> supportDataCtrlNum() {
                return new HashSet<String>(Arrays.asList("auxinvop_mat_ctrl", "invop_mat_ctrl", "invop_auxmat_ctrl"));
            }

            @Override
            public boolean filter(Map<String, Object> dcSchemeParam) {
                Object org = dcSchemeParam.get("org");
                if (org == null && (org = dcSchemeParam.get("auxorg")) == null) {
                    return false;
                }
                ArrayList<Long> orgIds = new ArrayList<Long>();
                if (org instanceof Long) {
                    orgIds.add((Long)org);
                } else {
                    orgIds.addAll((Collection)org);
                }
                AppParam appParam = new AppParam("=9Q86DR2P+Q", "05", (Long)orgIds.get(0), Long.valueOf(0L));
                Object warehouseIsolate = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"fmaterialisolate");
                if (warehouseIsolate instanceof Boolean) {
                    return (Boolean)warehouseIsolate;
                }
                return true;
            }
        });
        this.addFilter(new DcSchemeFilter(){

            @Override
            public Set<String> supportDataCtrlNum() {
                return new HashSet<String>(Arrays.asList("auxinvop_auxwh_ctrl", "invop_auxwh_ctrl", "invop_wh_ctrl"));
            }

            @Override
            public boolean filter(Map<String, Object> dcSchemeParam) {
                return InvDataCtrlHelper.this.getAppParameterScope(dcSchemeParam, "fpeoplescop");
            }
        });
        this.addFilter(new DcSchemeFilter(){

            @Override
            public Set<String> supportDataCtrlNum() {
                return new HashSet<String>(Arrays.asList("auxmat_auxwh_ctrl", "auxorg_auxwh_mat_ctrl", "auxorg_mat_auxwh_ctrl", "auxwh_auxmat_ctrl", "auxwh_mat_ctrl", "mat_auxwh_ctrl", "mat_wh_ctrl", "wh_mat_ctrl"));
            }

            @Override
            public boolean filter(Map<String, Object> dcSchemeParam) {
                return InvDataCtrlHelper.this.getAppParameterScope(dcSchemeParam, "fmeterialscope");
            }
        });
    }

    public void addFilter(DcSchemeFilter dcSchemeFilter) {
        if (null == dcSchemeFilter || CollectionUtils.isEmpty(dcSchemeFilter.supportDataCtrlNum())) {
            return;
        }
        for (String dataCtrlNum : dcSchemeFilter.supportDataCtrlNum()) {
            this.filterMap.put(dataCtrlNum, dcSchemeFilter);
        }
    }

    private boolean getAppParameterScope(Map<String, Object> dcSchemeParam, String scopeField) {
        Object org = dcSchemeParam.get("org");
        if (org == null && (org = dcSchemeParam.get("auxorg")) == null) {
            return false;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (org instanceof Long) {
            orgIds.add((Long)org);
        } else {
            orgIds.addAll((Collection)org);
        }
        Object appParameter = AppParameterHelper.getAppParameter("=9Q86DR2P+Q", "05", (Long)orgIds.get(0), scopeField);
        return "2".equals(appParameter);
    }

    public Set<Long> getDataByUser(List<Long> orgIds, String formId, String ctrlField) {
        try {
            if (CollectionUtils.isEmpty(orgIds) || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return Collections.emptySet();
            }
            Long userId = UserServiceHelper.getCurrentUserId();
            Set<Long> operatorIds = this.getOperatorIds(userId);
            if (operatorIds.isEmpty()) {
                return Collections.emptySet();
            }
            HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>(4);
            param.put("org", orgIds);
            param.put("operator", operatorIds);
            ctrlField = this.getFullFiledPath(formId, ctrlField);
            HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(4);
            DynamicObject strategyDym = this.loadDataCtrlStrategy(formId, ctrlField);
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            DynamicObjectCollection entryRows = strategyDym.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryRows) {
                paramMap.put(entryRow.getString("datactrlscheme.number"), param);
            }
            Map<String, Set<Long>> resultMap = this.getDataByStrategy(paramMap, strategyDym.getLong("id"));
            return this.getDataResult(resultMap);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private String getFullFiledPath(String entityKey, String ctrlField) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)ctrlField);
        if (null == property) {
            return ctrlField;
        }
        String field = property.getName();
        for (IDataEntityType entityType = property.getParent(); null != entityType && null != entityType.getParent(); entityType = entityType.getParent()) {
            field = entityType.getName() + "." + field;
        }
        return field;
    }

    public Set<Long> getDataByUser(List<Long> orgIds, Long strategyId) {
        try {
            Long userId = UserServiceHelper.getCurrentUserId();
            Set<Long> operatorIds = this.getOperatorIds(userId);
            if (operatorIds.isEmpty()) {
                return Collections.emptySet();
            }
            HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>(4);
            param.put("org", orgIds);
            param.put("operator", operatorIds);
            HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(4);
            DynamicObject strategyDym = this.loadDataCtrlStrategy(strategyId);
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            DynamicObjectCollection entryRows = strategyDym.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryRows) {
                paramMap.put(entryRow.getString("datactrlscheme.number"), param);
            }
            Map<String, Set<Long>> resultMap = this.getDataByStrategy(paramMap, strategyDym.getLong("id"));
            return this.getDataResult(resultMap);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> getDataResult(Map<String, Set<Long>> resultMap) {
        if (null == resultMap) {
            return Collections.emptySet();
        }
        Set<Long> ids = resultMap.get("ALLOW_DATA");
        return null != ids ? ids : Collections.emptySet();
    }

    private Set<Long> getOperatorIds(Long userId) {
        QFilter qFilter = new QFilter("operatorid", "=", (Object)userId);
        qFilter.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        DynamicObjectCollection operators = QueryServiceHelper.query((String)"bd_operator", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> operatorIds = new HashSet<Long>(operators.size());
        if (operators.isEmpty()) {
            return operatorIds;
        }
        for (DynamicObject operator : operators) {
            operatorIds.add(operator.getLong("id"));
        }
        return operatorIds;
    }

    public Set<Long> getDataByDataCtrl(DynamicObject entity, String formId, String ctrlField) {
        try {
            ctrlField = this.getFullFiledPath(formId, ctrlField);
            DynamicObject strategyDym = this.loadDataCtrlStrategy(formId, ctrlField);
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            String entityKey = strategyDym.getString("bizbill.number");
            Map<String, Map<String, Object>> schemeParams = this.buildSchemeParams(entity, entityKey, ctrlField, null, null);
            String expression = this.buildExpression(strategyDym, null);
            if (StringUtils.isBlank((CharSequence)(expression = this.filterExpression(schemeParams, expression)))) {
                return Collections.emptySet();
            }
            this.log.info("schemeParams:{}", schemeParams);
            Map resultMap = DataCtrlServiceHelper.getCtrlDataByScheme(schemeParams, (String)expression);
            return this.getDataResult(resultMap);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Map<String, Map<String, Object>> buildSchemeParams(DynamicObject entity, String formId, String ctrlField, Map<String, Map<String, Set<Long>>> cacheMap, Set<String> checkSchemeNumList) {
        HashMap<String, Map<String, Object>> paramsMap = new HashMap<String, Map<String, Object>>(4);
        CtrlStrategyInfo strategyInfo = CtrlStrategyBulider.bulid((String)formId, (String)ctrlField);
        if (null == strategyInfo) {
            return paramsMap;
        }
        Map ctrlSchemeCollList = strategyInfo.getCtrlSchemeColl();
        StringBuilder inputConditionSb = new StringBuilder();
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeCollList.values()) {
            List inputConditionList = schemeInfo.getInputConditionList();
            for (Object inputCondition : inputConditionList) {
                inputConditionSb.append((String)inputCondition);
            }
        }
        String entityKey = entity.getDataEntityType().getName();
        for (DynamicObject parent = entity; null != parent; parent = (DynamicObject)parent.getParent()) {
            entityKey = parent.getDataEntityType().getName();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        ModelMapping mbMapping = strategyInfo.getMBMapping();
        for (Map.Entry entry : mbMapping.getModelMapping().entrySet()) {
            Object value;
            String modelField = (String)entry.getKey();
            String billField = (String)entry.getValue();
            if (inputConditionSb.indexOf("," + modelField + ",") == -1 || ObjectUtils.isEmpty((Object)(value = this.getValue(mainEntityType, entity, billField)))) continue;
            mbMapping.getRightValueMap().put(billField, value);
            mbMapping.getLeftValueMap().put(modelField, value);
        }
        Map ctrlSchemeColl = strategyInfo.getCtrlSchemeColl();
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeColl.values()) {
            ModelMapping meMapping = schemeInfo.getMEMapping();
            if (null == mbMapping.getLeftValueMap() || null != checkSchemeNumList && !checkSchemeNumList.contains(schemeInfo.getNumber())) continue;
            meMapping.getLeftValueMap().putAll(mbMapping.getLeftValueMap());
            Map meRvMap = meMapping.convert2LVMap();
            paramsMap.put(schemeInfo.getNumber(), meRvMap);
        }
        return paramsMap;
    }

    private Map<String, Map<String, Object>> buildSchemeParams(DynamicObject entity, Set<String> numbers, String expression, Set<String> checkSchemeNumList) {
        HashMap<String, Map<String, Object>> paramsMap = new HashMap<String, Map<String, Object>>(4);
        CtrlStrategyInfo strategyInfo = CtrlStrategyBulider.bulid(numbers, (String)expression);
        if (null == strategyInfo) {
            return paramsMap;
        }
        Map ctrlSchemeCollList = strategyInfo.getCtrlSchemeColl();
        StringBuilder inputConditionSb = new StringBuilder();
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeCollList.values()) {
            List inputConditionList = schemeInfo.getInputConditionList();
            for (Object inputCondition : inputConditionList) {
                inputConditionSb.append((String)inputCondition);
            }
        }
        String entityKey = entity.getDataEntityType().getName();
        for (DynamicObject parent = entity; null != parent; parent = (DynamicObject)parent.getParent()) {
            entityKey = parent.getDataEntityType().getName();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        ModelMapping mbMapping = strategyInfo.getMBMapping();
        for (Map.Entry entry : mbMapping.getModelMapping().entrySet()) {
            Object value;
            String modelField = (String)entry.getKey();
            String billField = (String)entry.getValue();
            if (inputConditionSb.indexOf("," + modelField + ",") == -1 || ObjectUtils.isEmpty((Object)(value = this.getValue(mainEntityType, entity, billField)))) continue;
            mbMapping.getRightValueMap().put(billField, value);
            mbMapping.getLeftValueMap().put(modelField, value);
        }
        Map ctrlSchemeColl = strategyInfo.getCtrlSchemeColl();
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeColl.values()) {
            ModelMapping meMapping = schemeInfo.getMEMapping();
            if (null == mbMapping.getLeftValueMap() || null != checkSchemeNumList && !checkSchemeNumList.contains(schemeInfo.getNumber())) continue;
            meMapping.getLeftValueMap().putAll(mbMapping.getLeftValueMap());
            Map meRvMap = meMapping.convert2LVMap();
            paramsMap.put(schemeInfo.getNumber(), meRvMap);
        }
        return paramsMap;
    }

    private List<String> getEntityTypeList(String entityKey) {
        String inheritPath;
        ArrayList<String> entityTypeList = new ArrayList<String>(4);
        entityTypeList.add(entityKey);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        if (null != mainEntityType && StringUtils.isNotBlank((CharSequence)(inheritPath = mainEntityType.getInheritPath()))) {
            String[] parentEntityTypes = StringUtils.split((String)inheritPath, (String)",");
            for (int i = parentEntityTypes.length - 1; i >= 0; --i) {
                String parentEntityTypeId = parentEntityTypes[i];
                MainEntityType parentType = EntityMetadataCache.getDataEntityTypeById((String)parentEntityTypeId);
                if (parentType.getName().startsWith("bos_")) continue;
                entityTypeList.add(parentType.getName());
            }
        }
        return entityTypeList;
    }

    public Map<Long, Map<Long, Boolean>> checkData(List<DynamicObject> entityList, String formId, String ctrlField, Set<String> checkSchemeNumList) {
        try {
            if (CollectionUtils.isEmpty(entityList) || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return Collections.emptyMap();
            }
            List<DynamicObject> strategyDymList = this.loadDataCtrlStrategyList(formId, ctrlField);
            if (CollectionUtils.isEmpty(strategyDymList)) {
                return Collections.emptyMap();
            }
            HashMap<Long, Map<Long, Boolean>> resultMap = new HashMap<Long, Map<Long, Boolean>>(entityList.size());
            String expression = null;
            HashMap<String, Map> resultCache = new HashMap<String, Map>();
            for (int i = 0; i < entityList.size(); ++i) {
                DynamicObject entity = entityList.get(i);
                StringBuilder expressionFinal = new StringBuilder();
                HashMap<String, Map<String, Object>> dataCtrlSchemeParams = new HashMap<String, Map<String, Object>>();
                for (DynamicObject strategyDym : strategyDymList) {
                    String entityKey = strategyDym.getString("bizbill.number");
                    Map<String, Map<String, Object>> dataCtrlSchemeParam = this.buildSchemeParams(entity, entityKey, ctrlField, null, checkSchemeNumList);
                    expression = this.buildExpression(strategyDym, checkSchemeNumList);
                    if (StringUtils.isBlank((CharSequence)(expression = this.filterExpression(dataCtrlSchemeParam, expression))) || dataCtrlSchemeParam.isEmpty()) continue;
                    dataCtrlSchemeParams.putAll(dataCtrlSchemeParam);
                    expressionFinal.append("&").append(expression);
                }
                if (expressionFinal.length() == 0) continue;
                expression = expressionFinal.substring(1, expressionFinal.length());
                Set<Long> dataIds = this.getDataIdEntrys(entity, ctrlField);
                if (dataCtrlSchemeParams.isEmpty() || dataIds.isEmpty()) continue;
                String cacheKey = ((Object)dataCtrlSchemeParams).toString().concat(dataIds.toString()).concat(expression);
                Map checkMap = null;
                if (resultCache.containsKey(cacheKey)) {
                    checkMap = (Map)resultCache.get(cacheKey);
                    resultMap.put(Long.valueOf(i), checkMap);
                    continue;
                }
                checkMap = DataCtrlServiceHelper.checkDataByScheme(dataCtrlSchemeParams, dataIds, (String)expression);
                resultMap.put(Long.valueOf(i), checkMap);
                resultCache.put(cacheKey, checkMap);
            }
            return resultMap;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Set<Long> getDataIds(DynamicObject entity, String ctrlField) {
        MainEntityType mainEntityType = (MainEntityType)entity.getDataEntityType();
        DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)ctrlField);
        if (null == property) {
            return Collections.emptySet();
        }
        Object val = property.getValue((Object)entity);
        if (val instanceof DynamicObject) {
            return Collections.singleton(((DynamicObject)val).getLong("id"));
        }
        if (val instanceof DynamicObjectCollection) {
            DynamicObjectCollection collection = (DynamicObjectCollection)val;
            return collection.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public boolean enableCtrl(DynamicObject entity, String formId, String ctrlField) {
        try {
            if (null == entity || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return false;
            }
            List<DynamicObject> strategyDymList = this.loadDataCtrlStrategyList(formId, ctrlField);
            if (CollectionUtils.isEmpty(strategyDymList)) {
                return false;
            }
            for (DynamicObject strategyDym : strategyDymList) {
                DynamicObjectCollection entryRows = strategyDym.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryRow : entryRows) {
                    DcSchemeFilter filter;
                    String schemeNum = entryRow.getString("datactrlscheme.number");
                    Map<String, Map<String, Object>> dataCtrlSchemeParam = this.buildSchemeParams(entity, Collections.singleton(schemeNum), schemeNum, null);
                    if (null == dataCtrlSchemeParam) {
                        return false;
                    }
                    Map<String, Object> param = dataCtrlSchemeParam.get(schemeNum);
                    if (MapUtils.isEmpty(dataCtrlSchemeParam)) {
                        return false;
                    }
                    if (null != this.filterMap && !this.filterMap.isEmpty() && null != (filter = this.filterMap.get(schemeNum))) continue;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return false;
        }
    }

    private Set<Long> getDataIdEntrys(DynamicObject entity, String ctrlField) {
        String entityKey = "";
        for (DynamicObject parent = entity; null != parent; parent = (DynamicObject)parent.getParent()) {
            entityKey = parent.getDataEntityType().getName();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)ctrlField);
        if (null == property) {
            return Collections.emptySet();
        }
        Object val = this.getValue(mainEntityType, entity, ctrlField);
        if (val instanceof DynamicObject) {
            return Collections.singleton(((DynamicObject)val).getLong("id"));
        }
        if (val instanceof DynamicObjectCollection) {
            DynamicObjectCollection collection = (DynamicObjectCollection)val;
            return collection.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        }
        if (val instanceof Long) {
            HashSet<Long> objects = new HashSet<Long>();
            objects.add((Long)val);
            return objects;
        }
        if (val instanceof Set) {
            return (Set)val;
        }
        return Collections.emptySet();
    }

    private Object getValue(MainEntityType mainEntityType, DynamicObject entity, String field) {
        HashSet<Object> valueSet = new HashSet<Object>(8);
        if (null == entity || StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        RowDataModel model = new RowDataModel(entity.getDataEntityType().getName(), mainEntityType);
        model.setRowContext(entity);
        Object val = model.getValue(field);
        if (val == null) {
            return null;
        }
        if (val instanceof DynamicObject) {
            return this.getPkId((DynamicObject)val, field);
        }
        if (val instanceof DynamicObjectCollection) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)val;
            for (DynamicObject entry : entrys) {
                Object entryVal = this.getValue(mainEntityType, entry, field);
                if (entryVal instanceof Collection) {
                    valueSet.addAll((Collection)entryVal);
                    continue;
                }
                if (null == entryVal) continue;
                valueSet.add(entryVal);
            }
        } else if (val instanceof List) {
            List list = (List)val;
            for (Object item : list) {
                if (item instanceof DynamicObject) {
                    valueSet.add(this.getPkId((DynamicObject)item, field));
                    continue;
                }
                if (null == item) continue;
                valueSet.add(item);
            }
        } else if (ObjectUtils.isArray((Object)val)) {
            Object[] array;
            for (Object item : array = (Object[])val) {
                if (item instanceof DynamicObject) {
                    valueSet.add(this.getPkId((DynamicObject)item, field));
                    continue;
                }
                if (null == item) continue;
                valueSet.add(item);
            }
        } else if (null != val) {
            return val;
        }
        return valueSet;
    }

    private Long getPkId(DynamicObject dym, String field) {
        return dym.getLong("id");
    }

    public static interface DcSchemeFilter {
        public Set<String> supportDataCtrlNum();

        default public boolean filter(Map<String, Object> dcSchemeParam) {
            return true;
        }
    }
}

