/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.IFormView;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.InvSchemeServiceFactory;
import kd.scmc.im.consts.InvSchemeConst;
import kd.scmc.im.consts.InvschemeConsts;
import org.apache.commons.lang3.StringUtils;

public class InvSchemeHelper {
    private static final String[] inCheckFields = new String[]{"owner", "keeper", "ownertype", "keepertype", "invstatus", "invtype"};
    private static final String[] outCheckFields = new String[]{"outowner", "outkeeper", "outownertype", "outkeepertype", "outinvstatus", "outinvtype"};
    protected static final String[] specialBill = new String[]{"im_mdc_mftmanuinbill", "im_mdc_mftreturnbill", "im_mdc_omcmplinbill"};
    private static final String[] ENTRUSTSALE_BUTTON = new String[]{"bar_copy", "addrow", "deleterow", "splitrow", "fillbatch", "qinvacc", "snnumber", "matchingruleout"};
    private static final String[] ENTRUSTSALE_PANEL = new String[]{"flexpanelap1", "flexpanelap2", "billentry"};
    private static final String[] DIRECTTRAN_BUTTON = new String[]{"bar_copy"};

    public static List<DynamicObject> getInvSchemeByEntityID(String entityID) {
        String fields = InvSchemeConst.getAllSelector();
        QFilter qFilter1 = new QFilter("billform", "=", (Object)entityID);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] invSchemes = BusinessDataServiceHelper.load((String)"im_invscheme", (String)fields, (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return Arrays.asList(invSchemes);
    }

    public static DynamicObject getInvSchemeByEntityAndBizType(String billFormID, Long bizTypeID) {
        QFilter qFilter4;
        QFilter qFilter3;
        QFilter qFilter2;
        QFilter qFilter1;
        if (billFormID == null || bizTypeID == null || bizTypeID == 0L) {
            return null;
        }
        String fields = InvSchemeConst.getAllSelector();
        LinkedHashMap invSchemesMap = (LinkedHashMap)BusinessDataServiceHelper.loadFromCache((String)"im_invscheme", (String)fields, (QFilter[])new QFilter[]{qFilter1 = new QFilter("billform", "=", (Object)billFormID), qFilter2 = new QFilter("bitypeentry.biztype", "=", (Object)bizTypeID), qFilter3 = new QFilter("enable", "=", (Object)"1"), qFilter4 = new QFilter("bitypeentry.allowmanualadd", "=", (Object)"1")}, (String)"number");
        if (invSchemesMap == null || invSchemesMap.isEmpty()) {
            return null;
        }
        Collection values = invSchemesMap.values();
        DynamicObject[] invSchemes = values.toArray(new DynamicObject[values.size()]);
        return invSchemes[0];
    }

    public static DynamicObject getDefaltInvtype(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    public static List<Object> getInvtypes(DynamicObject invScheme) {
        return InvSchemeHelper.getInvTypes(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    public static Map<Long, List<String>> getInvTypeMap(DynamicObject invScheme) {
        return InvSchemeHelper.getTypeMap(invScheme, "invtypeentry", "invtype", "ownertype1", "keepertype1");
    }

    public static Map<Long, List<String>> getOutInvType(DynamicObject invScheme) {
        return InvSchemeHelper.getTypeMap(invScheme, "outinvtypeentry", "outinvtype", "outownertype1", "outkeepertype1");
    }

    public static Map<Long, List<String>> getTypeMap(DynamicObject invScheme, String entryKey, String invTypeKey, String ownerTypeKey, String keeperKey) {
        DynamicObjectCollection typeEntrys = invScheme.getDynamicObjectCollection(entryKey);
        HashMap<Long, List<String>> typeMap = new HashMap<Long, List<String>>(16);
        for (DynamicObject typeEntry : typeEntrys) {
            DynamicObject invType = typeEntry.getDynamicObject(invTypeKey);
            if (invType == null) continue;
            long invTypeId = invType.getLong("id");
            String ownerType = typeEntry.getString(ownerTypeKey);
            String keeperType = typeEntry.getString(keeperKey);
            ArrayList<String> ownerKeeperList = new ArrayList<String>(2);
            ownerKeeperList.add(ownerType);
            ownerKeeperList.add(keeperType);
            typeMap.put(invTypeId, ownerKeeperList);
        }
        return typeMap;
    }

    public static DynamicObject getDefaltOutInvtype(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    public static String getDefaultOwnerType(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultOwnerKeeperType(invScheme, "invtypeentry", "invtypeisdefault", "ownertype1");
    }

    public static String getDefaultKeeperType(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultOwnerKeeperType(invScheme, "invtypeentry", "invtypeisdefault", "keepertype1");
    }

    public static String getDefaultOutOwnerType(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultOwnerKeeperType(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outownertype1");
    }

    public static String getDefaultOutKeeperType(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultOwnerKeeperType(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outkeepertype1");
    }

    private static DynamicObject getDefaultInvTypeOrStatus(DynamicObject invScheme, String invTypeOrStatusEntry, String invTypeOrStatusIsDefault, String invTypeOrStatus) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeOrStatusEntry);
        DynamicObject defaultInvTypeOrStatus = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeOrStatusIsDefault)) continue;
                defaultInvTypeOrStatus = entry.getDynamicObject(invTypeOrStatus);
                break;
            }
            if (defaultInvTypeOrStatus == null) {
                defaultInvTypeOrStatus = ((DynamicObject)entries.get(0)).getDynamicObject(invTypeOrStatus);
            }
        }
        return defaultInvTypeOrStatus;
    }

    private static DynamicObject getDefaultInvTypeEntry(DynamicObject invScheme, String invTypeEntry, String invTypeIsDefault) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeEntry);
        DynamicObject defaultInvTypeEntry = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeIsDefault)) continue;
                defaultInvTypeEntry = entry;
                break;
            }
            if (defaultInvTypeEntry == null) {
                defaultInvTypeEntry = (DynamicObject)entries.get(0);
            }
        }
        return defaultInvTypeEntry;
    }

    public static DynamicObject getInvTypeEntryByInvType(DynamicObject invScheme, String invType, String invTypeValue, String invTypeEntry, String invTypeIsDefault) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeEntry);
        DynamicObject invTypeEntryObj = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getDynamicObject(invType).getString("number").equals(invTypeValue)) continue;
                invTypeEntryObj = entry;
                break;
            }
            if (invTypeEntryObj == null) {
                invTypeEntryObj = InvSchemeHelper.getDefaultInvTypeEntry(invScheme, invTypeEntry, invTypeIsDefault);
            }
        }
        return invTypeEntryObj;
    }

    private static String getDefaultOwnerKeeperType(DynamicObject invScheme, String entryName, String invTypeIsDefault, String typeField) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(entryName);
        String ownerKeeperType = null;
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeIsDefault)) continue;
                ownerKeeperType = entry.getString(typeField);
                break;
            }
            if (ownerKeeperType == null) {
                ownerKeeperType = ((DynamicObject)entries.get(0)).getString(typeField);
            }
        }
        return ownerKeeperType;
    }

    public static DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "invstatusentry", "invstatusisdefault", "invstatus");
    }

    public static DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "outinvstatusentry", "outinvstatusisdefault", "outinvstatus");
    }

    public static List<Object> getOutInvtypes(DynamicObject invScheme) {
        return InvSchemeHelper.getInvTypes(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    private static List<Object> getInvTypes(DynamicObject invScheme, String invTypeEntry, String invTypeIsDefault, String invType) {
        ArrayList<Object> invTypes = new ArrayList<Object>(16);
        DynamicObjectCollection outInvTypeEntrys = invScheme.getDynamicObjectCollection(invTypeEntry);
        DynamicObject defaultOutInvType = null;
        if (outInvTypeEntrys != null && outInvTypeEntrys.size() > 0) {
            for (DynamicObject outInvTypeEntry : outInvTypeEntrys) {
                if (!outInvTypeEntry.getBoolean(invTypeIsDefault)) continue;
                defaultOutInvType = outInvTypeEntry.getDynamicObject(invType);
                invTypes.add(defaultOutInvType.get("id"));
            }
        }
        return invTypes;
    }

    public static void initEntrysValue(IFormView view, DynamicObject invScheme, int ... rows) {
        IDataModel bill = view.getModel();
        boolean initialized = bill.isInitialized();
        if (invScheme == null || rows == null || rows.length == 0) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject invType = null;
        Object invStatusId = null;
        Object invTypeId = null;
        if (isInUpdate) {
            ownerType = InvSchemeHelper.getDefaultOwnerType(invScheme);
            keeperType = InvSchemeHelper.getDefaultKeeperType(invScheme);
            invStatus = InvSchemeHelper.getDefaultInvStatus(invScheme);
            invType = InvSchemeHelper.getDefaltInvtype(invScheme);
            invStatusId = invStatus == null ? null : invStatus.getPkValue();
            invTypeId = invType == null ? null : invType.getPkValue();
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvTtatus = null;
        DynamicObject outInvType = null;
        Object outInvStatusId = null;
        Object outInvTypeId = null;
        if (isOutUpdate) {
            outOwnerType = InvSchemeHelper.getDefaultOutOwnerType(invScheme);
            outKeeperType = InvSchemeHelper.getDefaultOutKeeperType(invScheme);
            outInvTtatus = InvSchemeHelper.getDefaultOutInvStatus(invScheme);
            outInvType = InvSchemeHelper.getDefaltOutInvtype(invScheme);
            outInvStatusId = outInvTtatus == null ? null : outInvTtatus.getPkValue();
            outInvTypeId = outInvType == null ? null : outInvType.getPkValue();
        }
        for (int i = 0; i < rows.length; ++i) {
            int rowIndex = rows[i];
            if (!initialized) {
                bill.beginInit();
            }
            bill.setValue("ownertype", (Object)ownerType, rowIndex);
            bill.setValue("keepertype", (Object)keeperType, rowIndex);
            bill.setValue("outownertype", (Object)outOwnerType, rowIndex);
            bill.setValue("outkeepertype", (Object)outKeeperType, rowIndex);
            bill.setValue("invstatus", invStatusId, rowIndex);
            bill.setValue("invtype", invTypeId, rowIndex);
            bill.setValue("outinvstatus", outInvStatusId, rowIndex);
            bill.setValue("outinvtype", outInvTypeId, rowIndex);
            if (initialized) continue;
            bill.endInit();
            view.updateView("owner", rowIndex);
            view.updateView("keeper", rowIndex);
            view.updateView("ownertype", rowIndex);
            view.updateView("keepertype", rowIndex);
            view.updateView("invstatus", rowIndex);
            view.updateView("invtype", rowIndex);
            view.updateView("outowner", rowIndex);
            view.updateView("outkeeper", rowIndex);
            view.updateView("outownertype", rowIndex);
            view.updateView("outkeepertype", rowIndex);
            view.updateView("outinvstatus", rowIndex);
            view.updateView("outinvtype", rowIndex);
        }
    }

    public static void setDefalutOwnerAndKeeeper(InvSchemeService service, IFormView view, int i) {
        IDataModel model = view.getModel();
        boolean initialized = model.isInitialized();
        if (service == null) {
            service = InvSchemeServiceFactory.getService(view);
        }
        if (service != null) {
            if (!initialized) {
                model.beginInit();
            }
            String outKeeperType = (String)model.getValue("outkeepertype", i);
            Object defalutOutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
                defalutOutKeeperId = service.getDefalutOutKeeper(outKeeperType, i);
            }
            model.setValue("outkeeper", defalutOutKeeperId, i);
            String outOwnerType = (String)model.getValue("outownertype", i);
            Object defalutOutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
                defalutOutOwnerId = service.getDefalutOutOwner(outOwnerType, i);
            }
            model.setValue("outowner", defalutOutOwnerId, i);
            String keeperType = (String)model.getValue("keepertype", i);
            Object defalutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)keeperType)) {
                defalutKeeperId = service.getDefalutKeeper(keeperType, i);
            }
            model.setValue("keeper", defalutKeeperId, i);
            String ownerType = (String)model.getValue("ownertype", i);
            Object defalutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)ownerType)) {
                defalutOwnerId = service.getDefalutOwner(ownerType, i);
            }
            model.setValue("owner", defalutOwnerId, i);
            if (!initialized) {
                model.endInit();
                view.updateView("outkeeper", i);
                view.updateView("outowner", i);
                view.updateView("keeper", i);
                view.updateView("owner", i);
            }
        }
    }

    public static void setDefaultOutOwnerAndKeeper(InvSchemeService service, IFormView view, int i) {
        IDataModel model = view.getModel();
        if (service != null) {
            String outKeeperType = (String)model.getValue("outkeepertype", i);
            Object defalutOutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
                defalutOutKeeperId = service.getDefalutOutKeeper(outKeeperType, i);
            }
            model.setValue("outkeeper", defalutOutKeeperId, i);
            String outOwnerType = (String)model.getValue("outownertype", i);
            Object defalutOutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
                defalutOutOwnerId = service.getDefalutOutOwner(outOwnerType, i);
            }
            model.setValue("outowner", defalutOutOwnerId, i);
        }
    }

    public static void setDefaultInOwnerAndKeeper(InvSchemeService service, IFormView view, int i) {
        IDataModel model = view.getModel();
        if (service != null) {
            String keeperType = (String)model.getValue("keepertype", i);
            Object defalutKeeperId = null;
            if (!StringUtils.isEmpty((CharSequence)keeperType)) {
                defalutKeeperId = service.getDefalutKeeper(keeperType, i);
            }
            model.setValue("keeper", defalutKeeperId, i);
            String ownerType = (String)model.getValue("ownertype", i);
            Object defalutOwnerId = null;
            if (!StringUtils.isEmpty((CharSequence)ownerType)) {
                defalutOwnerId = service.getDefalutOwner(ownerType, i);
            }
            model.setValue("owner", defalutOwnerId, i);
        }
    }

    public static void setViewByUpdate(IFormView view, boolean isInUpdate, boolean isOutUpdate) {
        InvSchemeHelper.setVisiableByUpdate(view, isInUpdate, isOutUpdate);
        InvSchemeHelper.setMustInputByUpdate(view, isInUpdate, isOutUpdate);
    }

    private static void setVisiableByUpdate(IFormView view, boolean isInUpdate, boolean isOutUpdate) {
        view.setVisible(Boolean.valueOf(isInUpdate), new String[]{"owner", "keeper", "ownertype", "keepertype", "invstatus", "invtype"});
        view.setVisible(Boolean.valueOf(isOutUpdate), new String[]{"outowner", "outkeeper", "outownertype", "outkeepertype", "outinvstatus", "outinvtype"});
    }

    private static void setMustInputByUpdate(IFormView view, boolean isInUpdate, boolean isOutUpdate) {
        InvSchemeHelper.setControlMustInput(view, isInUpdate, inCheckFields);
        InvSchemeHelper.setControlMustInput(view, isOutUpdate, outCheckFields);
    }

    private static void setControlMustInput(IFormView view, boolean isMustInput, String ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            FieldEdit control = (FieldEdit)view.getControl(keys[i]);
            if (control == null) continue;
            control.setMustInput(isMustInput);
        }
    }

    public static void setEntrySchemeEnable(InvSchemeService service, IFormView view, int i) {
        if (service == null) {
            service = InvSchemeServiceFactory.getService(view);
        }
        if (service != null) {
            service.setOutOwnerEnable(i);
            service.setOutKeeperEnable(i);
            service.setOwnerEnable(i);
            service.setKeeperEnable(i);
        }
    }

    public static void setEntrySchemeOutEnable(InvSchemeService service, int i) {
        if (service != null) {
            service.setOutOwnerEnable(i);
            service.setOutKeeperEnable(i);
        }
    }

    public static void setEntrySchemeInEnable(InvSchemeService service, int i) {
        if (service != null) {
            service.setOwnerEnable(i);
            service.setKeeperEnable(i);
        }
    }

    public static void setEntrySchemeEnable(InvSchemeService service, String entityTypeId, RowDataEntity row) {
        if (service == null) {
            service = InvSchemeServiceFactory.getService(entityTypeId);
        }
        if (service != null) {
            service.setOutOwnerEnable(row);
            service.setOutKeeperEnable(row);
            service.setOwnerEnable(row);
            service.setKeeperEnable(row);
        }
    }

    public static void setSpecialEnable(IFormView view, DynamicObject invScheme) {
        if (invScheme == null) {
            return;
        }
        String formId = view.getModel().getDataEntityType().getName();
        Long invschemeId = (Long)invScheme.getPkValue();
        if (InvschemeConsts.INVSCHEM_ENTRUST_SALEOUT.equals(invschemeId) || InvschemeConsts.INVSCHEM_ENTRUST_SALEOUT_BACK.equals(invschemeId)) {
            view.setEnable(Boolean.FALSE, ENTRUSTSALE_BUTTON);
            view.setEnable(Boolean.FALSE, new String[]{"invscheme"});
            view.setEnable(Boolean.FALSE, new String[]{"istax"});
        } else if (InvschemeConsts.INVSCHEM_DIRECTTRAN_PUR_IN.equals(invschemeId) || InvschemeConsts.INVSCHEM_DIRECTTRAN_SALE_OUT.equals(invschemeId)) {
            view.setEnable(Boolean.FALSE, DIRECTTRAN_BUTTON);
        } else if ("im_saloutbill".equals(formId)) {
            view.setEnable(Boolean.TRUE, ENTRUSTSALE_BUTTON);
            view.setEnable(Boolean.TRUE, ENTRUSTSALE_PANEL);
        }
    }
}

