/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public class InvaccDataSetHelper {
    private static final String algoKey = InvaccDataSetHelper.class.getName();
    private static final String selectInvaccFields = "warehouse,lotnum,location,auxpty,producedate,expirydate,unit,id,warehouse.name as warehousename,location.name as locationname,material.name,qty,qty2nd,baseqty,project,lockqty,lockbaseqty,lockqty2nd,invtype,invstatus,ownertype,owner,keepertype,keeper";
    private static final String selectGroupByInvaccFields = "org,material,id,qty,qty2nd,baseqty,lockqty,lockbaseqty,lockqty2nd";

    public static DataSet getInvAccDataSet(List<QFilter> qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        selectorSet.add("material.name");
        selectorSet.add("id");
        selectorSet.remove("keycol");
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)InvAccConst.getBalTb(), (String)String.join((CharSequence)",", selectorSet), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"");
        DataSet avbbaseqtyDs = ReserveHelper.getAvbbaseqty((DataSet)ds);
        return avbbaseqtyDs;
    }

    public static DataSet queryInvAccs(QFilter customFilter) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (customFilter != null) {
            filter.and(customFilter);
        }
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)InvAccConst.getBalTb(), (String)selectGroupByInvaccFields, (QFilter[])filter.toArray(), null);
        DataSet avbbaseqtyDs = ReserveHelper.getAvbbaseqty((DataSet)queryDataSet);
        DataSet groupByDS = avbbaseqtyDs.groupBy(new String[]{"org", "material"}).sum("avbbaseqty").finish();
        return groupByDS;
    }
}

