/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ImBillFieldSettingHelper;
import kd.scmc.im.consts.InvSchemeConst;
import org.apache.commons.lang3.StringUtils;

public class InverseBillHelper {
    private static final Log log = LogFactory.getLog(InverseBillHelper.class);

    public static void setNegativeColumnColor(IFormView view, String[] redColumns) {
        IDataModel model = view.getModel();
        if (InverseBillHelper.isNegativeBill(model)) {
            InverseBillHelper.setRedColumn(view, redColumns);
        } else {
            InverseBillHelper.cancelRedColumn(view, redColumns);
        }
    }

    public static void setInverseValues(IDataModel model, String[] needInverseColumns) {
        DynamicObjectCollection entrys = model.getEntryEntity("billentry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            for (String column : needInverseColumns) {
                BigDecimal value = ((DynamicObject)entrys.get(i)).getBigDecimal(column);
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                DataChangeHelper.setValue(model, column, value.abs(), i, false);
            }
        }
        model.setDataChanged(false);
    }

    public static boolean isNegativeBill(IDataModel model) {
        try {
            DynamicObject invscheme = (DynamicObject)model.getValue("invscheme");
            boolean caBill = model.getDataEntity().getBoolean("ischargeoff");
            boolean negativeBill = InverseBillHelper.isNegativeBill(invscheme);
            if (caBill) {
                return !negativeBill;
            }
            return negativeBill;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return false;
        }
    }

    public static boolean isNegativeBill(DynamicObject invscheme) {
        if (invscheme == null) {
            return false;
        }
        boolean isNegativeBill = false;
        DynamicObject transceiverType = (invscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invscheme.getPkValue(), (String)"im_invscheme", (String)InvSchemeConst.getAllSelector())).getDynamicObject("transceivertype");
        if (transceiverType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u4e8b\u52a1\u672a\u914d\u7f6e\u6536\u53d1\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InverseBillHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        String bizdirection = transceiverType.getString("bizdirection");
        if (StringUtils.isEmpty((CharSequence)bizdirection)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u4e8b\u52a1\u7684\u65f6\u6536\u53d1\u7c7b\u578b\u672a\u914d\u7f6e\u4e1a\u52a1\u65b9\u5411\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InverseBillHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if ("1".equals(bizdirection)) {
            isNegativeBill = true;
        }
        return isNegativeBill;
    }

    public static void setRedColumn(IFormView view, String[] redColumns) {
        String redColor = "#ff0000";
        InverseBillHelper.setColumsColor(redColor, view, redColumns);
    }

    public static void cancelRedColumn(IFormView view, String[] redColumns) {
        String redColor = "#000000";
        InverseBillHelper.setColumsColor(redColor, view, redColumns);
    }

    public static void setColumsColor(String redColor, IFormView view, String[] redColumns) {
        EntryGrid grid = (EntryGrid)view.getControl("billentry");
        for (String redColumn : redColumns) {
            grid.setColumnProperty(redColumn, "fc", (Object)redColor);
        }
    }

    public static String[] getNeedInverseColumns(String billEntity) {
        Map<String, Map<String, Object>> settingMap = ImBillFieldSettingHelper.getSetting(billEntity, "id,bill,entry.field,entry.isinverse");
        HashSet<String> needInverseColumnSet = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> fieldSetting : settingMap.entrySet()) {
            Map<String, Object> setting = fieldSetting.getValue();
            Boolean isinverse = (Boolean)setting.get("isinverse");
            if (isinverse == null || !isinverse.booleanValue()) continue;
            needInverseColumnSet.add(fieldSetting.getKey());
        }
        String[] needInverseColumns = needInverseColumnSet.toArray(new String[0]);
        return needInverseColumns;
    }
}

