/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.consts.BigDecimalConstants;

public class InvoiceBizHelper {
    private static final Long DEFAULT_INVOICE_BIZ = 1533341968170710016L;
    private static final Long PROFORMA_INVOICE_BIZ = 1571047306646894592L;

    public static void invoiceBizSelect(IFormView view, ListShowParameter showParameter) {
        AppInfo appInfo;
        String appId = view.getFormShowParameter().getAppId();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (appId != null && (appInfo = AppMetadataCache.getAppInfo((String)appId)) != null) {
            String bizCloudNumber = appInfo.getCloudNum();
            qFilter.and("mulbiz.fbasedataid.number", "=", (Object)bizCloudNumber);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static void handleInvoiceBizNull(DynamicObject bill, String appId) {
        DynamicObject invoiceBiz = bill.getDynamicObject("invoicebiztype");
        if (invoiceBiz == null) {
            DynamicObject defInvoice = BusinessDataServiceHelper.loadSingle((String)"bd_invoicebiztype", (QFilter[])new QFilter("id", "=", (Object)DEFAULT_INVOICE_BIZ).toArray());
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (supplier != null) {
                DynamicObject invoiceType = (DynamicObject)supplier.get("invoicecategory");
                if (invoiceType != null) {
                    Long invoiceTypeId = invoiceType.getLong("id");
                    DynamicObject newInvoiceBiz = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"CommonHelperService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, appId});
                    if (newInvoiceBiz != null) {
                        bill.set("invoicebiztype", (Object)newInvoiceBiz);
                    } else {
                        bill.set("invoicebiztype", (Object)defInvoice);
                    }
                } else {
                    bill.set("invoicebiztype", (Object)defInvoice);
                }
            } else {
                bill.set("invoicebiztype", (Object)defInvoice);
            }
        }
    }

    public static void invoiceBizChange(IDataModel model, DynamicObject invoiceBiz) {
        boolean purInBillType = InvoiceBizHelper.isPurInBillType(model.getDataEntity());
        if (purInBillType) {
            int rowCount = model.getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                if (invoiceBiz != null) {
                    Long invoiceBizId = invoiceBiz.getLong("id");
                    Object taxPayerType = model.getValue("taxpayertype", i);
                    if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
                        Object taxRate = model.getValue("taxrate", i);
                        model.setValue("deductiblerate", taxRate, i);
                        continue;
                    }
                    model.setValue("deductiblerate", (Object)BigDecimal.ZERO, i);
                    continue;
                }
                model.setValue("deductiblerate", (Object)BigDecimal.ZERO, i);
            }
        }
    }

    public static void taxPayerChange(IDataModel model, int rowIndex) {
        DynamicObject bill = model.getDataEntity();
        boolean purInBillType = InvoiceBizHelper.isPurInBillType(bill);
        if (purInBillType) {
            DynamicObject invoiceBiz = bill.getDynamicObject("invoicebiztype");
            if (invoiceBiz != null) {
                Long invoiceBizId = invoiceBiz.getLong("id");
                Object taxPayerType = model.getValue("taxpayertype", rowIndex);
                if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
                    Object taxRate = model.getValue("taxrate", rowIndex);
                    model.setValue("deductiblerate", taxRate, rowIndex);
                } else {
                    model.setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
                }
            } else {
                model.setValue("deductiblerate", (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    public static void handleDeductibleRateBotp(DynamicObject bill) {
        DynamicObject invoiceBiz;
        boolean purInBillType = InvoiceBizHelper.isPurInBillType(bill);
        if (purInBillType && (invoiceBiz = bill.getDynamicObject("invoicebiztype")) != null) {
            Long invoiceBizId = invoiceBiz.getLong("id");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Object taxPayerType = entry.get("taxpayertype");
                if ("1".equals(taxPayerType) && (DEFAULT_INVOICE_BIZ.equals(invoiceBizId) || PROFORMA_INVOICE_BIZ.equals(invoiceBizId))) {
                    Object taxRate = entry.get("taxrate");
                    entry.set("deductiblerate", taxRate);
                    continue;
                }
                entry.set("deductiblerate", (Object)BigDecimal.ZERO);
            }
        }
    }

    public static void handleAlgorithmSubmit(DynamicObject bill) {
        int curAmountPrecision = InvoiceBizHelper.getAmountPrecision(bill, "currency");
        int settleAmountPrecision = InvoiceBizHelper.getAmountPrecision(bill, "settlecurrency");
        InvoiceBizHelper.handleDeductibleRateBotp(bill);
        boolean purInBillType = InvoiceBizHelper.isPurInBillType(bill);
        if (!purInBillType) {
            return;
        }
        boolean isTax = bill.getBoolean("istax");
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        if (null == exchangeRate) {
            exchangeRate = BigDecimal.ONE;
        }
        String quotation = bill.getString("quotation");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            BigDecimal deductibleAmt;
            BigDecimal amount = entry.getBigDecimal("amount");
            BigDecimal deductibleRate = entry.getBigDecimal("deductiblerate");
            deductibleRate = deductibleRate.divide(BigDecimalConstants.ONEHUNDRED, deductibleRate.scale() + 2, 4);
            BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
            BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
            if (isTax) {
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                deductibleAmt = amountAndTax.multiply(deductibleRate).divide(taxRate.add(BigDecimalConstants.ONE), settleAmountPrecision, 4);
            } else {
                deductibleAmt = amount.multiply(deductibleRate).setScale(settleAmountPrecision, 4);
            }
            if ("0".equals(quotation)) {
                deductibleAmt = deductibleAmt.multiply(exchangeRate).setScale(curAmountPrecision, RoundingMode.HALF_UP);
            } else if ("1".equals(quotation) && BigDecimal.ZERO.compareTo(exchangeRate) != 0) {
                deductibleAmt = deductibleAmt.divide(exchangeRate, curAmountPrecision, RoundingMode.HALF_UP);
            }
            entry.set("curdeductibleamt", (Object)deductibleAmt);
            BigDecimal interCostAmt = curAmountAndTax.subtract(deductibleAmt).setScale(curAmountPrecision, 4);
            Object taxPayerType = entry.get("taxpayertype");
            if (StringUtils.isBlank((Object)taxPayerType)) {
                interCostAmt = BigDecimal.ZERO;
            }
            entry.set("intercostamt", (Object)interCostAmt);
        }
    }

    private static int getAmountPrecision(DynamicObject bill, String currencyField) {
        int amountPrecision = 2;
        DynamicObject currency = bill.getDynamicObject(currencyField);
        if (currency != null) {
            amountPrecision = currency.getInt("amtprecision");
        }
        return amountPrecision;
    }

    public static boolean isPurInBillType(DynamicObject bill) {
        String entityName = bill.getDynamicObjectType().getName();
        if ("im_purinbill".equals(entityName) || "im_ospurinbill".equals(entityName) || "im_mdc_ominbill".equals(entityName)) {
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) {
                return false;
            }
            String billTypeNum = billType.getString("number");
            if (!"im_PurInBill_FARM_BT_S".equals(billTypeNum)) {
                return true;
            }
        }
        return false;
    }
}

