/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;

public class KitManagementHelper {
    private static final String SM_DELIVERNOTICE = "sm_delivernotice";
    private static final String SM_RETURNAPPLY = "sm_returnapply";

    public static void setPriceAmtEnable(IFormView view, int rowIndex) {
        boolean result;
        IDataModel model = view.getModel();
        Object productType = model.getValue("kitproducttype", rowIndex);
        boolean bl = result = "kitparent".equals(productType) || "kitchild".equals(productType);
        if (result) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"price", "priceandtax", "actualprice", "actualtaxprice", "taxrateid", "taxamount", "amount", "amountandtax"});
        }
    }

    public static void reCalKitChildQty(IFormView view, int rowIndex, String propName) {
        IDataModel model = view.getModel();
        if (!"qty".equals(propName)) {
            return;
        }
        DynamicObject entryRowEntity = model.getEntryRowEntity("billentry", rowIndex);
        String productType = entryRowEntity.getString("kitproducttype");
        String kitTransferModel = entryRowEntity.getString("kittransfermodel");
        if ("kit".equals(kitTransferModel) && "kitparent".equals(productType)) {
            String mainBillEntity = entryRowEntity.getString("mainbillentity");
            long mainBillId = entryRowEntity.getLong("mainbillid");
            long mainBillEntryId = entryRowEntity.getLong("mainbillentryid");
            BigDecimal baseQty = entryRowEntity.getBigDecimal("baseqty");
            ArrayList parameters = new ArrayList();
            HashMap<String, Object> parameter = new HashMap<String, Object>(16);
            parameter.put("billEntity", mainBillEntity);
            parameter.put("billId", mainBillId);
            parameter.put("billEntryId", mainBillEntryId);
            parameter.put("baseQty", baseQty);
            parameters.add(parameter);
            String expandKitStructures = (String)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService", (String)"expandKitStructure", (Object[])new Object[]{parameters});
            Map result = (Map)JSON.parseObject((String)expandKitStructures, Map.class);
            if (result == null || result.isEmpty()) {
                return;
            }
            Map kitQtyPriceMap = (Map)result.get(mainBillEntryId);
            Object status = kitQtyPriceMap.get("status");
            if ("FAIL".equals(status)) {
                return;
            }
            Map childEntryQtyMap = (Map)kitQtyPriceMap.get("child");
            if (childEntryQtyMap == null || childEntryQtyMap.isEmpty()) {
                return;
            }
            Long pid = entryRowEntity.getLong("kitpid");
            DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("billentry");
            ArrayList<Long> childRowMainEntryIds = new ArrayList<Long>(16);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String kitProductType = entry.getString("kitproducttype");
                String transferModel = entry.getString("kittransfermodel");
                Long childPid = entry.getLong("kitpid");
                if (!"kitchild".equals(kitProductType) || !"kit".equals(transferModel) || !pid.equals(childPid)) continue;
                long childRowMainEntryId = entry.getLong("mainbillentryid");
                if (childRowMainEntryIds.contains(childRowMainEntryId)) {
                    model.setValue("qty", (Object)BigDecimal.ZERO, i);
                    continue;
                }
                Map childQtyMap = (Map)childEntryQtyMap.get(String.valueOf(childRowMainEntryId));
                BigDecimal calChildBaseQty = (BigDecimal)childQtyMap.get("baseQty");
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                DynamicObject unit = entry.getDynamicObject("unit");
                BigDecimal qty = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, calChildBaseQty, unit);
                model.setValue("qty", (Object)qty, i);
                childRowMainEntryIds.add(childRowMainEntryId);
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u6210\u5957\u53d1\u8d27\u65f6\uff0c\u4fee\u6539\u7236\u9879\u6570\u91cf\u5c06\u8054\u52a8\u6240\u6709\u5b50\u9879\u6570\u91cf\u3002", (String)"KitManagementHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    public static void deleteKitRow(IFormPlugin plugin, IFormView view, BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        IDataModel model = view.getModel();
        ArrayList<Integer> selectParentRows = new ArrayList<Integer>(16);
        ArrayList<Integer> selectChildRows = new ArrayList<Integer>(16);
        ArrayList<Integer> selectStandardRows = new ArrayList<Integer>(16);
        ArrayList<Long> pidList = new ArrayList<Long>(16);
        for (int rowIndex : rowIndexs = e.getRowIndexs()) {
            Object productType = model.getValue("kitproducttype", rowIndex);
            if ("kitparent".equals(productType)) {
                selectParentRows.add(rowIndex);
                Long pid = (Long)model.getValue("kitpid", rowIndex);
                pidList.add(pid);
                continue;
            }
            if ("kitchild".equals(productType)) {
                selectChildRows.add(rowIndex);
                continue;
            }
            if (!"standard".equals(productType)) continue;
            selectStandardRows.add(rowIndex);
        }
        if (selectChildRows.isEmpty() && selectParentRows.isEmpty()) {
            return;
        }
        e.setCancel(true);
        ArrayList<Integer> pidChildRows = new ArrayList<Integer>(16);
        HashMap<Long, List<Integer>> kitKidRowMap = new HashMap<Long, List<Integer>>(16);
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            long pid = entry.getLong("kitpid");
            String productType = entry.getString("kitproducttype");
            String kitTransferModel = entry.getString("kittransfermodel");
            if ("kitchild".equals(productType) && pidList.contains(pid)) {
                pidChildRows.add(i);
            }
            if (!"kitchild".equals(productType) || !"kit".equals(kitTransferModel)) continue;
            long mainBillEntryId = entry.getLong("mainbillentryid");
            kitKidRowMap.putIfAbsent(mainBillEntryId, new ArrayList(16));
            ((List)kitKidRowMap.get(mainBillEntryId)).add(i);
        }
        selectChildRows.removeAll(pidChildRows);
        if (!selectChildRows.isEmpty()) {
            KitManagementHelper.delSelectChildRows(plugin, view, selectChildRows, selectStandardRows, kitKidRowMap);
        } else {
            ArrayList<Integer> deleteRows = new ArrayList<Integer>(selectParentRows);
            deleteRows.addAll(pidChildRows);
            deleteRows.addAll(selectStandardRows);
            String delKitParentMsg = ResManager.loadKDString((String)"\u5220\u9664\u7236\u9879\u7269\u6599\u540c\u65f6\u5c06\u5220\u9664\u6240\u6709\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u5220\u9664\uff1f", (String)"KitManagementHelper_1", (String)"scmc-im-business", (Object[])new Object[0]);
            KitManagementHelper.showDelConfirm(plugin, view, deleteRows, delKitParentMsg);
        }
    }

    private static void delSelectChildRows(IFormPlugin plugin, IFormView view, List<Integer> selectChildRows, List<Integer> selectStandardRows, Map<Long, List<Integer>> kitKidRowMap) {
        IDataModel model = view.getModel();
        ArrayList<Integer> kitSelectChildRows = new ArrayList<Integer>(16);
        ArrayList<Integer> noKitSelectChildRows = new ArrayList<Integer>(16);
        for (Integer n : selectChildRows) {
            Object object = model.getValue("kittransfermodel", n.intValue());
            if ("kit".equals(object)) {
                kitSelectChildRows.add(n);
                continue;
            }
            if (!"nonkit".equals(object)) continue;
            noKitSelectChildRows.add(n);
        }
        if (!kitSelectChildRows.isEmpty()) {
            ArrayList<Integer> delForBidChildRows = new ArrayList<Integer>(16);
            for (Map.Entry<Long, List<Integer>> entry : kitKidRowMap.entrySet()) {
                List<Integer> kitKidRowList = entry.getValue();
                ArrayList<Integer> origKitKidRows = new ArrayList<Integer>(kitKidRowList);
                kitKidRowList.removeAll(kitSelectChildRows);
                if (!kitKidRowList.isEmpty()) continue;
                delForBidChildRows.addAll(origKitKidRows);
            }
            List<Integer> list = KitManagementHelper.getInspectRows(delForBidChildRows, model);
            delForBidChildRows.removeAll(list);
            if (!delForBidChildRows.isEmpty()) {
                String string = ResManager.loadKDString((String)"\u6210\u5957\u53d1\u8d27\u7684\u5957\u4ef6\u5b50\u9879\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\uff0c\u8bf7\u76f4\u63a5\u5220\u9664\u7236\u9879\u3002", (String)"KitManagementHelper_2", (String)"scmc-im-business", (Object[])new Object[0]);
                view.showTipNotification(string);
                return;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(kitSelectChildRows);
            arrayList.addAll(selectStandardRows);
            arrayList.addAll(noKitSelectChildRows);
            String delKitKidMsg = ResManager.loadKDString((String)"\u5c06\u8981\u5220\u9664\u5957\u4ef6\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"KitManagementHelper_3", (String)"scmc-im-business", (Object[])new Object[0]);
            KitManagementHelper.showDelConfirm(plugin, view, arrayList, delKitKidMsg);
            return;
        }
        if (!noKitSelectChildRows.isEmpty()) {
            ArrayList<Integer> deleteRows = new ArrayList<Integer>(noKitSelectChildRows);
            deleteRows.addAll(selectStandardRows);
            String string = ResManager.loadKDString((String)"\u5c06\u8981\u5220\u9664\u5957\u4ef6\u5b50\u9879\u7269\u6599\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"KitManagementHelper_3", (String)"scmc-im-business", (Object[])new Object[0]);
            KitManagementHelper.showDelConfirm(plugin, view, deleteRows, string);
        }
    }

    private static void showDelConfirm(IFormPlugin plugin, IFormView view, List<Integer> deleteRows, String tipMsg) {
        HashMap<String, List<Integer>> confirmInfo = new HashMap<String, List<Integer>>(2);
        confirmInfo.put("deleteRows", deleteRows);
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("deleteKitRow", plugin);
        view.showConfirm(tipMsg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
    }

    public static void confirmCallBack(MessageBoxClosedEvent e, IPageCache pageCache, IFormView view) {
        IDataModel model = view.getModel();
        String callBackId = e.getCallBackId();
        String customValue = e.getCustomVaule();
        MessageBoxResult result = e.getResult();
        if (callBackId == null || customValue == null) {
            return;
        }
        if ("deleteKitRow".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
            List deleteRows = (List)confirmInfo.get("deleteRows");
            pageCache.put("completeDeleteKitRows", "false");
            int[] deleteRowArr = Arrays.stream(deleteRows.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
            model.deleteEntryRows("billentry", deleteRowArr);
            pageCache.put("completeDeleteKitRows", "true");
        }
    }

    public static Map<Long, Map<String, BigDecimal>> calMaxBaseQty(Map<Long, Map<String, Object>> kitResult, List<Long> bluePids, List<Long> redPids) {
        HashMap<Long, Map<String, BigDecimal>> maxBaseQtyMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        KitManagementHelper.filterKitResult(kitResult);
        Set<Long> pidSet = kitResult.keySet();
        if (pidSet.isEmpty()) {
            return new HashMap<Long, Map<String, BigDecimal>>(1);
        }
        QFilter baseQtyFilter = new QFilter("billstatus", "=", (Object)"C").and("billentry.kitpid", "in", pidSet).and("billentry.mainbillentryid", "not in", pidSet);
        DataSet baseQtyDataSet = QueryServiceHelper.queryDataSet((String)KitManagementHelper.class.getName(), (String)"im_saloutbill", (String)"billentry.mainbillentryid, billentry.kitpid, billentry.baseqty, billentry.unverifybaseqty", (QFilter[])baseQtyFilter.toArray(), null);
        DataSet baseQtySum = baseQtyDataSet.groupBy(new String[]{"billentry.mainbillentryid", "billentry.kitpid"}).sum("billentry.baseqty").sum("billentry.unverifybaseqty").finish();
        QFilter baseUnitFilter = new QFilter("billstatus", "=", (Object)"C").and("billentry.kitpid", "in", pidSet).and("billentry.mainbillentryid", "in", pidSet);
        DataSet baseUnitDataSet = QueryServiceHelper.queryDataSet((String)KitManagementHelper.class.getName(), (String)"im_saloutbill", (String)"billentry.kitpid, billentry.baseunit.precision, billentry.baseunit.precisionAccount", (QFilter[])baseUnitFilter.toArray(), null).groupBy(new String[]{"billentry.kitpid", "billentry.baseunit.precision"}).finish();
        DataSet joinDataSet = baseUnitDataSet.leftJoin(baseQtySum).on("billentry.kitpid", "billentry.kitpid").select(new String[]{"billentry.mainbillentryid", "billentry.kitpid", "billentry.baseqty", "billentry.unverifybaseqty", "billentry.baseunit.precision"}).finish();
        HashMap mainBillEntryIdMap = new HashMap(16);
        for (Row row : joinDataSet) {
            BigDecimal maxUnVerifyBaseQty;
            BigDecimal calUnVerifyBaseQty;
            BigDecimal maxOutBaseQty;
            BigDecimal calParentBaseQty;
            Map childEntryQtyMap;
            Object status;
            String srcMainBillEntryId = row.getString("billentry.mainbillentryid");
            if (srcMainBillEntryId == null) continue;
            Long srcEntryPid = row.getLong("billentry.kitpid");
            BigDecimal childBaseQty = row.getBigDecimal("billentry.baseqty");
            BigDecimal unVerifyBaseQty = row.getBigDecimal("billentry.unverifybaseqty");
            Map<String, Object> kitQtyPriceMap = kitResult.get(srcEntryPid);
            if (kitQtyPriceMap == null || "FAIL".equals(status = kitQtyPriceMap.get("status")) || (childEntryQtyMap = (Map)kitQtyPriceMap.get("child")) == null || childEntryQtyMap.isEmpty()) continue;
            Map childQtyMap = (Map)childEntryQtyMap.get(srcMainBillEntryId);
            BigDecimal childKitQty = (BigDecimal)childQtyMap.get("kitQty");
            BigDecimal parentKitQty = (BigDecimal)childQtyMap.get("parentQty");
            int precision = row.getInteger("billentry.baseunit.precision");
            maxBaseQtyMap.putIfAbsent(srcEntryPid, new HashMap(4));
            Map entryMaxBaseQtyMap = (Map)maxBaseQtyMap.get(srcEntryPid);
            if (bluePids.contains(srcEntryPid)) {
                calParentBaseQty = childBaseQty.multiply(parentKitQty).divide(childKitQty, precision, 1);
                maxOutBaseQty = (BigDecimal)entryMaxBaseQtyMap.get("maxOutBaseQty");
                calUnVerifyBaseQty = unVerifyBaseQty.multiply(parentKitQty).divide(childKitQty, precision, 1);
                maxUnVerifyBaseQty = (BigDecimal)entryMaxBaseQtyMap.get("maxUnVerifyBaseQty");
                if (maxOutBaseQty == null || calParentBaseQty.compareTo(maxOutBaseQty) < 0) {
                    entryMaxBaseQtyMap.put("maxOutBaseQty", calParentBaseQty);
                }
                if (maxUnVerifyBaseQty == null || calUnVerifyBaseQty.compareTo(maxUnVerifyBaseQty) < 0) {
                    entryMaxBaseQtyMap.put("maxUnVerifyBaseQty", calUnVerifyBaseQty);
                }
            } else if (redPids.contains(srcEntryPid)) {
                calParentBaseQty = childBaseQty.multiply(parentKitQty).divide(childKitQty, precision, 0);
                maxOutBaseQty = (BigDecimal)entryMaxBaseQtyMap.get("maxOutBaseQty");
                calUnVerifyBaseQty = unVerifyBaseQty.multiply(parentKitQty).divide(childKitQty, precision, 0);
                maxUnVerifyBaseQty = (BigDecimal)entryMaxBaseQtyMap.get("maxUnVerifyBaseQty");
                if (maxOutBaseQty == null || calParentBaseQty.compareTo(maxOutBaseQty) > 0) {
                    entryMaxBaseQtyMap.put("maxOutBaseQty", calParentBaseQty);
                }
                if (maxUnVerifyBaseQty == null || calUnVerifyBaseQty.compareTo(maxUnVerifyBaseQty) > 0) {
                    entryMaxBaseQtyMap.put("maxUnVerifyBaseQty", calUnVerifyBaseQty);
                }
            }
            Set childEntryIds = childEntryQtyMap.keySet();
            mainBillEntryIdMap.putIfAbsent(srcEntryPid, childEntryIds);
            ((Set)mainBillEntryIdMap.get(srcEntryPid)).remove(srcMainBillEntryId);
        }
        for (Long pid : pidSet) {
            Set childEntryIds = (Set)mainBillEntryIdMap.get(pid);
            if (childEntryIds != null && childEntryIds.isEmpty()) continue;
            maxBaseQtyMap.putIfAbsent(pid, new HashMap(2));
            Map entryMaxBaseQtyMap = (Map)maxBaseQtyMap.get(pid);
            entryMaxBaseQtyMap.put("maxOutBaseQty", BigDecimal.ZERO);
            entryMaxBaseQtyMap.put("maxUnVerifyBaseQty", BigDecimal.ZERO);
        }
        return maxBaseQtyMap;
    }

    private static List<Integer> getInspectRows(List<Integer> delForBidChildRows, IDataModel model) {
        ArrayList<Integer> inspectRows = new ArrayList<Integer>(16);
        HashMap kitChildMainEntryIdMap = new HashMap(16);
        HashMap<String, List<Long>> inspectSrcBillMap = new HashMap<String, List<Long>>(16);
        for (Integer delForBidChildRow : delForBidChildRows) {
            DynamicObject entryRowEntity = model.getEntryRowEntity("billentry", delForBidChildRow.intValue());
            long mainBillEntryId = entryRowEntity.getLong("mainbillentryid");
            kitChildMainEntryIdMap.putIfAbsent(mainBillEntryId, new ArrayList(16));
            ((List)kitChildMainEntryIdMap.get(mainBillEntryId)).add(delForBidChildRow);
            String srcBillEntity = entryRowEntity.getString("srcbillentity");
            long srcBillId = entryRowEntity.getLong("srcbillid");
            inspectSrcBillMap.putIfAbsent(srcBillEntity, new ArrayList(16));
            ((List)inspectSrcBillMap.get(srcBillEntity)).add(srcBillId);
        }
        Map<String, List<Long>> reCheckInspectBillMap = KitManagementHelper.reCheckInspectBill(inspectSrcBillMap);
        if (!reCheckInspectBillMap.isEmpty()) {
            Set mainEntryIdSet = kitChildMainEntryIdMap.keySet();
            for (Map.Entry<String, List<Long>> inspectSrcEntry : reCheckInspectBillMap.entrySet()) {
                String srcBillEntity = inspectSrcEntry.getKey();
                if (!SM_DELIVERNOTICE.equals(srcBillEntity) && !SM_RETURNAPPLY.equals(srcBillEntity)) continue;
                List<Long> inspectSrcBillIds = inspectSrcEntry.getValue();
                QFilter qFilter = new QFilter("id", "in", inspectSrcBillIds).and("billentry.mainbillentryid", "in", mainEntryIdSet).and("billentry.isinspect", "=", (Object)"1");
                DataSet inspectData = QueryServiceHelper.queryDataSet((String)KitManagementHelper.class.getName(), (String)srcBillEntity, (String)"billentry.mainbillentryid", (QFilter[])qFilter.toArray(), null);
                for (Row inspectDatum : inspectData) {
                    Long inspectMainEntryId = inspectDatum.getLong("billentry.mainbillentryid");
                    inspectRows.addAll((Collection)kitChildMainEntryIdMap.get(inspectMainEntryId));
                }
            }
        }
        return inspectRows;
    }

    public static Map<String, List<Long>> reCheckInspectBill(Map<String, List<Long>> inspectSrcBillMap) {
        TableDefine deliNoticeTable = EntityMetadataCache.loadTableDefine((String)SM_DELIVERNOTICE, (String)SM_DELIVERNOTICE);
        Long deliNoticeTableId = deliNoticeTable.getTableId();
        TableDefine returnApplyTable = EntityMetadataCache.loadTableDefine((String)SM_RETURNAPPLY, (String)SM_RETURNAPPLY);
        Long returnApplyTableId = returnApplyTable.getTableId();
        for (Map.Entry<String, List<Long>> inspectSrcEntry : inspectSrcBillMap.entrySet()) {
            String srcBillEntity = inspectSrcEntry.getKey();
            List<Long> inspectSrcBillIds = inspectSrcEntry.getValue();
            if (SM_DELIVERNOTICE.equals(srcBillEntity) || SM_RETURNAPPLY.equals(srcBillEntity)) continue;
            Map linkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)srcBillEntity, (Long[])inspectSrcBillIds.toArray(new Long[0]), (boolean)false);
            for (Map.Entry linkUpNodeEntry : linkUpNodes.entrySet()) {
                List allSourceNodes = ((BFRowLinkUpNode)linkUpNodeEntry.getValue()).findAllSourceNodes();
                for (BFRowLinkUpNode sourceNode : allSourceNodes) {
                    BFRowId rowId = sourceNode.getRowId();
                    Long mainTableId = rowId.getMainTableId();
                    String entityKey = null;
                    if (deliNoticeTableId.equals(mainTableId)) {
                        entityKey = SM_DELIVERNOTICE;
                    } else if (returnApplyTableId.equals(mainTableId)) {
                        entityKey = SM_RETURNAPPLY;
                    }
                    if (entityKey == null) continue;
                    Long billId = rowId.getBillId();
                    inspectSrcBillMap.putIfAbsent(entityKey, new ArrayList(16));
                    inspectSrcBillMap.get(entityKey).add(billId);
                }
            }
        }
        return inspectSrcBillMap;
    }

    private static void filterKitResult(Map<Long, Map<String, Object>> kitResult) {
        HashMap<Long, Map<String, Object>> newKitResult = new HashMap<Long, Map<String, Object>>(kitResult);
        for (Map.Entry kitResultEntry : newKitResult.entrySet()) {
            Object status = ((Map)kitResultEntry.getValue()).get("status");
            if ("FAIL".equals(status)) {
                kitResult.remove(kitResultEntry.getKey());
                continue;
            }
            Map childEntryQtyMap = (Map)((Map)kitResultEntry.getValue()).get("child");
            if (childEntryQtyMap == null || childEntryQtyMap.isEmpty()) continue;
            HashMap newChildEntryQtyMap = new HashMap(childEntryQtyMap);
            for (Map.Entry childEntryQty : childEntryQtyMap.entrySet()) {
                String childEntryId = (String)childEntryQty.getKey();
                Object storageOut = ((Map)childEntryQty.getValue()).get("storageOut");
                if (!Boolean.FALSE.equals(storageOut)) continue;
                newChildEntryQtyMap.remove(childEntryId);
            }
            if (newChildEntryQtyMap.isEmpty()) {
                kitResult.remove(kitResultEntry.getKey());
                continue;
            }
            kitResult.get(kitResultEntry.getKey()).put("child", newChildEntryQtyMap);
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit, int roundingMode) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, roundingMode);
            }
        }
        return BigDecimal.ZERO;
    }
}

