/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class LotMainFileHelper {
    private static String ID_SUF = "_id";
    private static List<String> headColumns = Arrays.asList("org", "inorg", "outorg", "invscheme", "org" + ID_SUF, "inorg" + ID_SUF, "outorg" + ID_SUF, "invscheme" + ID_SUF);
    private static List<String> entryColumns = Arrays.asList("material", "lotnumber", "lot", "inlotnumber", "inlot", "material" + ID_SUF, "lot" + ID_SUF, "inlot" + ID_SUF);
    private static List<String> subentryColumns = Arrays.asList("material1", "lotnumber1", "lot1", "material1" + ID_SUF, "lot1" + ID_SUF);
    private static List<String> hasSubEntryBilltypes = Arrays.asList("im_adjustbill", "im_assembbill", "im_disassemblebill");

    public static void handleLotMainFileNumber(IFormView view, DynamicObject bill, DynamicObjectCollection entryEntity, String operate, String lotidField, String lotnumber) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"saveLotMainFileByBillOperate", (Object[])new Object[]{operate, bill, entryEntity, lotidField});
        StringBuilder sb = new StringBuilder();
        Set entrySet = result.entrySet();
        String[] paramNodes = lotidField.split("\\.");
        String lotIDKey = paramNodes.length > 1 ? paramNodes[paramNodes.length - 1] : lotidField;
        for (Map.Entry entry : entrySet) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                if (msg.startsWith("ERRORLOTNUMBERCLEAR")) {
                    sb.append(msg.substring("ERRORLOTNUMBERCLEAR".length())).append('\n');
                    view.getModel().setValue(lotnumber, (Object)"", seq - 1);
                    continue;
                }
                sb.append(msg.substring("ERROR".length())).append('\n');
                continue;
            }
            view.getModel().setValue(lotIDKey, (Object)msg, seq - 1);
        }
        view.getModel().endInit();
        view.updateView(entryEntity.getDynamicObjectType().getName());
        if (sb.length() > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u201c\u6279\u53f7\u4e3b\u6863\u201d\u751f\u6210\u5f02\u5e38\u3002", (String)"LotmainfileGenError", (String)"scmc-im-business", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    public static void setLotMainfFileF7Filter(BeforeF7SelectEvent e, DynamicObject bill, DynamicObject selectEntry, String lotidField) {
        ListFilterParameter listFilterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainfFileFilter", (Object[])new Object[]{bill, selectEntry, lotidField});
        if (filter != null) {
            filter = filter.and("lotstatus", "=", (Object)"A");
            listFilterParameter.setFilter(filter);
        }
    }

    public static void changeLot(PropertyChangedArgs e, IDataModel model, IFormView view, String entryName, int rowIndex, String lotidField, String lotnumberField) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object lotValue = changeSet.getNewValue();
        if (lotValue == null) {
            model.setValue(lotnumberField, (Object)"", rowIndex);
            return;
        }
        DynamicObject bill = model.getDataEntity();
        DynamicObject selectEntry = model.getEntryRowEntity(entryName, rowIndex);
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getReturnParamMapping", (Object[])new Object[]{bill, selectEntry, lotidField});
        model.beginInit();
        if (map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                LotMainFileHelper.setParamField(entry, model, lotValue, rowIndex);
            }
        }
        model.endInit();
        view.updateView(entryName, rowIndex);
    }

    private static void setParamField(Map.Entry<String, String> entry, IDataModel model, Object lotValue, int rowIndex) {
        String param = entry.getValue();
        String[] paramNodes = param.split("\\.");
        if (paramNodes.length > 1) {
            model.setValue(paramNodes[paramNodes.length - 1], ((DynamicObject)lotValue).get(entry.getKey()), rowIndex);
        } else {
            model.setValue(entry.getValue(), ((DynamicObject)lotValue).get(entry.getKey()));
        }
    }

    public static boolean isUseLotMainFile() {
        return SystemCallParamHelper.isEnable("sbs_scmcapplevelparam", "INV0003");
    }

    public static int getUnqctrl() {
        Integer unqCtrl = (Integer)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getUnqctrl", (Object[])new Object[0]);
        return unqCtrl;
    }

    public static void showPageLotMainfileList(IFormPlugin form, IFormView view, DynamicObject bill, DynamicObject selectEntry, String lotnumField) {
        if (LotMainFileHelper.isUseLotMainFile()) {
            MainEntityType entityType = (MainEntityType)bill.getDataEntityType();
            String mainOrg = entityType.getMainOrg();
            if (mainOrg == null) {
                return;
            }
            DynamicProperty orgProp = entityType.getProperty(mainOrg);
            if (bill.get(mainOrg) == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u3002", (String)"IM-W-068466", (String)"scmc-im-business", (Object[])new Object[]{orgProp.getDisplayName()}));
                return;
            }
            String billtype = entityType.getName();
            Set cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{billtype, selectEntry.getDataEntityType().getName(), bill, lotnumField});
            if (cfgDynamicObject == null || cfgDynamicObject.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u4e0d\u5230\u6279\u53f7\u5355\u636e\u914d\u7f6e\u3002", (String)"LotmainfileNoRule", (String)"scmc-im-business", (Object[])new Object[0]));
                return;
            }
            String lotidfield = ((DynamicObject)new ArrayList(cfgDynamicObject).get(0)).getString("lotidfield");
            QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainfFileFilterByLotnum", (Object[])new Object[]{bill, selectEntry, lotnumField});
            HashMap<String, String> paramMap = new HashMap<String, String>(4);
            paramMap.put("formId", "msmod_selectlot");
            paramMap.put("lotidfield", lotidfield);
            paramMap.put("lotnumfield", lotnumField);
            paramMap.put("filter", filter != null ? filter.toSerializedString() : null);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack(form, "msmod_selectlot"));
            view.showForm(showParameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"LotmainfileDisable", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    public static void matchBillLotId(DynamicObject[] bills, String operate) {
        if (bills == null || bills.length == 0) {
            return;
        }
        String billtype = null;
        int billsize = bills.length;
        ArrayList<Long> billids = new ArrayList<Long>(billsize);
        boolean isHasSubEntry = false;
        boolean isFromDataBase = true;
        boolean dirtyflag = false;
        DynamicObject billSingle = null;
        for (DynamicObject bill : bills) {
            if (billtype == null) {
                billtype = bill.getDynamicObjectType().getName();
                isFromDataBase = bill.getDataEntityState().getFromDatabase();
                isHasSubEntry = LotMainFileHelper.getHasSubEntry(billtype);
                billSingle = bill;
                if (!isFromDataBase) {
                    dirtyflag = true;
                }
                if (billsize == 1 && LotMainFileHelper.checkDirtyFlag(bill, isHasSubEntry)) {
                    dirtyflag = true;
                }
            }
            Long billid = (Long)bill.getPkValue();
            billids.add(billid);
        }
        Map allLotMatchMap = dirtyflag ? (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"genLotBySingleOperate", (Object[])new Object[]{billtype, operate, billSingle}) : (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"genLotByOperate", (Object[])new Object[]{billtype, operate, billids});
        if (!allLotMatchMap.isEmpty()) {
            Map<Object, DynamicObject> lotDynamicObjects = LotMainFileHelper.getLotDynamicObjects(dirtyflag, billsize, allLotMatchMap);
            HashMap<String, Map<String, List<String>>> errBillsMap = new HashMap<String, Map<String, List<String>>>();
            for (DynamicObject bill : bills) {
                String billno = bill.getString("billno");
                if (!allLotMatchMap.containsKey(billno)) continue;
                Map billMatchMap = (Map)allLotMatchMap.get(billno);
                DynamicObjectCollection billentries = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentries) {
                    String billentrykey;
                    Set<String> errCols = LotMainFileHelper.setEntryLotidByMatch(billentry, billMatchMap, billentrykey = "billentry" + '.' + billentry.getInt("seq"), lotDynamicObjects);
                    if (!errCols.isEmpty()) {
                        LotMainFileHelper.assembErrMap(errBillsMap, billno, billentry, null);
                    }
                    if (!isHasSubEntry) continue;
                    String parentSeq = String.valueOf(billentry.getInt("seq"));
                    DynamicObjectCollection subbillentries = billentry.getDynamicObjectCollection("afterentity");
                    for (DynamicObject subbillentry : subbillentries) {
                        String subbillentrykey;
                        Set<String> subErrCols = LotMainFileHelper.setEntryLotidByMatch(subbillentry, billMatchMap, subbillentrykey = "billentry" + '.' + parentSeq + '.' + "afterentity" + '.' + subbillentry.getInt("seq"), lotDynamicObjects);
                        if (subErrCols.isEmpty()) continue;
                        LotMainFileHelper.assembErrMap(errBillsMap, billno, subbillentry, parentSeq);
                    }
                }
            }
            if (!errBillsMap.isEmpty()) {
                LotMainFileHelper.showMatchErrmsg(errBillsMap, billtype);
            }
        }
    }

    private static Map<Object, DynamicObject> getLotDynamicObjects(boolean dirtyflag, int billsize, Map<String, Map<String, Map<String, Long>>> allLotMatchMap) {
        if (billsize == 1) {
            HashSet<Long> lotids = new HashSet<Long>();
            for (Map<String, Map<String, Long>> billMatchMap : allLotMatchMap.values()) {
                for (Map<String, Long> billentryMatchMap : billMatchMap.values()) {
                    for (Long lotid : billentryMatchMap.values()) {
                        if (lotid <= 0L) continue;
                        lotids.add(lotid);
                    }
                }
            }
            if (!lotids.isEmpty()) {
                return BusinessDataServiceHelper.loadFromCache((Object[])lotids.toArray(), (String)"bd_lot");
            }
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    private static Set<String> setEntryLotidByMatch(DynamicObject billentry, Map<String, Map<String, Long>> billMatchMap, String billentrykey, Map<Object, DynamicObject> lotDynamicObjects) {
        if (billMatchMap.containsKey(billentrykey)) {
            HashSet<String> errCols = new HashSet<String>();
            Map<String, Long> billentryMatchMap = billMatchMap.get(billentrykey);
            for (Map.Entry<String, Long> billentryMatchEntry : billentryMatchMap.entrySet()) {
                String lotidcol = billentryMatchEntry.getKey();
                Long lotid = billentryMatchEntry.getValue();
                if (lotid > 0L) {
                    DynamicObject lotDynamicObject = lotDynamicObjects.get(lotid);
                    if (lotDynamicObject != null) {
                        billentry.set(lotidcol, (Object)lotDynamicObject);
                        continue;
                    }
                    billentry.set(lotidcol, (Object)lotid);
                    continue;
                }
                if (lotid >= 0L) continue;
                errCols.add(lotidcol);
            }
            return errCols;
        }
        return Collections.emptySet();
    }

    private static void assembErrMap(Map<String, Map<String, List<String>>> errBillsMap, String billno, DynamicObject billentry, String parantSeq) {
        String seq = String.valueOf(billentry.getInt("seq"));
        String entrytype = billentry.getDataEntityType().getName();
        Map errEntriesMap = errBillsMap.getOrDefault(billno, new HashMap());
        List errEntries = errEntriesMap.getOrDefault(entrytype, new ArrayList());
        if (parantSeq != null) {
            errEntries.add(parantSeq + '-' + seq);
        } else {
            errEntries.add(seq);
        }
        if (!errEntriesMap.containsKey(entrytype)) {
            errEntriesMap.put(entrytype, errEntries);
        }
        if (!errBillsMap.containsKey(billno)) {
            errBillsMap.put(billno, errEntriesMap);
        }
    }

    private static void showMatchErrmsg(Map<String, Map<String, List<String>>> errBillsMap, String billtype) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
        Map entrytypes = mainEntityType.getAllEntities();
        StringBuilder errEntryMsgBuilder = new StringBuilder();
        for (Map.Entry<String, Map<String, List<String>>> errBillsEntry : errBillsMap.entrySet()) {
            String billno = errBillsEntry.getKey();
            errEntryMsgBuilder.append(billno);
            Map<String, List<String>> errEntriesMap = errBillsEntry.getValue();
            for (Map.Entry<String, List<String>> errEntry : errEntriesMap.entrySet()) {
                String entrytype = errEntry.getKey();
                String entryname = ((EntityType)entrytypes.get(entrytype)).getDisplayName().getLocaleValue();
                errEntryMsgBuilder.append(entryname).append(ResManager.loadKDString((String)"\u7b2c", (String)"LotMainFileEntryPre", (String)"scmc-im-business", (Object[])new Object[0])).append(errEntry.getValue()).append(ResManager.loadKDString((String)"\u884c.", (String)"LotMainFileEntryPost", (String)"scmc-im-business", (Object[])new Object[0]));
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u5206\u5f55\u7684\u6279\u53f7\u5df2\u5b58\u5728,\u4f46\u7269\u6599\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539:%s\u3002", (String)"LotMainFileMaterialNotSame", (String)"scmc-im-business", (Object[])new Object[0]), errEntryMsgBuilder.toString()));
    }

    private static boolean checkDirtyFlag(DynamicObject bill, boolean isHasSubEntry) {
        DataEntityState state = bill.getDataEntityState();
        long dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> headColumns.contains(dirtyProp.getName())).count();
        if (dirtySize > 0L || state.getRemovedItems().booleanValue()) {
            return true;
        }
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject billentry : billentries) {
            state = billentry.getDataEntityState();
            dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> entryColumns.contains(dirtyProp.getName())).count();
            if (dirtySize > 0L || state.getRemovedItems().booleanValue()) {
                return true;
            }
            if (!isHasSubEntry) continue;
            DynamicObjectCollection subentries = billentry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subentry : subentries) {
                state = subentry.getDataEntityState();
                dirtySize = StreamSupport.stream(state.getBizChangedProperties().spliterator(), false).filter(dirtyProp -> subentryColumns.contains(dirtyProp.getName())).count();
                if (dirtySize <= 0L) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean getHasSubEntry(String billtype) {
        return hasSubEntryBilltypes.contains(billtype);
    }
}

