/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.QualifiedMaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.QualifiedMaterielScopeResultHandle;
import kd.scmc.im.business.helper.datactrl.UnQualifiedMaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.UnQualifiedMaterielScopeResultHandle;

public class MaterialWhRelationHelper {
    private static final String STRICT_CTL = "2";
    private static final String ALGO_KEY = "kd.scmc.im.business.helper.MaterialWhRelationHelper";

    public static void addWarehouseSetupFilter(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, String warehouseKey) {
        int row = e.getRow();
        Object orgVal = bill.getValue("org");
        if (orgVal == null) {
            return;
        }
        String entityKey = bill.getDataEntity().getDataEntityType().getName();
        InvBizDataCtrlHelper invBizDataCtrlHelper = InvBizDataCtrlHelper.buildF7Helper();
        if ("im_invinspectbill".equals(entityKey)) {
            invBizDataCtrlHelper.addFilter(new QualifiedMaterielIsolateResultHandle());
            invBizDataCtrlHelper.addFilter(new QualifiedMaterielScopeResultHandle(true));
            invBizDataCtrlHelper.addFilter(new UnQualifiedMaterielIsolateResultHandle());
            invBizDataCtrlHelper.addFilter(new UnQualifiedMaterielScopeResultHandle(true));
        }
        if ("warehouse".equals(warehouseKey)) {
            QFilter q = invBizDataCtrlHelper.getF7QFilterByStrategyList((DynamicObject)bill.getEntryEntity("billentry").get(row), entityKey, "billentry.material.masterid");
            showParameter.getListFilterParameter().getQFilters().add(q);
        } else if ("warehouse1".equals(warehouseKey)) {
            QFilter q = invBizDataCtrlHelper.getF7QFilterByStrategyList((DynamicObject)bill.getEntryEntity("afterentity").get(row), entityKey, "billentry.afterentity.material1.masterid");
            showParameter.getListFilterParameter().getQFilters().add(q);
        }
    }

    public static void addMaterialFilter(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, String materialKey) {
        DynamicObject invOrg;
        Object appParameter;
        String formId;
        int row = e.getRow();
        Object materialVal = bill.getValue(materialKey, row);
        Object orgVal = bill.getValue("org");
        if (orgVal == null || materialVal == null) {
            return;
        }
        DynamicObject material = (DynamicObject)materialVal;
        if (material != null && !"bd_material".equals(formId = material.getDataEntityType().getName())) {
            material = material.getDynamicObject("masterid");
        }
        if (!STRICT_CTL.equals(appParameter = AppParameterHelper.getAppParameter("=9Q86DR2P+Q", "05", (Long)(invOrg = (DynamicObject)orgVal).getPkValue(), "fmeterialscope"))) {
            return;
        }
        DataSet materialGrpDataset = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_materialgroupdetail", (String)"group.id", (QFilter[])new QFilter("material.id", "=", material.getPkValue()).toArray(), null);
        HashSet<Long> groupIds = new HashSet<Long>(16);
        while (materialGrpDataset.hasNext()) {
            Row next = materialGrpDataset.next();
            Long materialId = next.getLong("group.id");
            groupIds.add(materialId);
        }
        QFilter qFilter = new QFilter("org", "=", invOrg.getPkValue());
        QFilter entryFilter = new QFilter("materialentity.materialmasterid", "=", material.getPkValue()).or("materialentity.materialgrpnumber.id", "in", groupIds);
        qFilter.and(entryFilter);
        DataSet whSetupDataset = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])qFilter.toArray(), null);
        HashSet<Long> whIds = new HashSet<Long>(16);
        while (whSetupDataset.hasNext()) {
            Row next = whSetupDataset.next();
            Long whId = next.getLong("warehouse.id");
            whIds.add(whId);
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", whIds));
    }
}

