/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class MetaDataHelper {
    private static final Log logger = LogFactory.getLog(MetaDataHelper.class);

    public static boolean isExistField(IDataModel bill, String fieldName) {
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = bill.getDataEntityType().findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isExistField(IDataModel bill, String entryName, String fieldName) {
        Map type = bill.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryName);
        Map map = entityType.getFields();
        boolean isExist = false;
        for (Map.Entry field : map.entrySet()) {
            if (!fieldName.equals(field.getKey())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static boolean isExistField(MainEntityType mainType, String entryName, String fieldName) {
        return mainType.findProperty(fieldName) != null;
    }

    public static boolean isExistField(DynamicObject obj, String entryName, String fieldName) {
        if (obj == null) {
            return false;
        }
        return MetaDataHelper.isExistField((MainEntityType)obj.getDataEntityType(), entryName, fieldName);
    }

    public static boolean isExistField(IDataEntityType entityType, String fieldName) {
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = ((EntityType)entityType).findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isBizAppExist(String bizAppId) {
        try {
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"isv,deploystatus,visible");
            if (obj != null) {
                String isv = obj.getString("isv");
                String deploystatus = obj.getString("deploystatus");
                if ("kingdee".equals(isv) && "2".equals(deploystatus)) {
                    return true;
                }
                if (!"kingdee".equals(isv) && "2".equals(deploystatus)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.error("MetaDataHelperException:", (Throwable)e);
            return false;
        }
        return false;
    }

    public static boolean isBizAppExistCal() {
        return SystemCallParamHelper.isEnable("sbs_intersystemcallconf", "KC0001");
    }

    public static boolean isBizAppExistAp() {
        return SystemCallParamHelper.isEnable("sbs_intersystemcallconf", "KC0005");
    }

    public static boolean isBizAppExistPom() {
        return MetaDataHelper.isBizAppExist("064+TL0DU6T9");
    }

    public static boolean isBizAppExistQcbd() {
        return MetaDataHelper.isBizAppExist("0M6ZTYMJVM9A");
    }

    public static FormConfig getFormConfig(String formid) {
        return FormMetadataCache.getFormConfig((String)formid);
    }

    @Deprecated
    public static MainEntity getMainEntity(String formId) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        if (meta == null) {
            return null;
        }
        return meta.getRootEntity();
    }
}

