/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class NoUpdateFieldsAnalysisHelper {
    private static final Log log = LogFactory.getLog(NoUpdateFieldsAnalysisHelper.class);

    public static String getFuncName(String referCol) {
        Map updateInvFieldsMap;
        String funcName = "";
        boolean jsonType = NoUpdateFieldsAnalysisHelper.getJSONType(referCol);
        if (jsonType && (updateInvFieldsMap = (Map)SerializationUtils.fromJsonString((String)referCol, Map.class)) != null && !updateInvFieldsMap.isEmpty()) {
            funcName = (String)updateInvFieldsMap.keySet().iterator().next();
        }
        return funcName;
    }

    public static List<String> getNoUpdateFieldsList(String noUpdateInvFields) {
        List<String> updateInvFieldsList = new ArrayList<String>(4);
        boolean jsonType = NoUpdateFieldsAnalysisHelper.getJSONType(noUpdateInvFields);
        if (!jsonType) {
            return updateInvFieldsList;
        }
        Map updateInvFieldsMap = (Map)SerializationUtils.fromJsonString((String)noUpdateInvFields, Map.class);
        updateInvFieldsList = (List)updateInvFieldsMap.get("setnull");
        if (null == updateInvFieldsList) {
            updateInvFieldsList = new ArrayList(4);
        }
        return updateInvFieldsList;
    }

    private static boolean getJSONType(String str) {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }

    public static void setNoUpdateFields(IDataModel model, String entryKey, String materialKey, String entryNoUpdateFieldKey) {
        String formId = model.getDataEntityType().getName();
        int rowCount = model.getEntryRowCount(entryKey);
        HashSet<Object> materialIdSet = new HashSet<Object>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject material = (DynamicObject)model.getValue(materialKey, i);
            if (null == material) continue;
            materialIdSet.add(material.getPkValue());
        }
        log.info("----------NoUpdateFieldsAnalysisHelper,materialIdSet:" + materialIdSet + ";formId:" + formId + ";entryKey:" + entryKey);
        Map noUpdateFiledsMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"NoUpdateInvService", (String)"getNoUpdateFields", (Object[])new Object[]{formId, entryKey, materialIdSet});
        log.info("---------------NoUpdateFieldsAnalysisHelper,noUpdateFiledsMap:" + noUpdateFiledsMap);
        for (int i = 0; i < rowCount; ++i) {
            String noUpdateFieldsValue;
            DynamicObject material = (DynamicObject)model.getValue(materialKey, i);
            if (null == material || !(noUpdateFieldsValue = (String)model.getValue(entryNoUpdateFieldKey, i)).isEmpty()) continue;
            String value = (String)noUpdateFiledsMap.get(material.getPkValue());
            model.setValue(entryNoUpdateFieldKey, (Object)value, i);
        }
    }
}

