/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ScmPurDownPushInvHelper {
    private static final String UNION_PUSH = "msisv_unionpush_record";

    public static Map<Long, Map<String, Object>> buildWriteBackParam(DynamicObject[] dataEntities) {
        HashSet<Object> targetIdSet = new HashSet<Object>(16);
        HashMap<Object, Object> billNoMap = new HashMap<Object, Object>(16);
        for (DynamicObject dataEntity : dataEntities) {
            Object targetId = dataEntity.getPkValue();
            targetIdSet.add(targetId);
            Object billNo = dataEntity.get("billno");
            billNoMap.put(targetId, billNo);
        }
        QFilter qFilter = new QFilter("tgtbillid", "in", targetIdSet);
        DynamicObject[] unionPushList = BusinessDataServiceHelper.load((String)UNION_PUSH, (String)"relentryid, tgtentity, tgtbillno, tgtbillid, tgtentryid", (QFilter[])qFilter.toArray(), null);
        HashMap<Long, Map<String, Object>> param = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject push : unionPushList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            Object targetId = push.get("tgtbillid");
            Object billNo = billNoMap.get(targetId);
            map.put("billno", billNo);
            map.put("billid", targetId);
            map.put("billtype", push.get("tgtentity"));
            map.put("entryid", push.get("tgtentryid"));
            param.put(push.getLong("relentryid"), map);
        }
        return param;
    }

    public static Map<String, Object> deleteScmDownInvBill(Map<String, Object> param) {
        String entityName = (String)param.get("entityName");
        List billIds = (List)param.get("ids");
        Map billMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"billstatus", (QFilter[])new QFilter("id", "in", (Object)billIds).toArray());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        resultMap.put("isSuccess", true);
        for (Long billId : billIds) {
            try {
                String biiStatus;
                DynamicObject bill = (DynamicObject)billMap.get(billId);
                if (bill == null) continue;
                switch (biiStatus = bill.getString("billstatus")) {
                    case "A": {
                        ScmPurDownPushInvHelper.deleteSaveBill(billId, entityName);
                        break;
                    }
                    case "B": {
                        ScmPurDownPushInvHelper.deleteSubmitBill(billId, entityName);
                        break;
                    }
                    case "C": {
                        ScmPurDownPushInvHelper.deleteAuditBill(billId, entityName);
                        break;
                    }
                }
            }
            catch (Exception e) {
                errorMap.put(String.valueOf(billId), e.getMessage());
                resultMap.put("isSuccess", false);
                resultMap.put("message", errorMap);
            }
        }
        return resultMap;
    }

    private static String buildErrorMessage(OperationResult result) {
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
            String message = info.getMessage();
            stringBuilder.append(message);
            stringBuilder.append('\n');
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(result.getMessage());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static OperateOption buildOperation() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("ignoreValidation", "true");
        return operateOption;
    }

    private static void deleteSaveBill(Long billId, String entityName) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])new Long[]{billId}, (OperateOption)ScmPurDownPushInvHelper.buildOperation());
        if (!result.isSuccess()) {
            throw new KDBizException(ScmPurDownPushInvHelper.buildErrorMessage(result));
        }
    }

    private static void deleteSubmitBill(Long billId, String entityName) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"unsubmit", (String)entityName, (Object[])new Long[]{billId}, (OperateOption)ScmPurDownPushInvHelper.buildOperation());
        if (!result.isSuccess()) {
            throw new KDBizException(ScmPurDownPushInvHelper.buildErrorMessage(result));
        }
        result = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])new Long[]{billId}, (OperateOption)ScmPurDownPushInvHelper.buildOperation());
        if (!result.isSuccess()) {
            throw new KDBizException(ScmPurDownPushInvHelper.buildErrorMessage(result));
        }
    }

    private static void deleteAuditBill(Long billId, String entityName) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityName, (Object[])new Long[]{billId}, (OperateOption)ScmPurDownPushInvHelper.buildOperation());
        if (!result.isSuccess()) {
            throw new KDBizException(ScmPurDownPushInvHelper.buildErrorMessage(result));
        }
        result = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])new Long[]{billId}, (OperateOption)ScmPurDownPushInvHelper.buildOperation());
        if (!result.isSuccess()) {
            throw new KDBizException(ScmPurDownPushInvHelper.buildErrorMessage(result));
        }
    }
}

