/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;

public class SerialNumberHelper {
    private static final Log logger = LogFactory.getLog(SerialNumberHelper.class);
    public static final String BARITEM_ENTER_SNNUMBER = "entersnnumber";
    public static final String BARITEM_IMPORT_SNNUMBER = "importsnnumber";
    public static final String BARITEM_CHECK_SNNUMBER = "checksnnumber";
    private static List<String> ignoreColumns = Arrays.asList("billstatus", "auditor", "auditdate", "auditor_id");

    public static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static boolean getHasSubEntry(String billtype) {
        return "im_assembbill".equals(billtype) || "im_adjustbill".equals(billtype) || "im_disassemblebill".equals(billtype);
    }

    public static boolean isInvBillEnableSerial(DynamicObject bill) {
        String billtype = bill.getDynamicObjectType().getName();
        boolean isHasSub = SerialNumberHelper.getHasSubEntry(billtype);
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billentry) {
            DynamicObject material = entry.getDynamicObject("material");
            if (SerialNumberHelper.isEnableSerial(material)) {
                return true;
            }
            if (!isHasSub) continue;
            DynamicObjectCollection subbillentry = entry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subentry : subbillentry) {
                DynamicObject subMaterial = subentry.getDynamicObject("material1");
                if (!SerialNumberHelper.isEnableSerial(subMaterial)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getUpSnRelationId(String billType, DynamicObject entry) {
        String billEntry_lk = null;
        String billEntry_lk_sid = null;
        EntryType entryType = (EntryType)entry.getDynamicObjectType();
        switch (billType) {
            case "im_locationtransfer": 
            case "im_initbill": {
                return null;
            }
            case "im_transinbill": {
                billEntry_lk = "invbillentry_lk";
                billEntry_lk_sid = "invbillentry_lk_sid";
                break;
            }
            default: {
                DynamicProperty property = entryType.getProperty(entryType + "_lk");
                if (property != null) {
                    billEntry_lk = entryType + "_lk";
                    billEntry_lk_sid = entryType + "_lk_sid";
                    break;
                }
                return null;
            }
        }
        DynamicObjectCollection linkRows = null;
        Object billSnRelationId = null;
        linkRows = (DynamicObjectCollection)entry.get(billEntry_lk);
        if (linkRows != null && linkRows.size() == 1) {
            DynamicObject linkrow = (DynamicObject)linkRows.get(0);
            Object sourceEntryID = linkrow.get(billEntry_lk_sid);
            QFilter filter = new QFilter("entryid", "=", sourceEntryID);
            DynamicObject billSNRelation = QueryServiceHelper.queryOne((String)"sbs_billsnrelation", (String)"id", (QFilter[])filter.toArray());
            billSnRelationId = billSNRelation != null ? billSNRelation.get("id") : null;
        }
        return billSnRelationId;
    }

    @Deprecated
    public static void quickInputSerialNumber(String billType, Object billId, String entryName, Object entryId, Object materialId, String serialName) {
        DynamicObject singleSn;
        DynamicObjectCollection entryEntity;
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", billId).and("entryid", "=", entryId);
        DynamicObject billSNRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
        if (billSNRelation == null) {
            billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)"sbs_billsnrelation");
            billSNRelation.set("billtype", (Object)billType);
            billSNRelation.set("entrykey", (Object)entryName);
            billSNRelation.set("billid", billId);
            billSNRelation.set("entryid", entryId);
        }
        if ((entryEntity = billSNRelation.getDynamicObjectCollection("entryentity")).size() == 1) {
            singleSn = (DynamicObject)entryEntity.get(0);
        } else {
            entryEntity.clear();
            singleSn = entryEntity.addNew();
        }
        singleSn.set("snnumber", (Object)serialName);
        singleSn.set("seq", (Object)1);
        singleSn.set("handlestatus", (Object)"A");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billSNRelation});
    }

    public static void quickFullInputSerialNumber(Boolean forceClear, String billType, Long billId, String entryName, Map<Long, List<Map<String, Object>>> allEntrySerials, Map<Long, Map<String, Object>> entrySrcMap) {
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", (Object)billId).and("entryid", "in", allEntrySerials.keySet());
        Map billSNRelationsById = BusinessDataServiceHelper.loadFromCache((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> billSNRelationsByEntryId = new HashMap<Long, DynamicObject>(billSNRelationsById.size());
        for (DynamicObject billSNRelation : billSNRelationsById.values()) {
            Long entryId = billSNRelation.getLong("entryid");
            billSNRelationsByEntryId.put(entryId, billSNRelation);
        }
        ArrayList<DynamicObject> billSNRelationsForSave = new ArrayList<DynamicObject>(allEntrySerials.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entrySerials : allEntrySerials.entrySet()) {
            DynamicObjectCollection entryEntity;
            Long entryId = entrySerials.getKey();
            List<Map<String, Object>> serialList = entrySerials.getValue();
            DynamicObject billSNRelation = (DynamicObject)billSNRelationsByEntryId.get(entryId);
            if (billSNRelation == null) {
                Map<String, Object> entrySrc;
                billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)"sbs_billsnrelation");
                billSNRelation.set("billtype", (Object)billType);
                billSNRelation.set("entrykey", (Object)entryName);
                billSNRelation.set("billid", (Object)billId);
                billSNRelation.set("entryid", (Object)entryId);
                if (entrySrcMap != null && (entrySrc = entrySrcMap.get(entryId)) != null) {
                    billSNRelation.set("srcbilltype", entrySrc.get("srcbilltype"));
                    billSNRelation.set("srcbillid", entrySrc.get("srcbillid"));
                    billSNRelation.set("srcentrykey", entrySrc.get("srcentrykey"));
                    billSNRelation.set("srcentryid", entrySrc.get("srcentryid"));
                    billSNRelation.set("srcisreq", entrySrc.get("srcisreq"));
                }
            }
            if ((entryEntity = billSNRelation.getDynamicObjectCollection("entryentity")).size() > 0) {
                if (!forceClear.booleanValue()) continue;
                entryEntity.clear();
            }
            for (int i = 1; i <= serialList.size(); ++i) {
                Map<String, Object> serial = serialList.get(i - 1);
                DynamicObject singleSn = entryEntity.addNew();
                singleSn.set("handlestatus", (Object)"A");
                singleSn.set("seq", (Object)i);
                for (Map.Entry<String, Object> serialItem : serial.entrySet()) {
                    singleSn.set(serialItem.getKey(), serialItem.getValue());
                }
            }
            billSNRelationsForSave.add(billSNRelation);
        }
        if (!billSNRelationsForSave.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])billSNRelationsForSave.toArray(new DynamicObject[0]));
        }
    }

    public static void quickBatchInputSerialNumber(String billType, Object billId, String entryName, Object entryId, String srcbilltype, Long srcbillid, String srcentrykey, Long srcentryid, Object materialId, List<Map<String, Object>> serialItems) {
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", billId).and("entryid", "=", entryId);
        DynamicObject billSNRelation = BusinessDataServiceHelper.loadSingle((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
        if (billSNRelation == null) {
            billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)"sbs_billsnrelation");
            billSNRelation.set("billtype", (Object)billType);
            billSNRelation.set("entrykey", (Object)entryName);
            billSNRelation.set("billid", billId);
            billSNRelation.set("entryid", entryId);
            billSNRelation.set("srcbilltype", (Object)srcbilltype);
            billSNRelation.set("srcbillid", (Object)srcbillid);
            billSNRelation.set("srcentrykey", (Object)srcentrykey);
            billSNRelation.set("srcentryid", (Object)srcentryid);
        }
        DynamicObjectCollection entryEntity = billSNRelation.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        for (Map<String, Object> serialItem : serialItems) {
            DynamicObject singleSn = entryEntity.addNew();
            singleSn.set("snnumber", serialItem.get("snnumber"));
            singleSn.set("seq", serialItem.get("seq"));
            singleSn.set("invorg", serialItem.get("invorg"));
            singleSn.set("imei", serialItem.get("imei"));
            singleSn.set("meid", serialItem.get("meid"));
            singleSn.set("handlestatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billSNRelation});
    }

    public static void copySerialnumToRel(DynamicObject[] bills, String entryName) {
        String billtype = bills[0].getDataEntityType().getName();
        for (DynamicObject bill : bills) {
            long billid = (Long)bill.getPkValue();
            if (billid <= 0L) continue;
            DynamicObject org = SerialNumberHelper.getBillMainOrg(bill, billtype);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryName);
            HashMap<Long, List<Map<String, Object>>> allEntrySerials = new HashMap<Long, List<Map<String, Object>>>(entries.size());
            for (DynamicObject entry : entries) {
                String serialnumber;
                long entryid = (Long)entry.getPkValue();
                if (entryid <= 0L || StringUtils.isBlank((String)(serialnumber = entry.getString("serialnumber")))) continue;
                ArrayList serialList = new ArrayList(1);
                HashMap<String, Object> serial = new HashMap<String, Object>(2);
                serial.put("snnumber", serialnumber);
                serial.put("invorg", org != null ? org.getPkValue() : null);
                serialList.add(serial);
                allEntrySerials.put(entryid, serialList);
            }
            if (allEntrySerials.isEmpty()) continue;
            SerialNumberHelper.quickFullInputSerialNumber(true, billtype, billid, entryName, allEntrySerials, Collections.emptyMap());
        }
    }

    public static void showPageImportSNNumber(AbstractBillPlugIn bill, Map<String, Object> showImportSNNumberParam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sbs_importsn");
        showParameter.setCustomParams(showImportSNNumberParam);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)bill, "sbs_importsn"));
        bill.getView().showForm(showParameter);
    }

    public static void showPageEnterSNNumber(AbstractBillPlugIn bill, Map<String, Object> showEnterSNNumberParam) {
        SerialNumberHelper.showPageEnterSNNumber(bill.getView(), showEnterSNNumberParam);
    }

    public static void showPageEnterSNNumber(IFormView view, Map<String, Object> showEnterSNNumberParam) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7", (String)"SerialNumberHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        baseShowParameter.setFormId("sbs_billsnrelation");
        Object relationId = showEnterSNNumberParam.get("billsnrelationid");
        if (relationId != null) {
            baseShowParameter.setPkId(relationId);
        }
        baseShowParameter.setCustomParams(showEnterSNNumberParam);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    public static void showPageCheckSNNumber(AbstractBillPlugIn bill, Map<String, Object> showCheckSNNumberParam) {
        SerialNumberHelper.showPageCheckSNNumber(bill.getView(), showCheckSNNumberParam);
    }

    public static void showPageCheckSNNumber(IFormView view, Map<String, Object> showCheckSNNumberParam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sbs_checksn");
        showParameter.setCustomParams(showCheckSNNumberParam);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void handleSNNumber(AbstractBillPlugIn plugin, ItemClickEvent evt) {
        long locationId;
        DynamicObject location;
        long warehouseId;
        DynamicObject warehouse;
        IDataModel model = plugin.getView().getModel();
        IFormView view = plugin.getView();
        String itemKey = evt.getItemKey();
        DynamicObject bill = model.getDataEntity();
        Object pkValue = bill.getPkValue();
        MainEntityType billtypeEntity = model.getDataEntityType();
        String billtype = billtypeEntity.getName();
        DynamicObject org = SerialNumberHelper.getBillMainOrg(bill, billtype);
        String entryName = "billentry";
        int[] selectRows = ((EntryGrid)view.getControl(entryName)).getSelectRows();
        if (selectRows.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectOneEntryToHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entry = (DynamicObject)model.getEntryEntity(entryName).get(selectRows[0]);
        if ("im_transdirbill".equals(billtype) || "im_invinspectbill".equals(billtype)) {
            warehouse = entry.getDynamicObject("outwarehouse");
            warehouseId = warehouse == null ? 0L : (Long)warehouse.getPkValue();
            location = entry.getDynamicObject("outlocation");
            locationId = location == null ? 0L : (Long)location.getPkValue();
        } else if ("im_locationtransfer".equals(billtype)) {
            warehouse = entry.getDynamicObject("warehouse");
            warehouseId = warehouse == null ? 0L : (Long)warehouse.getPkValue();
            location = entry.getDynamicObject("outlocation");
            locationId = location == null ? 0L : (Long)location.getPkValue();
        } else {
            warehouse = entry.getDynamicObject("warehouse");
            warehouseId = warehouse == null ? 0L : (Long)warehouse.getPkValue();
            location = entry.getDynamicObject("location");
            locationId = location == null ? 0L : (Long)location.getPkValue();
        }
        DynamicObject material = entry.getDynamicObject("material");
        String serialQtyKey = SerialNumberHelper.getSerialQtyKey(billtype, entryName, (Long)pkValue, "baseqty");
        String serialUnitKey = SerialNumberHelper.getSerialUnitKey(billtypeEntity, entryName, serialQtyKey);
        DynamicObject baseUnit = entry.getDynamicObject(serialUnitKey);
        BigDecimal baseQty = entry.getBigDecimal(serialQtyKey);
        if (material == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialIsNull", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!SerialNumberHelper.isEnableSerial(material)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"UnEnableSerialCanNotHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        if (baseUnit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"UnitIsNull", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Object entryid = entry.getPkValue();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("material", material.getPkValue());
        param.put("unit", baseUnit.getPkValue());
        param.put("qty", baseQty.intValue());
        param.put("billid", pkValue);
        param.put("billtype", billtype);
        param.put("entryid", entryid);
        param.put("entrykey", entryName);
        param.put("invorg", org != null ? org.getPkValue() : null);
        param.put("curwarehous", warehouseId);
        param.put("curlocation", locationId);
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        if (!isFromDataBase && BARITEM_CHECK_SNNUMBER.equals(itemKey)) {
            Object billSnRelationId = SerialNumberHelper.getUpSnRelationId(billtype, entry);
            param.put("billsnrelationid", billSnRelationId);
        } else {
            QFilter filter;
            DynamicObject billSNRelation;
            if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7\u3002", (String)"CanNotHandleSerialNumberBecauseBillNotSave", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            if (entryid == null || entryid.equals(0L)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7\u3002", (String)"CanNotHandleSerialNumberBecauseEntryNotSave", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            String serialnumber = entry.getString("serialnumber");
            if (!StringUtils.isBlank((String)serialnumber)) {
                if (BARITEM_ENTER_SNNUMBER.equals(itemKey) || BARITEM_IMPORT_SNNUMBER.equals(itemKey)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u5df2\u5728\u7269\u6599\u660e\u7ec6\u4e2d\u5f55\u5165\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165\u6216\u5bfc\u5165\u3002", (String)"SerialNumberHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
                    return;
                }
                if (BARITEM_CHECK_SNNUMBER.equals(itemKey)) {
                    HashMap<String, Object> serial = new HashMap<String, Object>(2);
                    serial.put("snnumber", serialnumber);
                    serial.put("invorg", org != null ? org.getPkValue() : null);
                    Map<Long, List<Map<String, Object>>> allEntrySerials = Collections.singletonMap((Long)entryid, Collections.singletonList(serial));
                    SerialNumberHelper.quickFullInputSerialNumber(true, billtype, (Long)pkValue, entryName, allEntrySerials, Collections.emptyMap());
                }
            }
            if ((billSNRelation = QueryServiceHelper.queryOne((String)"sbs_billsnrelation", (String)"id", (QFilter[])(filter = new QFilter("billtype", "=", (Object)billtype).and("entrykey", "=", (Object)entryName).and("billid", "=", pkValue).and("entryid", "=", entryid)).toArray())) != null) {
                param.put("billsnrelationid", billSNRelation.get("id"));
            }
        }
        SerialNumberHelper.showSerialNumberPage(plugin, itemKey, param);
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }

    private static void showSerialNumberPage(AbstractBillPlugIn plugin, String itemKey, Map<String, Object> param) {
        IDataModel model = plugin.getView().getModel();
        IFormView view = plugin.getView();
        switch (itemKey) {
            case "checksnnumber": {
                SerialNumberHelper.showPageCheckSNNumber(plugin, param);
                break;
            }
            case "entersnnumber": {
                if (!"A".equals(model.getValue("billstatus"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"OnlySaveStatusCanAddSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
                SerialNumberHelper.showPageEnterSNNumber(plugin, param);
                break;
            }
            case "importsnnumber": {
                if (!"A".equals(model.getValue("billstatus"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (String)"OnlySaveStatusCanImportSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (SerialNumberHelper.checkExistBotpSrcSeq(param)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u6ca1\u6709\u5e8f\u5217\u53f7\u5173\u8054\u65f6\u624d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (String)"OnlyNotBotpCanImportSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
                SerialNumberHelper.showPageImportSNNumber(plugin, param);
                break;
            }
        }
    }

    public static Map<Object, List<String>> validateCallSNService(Collection<DynamicObject> bills, String operate) {
        if (bills == null || bills.size() == 0) {
            return new HashMap<Object, List<String>>(0);
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.size());
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.size());
        ArrayList<Object> hasSNentryIdList = new ArrayList<Object>(16);
        String billtype = null;
        boolean isFromDataBase = true;
        boolean notExistSingleSerialRow = true;
        boolean isHasSubEntry = false;
        int billsize = bills.size();
        boolean dirtyFlag = false;
        DynamicObject billSingle = null;
        for (DynamicObject bill : bills) {
            if (billtype == null) {
                billtype = bill.getDynamicObjectType().getName();
                isFromDataBase = bill.getDataEntityState().getFromDatabase();
                isHasSubEntry = SerialNumberHelper.getHasSubEntry(billtype);
                billSingle = bill;
            }
            Long billid = (Long)bill.getPkValue();
            billIdList.add(billid);
            if (SerialNumberHelper.isInvBillEnableSerial(bill) && !InvBillHelper.isVirtualBill(bill) && !InvBillHelper.isInitBill(bill)) {
                hasSNBillIdList.add(billid);
                if (operate.equals("save") || billsize == 1 && operate.equals("submit")) {
                    SerialNumberHelper.putSNentryids(hasSNentryIdList, bill, isHasSubEntry);
                }
            }
            if (billsize != 1 || !operate.equals("submit") || !(dirtyFlag = SerialNumberHelper.checkDirtyFlag(bill, isHasSubEntry)) || isHasSubEntry) continue;
            DynamicObjectCollection billentries = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentries) {
                String serialnumber;
                long entryid = (Long)billentry.getPkValue();
                if (entryid != 0L || StringUtils.isBlank((String)(serialnumber = billentry.getString("serialnumber")))) continue;
                notExistSingleSerialRow = false;
            }
        }
        if (isFromDataBase && notExistSingleSerialRow && !hasSNBillIdList.isEmpty() && !isHasSubEntry && billsize == 1 && operate.equals("submit") && dirtyFlag) {
            SerialNumberHelper.copySerialnumToRel(new DynamicObject[]{billSingle}, "billentry");
        }
        if (operate.equals("save") || billsize == 1 && operate.equals("submit")) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"validateSNByBillDelEntry", (Object[])new Object[]{billtype, operate, billIdList, hasSNentryIdList});
        }
        if (hasSNBillIdList.isEmpty() || operate.equals("save")) {
            return new HashMap<Object, List<String>>(0);
        }
        if (!isFromDataBase || !notExistSingleSerialRow) {
            Long billid = (Long)hasSNBillIdList.get(0);
            String message = ResManager.loadKDString((String)"\u5305\u542b\u5e8f\u5217\u53f7\u63a7\u5236\u7684\u5355\u636e\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u63d0\u4ea4\u3002", (String)"SerialNumberMustSave", (String)"scmc-im-business", (Object[])new Object[0]);
            HashMap<Object, List<String>> errorMessageData = new HashMap<Object, List<String>>(1);
            errorMessageData.put(billid, Collections.singletonList(message));
            return errorMessageData;
        }
        if (billsize == 1 && operate.equals("submit") && dirtyFlag) {
            return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"validateSNBySingleBillOperate", (Object[])new Object[]{billtype, operate, billSingle});
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"validateSNByBillOperate", (Object[])new Object[]{billtype, operate, hasSNBillIdList});
    }

    public static void operateCallSNSerivce(DynamicObject[] bills, String operate) {
        if (bills == null || bills.length == 0) {
            return;
        }
        HashSet<Long> billIdSet = new HashSet<Long>(bills.length);
        ArrayList<Long> hasSNBillIdList = new ArrayList<Long>(bills.length);
        HashSet<Object> hasSNentryIdSet = new HashSet<Object>(16);
        String billtype = bills[0].getDynamicObjectType().getName();
        String billno = bills[0].getString("billno");
        boolean isHasSubEntry = SerialNumberHelper.getHasSubEntry(billtype);
        int billsize = bills.length;
        for (DynamicObject bill : bills) {
            Long billid = (Long)bill.getPkValue();
            billIdSet.add(billid);
            if (SerialNumberHelper.isInvBillEnableSerial(bill) && !InvBillHelper.isVirtualBill(bill) && !InvBillHelper.isInitBill(bill)) {
                hasSNBillIdList.add(billid);
            }
            if (billsize != 1 || !operate.equals("submit")) continue;
            SerialNumberHelper.putSNentryids(hasSNentryIdSet, bill, isHasSubEntry);
        }
        if (billsize == 1 && operate.equals("submit")) {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"BillSNRelationService", (String)"deleteSurplusRelation", (Object[])new Object[]{billtype, billIdSet, hasSNentryIdSet});
        }
        if (hasSNBillIdList.isEmpty()) {
            return;
        }
        logger.debug("BillTplOp:\u8c03\u7528\u5e8f\u5217\u53f7\u670d\u52a1\uff0c\u6267\u884c\u5e8f\u5217\u53f7\u4e3b\u6863\u66f4\u65b0\u3010" + operate + "\u3011" + billno);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"SerialNumberService", (String)"handleSNByBillOperate", (Object[])new Object[]{billtype, operate, hasSNBillIdList});
        logger.debug("BillTplOp:\u8c03\u7528\u5e8f\u5217\u53f7\u670d\u52a1\u5b8c\u6210");
        Object resultInfo = result.get("result");
        if (resultInfo != null && !Boolean.parseBoolean(resultInfo.toString())) {
            throw new KDBizException(result.get("failreason").toString());
        }
    }

    private static void putSNentryids(Collection<Object> hasSNentryIdCollection, DynamicObject bill, boolean isHasSubEntry) {
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject billentry : billentries) {
            DynamicObject material = billentry.getDynamicObject("material");
            if (material != null && material.getBoolean("enableserial")) {
                hasSNentryIdCollection.add((Long)billentry.getPkValue());
            }
            if (!isHasSubEntry) continue;
            DynamicObjectCollection subentries = billentry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subentry : subentries) {
                DynamicObject submaterial = subentry.getDynamicObject("material1");
                if (submaterial == null || !submaterial.getBoolean("enableserial")) continue;
                hasSNentryIdCollection.add((Long)subentry.getPkValue());
            }
        }
    }

    private static boolean checkDirtyFlag(DynamicObject bill, boolean isHasSubEntry) {
        DataEntityState state = bill.getDataEntityState();
        long dirtySize = state.GetDirtyProperties().stream().filter(dirtyProp -> !ignoreColumns.contains(dirtyProp.getName())).count();
        if (dirtySize > 0L || state.getRemovedItems().booleanValue()) {
            return true;
        }
        DynamicObjectCollection billentries = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject billentry : billentries) {
            state = billentry.getDataEntityState();
            if (state.getDataEntityDirty() || state.getRemovedItems().booleanValue()) {
                return true;
            }
            if (!isHasSubEntry) continue;
            DynamicObjectCollection subentries = billentry.getDynamicObjectCollection("afterentity");
            for (DynamicObject subentry : subentries) {
                if (!subentry.getDataEntityState().getDataEntityDirty()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkExistBotpSrcSeq(Map<String, Object> param) {
        Long billid = (Long)param.get("billid");
        String billtype = (String)param.get("billtype");
        Long entryid = (Long)param.get("entryid");
        String entrykey = (String)param.get("entrykey");
        boolean srcSeqFlag = QueryServiceHelper.exists((String)"sbs_billsnrelation", (QFilter[])new QFilter("billtype", "=", (Object)billtype).and("billid", "=", (Object)billid).and("entrykey", "=", (Object)entrykey).and("entryid", "=", (Object)entryid).and("srcbillid", "!=", (Object)0).toArray());
        return srcSeqFlag;
    }

    public static String getSerialQtyKey(String billtype, String entrytype, Long billid, String defaultQtyKey) {
        DynamicObject cfg = SNBillConfigHelper.getSNBillConfigByBillId((String)billtype, (String)entrytype, (Long)billid);
        if (cfg != null) {
            String serialQtyKey = SerialNumberHelper.getPureKey(cfg.getString("snbaseqtycol"));
            return serialQtyKey;
        }
        return defaultQtyKey;
    }

    public static String getSerialUnitKey(MainEntityType billtypeEntity, String entrytype, String serialQtyKey) {
        Map allEntryFields = ((EntityType)billtypeEntity.getAllEntities().get(entrytype)).getFields();
        QtyProp serialQtyProp = (QtyProp)allEntryFields.get(serialQtyKey);
        return serialQtyProp.getRelatedUnit();
    }

    private static String getPureKey(String currentKey) {
        if (currentKey.lastIndexOf(46) != -1) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        return currentKey;
    }
}

