/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.CustomerHelper;
import kd.scmc.im.business.helper.SupplierHelper;

public class SupplierAndCustomerHelper {
    public static void setSupplier(IFormView view, int rowIndex) {
        IDataModel model = view.getModel();
        Object supplierObj = model.getValue("supplier");
        if (supplierObj == null) {
            return;
        }
        DynamicObject supplier = (DynamicObject)supplierObj;
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject deliverSupplier = null;
        String bizFunction = supplier.get("bizfunction") == null ? "" : supplier.get("bizfunction").toString();
        invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
        invoiceSupplier = invoiceSupplier == null ? (bizFunction.contains("2") ? supplier : null) : invoiceSupplier;
        receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
        receivingSupplier = receivingSupplier == null ? (bizFunction.contains("3") ? supplier : null) : receivingSupplier;
        deliverSupplier = bizFunction.contains("1") ? supplier : null;
        model.setValue("providersupplier", deliverSupplier == null ? null : deliverSupplier.getPkValue(), rowIndex);
        model.setValue("invoicesupplier", invoiceSupplier == null ? null : invoiceSupplier.getPkValue(), rowIndex);
        model.setValue("receivesupplier", receivingSupplier == null ? null : receivingSupplier.getPkValue(), rowIndex);
        ILocaleString providerAddress = SupplierHelper.getValidDefaultMultilingualAddress(supplier);
        DynamicObject linkman = SupplierHelper.getDefaultLinkMan(supplier);
        model.setValue("provideraddress", (Object)providerAddress, rowIndex);
        model.setValue("providerlinkman", (Object)linkman, rowIndex);
    }

    public static void setCustomer(IFormView view, int rowIndex) {
        IDataModel bill = view.getModel();
        Object customerObj = bill.getValue("customer");
        if (customerObj == null) {
            return;
        }
        DynamicObject customer = (DynamicObject)customerObj;
        DynamicObject settleCustomer = null;
        DynamicObject payingCustomer = null;
        DynamicObject recCustomer = null;
        String bizFunction = customer.get("bizfunction") == null ? "" : customer.get("bizfunction").toString();
        recCustomer = bizFunction.contains("1") ? customer : null;
        settleCustomer = customer.getDynamicObject("invoicecustomerid");
        settleCustomer = settleCustomer == null ? (bizFunction.contains("2") ? customer : null) : settleCustomer;
        payingCustomer = customer.getDynamicObject("paymentcustomerid");
        payingCustomer = payingCustomer == null ? (bizFunction.contains("3") ? customer : null) : payingCustomer;
        bill.setValue("reccustomer", recCustomer == null ? null : recCustomer.getPkValue(), rowIndex);
        bill.setValue("settlecustomer", settleCustomer == null ? null : settleCustomer.getPkValue(), rowIndex);
        bill.setValue("payingcustomer", payingCustomer == null ? null : payingCustomer.getPkValue(), rowIndex);
        Long receiveLinkman = CustomerHelper.getLinkman(customer);
        ILocaleString receiveAddress = CustomerHelper.getValidDefaultMultilingualAddress(customer);
        bill.setValue("reclinkman", (Object)receiveLinkman, rowIndex);
        bill.setValue("receiveaddress", (Object)receiveAddress, rowIndex);
    }
}

