/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.consts.WriteBackContractModel;

public class TrackContractHelper {
    protected static final Log logger = LogFactory.getLog(TrackContractHelper.class);

    public static List<Object[]> trackContractInfo(List<Object[]> info, String contractEntity) {
        String orderEntity;
        if ("conm_purcontract".equalsIgnoreCase(contractEntity)) {
            orderEntity = "pm_purorderbill";
        } else if ("conm_salcontract".equalsIgnoreCase(contractEntity)) {
            orderEntity = "sm_salorder";
        } else {
            return null;
        }
        ArrayList<Object[]> contractInfoList = new ArrayList<Object[]>();
        ArrayList<Object[]> mainBillInfoList = new ArrayList<Object[]>();
        for (Object[] param : info) {
            if (param[7] != null && param[8] != null) {
                contractInfoList.add(param);
                continue;
            }
            mainBillInfoList.add(param);
        }
        RowMeta resultMeta = new RowMeta(new String[]{"verifyQty", "verifyBaseQty", "measureunit", "verifyAmt", "centryid", "cmaterial", "cunit"}, new DataType[]{DataType.BigDecimalType, DataType.BigDecimalType, DataType.LongType, DataType.BigDecimalType, DataType.LongType, DataType.LongType, DataType.LongType});
        DataSet result = Algo.create((String)"search-contractInfo").createDataSet(new ArrayList().iterator(), resultMeta);
        RowMeta verifyMeta = new RowMeta(new String[]{"verifyQty", "verifyBaseQty", "measureunit", "verifyAmt", "org", "mainBillEntryid", "mainbillid", "conbillid", "conbillentryid"}, new DataType[]{DataType.BigDecimalType, DataType.BigDecimalType, DataType.LongType, DataType.BigDecimalType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType});
        if (contractInfoList.size() > 0) {
            HashSet<Long> conEntryIds = new HashSet<Long>(contractInfoList.size());
            for (Object[] obj : contractInfoList) {
                Long conbillEntryid = (Long)obj[8];
                conEntryIds.add(conbillEntryid);
            }
            DataSet cverifyInfo = Algo.create((String)"verifyInfo").createDataSet(contractInfoList.iterator(), verifyMeta);
            DataSet cContracts = QueryServiceHelper.queryDataSet((String)"queryContract", (String)contractEntity, (String)"billentry.id as centryid,billentry.material.masterid as cmaterial,billentry.unit as cunit,billentry.entrysettleorg as corg", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", conEntryIds)}, null);
            DataSet imContractInfo = cverifyInfo.join(cContracts, JoinType.INNER).on("conbillentryid", "centryid").on("org", "corg").select(new String[]{"verifyQty", "verifyBaseQty", "measureunit", "verifyAmt"}, new String[]{"centryid", "cmaterial", "cunit"}).finish();
            result = result.union(imContractInfo);
        }
        if (mainBillInfoList.size() > 0) {
            DataSet mverifyInfo = Algo.create((String)"verifyInfo").createDataSet(mainBillInfoList.iterator(), verifyMeta);
            HashSet<Long> orderEntryIds = new HashSet<Long>(mainBillInfoList.size());
            for (Object[] orderEntry : mainBillInfoList) {
                orderEntryIds.add((Long)orderEntry[5]);
            }
            DataSet mOrders = QueryServiceHelper.queryDataSet((String)"queryOrder", (String)orderEntity, (String)"billentry.id as oentryid,billentry.srcbillentryid as srcbillentryid,billentry.conbillentity as conbillentity,billentry.conbillid as conbillid,billentry.conbillentryid as conbillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", orderEntryIds), new QFilter("billentry.srcbillentity", "=", (Object)contractEntity).or(new QFilter("billentry.conbillentity", "=", (Object)contractEntity))}, null);
            HashSet<Long> conEntryIds = new HashSet<Long>(orderEntryIds.size());
            DataSet ordersCopy = mOrders.copy();
            while (ordersCopy.hasNext()) {
                Row row = ordersCopy.next();
                conEntryIds.add(row.getLong("srcbillentryid"));
                conEntryIds.add(row.getLong("conbillentryid"));
            }
            if (conEntryIds.size() > 0) {
                DataSet mOrderVerifyInfo = mverifyInfo.join(mOrders, JoinType.INNER).on("mainBillEntryid", "oentryid").select(new String[]{"verifyQty", "verifyBaseQty", "measureunit", "verifyAmt", "org"}, new String[]{"srcbillentryid", "conbillentity", "conbillentryid"}).finish();
                DataSet mContracts = QueryServiceHelper.queryDataSet((String)"queryContract", (String)contractEntity, (String)"billentry.id as centryid,billentry.material.masterid as cmaterial,billentry.unit as cunit,billentry.entrysettleorg as corg", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", conEntryIds)}, null);
                DataSet orderContractInfo = mOrderVerifyInfo.copy().filter("conbillentryid != 0").join(mContracts.copy(), JoinType.INNER).on("conbillentryid", "centryid").on("org", "corg").select(new String[]{"verifyQty", "verifyBaseQty", "measureunit", "verifyAmt"}, new String[]{"centryid", "cmaterial", "cunit"}).finish();
                result = result.union(orderContractInfo);
                DataSet orderSrcBillInfo = mOrderVerifyInfo.filter("conbillentryid = 0").join(mContracts, JoinType.INNER).on("srcbillentryid", "centryid").on("org", "corg").select(new String[]{"verifyQty", "verifyBaseQty", "measureunit", "verifyAmt"}, new String[]{"centryid", "cmaterial", "cunit"}).finish();
                result = result.union(orderSrcBillInfo);
            }
        }
        ArrayList<WriteBackContractModel> list = new ArrayList<WriteBackContractModel>(info.size());
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> unitIds = new HashSet<Long>(16);
        while (result.hasNext()) {
            Row row = result.next();
            BigDecimal verifyQty = row.getBigDecimal("verifyQty");
            BigDecimal verifyBaseQty = row.getBigDecimal("verifyBaseQty");
            BigDecimal verifyAmt = row.getBigDecimal("verifyAmt");
            Long measureunit = row.getLong("measureunit");
            Long centryid = row.getLong("centryid");
            Long cmaterial = row.getLong("cmaterial");
            Long cunit = row.getLong("cunit");
            list.add(new WriteBackContractModel(verifyQty, verifyBaseQty, verifyAmt, measureunit, centryid, cmaterial, cunit));
            materialIds.add(cmaterial);
            unitIds.add(cunit);
            unitIds.add(measureunit);
        }
        QFilter materialFilter = new QFilter("id", "in", materialIds);
        QFilter unitFilter = new QFilter("id", "in", unitIds);
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray(), null);
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id, precision, precisionaccount", (QFilter[])unitFilter.toArray(), null);
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(list.size());
        for (WriteBackContractModel obj : list) {
            Long modelUnitId = obj.getVerifyUnit();
            Long orderUnitId = obj.getCunit();
            BigDecimal verifyQty = obj.getVerifyQty();
            BigDecimal verifyBaseQty = obj.getVerifyBaseQty();
            BigDecimal verifyAmt = obj.getVerifyAmt();
            Long centryid = obj.getCentryid();
            if (modelUnitId.compareTo(orderUnitId) != 0) {
                Long masterid = obj.getCmaterial();
                DynamicObject material = (DynamicObject)materialMap.get(masterid);
                DynamicObject modelUnit = (DynamicObject)unitMap.get(modelUnitId);
                DynamicObject orderUnit = (DynamicObject)unitMap.get(orderUnitId);
                verifyQty = BillUnitAndQtytHelper.getDesQtyConv(material, modelUnit, verifyQty, orderUnit);
            }
            resultList.add(new Object[]{verifyQty, verifyBaseQty, verifyAmt, centryid});
        }
        logger.info("wbContractParams:" + JSON.toJSONString(resultList));
        return resultList;
    }
}

