/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.utils.ArrayUtils;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class WarehouseHelper {
    private static final String algoKey = "kd.scmc.im.business.helper.WarehouseHelper";

    public static Long[] getAllFinishInitWarehouseIDs(Long orgId) {
        QFilter qFilter1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter qFilter2 = new QFilter("initstatus", "=", (Object)"B");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, null);
        return WarehouseHelper.getWarehouseID(dataSet);
    }

    public static Map<Long, Long[]> getAllFinishInitWarehouseIDsByOrgIds(Long[] orgIds) {
        HashMap<Long, Long[]> getWarehouseIDs = new HashMap<Long, Long[]>(orgIds.length);
        for (Long orgId : orgIds) {
            getWarehouseIDs.put(orgId, WarehouseHelper.getAllFinishInitWarehouseIDs(orgId));
        }
        return getWarehouseIDs;
    }

    public static List<Long> getAllFinishInitWarehouseIDsByOrgIds(List<Long> orgIds) {
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        QFilter qFilter = new QFilter("org.id", "in", orgIds).and("initstatus", "=", (Object)"B").and("enable", "=", (Object)"1");
        Map whsSetupMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{qFilter});
        if (whsSetupMap == null || whsSetupMap.isEmpty()) {
            return wareHouseIds;
        }
        for (Map.Entry whsSetupEntry : whsSetupMap.entrySet()) {
            DynamicObject whsSetup = (DynamicObject)whsSetupEntry.getValue();
            DynamicObject warehouse = whsSetup.getDynamicObject("warehouse");
            if (warehouse == null) continue;
            wareHouseIds.add(warehouse.getLong("id"));
        }
        return wareHouseIds;
    }

    public static Long[] getAllFinishInitWarehouseNum(String orgNum) {
        QFilter qFilter1 = new QFilter("org.number", "=", (Object)orgNum);
        QFilter qFilter2 = new QFilter("initstatus", "=", (Object)"B");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, null);
        return WarehouseHelper.getWarehouseID(dataSet);
    }

    public static Long[] getWarehouseIDsByOrg(Long orgID, boolean isConsiderStatus) {
        if (isConsiderStatus) {
            return WarehouseHelper.getAllFinishInitWarehouseIDs(orgID);
        }
        QFilter qFilter = new QFilter("org.id", "=", (Object)orgID);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{qFilter}, null);
        return WarehouseHelper.getWarehouseID(dataSet);
    }

    public static Long[] getAllUnFinishInitWarehouseIDs(Long orgID) {
        QFilter orgf = new QFilter("org", "=", (Object)orgID);
        orgf.and(new QFilter("initstatus", "=", (Object)"A"));
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{orgf}, null);
        return WarehouseHelper.getWarehouseID(dataSet);
    }

    public static Long[] getAllUnFinishInitWarehouseNum(String orgNum) {
        QFilter orgf = new QFilter("org.number", "=", (Object)orgNum);
        orgf.and(new QFilter("initstatus", "=", (Object)"A"));
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{orgf}, null);
        return WarehouseHelper.getWarehouseID(dataSet);
    }

    public static boolean isFinishInit(Long orgID, Long warehouseID) {
        QFilter qFilter1 = new QFilter("warehouse.id", "=", (Object)warehouseID);
        QFilter qFilter2 = new QFilter("initstatus", "=", (Object)"B");
        QFilter orgf = new QFilter("org.id", "=", (Object)orgID);
        DynamicObject whSet = BusinessDataServiceHelper.loadSingleFromCache((String)"im_warehousesetup", (QFilter[])new QFilter[]{qFilter1, qFilter2, orgf});
        return !CommonUtils.isNull((Object)whSet);
    }

    public static ArrayList<DynamicObject> isFinishInit(Long orgID, ArrayList<DynamicObject> warehouses, boolean isFinished) {
        if (CommonUtils.isNull(warehouses)) {
            return null;
        }
        Object[] warehouseIDs = new Object[warehouses.size()];
        for (int i = 0; i < warehouses.size(); ++i) {
            warehouseIDs[i] = warehouses.get(i).get("id");
        }
        QFilter qFilter1 = new QFilter("warehouse.id", "in", (Object)warehouseIDs);
        QFilter qFilter2 = new QFilter("initstatus", "=", (Object)"B");
        QFilter orgf = new QFilter("org.id", "=", (Object)orgID);
        Map whSets = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{qFilter1, qFilter2, orgf});
        if (isFinished) {
            if (CommonUtils.isNull((Object)whSets)) {
                return null;
            }
            ArrayList<DynamicObject> finished = new ArrayList<DynamicObject>();
            for (DynamicObject whSet : whSets.values()) {
                finished.add(whSet.getDynamicObject("warehouse"));
            }
            return finished;
        }
        ArrayList<DynamicObject> unfinished = new ArrayList<DynamicObject>();
        Collection whSetCol = whSets.values();
        if (CommonUtils.isNull(whSetCol)) {
            return warehouses;
        }
        for (DynamicObject wh : warehouses) {
            boolean isExist = false;
            Object whId = wh.getPkValue();
            for (DynamicObject whSet : whSetCol) {
                if (!whId.equals(whSet.getDynamicObject("warehouse").getPkValue())) continue;
                isExist = true;
            }
            if (isExist) continue;
            unfinished.add(wh);
        }
        return unfinished;
    }

    public static Map<Object, DynamicObject> getAllUnInitWarehouse(HashMap<Long, Set<Long>> orgWarehouseMap) {
        Map<Object, Object> result = new HashMap<Object, DynamicObject>();
        if (CommonUtils.isNull(orgWarehouseMap)) {
            return result;
        }
        QFilter filter = WarehouseHelper.buildUnInitFilter(orgWarehouseMap, "A");
        result = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])new QFilter[]{filter});
        return result;
    }

    public static List<Long> getAllWarehouse(String orgNum) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (CommonUtils.isNull((Object)orgNum)) {
            return result;
        }
        QFilter orgf = new QFilter("org.number", "=", (Object)orgNum);
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        String selects = "warehouse.id";
        Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{orgf});
        Map warehouseMap = ArrayUtils.getDynamicObjectMap((String)selects, (DynamicObject[])warehouseDycs.values().toArray(new DynamicObject[0]));
        result = new ArrayList(warehouseMap.keySet());
        return result;
    }

    public static List<Long> getAllWarehouse(List<Object> orgIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (CommonUtils.isNull(orgIds)) {
            return result;
        }
        QFilter orgf = new QFilter("org", "in", (Object)orgIds.toArray());
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        String selects = "warehouse.id";
        try (DataSet whSetUpData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{orgf}, null);){
            while (whSetUpData.hasNext()) {
                Row next = whSetUpData.next();
                result.add(next.getLong(selects));
            }
        }
        return result;
    }

    public static Map<String, Date> getOrgWarehouseSetupTime(Map<Long, Set<Long>> orgWarehouseMap) {
        if (CommonUtils.isNull(orgWarehouseMap)) {
            return new HashMap<String, Date>();
        }
        QFilter filter = WarehouseHelper.getOrgWarehouseFilter(orgWarehouseMap);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_warehousesetup", (String)"warehouse.id,org.id,startdate,createtime", (QFilter[])new QFilter[]{filter}, null);
        HashMap<String, Date> result = new HashMap<String, Date>(64);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            Long whId = next.getLong("warehouse.id");
            Long orgId = next.getLong("org.id");
            StringBuilder sb = new StringBuilder();
            sb.append(orgId);
            sb.append(',');
            sb.append(whId);
            Date startupDate = next.getDate("startdate");
            startupDate = startupDate == null ? DateUtils.getDate((Date)next.getDate("createtime")) : startupDate;
            result.put(sb.toString(), startupDate);
        }
        return result;
    }

    public static List<DynamicObject> getOrgWarehouseSetupTimeDyc(Map<Long, Set<Long>> orgWarehouseMap) {
        List<Object> result = new ArrayList<DynamicObject>();
        if (CommonUtils.isNull(orgWarehouseMap)) {
            return result;
        }
        QFilter filter = WarehouseHelper.getOrgWarehouseFilter(orgWarehouseMap);
        List<String> properties = Arrays.asList("org", "warehouse", "startdate", "createtime");
        String selects = StringUtils.join((Object[])properties.toArray(), (String)",");
        Map wareHouseSetupDycMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selects, (QFilter[])new QFilter[]{filter});
        result = wareHouseSetupDycMap.values().stream().collect(Collectors.toList());
        return result;
    }

    public static DynamicObject[] getSetupOrgWarehouse(String setupStatus, QFilter filter) {
        QFilter unSetupF = new QFilter("startstatus", "=", (Object)setupStatus);
        unSetupF = filter == null ? unSetupF : unSetupF.and(filter);
        String selects = "startstatus,startdate,warehouse";
        Map resultFromCache = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)selects, (QFilter[])unSetupF.toArray());
        return resultFromCache.values().toArray(new DynamicObject[0]);
    }

    public static boolean isCan4Init(Long orgId, Long warehouseID) {
        return WarehouseHelper.isCan4InitOrInv(orgId, warehouseID, false);
    }

    private static boolean isCan4InitOrInv(Long orgId, Long warehouseID, boolean isInv) {
        return WarehouseHelper.isSet(warehouseID) && WarehouseHelper.isFinishInit(orgId, warehouseID) && isInv;
    }

    public static boolean isCan4Inv(Long orgId, Long warehouseID) {
        return WarehouseHelper.isCan4InitOrInv(orgId, warehouseID, true);
    }

    public static boolean isExistWarehouseSet(Long warehouseID) {
        return WarehouseHelper.isSet(warehouseID);
    }

    public static Long[] getAllWarehouseIDs(Long orgID) {
        return WarehouseHelper.getAllWarehouse(Collections.singletonList(orgID)).toArray(new Long[0]);
    }

    public static Long[] getAllWarehouseIDsNum(String orgNum) {
        return WarehouseHelper.getAllWarehouse(orgNum).toArray(new Long[0]);
    }

    public static Map<Long, DynamicObject> getAllWarehouseSetup(Long orgId, DynamicObjectCollection dtCol, String warehouseKey) {
        HashSet<Long> whIds = new HashSet<Long>();
        for (DynamicObject dymCol : dtCol) {
            DynamicObject wh = dymCol.getDynamicObject(warehouseKey);
            if (wh == null) continue;
            Long whId = (Long)wh.getPkValue();
            whIds.add(whId);
        }
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and(new QFilter("warehouse.id", "in", whIds));
        Map setUps = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"operatoruser, materialgrpnumber, materialnumber, materialmasterid,warehouse", (QFilter[])new QFilter[]{filter});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(setUps.size());
        for (DynamicObject setupDym : setUps.values()) {
            DynamicObject warehouse = setupDym.getDynamicObject("warehouse");
            Long whId = (Long)warehouse.getPkValue();
            map.put(whId, setupDym);
        }
        return map;
    }

    public static Map<Long, DynamicObject> getAllWarehouseSetup(Long orgId, DynamicObjectCollection dtCol, String warehouseKey, String formId) {
        HashSet<Long> whIds = new HashSet<Long>();
        for (DynamicObject dymCol : dtCol) {
            DynamicObject wh = dymCol.getDynamicObject(warehouseKey);
            if (wh == null) continue;
            Long whId = (Long)wh.getPkValue();
            whIds.add(whId);
            if (!"im_disassemblebill".equals(formId) && !"im_assembbill".equals(formId) && !"im_adjustbill".equals(formId)) continue;
            DynamicObjectCollection afterEntries = dymCol.getDynamicObjectCollection("afterentity");
            for (DynamicObject afterEntry : afterEntries) {
                DynamicObject afterWarehouse = afterEntry.getDynamicObject("warehouse1");
                if (afterWarehouse == null) continue;
                whIds.add((Long)afterWarehouse.getPkValue());
            }
        }
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        filter.and(new QFilter("warehouse.id", "in", whIds));
        Map setUps = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"operatoruser, materialgrpnumber, materialnumber, materialmasterid,warehouse", (QFilter[])new QFilter[]{filter});
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(setUps.size());
        for (DynamicObject setupDym : setUps.values()) {
            DynamicObject warehouse = setupDym.getDynamicObject("warehouse");
            Long whId = (Long)warehouse.getPkValue();
            map.put(whId, setupDym);
        }
        return map;
    }

    private static QFilter getOrgWarehouseFilter(Map<Long, Set<Long>> orgWarehouseMap) {
        QFilter orgWarehouseFilters = null;
        for (Map.Entry<Long, Set<Long>> entry : orgWarehouseMap.entrySet()) {
            QFilter orgf = new QFilter("org.id", "=", (Object)entry.getKey());
            QFilter orgWarehousef = new QFilter("warehouse.id", "in", (Object)entry.getValue().toArray());
            orgWarehousef.and(orgf);
            orgWarehouseFilters = orgWarehouseFilters == null ? orgWarehousef : orgWarehouseFilters.or(orgWarehousef);
        }
        return orgWarehouseFilters;
    }

    private static QFilter buildUnInitFilter(Map<Long, Set<Long>> orgWarehouseMap, String initStatus) {
        QFilter orgWarehouseFilters = WarehouseHelper.getOrgWarehouseFilter(orgWarehouseMap);
        return orgWarehouseFilters == null ? null : orgWarehouseFilters.and(new QFilter("initstatus", "=", (Object)initStatus));
    }

    private static boolean isSet(Long warehouseID) {
        QFilter qFilter1 = new QFilter("warehouse.id", "=", (Object)warehouseID);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObject whSet = BusinessDataServiceHelper.loadSingleFromCache((String)"im_warehousesetup", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return !CommonUtils.isNull((Object)whSet);
    }

    private static Long[] getWarehouseID(DataSet whsSetup) {
        ArrayList<Long> warehouseIDs = new ArrayList<Long>(16);
        while (whsSetup.hasNext()) {
            Row next = whsSetup.next();
            Long whId = next.getLong("warehouse.id");
            if (whId == null || whId == 0L) continue;
            warehouseIDs.add(whId);
        }
        return warehouseIDs.toArray(new Long[0]);
    }

    public static Set<Long> getAllInitOrgId() {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"org", (QFilter[])new QFilter("initstatus", "=", (Object)"B").toArray());
        if (objectDynamicObjectMap == null) {
            return orgIds;
        }
        for (DynamicObject item : objectDynamicObjectMap.values()) {
            DynamicObject org = item.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    public static QFilter buildLocationQFilter(DynamicObject warehouse) {
        if (null == warehouse) {
            return null;
        }
        List<Long> locationIds = WarehouseHelper.getLocationIds(warehouse.getPkValue());
        return new QFilter("id", "in", locationIds);
    }

    public static List<Long> getLocationIds(Object whId) {
        ArrayList<Long> locationIds = new ArrayList<Long>(2);
        QFilter qFilter = new QFilter("id", "=", whId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WarehouseHelper.class.getName(), (String)"bd_warehouse", (String)"entryentity.location location", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long locationId = row.getLong("location");
                locationIds.add(locationId);
            }
        }
        return locationIds;
    }

    public static Set<Long> getWarehouseIds(Object locationId) {
        HashSet<Long> warehouseIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("entryentity.location", "=", locationId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WarehouseHelper.class.getName(), (String)"bd_warehouse", (String)"id", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                warehouseIds.add(id);
            }
        }
        return warehouseIds;
    }

    public static Map<Object, List<Long>> getWarehouseAndLocationIds(Set<Object> warehousePkvalues) {
        HashMap<Object, List<Long>> warehouseAndLocationIds = new HashMap<Object, List<Long>>(warehousePkvalues.size());
        QFilter qFilter = new QFilter("id", "in", warehousePkvalues);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)WarehouseHelper.class.getName(), (String)"bd_warehouse", (String)"id,entryentity.location location", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                List locationIds = warehouseAndLocationIds.computeIfAbsent(row.get("id"), fun -> new ArrayList());
                Long locationId = row.getLong("location");
                locationIds.add(locationId);
            }
        }
        return warehouseAndLocationIds;
    }

    public static final boolean containLocationInWarehouse(Long warehouseId, Long locationId) {
        QFilter qFilter = new QFilter("id", "=", (Object)warehouseId);
        qFilter.and("entryentity.location", "=", (Object)locationId);
        return QueryServiceHelper.exists((String)"bd_warehouse", (QFilter[])qFilter.toArray());
    }
}

