/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.acct;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balance.BalanceUpdateHandle;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.acct.BalanceRecordUpdateParams;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.enums.BalanceTypeEnum;
import kd.scmc.im.utils.ArrayUtils;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.IDGenerator;

public class BalanceHelper {
    private static final int MAX_RECORD_NUM = 1024;
    private static final Set<String> SPBILLS = new HashSet<String>(Arrays.asList("im_adjustbill", "im_assembbill", "im_locationtransfer", "im_disassemblebill"));
    private static final String[] balUnionf = new String[]{"0L as balanceid", "0 as oldbgnqty", "0 as oldbgnbaseqty", "0 as oldbgnqty2nd", "0 as oldendqty", "0 as oldendbaseqty", "0 as oldendqty2nd", "0 as oldinqty", "0 as oldinbaseqty", "0 as oldinqty2nd", "0 as oldoutqty", "0 as oldoutbaseqty", "0 as oldoutqty2nd", "0 as bgnqty", "0 as bgnbaseqty", "0 as bgnqty2nd", "0 as endqty", "0 as endbaseqty", "0 as endqty2nd"};
    private static final String[] balSels = new String[]{"id as balanceid", "period as balperiod", "oldbgnqty", "oldbgnbaseqty", "oldbgnqty2nd", "oldinqty", "oldinbaseqty", "oldinqty2nd", "oldoutqty", "oldoutbaseqty", "oldoutqty2nd", "oldendqty", "oldendbaseqty", "oldendqty2nd"};
    private static final String PERIOD = "period";
    private static final String ENDPERIOD = "endperiod";
    private static final String BILLPERIOD = "billperiod";
    private static final String BILLENDPERIOD = "billendperiod";
    private static final String BALPERIOD = "balperiod";
    private static final String BALANCEID = "balanceid";

    public static void initBalanceUpdate(String formId, List<Long> ids) {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return;
        }
        String selets = InvBalanceConst.getInitSelects();
        QFilter idf = new QFilter("id", "in", ids);
        try (DataSet billsData = BalanceHelper.getBillDataSet(formId, idf.toArray(), selets);){
            BalanceHelper.calInitBalanceData(billsData.copy(), false, true, false);
            BalanceHelper.calInitBalanceData(billsData, true, true, false);
        }
        BalanceHelper.recordSnapInfo(formId, idf);
    }

    public static void calInitBalanceData(DataSet billsData, boolean recordAccountBalance, boolean isPositive, boolean reCalAll) {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return;
        }
        if (recordAccountBalance) {
            billsData = billsData.filter("invtypeisforwardamount=True and ownertype='bos_org'");
        }
        try (DataSet billSumData = BalanceHelper.getInitSumData(billsData, recordAccountBalance, reCalAll);){
            HashMap<String, List<BalanceRecordUpdateParams>> updateDimStrBalidParamsMap = new HashMap<String, List<BalanceRecordUpdateParams>>(16);
            HashMap<String, DynamicObject> dimDateStrNewBalMap = new HashMap<String, DynamicObject>(16);
            HashSet<String> hasMatch = new HashSet<String>(16);
            int count = 0;
            String preDimStr = "";
            MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)"im_invbalance");
            IDGenerator idGenerator = new IDGenerator(targetDataEntityType.getAlias());
            for (Row row : billSumData) {
                String dimStr = BalanceHelper.getDimStr(row);
                String dimDateStr = dimStr + row.getInteger(BILLPERIOD);
                if (count >= 1024 && !dimStr.equals(preDimStr)) {
                    BalanceHelper.saveInitBalanceRecord(updateDimStrBalidParamsMap, dimDateStrNewBalMap.values());
                    updateDimStrBalidParamsMap = new HashMap(16);
                    dimDateStrNewBalMap = new HashMap(16);
                    hasMatch = new HashSet(16);
                    count = 0;
                }
                preDimStr = dimStr;
                BalanceRecordUpdateParams balIdParams = new BalanceRecordUpdateParams();
                ArrayList<BalanceRecordUpdateParams> balanceRecordUpdateParams = (ArrayList<BalanceRecordUpdateParams>)updateDimStrBalidParamsMap.get(dimStr);
                if (balanceRecordUpdateParams == null) {
                    balanceRecordUpdateParams = new ArrayList<BalanceRecordUpdateParams>(16);
                    updateDimStrBalidParamsMap.put(dimStr, balanceRecordUpdateParams);
                }
                if (row.getLong(BALANCEID) == null || row.getLong(BALANCEID).equals(0L)) {
                    balIdParams.setBalId(idGenerator.getIdByTabName());
                    balIdParams.setNewBalRecord(true);
                    balanceRecordUpdateParams.add(balIdParams);
                    BalanceHelper.setQty4Update(row, balIdParams);
                    dimDateStrNewBalMap.put(dimDateStr, BalanceHelper.createNewBalDyc(recordAccountBalance, row, dimStr, balIdParams.getBalId(), true));
                } else if (row.getInteger(BILLPERIOD).compareTo(row.getInteger(BALPERIOD)) == 0) {
                    balIdParams.setBalId(row.getLong(BALANCEID));
                    BalanceHelper.setInitQtyUpdateParams(isPositive, row, balIdParams);
                    balanceRecordUpdateParams.add(balIdParams);
                    hasMatch.add(dimDateStr);
                } else {
                    if (hasMatch.add(dimDateStr)) {
                        balIdParams.setBalId(idGenerator.getIdByTabName());
                        balIdParams.setEndPeriod(row.getInteger(BALPERIOD));
                        balIdParams.setNewBalRecord(true);
                        BalanceHelper.setInitQtyUpdateParams(isPositive, row, balIdParams);
                        dimDateStrNewBalMap.put(dimDateStr, BalanceHelper.createNewBalDyc(recordAccountBalance, row, dimStr, balIdParams.getBalId(), true));
                        balanceRecordUpdateParams.add(balIdParams);
                    }
                    ((BalanceRecordUpdateParams)balanceRecordUpdateParams.get(0)).getAfterBalIds().add(row.getLong(BALANCEID));
                }
                ++count;
            }
            BalanceHelper.saveInitBalanceRecord(updateDimStrBalidParamsMap, dimDateStrNewBalMap.values());
        }
    }

    public static void unInitBalanceUpdate(String formId, List<Long> ids) {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return;
        }
        String selets = InvBalanceConst.getInitSelects();
        QFilter idf = new QFilter("id", "in", ids);
        try (DataSet billsData = BalanceHelper.getBillDataSet(formId, idf.toArray(), selets);){
            BalanceHelper.calInitBalanceData(billsData.copy(), false, false, false);
            BalanceHelper.calInitBalanceData(billsData, true, false, false);
            BalanceHelper.deleteSnapInfo(formId, ids);
        }
    }

    public static void auditBalanceUpdate(String formId, List<Long> ids) {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return;
        }
        try (DataSet recordInvBalanceDataSet = BalanceHelper.getBillRecAndSedInfos(formId, ids, false);
             DataSet recordAccountBalanceDataSet = BalanceHelper.getBillRecAndSedInfos(formId, ids, true);){
            BalanceHelper.calBillBalanceData(recordInvBalanceDataSet, false, true, false);
            BalanceHelper.calBillBalanceData(recordAccountBalanceDataSet, true, true, false);
            QFilter idf = new QFilter("id", "in", ids);
            BalanceHelper.recordSnapInfo(formId, idf);
        }
    }

    public static void unAuditBalanceUpdate(String formId, List<Long> ids) {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return;
        }
        try (DataSet recordInvBalanceDataSet = BalanceHelper.getBillRecAndSedInfos(formId, ids, false);
             DataSet recordAccountBalanceDataSet = BalanceHelper.getBillRecAndSedInfos(formId, ids, true);){
            BalanceHelper.calBillBalanceData(recordInvBalanceDataSet, false, false, false);
            BalanceHelper.calBillBalanceData(recordAccountBalanceDataSet, true, false, false);
            BalanceHelper.deleteSnapInfo(formId, ids);
        }
    }

    public static void calBillBalanceData(DataSet billsData, boolean recordAccountBalance, boolean isPositive, boolean reCalAll) {
        if (BalanceUpdateHandle.isNewPeriodBal()) {
            return;
        }
        try (DataSet billSumData = BalanceHelper.getBillSumData(billsData, recordAccountBalance, isPositive, reCalAll);){
            ArrayList<Object> newBalDycs = new ArrayList<DynamicObject>(16);
            ArrayList<Object> balUpdateParams = new ArrayList<Object[]>(16);
            ArrayList<Object> balEndPeriodParams = new ArrayList<Object[]>(16);
            int count = 0;
            String preDimStr = null;
            boolean preCreate = false;
            Long preBalId = 0L;
            MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)"im_invbalance");
            IDGenerator idGenerator = new IDGenerator(targetDataEntityType.getAlias());
            for (Row row : billSumData) {
                String dimStr = BalanceHelper.getDimStr(row);
                if (dimStr.equals(preDimStr) && preCreate) {
                    balEndPeriodParams.add(new Object[]{row.getLong(PERIOD), preBalId, row.getLong(PERIOD)});
                }
                preCreate = false;
                if (row.getLong(BALANCEID) == null || row.getLong(BALANCEID).equals(0L)) {
                    long balId = idGenerator.getIdByTabName();
                    newBalDycs.add(BalanceHelper.createNewBalDyc(recordAccountBalance, row, dimStr, balId, false));
                    preCreate = true;
                    preBalId = balId;
                    Long balRecordPreBalId = row.getLong("prebalid");
                    if (balRecordPreBalId != null && !balRecordPreBalId.equals(0L)) {
                        balEndPeriodParams.add(new Object[]{row.getLong(PERIOD), balRecordPreBalId, row.getLong(PERIOD)});
                    }
                } else {
                    Object[] updateParam = new Object[]{row.getBigDecimal("diffbgnqty"), row.getBigDecimal("diffbgnbaseqty"), row.getBigDecimal("diffbgnqty2nd"), row.getBigDecimal("diffinqty"), row.getBigDecimal("diffinbaseqty"), row.getBigDecimal("diffinqty2nd"), row.getBigDecimal("diffoutqty"), row.getBigDecimal("diffoutbaseqty"), row.getBigDecimal("diffoutqty2nd"), row.getBigDecimal("diffendqty"), row.getBigDecimal("diffendbaseqty"), row.getBigDecimal("diffendqty2nd"), row.getLong(BALANCEID)};
                    balUpdateParams.add(updateParam);
                }
                preDimStr = dimStr;
                if (++count < 1024) continue;
                BalanceHelper.saveBillBalanceRecord(newBalDycs, balUpdateParams, balEndPeriodParams);
                newBalDycs = new ArrayList(16);
                balUpdateParams = new ArrayList(16);
                balEndPeriodParams = new ArrayList(16);
                count = 0;
            }
            BalanceHelper.saveBillBalanceRecord(newBalDycs, balUpdateParams, balEndPeriodParams);
        }
    }

    private static DataSet getBalDs(QFilter balf, boolean recordAccountBalance) {
        String balSelects = StringUtils.join((Object[])InvBalanceConst.getBalAlls().toArray(), (String)",");
        QFilter balfs = recordAccountBalance ? new QFilter("balancetype", "=", (Object)BalanceTypeEnum.CalType.getType()) : new QFilter("balancetype", "=", (Object)BalanceTypeEnum.InvType.getType());
        if (balf != null) {
            balfs.and(balf);
        }
        DataSet invBalDs = QueryServiceHelper.queryDataSet((String)BalanceHelper.class.getName(), (String)"im_invbalance", (String)balSelects, (QFilter[])balfs.toArray(), null);
        return invBalDs;
    }

    private static DataSet getBillDataSet(String formId, QFilter[] filter, String select) {
        return QueryServiceHelper.queryDataSet((String)BalanceHelper.class.getName(), (String)formId, (String)select, (QFilter[])filter, null);
    }

    private static BigDecimal calculateEndQty(DynamicObject balUpdateDyc, String endQtyf, String bgnQtyf, String inQtyf, String outQtyf) {
        BigDecimal endQty = balUpdateDyc.getBigDecimal(bgnQtyf).add(balUpdateDyc.getBigDecimal(inQtyf)).subtract(balUpdateDyc.getBigDecimal(outQtyf));
        balUpdateDyc.set(endQtyf, (Object)endQty);
        return endQty;
    }

    private static QFilter getInOrOutUpdateFilter(String updateDc, String formId) {
        QFilter filter = new QFilter(updateDc, "=", (Object)true);
        filter.and(new QFilter("invscheme.isnotupdate", "=", (Object)false));
        DynamicProperty isVirtualBill = EntityMetadataCache.getDataEntityType((String)formId).getProperty("isvirtualbill");
        if (isVirtualBill != null && kd.bos.util.StringUtils.isNotEmpty((String)isVirtualBill.getAlias())) {
            filter.and(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
        }
        return filter;
    }

    private static String getDimStr(Row bill) {
        StringBuilder dimStrBuilder = new StringBuilder();
        List dims = InvBalanceConst.getGroups();
        for (String item : dims) {
            dimStrBuilder.append(bill.get(item)).append(",");
        }
        return BalanceHelper.getSHA256Base64Str(dimStrBuilder.toString().substring(0, dimStrBuilder.length() - 1));
    }

    private static DataSet getBillRecAndSedInfos(String formId, List<Long> ids, boolean recordAccountBalance) {
        QFilter outFilter;
        String outSelets;
        QFilter filter;
        String selets;
        if (formId.equals("im_adjustbill") || formId.equals("im_disassemblebill")) {
            selets = InvBalanceConst.getAdjInSelects();
            filter = BalanceHelper.getIdFilter(ids);
            outSelets = InvBalanceConst.getAdjOutSelects();
            outFilter = BalanceHelper.getIdFilter(ids);
            filter = recordAccountBalance ? filter.and(BalanceHelper.filterRecIsCal(formId)) : filter;
            outFilter = recordAccountBalance ? outFilter.and(BalanceHelper.filterSedIsCal(formId)) : outFilter;
        } else if (formId.equals("im_assembbill")) {
            selets = InvBalanceConst.getAssInSelects();
            filter = BalanceHelper.getIdFilter(ids);
            outSelets = InvBalanceConst.getAssOutSelects();
            outFilter = BalanceHelper.getIdFilter(ids);
            filter = recordAccountBalance ? filter.and(BalanceHelper.filterRecIsCal(formId)) : filter;
            outFilter = recordAccountBalance ? outFilter.and(BalanceHelper.filterSedIsCal(formId)) : outFilter;
        } else if (formId.equals("im_locationtransfer")) {
            selets = InvBalanceConst.getLocInSelects();
            filter = BalanceHelper.getIdFilter(ids);
            outSelets = InvBalanceConst.getLocOutSelects();
            outFilter = BalanceHelper.getIdFilter(ids);
            filter = recordAccountBalance ? filter.and(BalanceHelper.filterRecIsCal(formId)) : filter;
            outFilter = recordAccountBalance ? outFilter.and(BalanceHelper.filterSedIsCal(formId)) : outFilter;
        } else {
            boolean isDirBill = formId.equalsIgnoreCase("im_transdirbill");
            selets = isDirBill ? InvBalanceConst.getDirInSelects() : InvBalanceConst.getInSelects();
            String inUpdatef = "invscheme.isinupdate";
            if (recordAccountBalance) {
                filter = BalanceHelper.getIdFilter(ids);
                filter.and(BalanceHelper.filterRecIsCal(formId));
                filter.and(new QFilter(inUpdatef, "=", (Object)true));
            } else {
                filter = BalanceHelper.getIdFilter(ids);
                filter.and(BalanceHelper.getInOrOutUpdateFilter(inUpdatef, formId));
            }
            BalanceHelper.filterIsInitBill(formId, filter);
            outSelets = isDirBill ? InvBalanceConst.getDirOutSelects() : InvBalanceConst.getOutSelects();
            String outUpdatef = "invscheme.isoutupdate";
            if (recordAccountBalance) {
                outFilter = BalanceHelper.getIdFilter(ids);
                outFilter.and(BalanceHelper.filterSedIsCal(formId));
                outFilter.and(new QFilter(outUpdatef, "=", (Object)true));
            } else {
                outFilter = BalanceHelper.getIdFilter(ids);
                outFilter.and(BalanceHelper.getInOrOutUpdateFilter(outUpdatef, formId));
            }
            BalanceHelper.filterIsInitBill(formId, outFilter);
        }
        DataSet billData = BalanceHelper.getBillDataSet(formId, filter.toArray(), selets);
        billData = billData.union(BalanceHelper.getBillDataSet(formId, outFilter.toArray(), outSelets));
        return billData;
    }

    private static QFilter filterRecIsCal(String formId) {
        String invCalf = null;
        invCalf = formId.equals("im_adjustbill") || formId.equals("im_disassemblebill") ? "billentry.afterentity.invtype1.isforwardamount" : "billentry.invtype.isforwardamount";
        QFilter filters = new QFilter(invCalf, "=", (Object)true);
        String ownerf = null;
        ownerf = formId.equals("im_adjustbill") || formId.equals("im_disassemblebill") ? "billentry.afterentity.ownertype1" : "billentry.ownertype";
        filters.and(new QFilter(ownerf, "=", (Object)"bos_org"));
        if (!SPBILLS.contains(formId)) {
            filters.and(new QFilter("invscheme.isforwardamount", "=", (Object)true));
        }
        if (!SPBILLS.contains(formId) || "im_locationtransfer".equals(formId)) {
            filters.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        }
        return filters;
    }

    private static QFilter filterSedIsCal(String formId) {
        QFilter filters = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (!SPBILLS.contains(formId)) {
            filters.and(new QFilter("invscheme.isforwardamount", "=", (Object)true));
            filters.and(new QFilter("billentry.outinvtype.isforwardamount", "=", (Object)true));
            filters.and(new QFilter("billentry.outownertype", "=", (Object)"bos_org"));
        } else {
            String invCalf = "im_assembbill".equals(formId) ? "billentry.afterentity.invtype1.isforwardamount" : "billentry.invtype.isforwardamount";
            filters.and(new QFilter(invCalf, "=", (Object)true));
            String outOwnerf = "im_assembbill".equals(formId) ? "billentry.afterentity.ownertype1" : "billentry.ownertype";
            filters.and(new QFilter(outOwnerf, "=", (Object)"bos_org"));
        }
        if (!SPBILLS.contains(formId) || "im_locationtransfer".equals(formId)) {
            filters.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        }
        return filters;
    }

    private static void deleteSnapInfo(String formId, List<Long> ids) {
        QFilter billf = new QFilter("formid", "=", (Object)formId);
        billf.and(new QFilter("billid", "in", ids));
        DeleteServiceHelper.delete((String)"im_invsnapshoot", (QFilter[])billf.toArray());
    }

    private static QFilter filterIsInitBill(String formId, QFilter balfs) {
        if (balfs != null && MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId), "isinitbill")) {
            balfs.and(new QFilter("isinitbill", "=", (Object)false));
        }
        return balfs;
    }

    private static void saveInitBalanceRecord(Map<String, List<BalanceRecordUpdateParams>> updateDimStrBalidParamsMap, Collection<DynamicObject> newBals) {
        if (newBals.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newBals.toArray(new DynamicObject[0]));
        }
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> endPeriodParams = new ArrayList<Object[]>(16);
        for (List<BalanceRecordUpdateParams> item : updateDimStrBalidParamsMap.values()) {
            for (BalanceRecordUpdateParams update : item) {
                if (!update.isNewBalRecord()) {
                    sqlParams.add(new Object[]{update.getBgnQtyDiff(), update.getBgnBaseQtyDiff(), update.getBgn2ndQtyDiff(), update.getRecQty(), update.getRecBaseQty(), update.getRec2ndQty(), update.getSedQty(), update.getSedBaseQty(), update.getSed2ndQty(), update.getEndQtyDiff(), update.getEndBaseQtyDiff(), update.getEnd2ndQtyDiff(), update.getBalId()});
                }
                if (update.getEndPeriod() != -1) {
                    endPeriodParams.add(new Object[]{update.getEndPeriod(), update.getBalId()});
                }
                for (Long afterBalId : update.getAfterBalIds()) {
                    sqlParams.add(new Object[]{update.getEndQtyDiff(), update.getEndBaseQtyDiff(), update.getEnd2ndQtyDiff(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, update.getEndQtyDiff(), update.getEndBaseQtyDiff(), update.getEnd2ndQtyDiff(), afterBalId});
                }
            }
        }
        if (sqlParams.size() > 0) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)"update t_im_invbalance set fbgnqty = fbgnqty + ?, fbgnbaseqty = fbgnbaseqty + ?, fbgnqty2nd = fbgnqty2nd + ?,finqty = finqty + ?, finbaseqty = finbaseqty + ?,  finqty2nd = finqty2nd + ?,foutqty = foutqty + ?, foutbaseqty = foutbaseqty + ?, foutqty2nd = foutqty2nd + ?,fendqty = fendqty + ?, fendbaseqty = fendbaseqty + ?, fendqty2nd = fendqty2nd + ? where fid = ? ", sqlParams);
        }
        if (endPeriodParams.size() > 0) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)"update t_im_invbalance set fendperiod = ? where fid = ?", endPeriodParams);
        }
    }

    private static void saveBillBalanceRecord(List<DynamicObject> newBalDycs, List<Object[]> balUpdateParams, List<Object[]> balEndPeriodParams) {
        if (newBalDycs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newBalDycs.toArray(new DynamicObject[0]));
        }
        if (balUpdateParams.size() > 0) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)"update t_im_invbalance set fbgnqty = fbgnqty + ?, fbgnbaseqty = fbgnbaseqty + ?, fbgnqty2nd = fbgnqty2nd + ?,finqty = finqty + ?, finbaseqty = finbaseqty + ?,  finqty2nd = finqty2nd + ?,foutqty = foutqty + ?, foutbaseqty = foutbaseqty + ?, foutqty2nd = foutqty2nd + ?,fendqty = fendqty + ?, fendbaseqty = fendbaseqty + ?, fendqty2nd = fendqty2nd + ? where fid = ? ", balUpdateParams);
        }
        if (balEndPeriodParams.size() > 0) {
            DB.executeBatch((DBRoute)new DBRoute("im"), (String)"update t_im_invbalance set fendperiod = ? where fid = ? and fendperiod > ?", balEndPeriodParams);
        }
    }

    private static DataSet getBillSumData(DataSet billsData, boolean recordAccountBalance, boolean isPositive, boolean reCalAll) {
        QFilter orgWarehouseFilter = BalanceHelper.getBalOrgWarehouseFilter(billsData, reCalAll);
        billsData = billsData.addField("year(biztime)*100 + month(biztime)", PERIOD);
        List groups = InvBalanceConst.getGroups();
        String[] groupsString = (String[])ArrayUtils.concatAll((Object[])groups.toArray(new String[0]), (Object[][])new String[][]{{PERIOD}});
        billsData = BalanceHelper.sumRecAndSedQty(billsData, isPositive, groupsString);
        billsData = billsData.addField("999999", ENDPERIOD);
        String[] unionSelects = (String[])ArrayUtils.concatAll((Object[])billsData.getRowMeta().getFieldNames(), (Object[][])new String[][]{balUnionf});
        billsData = billsData.select(unionSelects);
        DataSet balDs = BalanceHelper.getBalDs(orgWarehouseFilter, recordAccountBalance);
        balDs = balDs.addField("id", BALANCEID);
        balDs = balDs.select(billsData.getRowMeta().getFieldNames());
        billsData = billsData.union(balDs);
        GroupbyDataSet billBalGroupDs = billsData.groupBy(groupsString).min(ENDPERIOD);
        for (String qtyf : InvBalanceConst.getBalAllQtyList()) {
            billBalGroupDs = billBalGroupDs.sum(qtyf);
            billBalGroupDs = billBalGroupDs.sum("old" + qtyf);
        }
        billsData = billBalGroupDs.max(BALANCEID).finish();
        billsData = billsData.addField("0", "diffendqty");
        billsData = billsData.addField("0", "diffendbaseqty");
        billsData = billsData.addField("0", "diffendqty2nd");
        groups.add(PERIOD);
        billsData = billsData.orderBy(groups.toArray(new String[0]));
        billsData = billsData.addField("0L", "prebalid");
        billsData = BalanceHelper.endQtyToBgnQty(billsData);
        billsData = billsData.addField("bgnqty - oldbgnqty", "diffbgnqty");
        billsData = billsData.addField("bgnbaseqty - oldbgnbaseqty", "diffbgnbaseqty");
        billsData = billsData.addField("bgnqty2nd - oldbgnqty2nd", "diffbgnqty2nd");
        billsData = billsData.addField("inqty", "diffinqty");
        billsData = billsData.addField("inbaseqty", "diffinbaseqty");
        billsData = billsData.addField("inqty2nd", "diffinqty2nd");
        billsData = billsData.addField("outqty", "diffoutqty");
        billsData = billsData.addField("outbaseqty", "diffoutbaseqty");
        billsData = billsData.addField("outqty2nd", "diffoutqty2nd");
        billsData = billsData.filter("diffendqty <> 0 or diffendbaseqty <> 0 or diffendqty2nd <> 0 or diffbgnqty <> 0 or diffbgnbaseqty <> 0 or diffbgnqty2nd <> 0  or diffinqty <> 0 or diffinbaseqty <> 0 or diffinqty2nd <> 0 or diffoutqty <> 0 or diffoutbaseqty <> 0 or diffoutqty2nd <> 0");
        return billsData;
    }

    private static QFilter getBalOrgWarehouseFilter(DataSet billsData, boolean reCalAll) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> warehouseIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<String> lotNums = new HashSet<String>(16);
        ArrayList<String> groups = new ArrayList<String>(Arrays.asList("org", "warehouse"));
        if (!reCalAll) {
            groups.add("material");
            groups.add("lotnumber");
        }
        try (DataSet orgWarehouseDs = billsData.copy().groupBy(groups.toArray(new String[0])).finish();){
            for (Row row : orgWarehouseDs) {
                orgIds.add(row.getLong("org"));
                warehouseIds.add(row.getLong("warehouse"));
                if (reCalAll) continue;
                materialIds.add(row.getLong("material"));
                lotNums.add(row.getString("lotnumber"));
            }
        }
        QFilter orgWarehousef = new QFilter("org", "in", orgIds);
        orgWarehousef.and(new QFilter("warehouse", "in", warehouseIds));
        if (!reCalAll) {
            orgWarehousef.and(new QFilter("material", "in", materialIds));
            orgWarehousef.and(new QFilter("lotnumber", "in", lotNums));
        }
        return orgWarehousef;
    }

    private static DataSet endQtyToBgnQty(DataSet billsData) {
        List groups = InvBalanceConst.getGroups();
        String dimMathCondition = BalanceHelper.getDimMathCondition(groups, null);
        String dimMNewMathCondition = BalanceHelper.getDimMathCondition(groups, " balanceid is null or balanceid = 0L ");
        String[] bgnSelects = billsData.getRowMeta().getFieldNames();
        String[] newFields = new String[bgnSelects.length];
        block24: for (int i = 0; i < bgnSelects.length; ++i) {
            newFields[i] = bgnSelects[i];
            switch (bgnSelects[i]) {
                case "prebalid": {
                    newFields[i] = String.format(dimMNewMathCondition, "PreRowValue(balanceid)", "prebalid", "prebalid");
                    continue block24;
                }
                case "oldendqty": {
                    newFields[i] = String.format(dimMNewMathCondition, "PreRowValue(oldendqty)", "oldendqty", "oldendqty");
                    continue block24;
                }
                case "oldendbaseqty": {
                    newFields[i] = String.format(dimMNewMathCondition, "PreRowValue(oldendbaseqty)", "oldendbaseqty", "oldendbaseqty");
                    continue block24;
                }
                case "oldendqty2nd": {
                    newFields[i] = String.format(dimMNewMathCondition, "PreRowValue(oldendqty2nd)", "oldendqty2nd", "oldendqty2nd");
                    continue block24;
                }
                case "diffendqty": {
                    String diffEndQty = "oldbgnqty + inqty + oldinqty - outqty - oldoutqty - oldendqty";
                    newFields[i] = String.format(dimMathCondition, "PreRowValue(diffendqty) + " + diffEndQty, diffEndQty, "diffendqty");
                    continue block24;
                }
                case "diffendbaseqty": {
                    String diffEndBaseQty = "oldbgnbaseqty + inbaseqty  + oldinbaseqty - outbaseqty - oldoutbaseqty - oldendbaseqty";
                    newFields[i] = String.format(dimMathCondition, "PreRowValue(diffendbaseqty) + " + diffEndBaseQty, diffEndBaseQty, "diffendbaseqty");
                    continue block24;
                }
                case "diffendqty2nd": {
                    String diffEndQty2nd = "oldbgnqty2nd + inqty2nd + oldinqty2nd - outqty2nd - oldoutqty2nd - oldendqty2nd";
                    newFields[i] = String.format(dimMathCondition, "PreRowValue(diffendqty2nd) + " + diffEndQty2nd, diffEndQty2nd, "diffendqty2nd");
                    continue block24;
                }
                case "bgnqty": {
                    newFields[i] = String.format(dimMathCondition, "PreRowValue(oldendqty) + PreRowValue(diffendqty)", "bgnqty", "bgnqty");
                    continue block24;
                }
                case "bgnbaseqty": {
                    newFields[i] = String.format(dimMathCondition, "PreRowValue(oldendbaseqty) + PreRowValue(diffendbaseqty)", "bgnbaseqty", "bgnbaseqty");
                    continue block24;
                }
                case "bgnqty2nd": {
                    newFields[i] = String.format(dimMathCondition, "PreRowValue(oldendqty2nd) +PreRowValue(diffendqty2nd)", "bgnqty2nd", "bgnqty2nd");
                    continue block24;
                }
            }
        }
        billsData = billsData.select(newFields);
        return billsData;
    }

    private static DataSet sumRecAndSedQty(DataSet billsData, boolean isPositive, String[] groupsString) {
        GroupbyDataSet billsGroupByDs = billsData.groupBy(groupsString);
        for (String recQtyf : InvBalanceConst.getRecQty()) {
            if (isPositive) {
                billsGroupByDs = billsGroupByDs.sum(recQtyf);
                continue;
            }
            billsGroupByDs = billsGroupByDs.sum("0 - " + recQtyf, recQtyf);
        }
        for (String sedQtyf : InvBalanceConst.getSedQty()) {
            if (isPositive) {
                billsGroupByDs = billsGroupByDs.sum(sedQtyf);
                continue;
            }
            billsGroupByDs = billsGroupByDs.sum("0 - " + sedQtyf, sedQtyf);
        }
        return billsGroupByDs.finish();
    }

    private static String getDimMathCondition(List<String> groups, String otherCondition) {
        StringBuilder dimMatch = new StringBuilder();
        dimMatch.append(" case when ");
        String equalsFormat = " PreRowValue(%1$s)=%1$s ";
        for (int i = 0; i < groups.size(); ++i) {
            dimMatch.append(String.format(equalsFormat, groups.get(i)));
            if (i == groups.size() - 1) continue;
            dimMatch.append(" and ");
        }
        if (otherCondition != null && !otherCondition.isEmpty()) {
            dimMatch.append(" and (");
            dimMatch.append(otherCondition);
            dimMatch.append(")");
        }
        return dimMatch.append(" then %1$s else %2$s end as %3$s ").toString();
    }

    private static void setQty4NegateUpdate(Row row, BalanceRecordUpdateParams balIdParams) {
        balIdParams.setRecQty(row.getBigDecimal("inqty").negate());
        balIdParams.setRecBaseQty(row.getBigDecimal("inbaseqty").negate());
        balIdParams.setRec2ndQty(row.getBigDecimal("inqty2nd").negate());
        balIdParams.setSedQty(row.getBigDecimal("outqty").negate());
        balIdParams.setSedBaseQty(row.getBigDecimal("outbaseqty").negate());
        balIdParams.setSed2ndQty(row.getBigDecimal("outqty2nd").negate());
        balIdParams.setEndQtyDiff(balIdParams.getBgnQtyDiff().add(balIdParams.getRecQty()).subtract(balIdParams.getSedQty()));
        balIdParams.setEndBaseQtyDiff(balIdParams.getBgnBaseQtyDiff().add(balIdParams.getRecBaseQty()).subtract(balIdParams.getSedBaseQty()));
        balIdParams.setEnd2ndQtyDiff(balIdParams.getBgn2ndQtyDiff().add(balIdParams.getRec2ndQty()).subtract(balIdParams.getSed2ndQty()));
    }

    private static void setQty4Update(Row row, BalanceRecordUpdateParams balIdParams) {
        boolean isReCal;
        balIdParams.setRecQty(row.getBigDecimal("inqty"));
        balIdParams.setRecBaseQty(row.getBigDecimal("inbaseqty"));
        balIdParams.setRec2ndQty(row.getBigDecimal("inqty2nd"));
        balIdParams.setSedQty(row.getBigDecimal("outqty"));
        balIdParams.setSedBaseQty(row.getBigDecimal("outbaseqty"));
        balIdParams.setSed2ndQty(row.getBigDecimal("outqty2nd"));
        BigDecimal oldEndQty = BigDecimal.ZERO;
        BigDecimal oldBaseEndQty = BigDecimal.ZERO;
        BigDecimal oldEnd2ndQty = BigDecimal.ZERO;
        if (row.getLong(BALANCEID) != null && !row.getLong(BALANCEID).equals(0L) && (isReCal = BalanceHelper.getIsCal(row))) {
            oldEndQty = row.getBigDecimal("oldendqty");
            oldBaseEndQty = row.getBigDecimal("oldendbaseqty");
            oldEnd2ndQty = row.getBigDecimal("oldendqty2nd");
        }
        balIdParams.setEndQtyDiff(balIdParams.getBgnQtyDiff().add(balIdParams.getRecQty()).subtract(balIdParams.getSedQty()).subtract(oldEndQty));
        balIdParams.setEndBaseQtyDiff(balIdParams.getBgnBaseQtyDiff().add(balIdParams.getRecBaseQty()).subtract(balIdParams.getSedBaseQty()).subtract(oldBaseEndQty));
        balIdParams.setEnd2ndQtyDiff(balIdParams.getBgn2ndQtyDiff().add(balIdParams.getRec2ndQty()).subtract(balIdParams.getSed2ndQty()).subtract(oldEnd2ndQty));
    }

    private static boolean getIsCal(Row row) {
        boolean bgnQty = row.getBigDecimal("oldbgnqty").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("oldbgnbaseqty").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("oldbgnqty2nd").compareTo(BigDecimal.ZERO) == 0;
        boolean inQty = row.getBigDecimal("oldinqty").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("oldinbaseqty").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("oldinqty2nd").compareTo(BigDecimal.ZERO) == 0;
        boolean sedQty = row.getBigDecimal("oldoutqty").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("oldoutbaseqty").compareTo(BigDecimal.ZERO) == 0 && row.getBigDecimal("oldoutqty2nd").compareTo(BigDecimal.ZERO) == 0;
        boolean endQty = row.getBigDecimal("oldendqty").compareTo(BigDecimal.ZERO) != 0 || row.getBigDecimal("oldendbaseqty").compareTo(BigDecimal.ZERO) != 0 || row.getBigDecimal("oldendqty2nd").compareTo(BigDecimal.ZERO) != 0;
        boolean isCal = bgnQty && inQty && sedQty && endQty;
        return isCal;
    }

    private static DynamicObject createNewBalDyc(boolean recordAccountBalance, Row row, String dimStr, Long balId, boolean isInit) {
        DynamicObject newBalDyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_invbalance"));
        newBalDyc.set("id", (Object)balId);
        List dims = InvBalanceConst.getGroups();
        for (String item : dims) {
            newBalDyc.set(item, row.get(item));
        }
        newBalDyc.set("dimmd5str", (Object)dimStr);
        newBalDyc.set("isinit", (Object)isInit);
        if (recordAccountBalance) {
            newBalDyc.set("balancetype", (Object)BalanceTypeEnum.CalType.getType());
        } else {
            newBalDyc.set("balancetype", (Object)BalanceTypeEnum.InvType.getType());
        }
        newBalDyc.set("bgnqty", (Object)row.getBigDecimal("bgnqty"));
        newBalDyc.set("bgnbaseqty", (Object)row.getBigDecimal("bgnbaseqty"));
        newBalDyc.set("bgnqty2nd", (Object)row.getBigDecimal("bgnqty2nd"));
        newBalDyc.set("inqty", (Object)row.getBigDecimal("inqty"));
        newBalDyc.set("inbaseqty", (Object)row.getBigDecimal("inbaseqty"));
        newBalDyc.set("inqty2nd", (Object)row.getBigDecimal("inqty2nd"));
        newBalDyc.set("outqty", (Object)row.getBigDecimal("outqty"));
        newBalDyc.set("outbaseqty", (Object)row.getBigDecimal("outbaseqty"));
        newBalDyc.set("outqty2nd", (Object)row.getBigDecimal("outqty2nd"));
        newBalDyc.set("endqty", (Object)BalanceHelper.calculateEndQty(newBalDyc, "endqty", "bgnqty", "inqty", "outqty"));
        newBalDyc.set("endbaseqty", (Object)BalanceHelper.calculateEndQty(newBalDyc, "endbaseqty", "bgnbaseqty", "inbaseqty", "outbaseqty"));
        newBalDyc.set("endqty2nd", (Object)BalanceHelper.calculateEndQty(newBalDyc, "endqty2nd", "bgnqty2nd", "inqty2nd", "outqty2nd"));
        Integer period = row.getInteger(isInit ? BILLPERIOD : PERIOD);
        newBalDyc.set(PERIOD, (Object)period);
        newBalDyc.set(ENDPERIOD, row.get(isInit ? BILLENDPERIOD : ENDPERIOD));
        if (!isInit && period != 0) {
            int year = period / 100;
            int month = period % 100;
            Date startDate = DateUtils.getDateBySpecifyValue((int)year, (int)month, (int)1);
            newBalDyc.set("startdate", (Object)startDate);
        }
        return newBalDyc;
    }

    private static DynamicObject createSnapDynamicObject(Row bill, String billFormId) {
        DynamicObject snapDyc = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_invsnapshoot"));
        snapDyc.set("formid", (Object)billFormId);
        snapDyc.set("billid", (Object)bill.getLong("id"));
        snapDyc.set("biztime", (Object)bill.getDate("biztime"));
        return snapDyc;
    }

    private static void recordSnapInfo(String formId, QFilter filter) {
        String selectFields = "id,biztime";
        try (DataSet billIdDateDs = QueryServiceHelper.queryDataSet((String)(BalanceHelper.class + "recordSnapInfo"), (String)formId, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            ArrayList<DynamicObject> snaps = new ArrayList<DynamicObject>(16);
            for (Row row : billIdDateDs) {
                snaps.add(BalanceHelper.createSnapDynamicObject(row, formId));
            }
            SaveServiceHelper.save((DynamicObject[])snaps.toArray(new DynamicObject[0]));
        }
    }

    private static DataSet getInitSumData(DataSet billsData, boolean recordAccountBalance, boolean reCalAll) {
        QFilter orgWarehouseFilter = BalanceHelper.getBalOrgWarehouseFilter(billsData, reCalAll);
        billsData = billsData.addField("0", BILLPERIOD);
        billsData = billsData.addField("999999", BILLENDPERIOD);
        List groups = InvBalanceConst.getGroups();
        groups.add(BILLPERIOD);
        groups.add(BILLENDPERIOD);
        GroupbyDataSet billsGroupByDs = billsData.groupBy(groups.toArray(new String[0]));
        for (String recQtyf : InvBalanceConst.getBalAllQtyList()) {
            billsGroupByDs.sum(recQtyf);
        }
        billsData = billsGroupByDs.finish().orderBy(groups.toArray(new String[0]));
        DataSet balDs = BalanceHelper.getBalDs(orgWarehouseFilter, recordAccountBalance);
        balDs = balDs.orderBy(new String[]{PERIOD});
        JoinDataSet billJoinBalDs = billsData.leftJoin(balDs);
        List dims = InvBalanceConst.getGroups();
        for (String dim : dims) {
            billJoinBalDs.on(dim, dim);
        }
        billsData = billJoinBalDs.select(billsData.getRowMeta().getFieldNames(), balSels).finish();
        return billsData;
    }

    private static void setInitQtyUpdateParams(boolean isPositive, Row row, BalanceRecordUpdateParams balIdParams) {
        if (isPositive) {
            balIdParams.setBgnQtyDiff(row.getBigDecimal("bgnqty"));
            balIdParams.setBgnBaseQtyDiff(row.getBigDecimal("bgnbaseqty"));
            balIdParams.setBgn2ndQtyDiff(row.getBigDecimal("bgnqty2nd"));
            BalanceHelper.setQty4Update(row, balIdParams);
        } else {
            balIdParams.setBgnQtyDiff(row.getBigDecimal("bgnqty").negate());
            balIdParams.setBgnBaseQtyDiff(row.getBigDecimal("bgnbaseqty").negate());
            balIdParams.setBgn2ndQtyDiff(row.getBigDecimal("bgnqty2nd").negate());
            BalanceHelper.setQty4NegateUpdate(row, balIdParams);
        }
    }

    private static QFilter getIdFilter(List<Long> billIds) {
        return new QFilter("id", "in", billIds);
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new KDBizException(String.format("IM-BalanceHelper:[%s] args:[%s]", e1.getMessage(), message));
        }
    }
}

