/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.calcost;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;

public class CalcExprHelper {
    public static Object getExpressionValue(ExpressionParameter calcParameter) {
        if (StringUtils.isBlank((CharSequence)calcParameter.getExpression())) {
            return Boolean.TRUE;
        }
        RowDataModel rowModel = calcParameter.getRowModel();
        rowModel.setRowContext(calcParameter.getActiveRow(), calcParameter.getRowIndex());
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        FunctionManage funcLib = calcParameter.getFcunLib() == null ? FunctionManage.get() : calcParameter.getFcunLib();
        Object expValue = CalcExprHelper.getExpressionValue(calcParameter.getBOSExpression(), (ExpressionContext)expContext, funcLib);
        return expValue;
    }

    public static Object getExpressionValue(BOSExpression expression, ExpressionContext expContext, FunctionManage funcLib) {
        if (expression == null || expression.getExpr() == null) {
            return null;
        }
        Object[] vars = expression.getVars().toArray(new String[0]);
        Arrays.sort(vars);
        HashMap<Object, Object> ctx = new HashMap<Object, Object>(32);
        for (Object var : vars) {
            ctx.put(var, CalcExprHelper.getVarValue((String)var, expContext));
        }
        BOSUDFunction[] functions = CalcExprHelper.createUdFunctions(expression.getFuncs(), funcLib, expContext);
        Object expValue = FormulaEngine.execExcelFormula((Expr)expression.getExpr(), ctx, (UDFunction[])functions);
        return expValue;
    }

    private static Object getVarValue(String var, ExpressionContext expContext) {
        OutValue value = new OutValue();
        if (!expContext.tryGetValue(var, value).booleanValue()) {
            return null;
        }
        Object item = value.get();
        if (item instanceof Object[] && ((Object[])item).length != 0) {
            item = ((Object[])item)[0];
        }
        if (item instanceof String) {
            item = ((String)item).trim();
        } else if (item instanceof OrmLocaleValue) {
            item = ((OrmLocaleValue)item).getLocaleValue();
        } else if (item instanceof DynamicObject) {
            item = ((DynamicObject)item).getPkValue();
        }
        return item;
    }

    private static BOSUDFunction[] createUdFunctions(Set<String> funcs, FunctionManage funcLib, ExpressionContext expContext) {
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>(16);
        for (String funcName : funcs) {
            if (!funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)funcLib.getFuncMap().get(funcName)).getInstance(expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[0]);
    }
}

