/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.calcost.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryPriceOrgFilter {
    public static List<DynamicObject> filterByApplyOrg(MainEntityType entityType, DynamicObject priceConfig, DynamicObject[] bills) {
        String mainOrgField = entityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrgField)) {
            return new ArrayList<DynamicObject>(1);
        }
        Map<Long, String> orgLotNum = QueryPriceOrgFilter.getOrgLotNumMap(priceConfig, bills, mainOrgField);
        return QueryPriceOrgFilter.checkApplyOrg(priceConfig, bills, orgLotNum, mainOrgField);
    }

    private static List<DynamicObject> checkApplyOrg(DynamicObject priceConfig, DynamicObject[] bills, Map<Long, String> orgLotNum, String mainOrgField) {
        ArrayList<DynamicObject> applyOrgBills = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection orgList = priceConfig.getDynamicObjectCollection("orgentry");
        if (orgList.isEmpty()) {
            return Arrays.asList(bills);
        }
        ArrayList<String> billNums = new ArrayList<String>(16);
        ArrayList<String> applyBillNums = new ArrayList<String>(16);
        block0: for (DynamicObject bill : bills) {
            DynamicObject mainOrg = bill.getDynamicObject(mainOrgField);
            billNums.add(bill.getString("billno"));
            if (mainOrg == null) continue;
            Long mainOrgId = mainOrg.getLong("id");
            for (DynamicObject orgRow : orgList) {
                Long entryOrgId = orgRow.getLong("org.id");
                if (mainOrgId.equals(entryOrgId)) {
                    applyOrgBills.add(bill);
                    applyBillNums.add(bill.getString("billno"));
                    continue block0;
                }
                boolean isInclude = orgRow.getBoolean("isincludesuborg");
                if (!isInclude) continue;
                String subOrgLongNum = orgLotNum.get(mainOrgId);
                String supOrgLongNum = orgLotNum.get(entryOrgId);
                boolean match = !StringUtils.isEmpty((CharSequence)subOrgLongNum) && !StringUtils.isEmpty((CharSequence)supOrgLongNum) && subOrgLongNum.startsWith(supOrgLongNum + '!');
                if (!match) continue;
                applyOrgBills.add(bill);
                applyBillNums.add(bill.getString("billno"));
                continue block0;
            }
        }
        billNums.removeAll(applyBillNums);
        if (!billNums.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5728\u5355\u4f4d\u6210\u672c\u914d\u7f6e\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u5185\uff0c\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u5931\u8d25\u3002", (String)"QueryPriceOrgFilter_0", (String)"scmc-im-business", (Object[])new Object[0]), billNums));
        }
        return applyOrgBills;
    }

    private static Map<Long, String> getOrgLotNumMap(DynamicObject priceConfig, DynamicObject[] bills, String mainOrgField) {
        HashMap<Long, String> orgLongNumMap = new HashMap<Long, String>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        DynamicObjectCollection orgList = priceConfig.getDynamicObjectCollection("orgentry");
        if (orgList.isEmpty()) {
            return orgLongNumMap;
        }
        for (DynamicObject orgRow : orgList) {
            boolean isInclude = orgRow.getBoolean("isincludesuborg");
            if (!isInclude) continue;
            DynamicObject org = orgRow.getDynamicObject("org");
            orgIds.add(org.getLong("id"));
        }
        for (DynamicObject bill : bills) {
            DynamicObject mainOrg = bill.getDynamicObject(mainOrgField);
            if (mainOrg == null) continue;
            orgIds.add(mainOrg.getLong("id"));
        }
        if (orgIds.isEmpty()) {
            return orgLongNumMap;
        }
        QFilter qFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        qFilter = qFilter.and("org", "in", orgIds);
        qFilter = qFilter.and("view.number", "=", (Object)"15");
        qFilter = qFilter.and("view.isdefault", "=", (Object)"1");
        DataSet orgData = QueryServiceHelper.queryDataSet((String)QueryPriceOrgFilter.class.getName(), (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])qFilter.toArray(), null);
        for (Row row : orgData) {
            orgLongNumMap.put(row.getLong("org"), row.getString("longnumber"));
        }
        return orgLongNumMap;
    }
}

