/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.datactrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.datacontrol.business.builder.CtrlStrategyBulider;
import kd.mpscmm.msbd.datacontrol.business.helper.DataCtrlServiceHelper;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlSchemeInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.CtrlStrategyInfo;
import kd.mpscmm.msbd.datacontrol.business.pojo.ModelMapping;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.MaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.MaterielScopeResultHandle;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.WarehousePeopleScopeResultHandle;
import org.apache.commons.collections4.CollectionUtils;

public class InvBizDataCtrlHelper {
    private static final Log log = LogFactory.getLog(InvBizDataCtrlHelper.class);
    private final Map<String, List<DataCtrlSchemeResultHandle>> resultHandleMap = new HashMap<String, List<DataCtrlSchemeResultHandle>>(4);
    private Set<String> checkNumList = new HashSet<String>(4);

    private InvBizDataCtrlHelper() {
    }

    public static InvBizDataCtrlHelper buildF7Helper() {
        InvBizDataCtrlHelper helper = new InvBizDataCtrlHelper();
        helper.addFilter(new WarehouseIsolateResultHandle());
        helper.addFilter(new MaterielIsolateResultHandle());
        helper.addFilter(new WarehousePeopleScopeResultHandle(true));
        helper.addFilter(new MaterielScopeResultHandle(true));
        return helper;
    }

    public static InvBizDataCtrlHelper buildValidatorHelper() {
        InvBizDataCtrlHelper helper = new InvBizDataCtrlHelper();
        helper.addFilter(new WarehouseIsolateResultHandle());
        helper.addFilter(new MaterielIsolateResultHandle());
        helper.addFilter(new WarehousePeopleScopeResultHandle(false));
        helper.addFilter(new MaterielScopeResultHandle(false));
        return helper;
    }

    public static InvBizDataCtrlHelper buildLimitHelper(DataCtrlSchemeResultHandle ... resultHandles) {
        InvBizDataCtrlHelper helper = new InvBizDataCtrlHelper();
        for (DataCtrlSchemeResultHandle resultHandle : resultHandles) {
            helper.addFilter(resultHandle);
            helper.addCheckNum(resultHandle.supportDataCtrlNum());
        }
        return helper;
    }

    private static Set<Long> getCtrlDataByScheme(Map<String, Object> paramMap, String dataCtrlSchemeNum, DataCtrlSchemeResultHandle filter) {
        try {
            Map resultMap = DataCtrlServiceHelper.getCtrlDataByScheme(Collections.singletonMap(dataCtrlSchemeNum, paramMap), (String)dataCtrlSchemeNum);
            if (null == resultMap) {
                return Collections.emptySet();
            }
            Set<Long> dataSet = (Set<Long>)resultMap.get("ALLOW_DATA");
            if (null != filter) {
                dataSet = filter.dealResult(dataSet);
                return dataSet;
            }
            if (CollectionUtils.isEmpty((Collection)dataSet)) {
                log.info("\u6570\u636e\u63a7\u5236\u65b9\u6848[{}]\u5339\u914d\u4e3a\u7a7a,\u53c2\u6570:{}", (Object)dataCtrlSchemeNum, paramMap);
                return Collections.singleton(-1L);
            }
            return dataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    public QFilter getF7QFilterByStrategy(DynamicObject entity, String formId, String ctrlField) {
        try {
            Set<Long> allDataSet = this.getDataByDataCtrl(entity, formId, ctrlField);
            return this.buildQFilter(allDataSet, ctrlField);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private QFilter buildQFilter(Set<Long> allDataSet, String ctrlField) {
        if (allDataSet.isEmpty()) {
            return null;
        }
        if (allDataSet.contains(-1L)) {
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        if (ctrlField.endsWith(".masterid")) {
            return new QFilter("masterid", "in", allDataSet);
        }
        return new QFilter("id", "in", allDataSet);
    }

    public Set<Long> getDataByDataCtrl(DynamicObject entity, String formId, String ctrlField) {
        try {
            if (null == entity || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return Collections.emptySet();
            }
            DynamicObject strategyDym = this.loadDataCtrlStrategy(formId, ctrlField = this.getFullFiledPath(formId, ctrlField));
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            return this.getDataByDataCtrl(entity, strategyDym);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> getDataByDataCtrl(DynamicObject entity, DynamicObject strategyDym) {
        try {
            if (null == entity || null == strategyDym) {
                return Collections.emptySet();
            }
            String bizbill = strategyDym.getString("bizbill.number");
            String ctrlField = strategyDym.getString("ctrlField");
            Map<String, Map<String, Object>> paramsMap = InvBizDataCtrlHelper.buildParamsMap(bizbill, entity, ctrlField);
            DynamicObjectCollection collection = strategyDym.getDynamicObjectCollection("entryentity");
            List dataCtrlSchemeNumList = collection.stream().map(item -> item.getString("datactrlscheme.number")).collect(Collectors.toList());
            Set<Long> allDataSet = new HashSet<Long>(4);
            for (String dataCtrlSchemeNum : dataCtrlSchemeNumList) {
                if (!this.checkNumList.isEmpty() && !this.checkNumList.contains(dataCtrlSchemeNum)) continue;
                List<DataCtrlSchemeResultHandle> resultHandles = this.resultHandleMap.get(dataCtrlSchemeNum);
                if (CollectionUtils.isEmpty(resultHandles)) {
                    Map<String, Object> params = paramsMap.get(dataCtrlSchemeNum);
                    if (null == params) continue;
                    Set<Long> dataSet = InvBizDataCtrlHelper.getCtrlDataByScheme(params, dataCtrlSchemeNum, null);
                    if (CollectionUtils.containsAny(dataSet, (Object[])new Long[]{-1L})) {
                        return this.noData();
                    }
                    allDataSet = this.retainAll(allDataSet, dataSet);
                    continue;
                }
                for (DataCtrlSchemeResultHandle resultHandle : resultHandles) {
                    Map<String, Object> params = paramsMap.get(dataCtrlSchemeNum);
                    if (null == params || !resultHandle.filter(params)) continue;
                    Map<String, Object> newParams = resultHandle.dealParamMap(entity, dataCtrlSchemeNum, params);
                    Set<Long> dataSet = InvBizDataCtrlHelper.getCtrlDataByScheme(newParams, dataCtrlSchemeNum, resultHandle);
                    if (CollectionUtils.containsAny(dataSet, (Object[])new Long[]{-1L})) {
                        return this.noData();
                    }
                    allDataSet = this.retainAll(allDataSet, dataSet);
                }
            }
            return allDataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> getDataByDataCtrl(Map<String, Map<String, Object>> paramsMap, DynamicObject strategyDym) {
        try {
            if (null == paramsMap || null == strategyDym) {
                return Collections.emptySet();
            }
            DynamicObjectCollection collection = strategyDym.getDynamicObjectCollection("entryentity");
            List dataCtrlSchemeNumList = collection.stream().map(item -> item.getString("datactrlscheme.number")).collect(Collectors.toList());
            Set<Long> allDataSet = new HashSet<Long>(4);
            for (String dataCtrlSchemeNum : dataCtrlSchemeNumList) {
                if (!this.checkNumList.isEmpty() && !this.checkNumList.contains(dataCtrlSchemeNum)) continue;
                List<DataCtrlSchemeResultHandle> resultHandles = this.resultHandleMap.get(dataCtrlSchemeNum);
                if (CollectionUtils.isEmpty(resultHandles)) {
                    Map<String, Object> params = paramsMap.get(dataCtrlSchemeNum);
                    if (null == params) continue;
                    Set<Long> dataSet = InvBizDataCtrlHelper.getCtrlDataByScheme(params, dataCtrlSchemeNum, null);
                    if (null != dataSet && dataSet.contains(-1L)) {
                        return this.noData();
                    }
                    allDataSet = this.retainAll(allDataSet, dataSet);
                }
                for (DataCtrlSchemeResultHandle resultHandle : resultHandles) {
                    Map<String, Object> params = paramsMap.get(dataCtrlSchemeNum);
                    if (null == params || !resultHandle.filter(params)) continue;
                    Set<Long> dataSet = InvBizDataCtrlHelper.getCtrlDataByScheme(params, dataCtrlSchemeNum, resultHandle);
                    if (null != dataSet && dataSet.contains(-1L)) {
                        return this.noData();
                    }
                    allDataSet = this.retainAll(allDataSet, dataSet);
                }
            }
            return allDataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> noData() {
        return Collections.singleton(-1L);
    }

    private Set<Long> retainAll(Set<Long> allDataSet, Set<Long> dataSet) {
        if (null == dataSet || dataSet.isEmpty()) {
            return allDataSet;
        }
        if (allDataSet.isEmpty()) {
            return new HashSet<Long>(dataSet);
        }
        if (dataSet.contains(-1L)) {
            return dataSet;
        }
        if (allDataSet.contains(-1L)) {
            return allDataSet;
        }
        allDataSet.retainAll(dataSet);
        if (allDataSet.isEmpty()) {
            return Collections.singleton(-1L);
        }
        return allDataSet;
    }

    private DynamicObject loadDataCtrlStrategy(String formId, String ctrlField) {
        List<String> entityTypeList = InvBizDataCtrlHelper.getEntityTypeList(formId);
        QFilter qFilter = new QFilter("bizbill", "in", entityTypeList);
        qFilter.and("ctrlField", "=", (Object)ctrlField);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
        if (resultMap.isEmpty()) {
            return null;
        }
        HashMap<String, DynamicObject> dataCtrlMap = new HashMap<String, DynamicObject>(4);
        for (DynamicObject dataCtrlDym : resultMap.values()) {
            String bizbill = dataCtrlDym.getString("bizbill.number");
            dataCtrlMap.put(bizbill, dataCtrlDym);
        }
        for (String entityType : entityTypeList) {
            if (!dataCtrlMap.containsKey(entityType)) continue;
            return (DynamicObject)dataCtrlMap.get(entityType);
        }
        return null;
    }

    private List<DynamicObject> loadDataCtrlStrategyList(String formId, String ctrlField) {
        List<String> entityTypeList = InvBizDataCtrlHelper.getEntityTypeList(formId);
        QFilter qFilter = new QFilter("bizbill", "in", entityTypeList);
        qFilter.and("ctrlField", "=", (Object)ctrlField);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
        if (resultMap.isEmpty()) {
            return null;
        }
        return new ArrayList<DynamicObject>(resultMap.values());
    }

    public QFilter getF7QFilterByStrategyList(DynamicObject entity, String formId, String ctrlField) {
        try {
            if (null == entity || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return null;
            }
            List<DynamicObject> strategyDymList = this.loadDataCtrlStrategyList(formId, ctrlField);
            if (CollectionUtils.isEmpty(strategyDymList)) {
                return null;
            }
            Set<Long> allDataSet = new HashSet<Long>(4);
            for (DynamicObject strategyDym : strategyDymList) {
                Set<Long> dataSet = this.getDataByDataCtrl(entity, strategyDym);
                if (!CollectionUtils.isNotEmpty(dataSet)) continue;
                if (allDataSet.isEmpty()) {
                    allDataSet = dataSet;
                    continue;
                }
                allDataSet = this.retainAll(allDataSet, dataSet);
            }
            return this.buildQFilter(allDataSet, ctrlField);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public Set<Long> getDataByStrategyList(DynamicObject entity, String formId, String ctrlField) {
        try {
            if (null == entity || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return Collections.emptySet();
            }
            List<DynamicObject> strategyDymList = this.loadDataCtrlStrategyList(formId, ctrlField);
            if (CollectionUtils.isEmpty(strategyDymList)) {
                return Collections.emptySet();
            }
            Set<Long> allDataSet = new HashSet<Long>(4);
            for (DynamicObject strategyDym : strategyDymList) {
                Set<Long> dataSet = this.getDataByDataCtrl(entity, strategyDym);
                if (!CollectionUtils.isNotEmpty(dataSet)) continue;
                if (allDataSet.isEmpty()) {
                    allDataSet = dataSet;
                    continue;
                }
                allDataSet = this.retainAll(allDataSet, dataSet);
            }
            return allDataSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private DynamicObject loadDataCtrlStrategy(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_datactrlstrategy", (String)"bizbill,ctrlField,entryentity.leftbracket,entryentity.datactrlscheme,entryentity.rightbracket,entryentity.logic", (QFilter[])qFilter.toArray());
    }

    public InvBizDataCtrlHelper addFilter(DataCtrlSchemeResultHandle resultHandle) {
        if (null == resultHandle || CollectionUtils.isEmpty(resultHandle.supportDataCtrlNum())) {
            return this;
        }
        for (String dataCtrlNum : resultHandle.supportDataCtrlNum()) {
            List<DataCtrlSchemeResultHandle> filterList = this.resultHandleMap.get(dataCtrlNum);
            if (filterList == null) {
                filterList = new ArrayList<DataCtrlSchemeResultHandle>(4);
                this.resultHandleMap.put(dataCtrlNum, filterList);
            }
            filterList.add(resultHandle);
        }
        return this;
    }

    public static String getAppParameterScope(Map<String, Object> dcSchemeParam, String scopeField) {
        Object org = dcSchemeParam.get("org");
        if (org == null && (org = dcSchemeParam.get("auxorg")) == null) {
            return "0";
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (org instanceof Long) {
            orgIds.add((Long)org);
        } else {
            orgIds.addAll((Collection)org);
        }
        Object appParameter = AppParameterHelper.getAppParameter("=9Q86DR2P+Q", "05", (Long)orgIds.get(0), scopeField);
        return (String)appParameter;
    }

    public Set<Long> getDataByUser(List<Long> orgIds, String formId, String ctrlField) {
        try {
            if (CollectionUtils.isEmpty(orgIds) || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return Collections.emptySet();
            }
            DynamicObject strategyDym = this.loadDataCtrlStrategy(formId, ctrlField = this.getFullFiledPath(formId, ctrlField));
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            return this.getDataByUser(orgIds, strategyDym.getLong("id"));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private String getFullFiledPath(String entityKey, String ctrlField) {
        if (ctrlField.contains(".")) {
            return ctrlField;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)ctrlField);
        if (null == property) {
            return ctrlField;
        }
        String field = property.getName();
        for (IDataEntityType entityType = property.getParent(); null != entityType && null != entityType.getParent(); entityType = entityType.getParent()) {
            field = entityType.getName() + "." + field;
        }
        return field;
    }

    public Set<Long> getDataByUser(List<Long> orgIds, Long strategyId) {
        try {
            Long userId = UserServiceHelper.getCurrentUserId();
            List<Long> operatorGrp = this.getOperatorGroupByOrg(orgIds);
            Set<Long> operatorIds = this.getOperatorIds(orgIds, userId, operatorGrp);
            if (operatorIds.isEmpty()) {
                return Collections.emptySet();
            }
            HashMap<String, Collection<Long>> param = new HashMap<String, Collection<Long>>(4);
            param.put("org", orgIds);
            param.put("operator", operatorIds);
            param.put("operatorgroup", operatorGrp);
            param.put("dept", UserServiceHelper.getAllDepartmentByUserId((long)userId));
            param.put("auxorg", orgIds);
            param.put("auxoperator", operatorIds);
            HashMap<String, Map<String, Object>> paramMap = new HashMap<String, Map<String, Object>>(4);
            DynamicObject strategyDym = this.loadDataCtrlStrategy(strategyId);
            if (null == strategyDym) {
                return Collections.emptySet();
            }
            DynamicObjectCollection entryRows = strategyDym.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryRows) {
                paramMap.put(entryRow.getString("datactrlscheme.number"), param);
            }
            return this.getDataByDataCtrl(paramMap, strategyDym);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptySet();
        }
    }

    private Set<Long> getOperatorIds(List<Long> orgIds, Long userId, List<Long> operatorGrp) {
        DynamicObjectCollection operators;
        QFilter qFilter = new QFilter("operatorid", "=", (Object)userId);
        qFilter.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        if (CollectionUtils.isNotEmpty(operatorGrp)) {
            qFilter.and(new QFilter("operatorgrpid", "in", operatorGrp));
        }
        if ((operators = QueryServiceHelper.query((String)"bd_operator", (String)"id", (QFilter[])qFilter.toArray())).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> operatorIds = new HashSet<Long>(operators.size());
        for (DynamicObject operator : operators) {
            operatorIds.add(operator.getLong("id"));
        }
        return operatorIds;
    }

    private List<Long> getOperatorGroupByOrg(List<Long> orgIdList) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIdList, (boolean)true);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)"KCZ");
        qFilter2.and("enable", "=", (Object)"1");
        QFilter operatorFilter = new QFilter("entryentity.operator.enable", "=", (Object)"1");
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2, operatorFilter});
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(map.values());
        ArrayList<Long> operatorGroupList = new ArrayList<Long>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
        }
        return operatorGroupList;
    }

    private static Map<String, Map<String, Object>> buildParamsMap(String formId, DynamicObject entity, String ctrlField) {
        HashMap<String, Map<String, Object>> paramsMap = new HashMap<String, Map<String, Object>>(4);
        CtrlStrategyInfo strategyInfo = CtrlStrategyBulider.bulid((String)formId, (String)ctrlField);
        if (null == strategyInfo) {
            return Collections.emptyMap();
        }
        Map ctrlSchemeCollList = strategyInfo.getCtrlSchemeColl();
        StringBuilder inputConditionSb = new StringBuilder();
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeCollList.values()) {
            List inputConditionList = schemeInfo.getInputConditionList();
            Iterator iterator = inputConditionList.iterator();
            while (iterator.hasNext()) {
                String inputCondition = (String)iterator.next();
                inputConditionSb.append(inputCondition);
            }
        }
        IDataEntityType entityType = entity.getDataEntityType();
        while (null != entityType.getParent()) {
            entityType = entityType.getParent();
        }
        ModelMapping mbMapping = strategyInfo.getMBMapping();
        for (Map.Entry entry : mbMapping.getModelMapping().entrySet()) {
            Object value;
            String modelField = (String)entry.getKey();
            String billField = (String)entry.getValue();
            if (inputConditionSb.indexOf("," + modelField + ",") == -1 || ObjectUtils.isEmpty((Object)(value = InvBizDataCtrlHelper.getValue((MainEntityType)entityType, entity, billField)))) continue;
            mbMapping.getRightValueMap().put(billField, value);
            mbMapping.getLeftValueMap().put(modelField, value);
        }
        Map ctrlSchemeColl = strategyInfo.getCtrlSchemeColl();
        for (CtrlSchemeInfo schemeInfo : ctrlSchemeColl.values()) {
            ModelMapping meMapping = schemeInfo.getMEMapping();
            if (null == mbMapping.getLeftValueMap()) continue;
            meMapping.getLeftValueMap().putAll(mbMapping.getLeftValueMap());
            Map meRvMap = meMapping.convert2LVMap();
            paramsMap.put(schemeInfo.getNumber(), meRvMap);
        }
        return paramsMap;
    }

    public static List<String> getEntityTypeList(String entityKey) {
        String inheritPath;
        ArrayList<String> entityTypeList = new ArrayList<String>(4);
        entityTypeList.add(entityKey);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        if (null != mainEntityType && StringUtils.isNotBlank((CharSequence)(inheritPath = mainEntityType.getInheritPath()))) {
            String[] parentEntityTypes = StringUtils.split((String)inheritPath, (String)",");
            for (int i = parentEntityTypes.length - 1; i >= 0; --i) {
                String parentEntityTypeId = parentEntityTypes[i];
                MainEntityType parentType = EntityMetadataCache.getDataEntityTypeById((String)parentEntityTypeId);
                if (parentType.getName().startsWith("bos_")) continue;
                entityTypeList.add(parentType.getName());
            }
        }
        return entityTypeList;
    }

    private static Object getValue(MainEntityType mainEntityType, DynamicObject entity, String field) {
        HashSet<Object> valueSet = new HashSet<Object>(8);
        if (null == entity || StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        RowDataModel model = new RowDataModel(entity.getDataEntityType().getName(), mainEntityType);
        model.setRowContext(entity);
        Object val = model.getValue(field);
        if (val == null) {
            return null;
        }
        if (val instanceof DynamicObject) {
            return InvBizDataCtrlHelper.getPkId((DynamicObject)val);
        }
        if (val instanceof DynamicObjectCollection) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)val;
            for (DynamicObject entry : entrys) {
                Object entryVal = InvBizDataCtrlHelper.getValue(mainEntityType, entry, field);
                if (entryVal instanceof Collection) {
                    valueSet.addAll((Collection)entryVal);
                    continue;
                }
                if (null == entryVal) continue;
                valueSet.add(entryVal);
            }
        } else if (val instanceof List) {
            List list = (List)val;
            for (Object item : list) {
                if (item instanceof DynamicObject) {
                    valueSet.add(InvBizDataCtrlHelper.getPkId((DynamicObject)item));
                    continue;
                }
                if (null == item) continue;
                valueSet.add(item);
            }
        } else if (ObjectUtils.isArray((Object)val)) {
            Object[] array;
            for (Object item : array = (Object[])val) {
                if (item instanceof DynamicObject) {
                    valueSet.add(InvBizDataCtrlHelper.getPkId((DynamicObject)item));
                    continue;
                }
                if (null == item) continue;
                valueSet.add(item);
            }
        } else if (null != val) {
            return val;
        }
        return valueSet;
    }

    private static Long getPkId(DynamicObject dym) {
        return dym.getLong("id");
    }

    private InvBizDataCtrlHelper addCheckNum(Set<String> supportDataCtrlNum) {
        this.checkNumList.addAll(supportDataCtrlNum);
        return this;
    }

    public Map<Long, Map<Long, Boolean>> checkData(List<DynamicObject> entityList, String formId, String ctrlField) {
        try {
            if (CollectionUtils.isEmpty(entityList) || StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)ctrlField)) {
                return Collections.emptyMap();
            }
            IDataEntityType entityType = entityList.get(0).getDataEntityType();
            while (null != entityType.getParent()) {
                entityType = entityType.getParent();
            }
            MainEntityType mainEntityType = (MainEntityType)entityType;
            HashMap<Long, Map<Long, Boolean>> checkResultMap = new HashMap<Long, Map<Long, Boolean>>(entityList.size());
            Integer rowIdx = 0;
            while (rowIdx < entityList.size()) {
                DynamicObject entity = entityList.get(rowIdx);
                Set<Long> dataSet = this.getDataByStrategyList(entity, formId, ctrlField);
                if (!dataSet.isEmpty()) {
                    Long pkId;
                    RowDataModel rowDataModel = new RowDataModel(entity.getDataEntityType().getName(), mainEntityType);
                    rowDataModel.setRowContext(entity);
                    Object value = rowDataModel.getValue(ctrlField);
                    if (value instanceof DynamicObject) {
                        pkId = (Long)((DynamicObject)value).getPkValue();
                        checkResultMap.put(rowIdx.longValue(), Collections.singletonMap(pkId, dataSet.contains(pkId)));
                    } else if (value instanceof Long) {
                        pkId = (Long)value;
                        checkResultMap.put(rowIdx.longValue(), Collections.singletonMap(pkId, dataSet.contains(pkId)));
                    }
                }
                Integer n = rowIdx;
                Integer n2 = rowIdx = Integer.valueOf(rowIdx + 1);
            }
            return checkResultMap;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return Collections.emptyMap();
        }
    }
}

