/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.datactrl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;

public class MaterielScopeResultHandle
implements DataCtrlSchemeResultHandle {
    private final boolean isF7;

    public MaterielScopeResultHandle(boolean isF7) {
        this.isF7 = isF7;
    }

    @Override
    public Set<String> supportDataCtrlNum() {
        return new HashSet<String>(Arrays.asList("auxmat_auxwh_ctrl", "auxorg_auxwh_mat_ctrl", "auxorg_mat_auxwh_ctrl", "auxwh_auxmat_ctrl", "auxwh_mat_ctrl", "mat_auxwh_ctrl", "mat_wh_ctrl", "wh_mat_ctrl"));
    }

    @Override
    public Map<String, Object> dealParamMap(DynamicObject entity, String dataCtrlSchemeNum, Map<String, Object> paramMap) {
        Object materielId = paramMap.get("material");
        if (ObjectUtils.isEmpty((Object)materielId)) {
            return paramMap;
        }
        QFilter qFilter = new QFilter("material", "in", materielId);
        DynamicObjectCollection materialGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"group", (QFilter[])new QFilter[]{qFilter});
        if (materialGroups.isEmpty()) {
            return paramMap;
        }
        Set groupIds = materialGroups.stream().map(item -> item.getLong("group")).collect(Collectors.toSet());
        HashMap<String, Object> newParams = new HashMap<String, Object>(paramMap);
        newParams.put("materialgroup", groupIds);
        return newParams;
    }

    @Override
    public boolean filter(Map<String, Object> paramMap) {
        String controlLevel = InvBizDataCtrlHelper.getAppParameterScope(paramMap, "fmeterialscope");
        if (this.isF7) {
            return "2".equals(controlLevel);
        }
        return !"0".equals(controlLevel);
    }
}

