/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.datactrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.helper.ParamsHelper;

public class WarehouseIsolateResultHandle
implements DataCtrlSchemeResultHandle {
    @Override
    public Set<String> supportDataCtrlNum() {
        return new HashSet<String>(Arrays.asList("invop_wh_ctrl", "invop_auxwh_ctrl", "auxinvop_auxwh_ctrl"));
    }

    @Override
    public boolean filter(Map<String, Object> paramMap) {
        Object org = paramMap.get("org");
        if (org == null && (org = paramMap.get("auxorg")) == null) {
            return false;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (org instanceof Long) {
            orgIds.add((Long)org);
        } else {
            orgIds.addAll((Collection)org);
        }
        Map params = ParamsHelper.getAppParams(orgIds, (String)"fwarehouseisolate");
        for (Map.Entry entry : params.entrySet()) {
            Object warehouseIsolate = entry.getValue();
            if (!(warehouseIsolate instanceof Boolean) || !((Boolean)warehouseIsolate).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> dealParamMap(DynamicObject entity, String dataCtrlSchemeNum, Map<String, Object> paramMap) {
        Object org = paramMap.get("org");
        if (org == null) {
            org = paramMap.get("auxorg");
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (org instanceof Long) {
            orgIds.add((Long)org);
        } else {
            orgIds.addAll((Collection)org);
        }
        Long userId = RequestContext.get().getCurrUserId();
        Set<Long> operatorIds = this.getOperatorIds(orgIds, userId);
        if (operatorIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> newParams = new HashMap<String, Object>(paramMap);
        newParams.put("operator", operatorIds);
        newParams.put("auxoperator", operatorIds);
        return newParams;
    }

    private Set<Long> getOperatorIds(List<Long> orgIds, Long userId) {
        QFilter qFilter = new QFilter("operatorid", "=", (Object)userId);
        qFilter.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        qFilter.and(new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg(orgIds)));
        DynamicObjectCollection operators = QueryServiceHelper.query((String)"bd_operator", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> operatorIds = new HashSet<Long>(operators.size());
        if (operators.isEmpty()) {
            return operatorIds;
        }
        for (DynamicObject operator : operators) {
            operatorIds.add(operator.getLong("id"));
        }
        return operatorIds;
    }

    private List<Long> getOperatorGroupByOrg(List<Long> orgIdList) {
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIdList, (boolean)true);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        qFilter2.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(map.values());
        ArrayList<Long> operatorGroupList = new ArrayList<Long>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
        }
        return operatorGroupList;
    }

    @Override
    public Set<Long> dealResult(Set<Long> dataSet) {
        return dataSet;
    }
}

