/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.directTran;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.ImBillBotpHelp;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.business.helper.directTran.HandleResult;
import kd.scmc.im.consts.InvschemeConsts;
import org.apache.commons.lang.ArrayUtils;

public class InvDirectTranHelper {
    protected static final Log logger = LogFactory.getLog(InvDirectTranHelper.class);
    protected static final String[] DIRECTTRANS_BUTTON = new String[]{"addrow", "splitrow", "qinvacc"};
    protected static final Long SOTOSALOUT_TRANSRULE_ID = 1132676586621900800L;
    private static final String BACKWRITEOFF_TAG = "backwriteoff_tag";

    public static boolean isSupplyTrans(DynamicObject bill) {
        if (Objects.isNull(bill)) {
            return false;
        }
        String billType = bill.getDynamicObjectType().getName();
        if ("im_purinbill".equals(billType) || "im_saloutbill".equals(billType)) {
            return bill.getBoolean("supplytrans");
        }
        return false;
    }

    public static void setEntryButtonEnable(IFormView view, boolean isSupplyTrans) {
        if (isSupplyTrans) {
            view.setEnable(Boolean.FALSE, DIRECTTRANS_BUTTON);
        }
    }

    public static HandleResult createSaleOutBill(DynamicObject purInBill) {
        if (Objects.isNull(purInBill)) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a", (String)"InvDirectTranHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!"im_purinbill".equals(purInBill.getDynamicObjectType().getName())) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u5355\u636e\u7c7b\u578b\u4e0d\u662f\u91c7\u8d2d\u5165\u5e93\u5355\u3002", (String)"InvDirectTranHelper_5", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!InvDirectTranHelper.isSupplyTrans(purInBill)) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f\u76f4\u8fd0\u7c7b\u578b\u3002", (String)"InvDirectTranHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!"C".equals(purInBill.getString("billstatus"))) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\u3002", (String)"InvDirectTranHelper_6", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        Long purInBillId = (Long)purInBill.getPkValue();
        if (InvDirectTranHelper.handleExpSalOutBill(purInBillId)) {
            HashMap<String, Map<Object, DynamicObject>> basecache = new HashMap<String, Map<Object, DynamicObject>>(6);
            Map<Long, List<Map<String, Object>>> purInSalOutMap = InvDirectTranHelper.getPurInSalOutEntryRelMap(purInBillId, basecache);
            return InvDirectTranHelper.handleGenSalOutBill(purInBillId, purInSalOutMap, basecache);
        }
        return new HandleResult(true);
    }

    private static boolean handleExpSalOutBill(Long purInBillId) {
        boolean flag = true;
        DynamicObjectCollection salOutBills = QueryServiceHelper.query((String)"im_saloutbill", (String)"id", (QFilter[])new QFilter("invscheme", "=", (Object)InvschemeConsts.INVSCHEM_DIRECTTRAN_SALE_OUT).and("billentry.srcbillid", "=", (Object)purInBillId).and("billstatus", "in", (Object)new String[]{"B", "C"}).toArray());
        if (Objects.nonNull(salOutBills) && !salOutBills.isEmpty()) {
            flag = false;
        } else {
            salOutBills = QueryServiceHelper.query((String)"im_saloutbill", (String)"id", (QFilter[])new QFilter("invscheme", "=", (Object)InvschemeConsts.INVSCHEM_DIRECTTRAN_SALE_OUT).and("billentry.srcbillid", "=", (Object)purInBillId).and("billstatus", "in", (Object)new String[]{"A"}).toArray());
            Object[] salOutBillIds = salOutBills.stream().map(item -> item.getLong("id")).distinct().toArray();
            if (ArrayUtils.isNotEmpty((Object[])salOutBillIds)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue(BACKWRITEOFF_TAG, "true");
                OperationResult opeResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])salOutBillIds, (OperateOption)option);
                if (!opeResult.isSuccess()) {
                    flag = false;
                }
            }
        }
        return flag;
    }

    private static HandleResult handleGenSalOutBill(Long purInBillId, Map<Long, List<Map<String, Object>>> purInSalOutMap, Map<String, Map<Object, DynamicObject>> basecache) {
        HandleResult result = new HandleResult(true);
        PushArgs pushArgs = InvDirectTranHelper.buildPushArgs(purInSalOutMap);
        ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            result.setSuccess(false);
            result.setMsg(pushResult.getBillReports().toString());
            return result;
        }
        Long purInTableId = ConvertMetaServiceHelper.loadTableDefine((String)"im_purinbill", (String)"im_purinbill").getTableId();
        Set salOutBillIds = pushResult.getTargetBillIds();
        DynamicObject[] salOutBills = BusinessDataServiceHelper.load((Object[])salOutBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"im_saloutbill"));
        try {
            for (DynamicObject salOutBill : salOutBills) {
                Long salOutBillId = (Long)salOutBill.getPkValue();
                salOutBill.set("supplytrans", (Object)Boolean.TRUE);
                DynamicObjectCollection salOutBillEntries = salOutBill.getDynamicObjectCollection("billentry");
                ArrayList<DynamicObject> salOutBillSplitEntries = new ArrayList<DynamicObject>();
                Object bizTime = null;
                Object bookDate = null;
                HashMap<String, String> cacheMap = new HashMap<String, String>(salOutBillEntries.size());
                for (DynamicObject salOutBillEntry : salOutBillEntries) {
                    Long soEntryId = salOutBillEntry.getLong("mainbillentryid");
                    List<Map<String, Object>> purInSalOutEntryList = purInSalOutMap.get(soEntryId);
                    for (int i = 0; i < purInSalOutEntryList.size(); ++i) {
                        Map<String, Object> purInSalOutEntryMap = purInSalOutEntryList.get(i);
                        if (i == 0) {
                            InvDirectTranHelper.setSalOutEntryProp(salOutBillEntry, purInSalOutEntryMap, basecache, cacheMap);
                            bizTime = purInSalOutEntryMap.get("biztime");
                            bookDate = purInSalOutEntryMap.get("bookdate");
                            continue;
                        }
                        DynamicObject salOutBillSplitEntry = InvDirectTranHelper.splitSalOutEntry(salOutBillEntry);
                        InvDirectTranHelper.setSalOutEntryProp(salOutBillSplitEntry, purInSalOutEntryMap, basecache, cacheMap);
                        salOutBillSplitEntries.add(salOutBillSplitEntry);
                    }
                }
                if (bizTime != null) {
                    salOutBill.set("biztime", bizTime);
                }
                if (bookDate != null) {
                    salOutBill.set("bookdate", bookDate);
                }
                if (!salOutBillSplitEntries.isEmpty()) {
                    salOutBillEntries.addAll(salOutBillSplitEntries);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salOutBill});
                    salOutBill = BusinessDataServiceHelper.loadSingle((Object)salOutBillId, (String)"im_saloutbill");
                }
                ImBillBotpHelp.reCalFields(salOutBill, "im_saloutbill");
                InvDirectTranHelper.copySerialNumber(salOutBill);
                InvDirectTranHelper.buildBillLink(purInBillId, salOutBill, purInTableId);
                OperationResult opeResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{salOutBill}, (OperateOption)OperateOption.create());
                if (opeResult.isSuccess()) continue;
                result.setSuccess(false);
                result.setMsg(opeResult.getMessage());
            }
        }
        catch (Exception e) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])salOutBillIds.stream().toArray(), (OperateOption)OperateOption.create());
            throw e;
        }
        if (!result.isSuccess()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])salOutBillIds.stream().toArray(), (OperateOption)OperateOption.create());
            return result;
        }
        try {
            OperateOption optionSubmit = OperateOption.create();
            optionSubmit.setVariableValue("WF", "false");
            OperationResult opeResultSubmit = OperationServiceHelper.executeOperate((String)"submit", (String)"im_saloutbill", (Object[])salOutBillIds.stream().toArray(), (OperateOption)optionSubmit);
            OperateOption optionAudit = OperateOption.create();
            optionAudit.setVariableValue("WF", "false");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"im_saloutbill", (Object[])salOutBillIds.stream().toArray(), (OperateOption)optionAudit);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return result;
    }

    private static PushArgs buildPushArgs(Map<Long, List<Map<String, Object>>> purInSalOutMap) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(purInSalOutMap.size());
        for (Map.Entry<Long, List<Map<String, Object>>> purInSalOutEntry : purInSalOutMap.entrySet()) {
            Long soEntryId = purInSalOutEntry.getKey();
            Long soBillId = (Long)purInSalOutEntry.getValue().get(0).get("mainbillid");
            ListSelectedRow selectedRow = new ListSelectedRow((Object)soBillId);
            selectedRow.setEntryEntityKey("billentry");
            selectedRow.setEntryPrimaryKeyValue((Object)soEntryId);
            selectedRows.add(selectedRow);
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sm_salorder");
        pushArgs.setTargetEntityNumber("im_saloutbill");
        pushArgs.setHasRight(true);
        pushArgs.setAppId("im");
        pushArgs.setRuleId(String.valueOf(SOTOSALOUT_TRANSRULE_ID));
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setAutoSave(true);
        return pushArgs;
    }

    private static void setSalOutEntryProp(DynamicObject salOutBillEntry, Map<String, Object> purInSalOutEntryMap, Map<String, Map<Object, DynamicObject>> basecache, Map<String, String> cacheMap) {
        salOutBillEntry.set("srcbillentity", (Object)"im_purinbill");
        salOutBillEntry.set("srcbillentryid", purInSalOutEntryMap.get("srcbillentryid"));
        salOutBillEntry.set("srcbillid", purInSalOutEntryMap.get("srcbillid"));
        salOutBillEntry.set("srcbillnumber", purInSalOutEntryMap.get("srcbillnumber"));
        salOutBillEntry.set("seq", purInSalOutEntryMap.get("srcbillentryseq"));
        salOutBillEntry.set("srcbillentryseq", purInSalOutEntryMap.get("srcbillentryseq"));
        salOutBillEntry.set("unit2nd", (Object)basecache.get("bd_measureunits").get(purInSalOutEntryMap.get("unit2nd")));
        salOutBillEntry.set("warehouse", (Object)basecache.get("bd_warehouse").get(purInSalOutEntryMap.get("warehouse")));
        salOutBillEntry.set("location", (Object)basecache.get("bd_location").get(purInSalOutEntryMap.get("location")));
        salOutBillEntry.set("lot", (Object)basecache.get("bd_lot").get(purInSalOutEntryMap.get("lot")));
        salOutBillEntry.set("lotnumber", purInSalOutEntryMap.get("lotnumber"));
        salOutBillEntry.set("project", (Object)basecache.get("bd_project").get(purInSalOutEntryMap.get("project")));
        salOutBillEntry.set("configuredcode", (Object)basecache.get("bd_configuredcode").get(purInSalOutEntryMap.get("configuredcode")));
        salOutBillEntry.set("tracknumber", (Object)basecache.get("bd_tracknumber").get(purInSalOutEntryMap.get("tracknumber")));
        salOutBillEntry.set("auxpty", purInSalOutEntryMap.get("auxpty"));
        salOutBillEntry.set("producedate", purInSalOutEntryMap.get("producedate"));
        salOutBillEntry.set("expirydate", purInSalOutEntryMap.get("expirydate"));
        salOutBillEntry.set("outowner", purInSalOutEntryMap.get("owner"));
        salOutBillEntry.set("linetype", (Object)basecache.get("bd_linetype").get(purInSalOutEntryMap.get("linetype")));
        BigDecimal baseQty = (BigDecimal)purInSalOutEntryMap.get("baseqty");
        Object material = salOutBillEntry.get("materialmasterid");
        Long materialmasterid = 0L;
        materialmasterid = material instanceof DynamicObject ? (Long)((DynamicObject)material).getPkValue() : (Long)material;
        DynamicObject baseUnit = salOutBillEntry.getDynamicObject("baseunit");
        DynamicObject unit = salOutBillEntry.getDynamicObject("unit");
        BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv(materialmasterid, (Long)baseUnit.getPkValue(), (Long)unit.getPkValue(), cacheMap);
        BigDecimal qty = PrecisionAccountHelper.dealWithprecision(unit, baseQty.multiply(unitRate));
        salOutBillEntry.set("baseqty", (Object)baseQty);
        salOutBillEntry.set("qty", (Object)qty);
        salOutBillEntry.set("remainreturnbaseqty", (Object)baseQty);
        salOutBillEntry.set("remainreturnqty", (Object)qty);
        salOutBillEntry.set("remainjoinpricebaseqty", (Object)baseQty);
        salOutBillEntry.set("remainjoinpriceqty", (Object)qty);
        salOutBillEntry.set("unverifybaseqty", (Object)baseQty);
        salOutBillEntry.set("unverifyqty", (Object)qty);
        salOutBillEntry.set("qtyunit2nd", purInSalOutEntryMap.get("qtyunit2nd"));
        BigDecimal baseMCost = salOutBillEntry.getBigDecimal("unitmaterialcost");
        baseMCost = baseMCost == null ? new BigDecimal(BigInteger.ZERO) : baseMCost;
        salOutBillEntry.set("materialcost", (Object)baseMCost.multiply(qty));
    }

    private static DynamicObject splitSalOutEntry(DynamicObject salOutBillEntry) {
        DynamicObject salOutBillSplitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)salOutBillEntry, (boolean)false, (boolean)true);
        return salOutBillSplitEntry;
    }

    private static void copySerialNumber(DynamicObject salOutBill) {
        DynamicObjectCollection salOutBillEntries = salOutBill.getDynamicObjectCollection("billentry");
        for (DynamicObject salOutBillEntry : salOutBillEntries) {
            DynamicObject material = salOutBillEntry.getDynamicObject("material");
            if (!SerialNumberHelper.isEnableSerial(material)) continue;
            Long purInBillId = salOutBillEntry.getLong("srcbillid");
            Long purInEntryId = salOutBillEntry.getLong("srcbillentryid");
            QFilter filter = new QFilter("billtype", "=", (Object)"im_purinbill").and("entrykey", "=", (Object)"billentry").and("billid", "=", (Object)purInBillId).and("entryid", "=", (Object)purInEntryId);
            DynamicObject purInSNRelation = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_billsnrelation", (QFilter[])filter.toArray());
            if (purInSNRelation == null) continue;
            DynamicObjectCollection purInSNRelationEntries = purInSNRelation.getDynamicObjectCollection("entryentity");
            ArrayList<Map<String, Object>> purInSNs = new ArrayList<Map<String, Object>>(purInSNRelationEntries.size());
            for (DynamicObject purInSNRelationEntry : purInSNRelationEntries) {
                HashMap<String, Object> purInSN = new HashMap<String, Object>(5);
                purInSN.put("snnumber", purInSNRelationEntry.get("snnumber"));
                purInSN.put("seq", purInSNRelationEntry.get("seq"));
                purInSN.put("invorg", purInSNRelationEntry.get("invorg"));
                purInSN.put("imei", purInSNRelationEntry.get("imei"));
                purInSN.put("meid", purInSNRelationEntry.get("meid"));
                purInSNs.add(purInSN);
            }
            SerialNumberHelper.quickBatchInputSerialNumber("im_saloutbill", salOutBill.getPkValue(), "billentry", salOutBillEntry.getPkValue(), "im_purinbill", purInBillId, "billentry", purInEntryId, material.get("id"), purInSNs);
        }
    }

    private static void buildBillLink(Long sourceBillid, DynamicObject targetBill, Long purInTableId) {
        if (sourceBillid == null || targetBill == null || purInTableId == null) {
            return;
        }
        DynamicObjectCollection linkRows = (DynamicObjectCollection)targetBill.get("billhead_lk");
        DynamicObject linkRow = linkRows.addNew();
        linkRow.set("billhead_lk_stableid", (Object)purInTableId);
        linkRow.set("billhead_lk_sbillid", (Object)sourceBillid);
        linkRow.set("billhead_lk_sid", (Object)sourceBillid);
    }

    private static Map<Long, List<Map<String, Object>>> getPurInSalOutEntryRelMap(Long purInBillId, Map<String, Map<Object, DynamicObject>> basecache) {
        HashMap<Long, List<Map<String, Object>>> purInSalOutMap = new HashMap<Long, List<Map<String, Object>>>();
        String purInBillSelects = "id,billno,biztime,bookdate,billentry.id as entryid,billentry.seq as seq,billentry.baseunit as baseunit,billentry.baseqty as baseqty,billentry.unit as unit,billentry.qty as qty,billentry.unit2nd as unit2nd,billentry.qtyunit2nd as qtyunit2nd,billentry.warehouse as warehouse,billentry.location as location,billentry.lot as lot,billentry.lotnumber as lotnumber,billentry.project as project,billentry.auxpty as auxpty,billentry.producedate as producedate,billentry.expirydate as expirydate,billentry.owner as owner,billentry.linetype as linetype,billentry.mainbillentryid as mainbillentryid,billentry.mainbillid as mainbillid,billentry.configuredcode as configuredcode,billentry.tracknumber as tracknumber";
        DataSet purInBillSet = QueryServiceHelper.queryDataSet((String)InvDirectTranHelper.class.getName(), (String)"im_purinbill", (String)purInBillSelects, (QFilter[])new QFilter("id", "=", (Object)purInBillId).toArray(), (String)"");
        HashSet poBillIds = new HashSet(8);
        purInBillSet.copy().forEach(row -> {
            Long poBillId = row.getLong("mainbillid");
            poBillIds.add(poBillId);
        });
        DataSet poBillSet = QueryServiceHelper.queryDataSet((String)InvDirectTranHelper.class.getName(), (String)"pm_purorderbill", (String)"billentry.salbillentryid as salbillentryid,billentry.salbillid as salbillid,billentry.id as poentryid", (QFilter[])new QFilter("id", "in", poBillIds).toArray(), (String)"");
        purInBillSet = purInBillSet.leftJoin(poBillSet).on("mainbillentryid", "poentryid").select(purInBillSet.getRowMeta().getFieldNames(), poBillSet.getRowMeta().getFieldNames()).finish();
        HashSet soBillIds = new HashSet(8);
        purInBillSet.copy().forEach(row -> {
            Long soBillId = row.getLong("salbillid");
            soBillIds.add(soBillId);
        });
        DataSet soBillSet = QueryServiceHelper.queryDataSet((String)InvDirectTranHelper.class.getName(), (String)"sm_salorder", (String)"id as sobillid,billentry.id as soentryid", (QFilter[])new QFilter("id", "in", soBillIds).toArray(), (String)"");
        purInBillSet = purInBillSet.leftJoin(soBillSet).on("salbillentryid", "soentryid").select(purInBillSet.getRowMeta().getFieldNames(), soBillSet.getRowMeta().getFieldNames()).finish();
        boolean notSoEntryFlag = false;
        HashSet<Long> unitids = new HashSet<Long>();
        HashSet<Long> warehouseids = new HashSet<Long>();
        HashSet<Long> locationids = new HashSet<Long>();
        HashSet<Long> lotids = new HashSet<Long>();
        HashSet<Long> projectids = new HashSet<Long>();
        HashSet<Long> configuredcodeids = new HashSet<Long>();
        HashSet<Long> tracknumberids = new HashSet<Long>();
        HashSet<Long> linetypeids = new HashSet<Long>();
        for (Row row2 : purInBillSet) {
            Long soEntryId = row2.getLong("soentryid");
            if (Objects.isNull(soEntryId) || soEntryId == 0L) {
                notSoEntryFlag = true;
            }
            HashMap<String, Object> purInAttrMap = new HashMap<String, Object>(32);
            purInAttrMap.put("biztime", row2.get("biztime"));
            purInAttrMap.put("srcbillentryid", row2.get("entryid"));
            purInAttrMap.put("srcbillid", row2.get("id"));
            purInAttrMap.put("srcbillnumber", row2.get("billno"));
            purInAttrMap.put("srcbillentryseq", row2.get("seq"));
            purInAttrMap.put("mainbillid", row2.get("sobillid"));
            purInAttrMap.put("baseunit", row2.get("baseunit"));
            purInAttrMap.put("baseqty", row2.getBigDecimal("baseqty"));
            purInAttrMap.put("unit", row2.get("unit"));
            purInAttrMap.put("qty", row2.getBigDecimal("qty"));
            purInAttrMap.put("unit2nd", row2.get("unit2nd"));
            purInAttrMap.put("qtyunit2nd", row2.get("qtyunit2nd"));
            purInAttrMap.put("warehouse", row2.get("warehouse"));
            purInAttrMap.put("location", row2.get("location"));
            purInAttrMap.put("lot", row2.get("lot"));
            purInAttrMap.put("lotnumber", row2.get("lotnumber"));
            purInAttrMap.put("project", row2.get("project"));
            purInAttrMap.put("configuredcode", row2.get("configuredcode"));
            purInAttrMap.put("tracknumber", row2.get("tracknumber"));
            purInAttrMap.put("auxpty", row2.get("auxpty"));
            purInAttrMap.put("producedate", row2.get("producedate"));
            purInAttrMap.put("expirydate", row2.get("expirydate"));
            purInAttrMap.put("owner", row2.get("owner"));
            purInAttrMap.put("linetype", row2.get("linetype"));
            purInAttrMap.put("bookdate", row2.get("bookdate"));
            unitids.add(row2.getLong("unit"));
            unitids.add(row2.getLong("unit2nd"));
            warehouseids.add(row2.getLong("warehouse"));
            locationids.add(row2.getLong("location"));
            lotids.add(row2.getLong("lot"));
            projectids.add(row2.getLong("project"));
            configuredcodeids.add(row2.getLong("configuredcode"));
            tracknumberids.add(row2.getLong("tracknumber"));
            linetypeids.add(row2.getLong("linetype"));
            List purInAttrList = purInSalOutMap.getOrDefault(soEntryId, new ArrayList());
            purInAttrList.add(purInAttrMap);
            if (purInSalOutMap.containsKey(soEntryId)) continue;
            purInSalOutMap.put(soEntryId, purInAttrList);
        }
        if (notSoEntryFlag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u76f4\u8fd0\u9500\u552e\u8ba2\u5355\u884c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"InvDirectTranHelper_7", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        Map unitmap = BusinessDataServiceHelper.loadFromCache((Object[])unitids.toArray(), (String)"bd_measureunits");
        basecache.put("bd_measureunits", unitmap);
        Map warehousemap = BusinessDataServiceHelper.loadFromCache((Object[])warehouseids.toArray(), (String)"bd_warehouse");
        basecache.put("bd_warehouse", warehousemap);
        Map locationmap = BusinessDataServiceHelper.loadFromCache((Object[])locationids.toArray(), (String)"bd_location");
        basecache.put("bd_location", locationmap);
        Map lotmap = BusinessDataServiceHelper.loadFromCache((Object[])lotids.toArray(), (String)"bd_lot");
        basecache.put("bd_lot", lotmap);
        Map projectmap = BusinessDataServiceHelper.loadFromCache((Object[])projectids.toArray(), (String)"bd_project");
        basecache.put("bd_project", projectmap);
        Map configuredcodemap = BusinessDataServiceHelper.loadFromCache((Object[])configuredcodeids.toArray(), (String)"bd_configuredcode");
        basecache.put("bd_configuredcode", configuredcodemap);
        Map tracknumbermap = BusinessDataServiceHelper.loadFromCache((Object[])tracknumberids.toArray(), (String)"bd_tracknumber");
        basecache.put("bd_tracknumber", tracknumbermap);
        Map linetypemap = BusinessDataServiceHelper.loadFromCache((Object[])linetypeids.toArray(), (String)"bd_linetype");
        basecache.put("bd_linetype", linetypemap);
        return purInSalOutMap;
    }

    public static HandleResult createSaleOutBillBatch(List<Long> purInBillIds) {
        HandleResult result = new HandleResult(true);
        if (Objects.isNull(purInBillIds)) {
            return result;
        }
        if (purInBillIds.isEmpty()) {
            return result;
        }
        DynamicObject[] purInBills = BusinessDataServiceHelper.load((String)"im_purinbill", (String)"id,billno,billstatus,supplytrans", (QFilter[])new QFilter("supplytrans", "=", (Object)"1").and("id", "in", purInBillIds).and("billstatus", "=", (Object)"C").toArray());
        if (Objects.isNull(purInBills)) {
            return result;
        }
        StringBuilder errMsg = new StringBuilder();
        for (DynamicObject purInBill : purInBills) {
            HandleResult curResult = InvDirectTranHelper.createSaleOutBill(purInBill);
            if (curResult.isSuccess()) continue;
            if (!result.isSuccess()) {
                errMsg.append(',');
            }
            result.setSuccess(false);
            errMsg.append(curResult.getMsg());
        }
        if (!result.isSuccess()) {
            result.setMsg(errMsg.toString());
        }
        return result;
    }

    public static HandleResult deleteSaleOutBill(DynamicObject salOutBill) {
        if (Objects.isNull(salOutBill)) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a", (String)"InvDirectTranHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!"im_saloutbill".equals(salOutBill.getDynamicObjectType().getName())) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u5355\u636e\u7c7b\u578b\u4e0d\u662f\u9500\u552e\u51fa\u5e93\u5355\u3002", (String)"InvDirectTranHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!InvDirectTranHelper.isSupplyTrans(salOutBill)) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f\u76f4\u8fd0\u7c7b\u578b\u3002", (String)"InvDirectTranHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        String salOutBillStatus = (String)salOutBill.get("billstatus");
        OperateOption option = OperateOption.create();
        option.setVariableValue(BACKWRITEOFF_TAG, "true");
        OperationResult opeResult = null;
        Object[] salOutBillId = new Long[]{(Long)salOutBill.getPkValue()};
        switch (salOutBillStatus) {
            case "C": {
                opeResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])salOutBillId, (OperateOption)option);
                break;
            }
            case "B": {
                opeResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"im_saloutbill", (Object[])salOutBillId, (OperateOption)option);
            }
        }
        if (opeResult != null && !opeResult.isSuccess()) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838/\u64a4\u9500\u5355\u636e\u5931\u8d25\u3002", (String)"InvDirectTranHelper_2", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        opeResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])salOutBillId, (OperateOption)option);
        if (!opeResult.isSuccess()) {
            return new HandleResult(false, ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e\u5931\u8d25", (String)"InvDirectTranHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        return new HandleResult(true);
    }

    private static String getOpeResultErrmsg(String operate, OperationResult opeResult) {
        StringBuilder sb = new StringBuilder(operate).append(':');
        if (!opeResult.isSuccess()) {
            sb.append(opeResult.getMessage());
            sb.append(';');
            opeResult.getAllErrorInfo().forEach(info -> {
                sb.append(info.getMessage());
                sb.append(';');
            });
            opeResult.getAllErrorOrValidateInfo().forEach(info -> {
                sb.append(info.getMessage());
                sb.append(';');
            });
        } else {
            sb.append("success");
        }
        return sb.toString();
    }
}

