/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.freeze;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.pojo.freeze.FreezeBizEntity;
import kd.scmc.im.business.pojo.freeze.FreezeIgnore;
import kd.scmc.im.business.pojo.freeze.FreezeIgnoreExpression;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FreezeIgnoreHelper {
    private static final String FIELDS = new StringJoiner(",").add("freezeentity").add("providerentity").add("entryenable").add("bizentity").add("conditionformula_tag").add("conditionjson_tag").toString();

    public static List<FreezeIgnore> load(String providerEntityNumber) {
        QFilter qFilter = new QFilter("providerentity", "=", (Object)providerEntityNumber).and("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] configList = BusinessDataServiceHelper.load((String)"msmod_freezeignore", (String)FIELDS, (QFilter[])qFilter.toArray());
        ArrayList<FreezeIgnore> freezeIgnoreList = new ArrayList<FreezeIgnore>(configList.length);
        if (ObjectUtils.isNotEmpty((Object)configList)) {
            for (DynamicObject dynamicObject : configList) {
                FreezeIgnore freezeIgnore = FreezeIgnoreHelper.parseIgnoreSetting(dynamicObject);
                CollectionUtils.addIgnoreNull(freezeIgnoreList, (Object)freezeIgnore);
            }
        }
        return freezeIgnoreList;
    }

    private static FreezeIgnore parseIgnoreSetting(DynamicObject config) {
        if (null == config || null == config.get("freezeentity") || null == config.get("providerentity")) {
            return null;
        }
        FreezeIgnore freezeIgnore = new FreezeIgnore();
        freezeIgnore.setFreezeEntity(new FreezeBizEntity(config.getDynamicObject("freezeentity")));
        freezeIgnore.setProviderEntity(new FreezeBizEntity(config.getDynamicObject("providerentity")));
        DynamicObjectCollection entryRows = config.getDynamicObjectCollection("entryentity");
        freezeIgnore.setFreezeIgnoreExpressionList(FreezeIgnoreHelper.parseIgnoreExpressionList(entryRows));
        return freezeIgnore;
    }

    private static List<FreezeIgnoreExpression> parseIgnoreExpressionList(DynamicObjectCollection entryRows) {
        ArrayList<FreezeIgnoreExpression> freezeIgnoreExpressionList = new ArrayList<FreezeIgnoreExpression>(entryRows.size());
        for (DynamicObject entryRow : entryRows) {
            boolean enable = entryRow.getBoolean("entryenable");
            if (!enable) continue;
            FreezeIgnoreExpression freezeIgnoreExpression = new FreezeIgnoreExpression();
            freezeIgnoreExpression.setBizEntity(new FreezeBizEntity(entryRow.getDynamicObject("bizentity")));
            freezeIgnoreExpression.setExpression(entryRow.getString("conditionformula_tag"));
            freezeIgnoreExpression.setFilterJson(entryRow.getString("conditionjson_tag"));
            freezeIgnoreExpressionList.add(freezeIgnoreExpression);
        }
        return freezeIgnoreExpressionList;
    }
}

