/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.impt;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.pojo.GeneralValResultInfo;

@Deprecated
public class ImptValidateHelper {
    public static boolean checkLingualismTxtLen(Map<String, String> txtData, int limitLen) {
        if (txtData != null && !txtData.isEmpty()) {
            String txtCN = txtData.get("zh_CN");
            String txtTW = txtData.get("zh_TW");
            String txtEN = txtData.get("en_US");
            Boolean isTxtCN = txtCN != null && txtCN.length() > limitLen;
            Boolean isTxtTW = txtTW != null && txtTW.length() > limitLen;
            Boolean isTxtEN = txtEN != null && txtEN.length() > limitLen;
            if (isTxtCN.booleanValue() || isTxtTW.booleanValue() || isTxtEN.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isEnableLot(DynamicObject materialStategyDym) {
        if (materialStategyDym == null) {
            return false;
        }
        return materialStategyDym.getBoolean("enablelot");
    }

    public static boolean isEnableShelflifeMgr(DynamicObject materialStategyDym) {
        if (materialStategyDym == null) {
            return false;
        }
        return materialStategyDym.getBoolean("enableshelflifemgr");
    }

    public static boolean isNumeric(String inputNum) {
        Pattern pattern = Pattern.compile("-?[0-9]+\\.?[0-9]*");
        String bigStr = null;
        try {
            bigStr = new BigDecimal(inputNum).toString();
        }
        catch (Exception e) {
            return false;
        }
        Matcher isNum = pattern.matcher(bigStr);
        return isNum.matches();
    }

    public static GeneralValResultInfo checkBizDept(DynamicObject billObj, List<Long> bizDeptIds) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        DynamicObject org = billObj.getDynamicObject("org");
        if (org == null) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ImptValidateHelperOrgtErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        String orgNum = org.getString("number");
        DynamicObject bizDept = billObj.getDynamicObject("bizdept");
        Long bizDeptId = bizDept == null ? 0L : bizDept.getLong("id");
        if (bizDept != null && bizDeptIds != null && !bizDeptIds.contains(bizDeptId)) {
            String bizDeptNum = bizDept.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u5e93\u7ba1\u90e8\u95e8\u201c%2$s\u201d\u6216\u8be5\u5e93\u7ba1\u90e8\u95e8\u5df2\u88ab\u5c01\u5b58\u3002", (String)"ImptValidateHelperCkDeptErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, bizDeptNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkTransferCause(Map<String, String> transfercauseData) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (!ImptValidateHelper.checkLingualismTxtLen(transfercauseData, 255)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u539f\u56e0\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002", (String)"ImptValidateHelperCkTransferCauseErr", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkCurrency(DynamicObject currency) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (!currency.getBoolean("enable")) {
            String currencyNum = currency.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e01\u79cd\u201c%s\u201d\u4e0d\u53ef\u7528\u3002", (String)"ImptValidateHelperCurrencyErr", (String)"scmc-im-business", (Object[])new Object[0]), currencyNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkPrice(BigDecimal price) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        BigDecimal maxValue = new BigDecimal("999999999999");
        if (maxValue.compareTo(price) <= 0 || BigDecimal.ZERO.compareTo(price) > 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c0\u2264\u4ef7\u683c\u22649999999999999\u201d\u7684\u5355\u4ef7\u3002", (String)"ImptValidateHelperCkPriceErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static Map<String, Object> checkAuxpty(DynamicObject entryObj, Map<String, Object> proKeyToAuxInfo, Map<Long, Integer> materialToAuxptySize, Map<Long, List<Map<String, Object>>> materialToAuxSetup) {
        Map<String, Object> checkResult = new HashMap<String, Object>();
        DynamicObject materialStategy = entryObj.getDynamicObject("material");
        DynamicObject materialObj = materialStategy.getDynamicObject("masterid");
        boolean isuseauxpty = materialObj.getBoolean("isuseauxpty");
        if (isuseauxpty && !proKeyToAuxInfo.isEmpty()) {
            Long materialId = materialObj.getLong("id");
            String materialNum = materialObj.getString("number");
            DynamicObject auxpty = entryObj.getDynamicObject("auxpty");
            String auxValue = auxpty.getString("value");
            try {
                Map imptAuxData = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
                int imptAuxSize = imptAuxData.size();
                int auxSizeOfMt = materialToAuxptySize.get(materialId);
                if (imptAuxSize != auxSizeOfMt) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u8f93\u5165\u5b8c\u6574\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u3002", (String)"ImptValidateHelperCkAuxptyErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum);
                    checkResult.put("isSuccess", Boolean.FALSE);
                    checkResult.put("isNext", Boolean.TRUE);
                    checkResult.put("isPBreak", Boolean.FALSE);
                    checkResult.put("errMsg", errMsg);
                    return checkResult;
                }
                List<Map<String, Object>> auxSetupList = materialToAuxSetup.get(materialId);
                if (auxSetupList == null || auxSetupList.isEmpty()) {
                    checkResult.put("isSuccess", Boolean.TRUE);
                    checkResult.put("isNext", Boolean.FALSE);
                    checkResult.put("isPBreak", Boolean.FALSE);
                    return checkResult;
                }
                for (Map<String, Object> auxSetup : auxSetupList) {
                    Object length;
                    String valType = String.valueOf(auxSetup.get("valType"));
                    String valueType = String.valueOf(auxSetup.get("valueType"));
                    String flexfield = String.valueOf(auxSetup.get("flexfield"));
                    String txtVal = String.valueOf(imptAuxData.get(flexfield));
                    if ("3".equals(valueType) && StringUtils.isNotEmpty((CharSequence)txtVal) && txtVal.contains("importprop=")) {
                        String errMsg = String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u5df2\u66f4\u65b0\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u5bfc\u5165\u6a21\u677f\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImptValidateHelperCkAuxptyUpdReImpt", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
                        return ImptValidateHelper.getCheckAuxErrResult(errMsg);
                    }
                    String auxptyName = String.valueOf(auxSetup.get("auxptyName"));
                    boolean istrim = (Boolean)auxSetup.get("istrim");
                    if (istrim && StringUtils.isNotEmpty((CharSequence)txtVal)) {
                        txtVal = txtVal.trim();
                    }
                    if ("decimal".equals(valType) && StringUtils.isNotEmpty((CharSequence)txtVal)) {
                        checkResult = ImptValidateHelper.checkAuxptyByDecimal(materialNum, auxSetup, txtVal, auxptyName);
                        if (checkResult.isEmpty()) continue;
                        return checkResult;
                    }
                    if (!"varchar".equals(valType) || !StringUtils.isNotEmpty((CharSequence)txtVal) || (length = auxSetup.get("length")) == null || txtVal.length() <= (Integer)length || (Integer)length == 0) continue;
                    String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u5b57\u7b26\u5927\u5c0f\u8d85\u8fc7\u503c\u6700\u5927\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyLenErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
                    return ImptValidateHelper.getCheckAuxErrResult(errMsg);
                }
            }
            catch (IOException e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u503c\u89e3\u6790\u5f02\u5e38\uff1a%s\u3002", (String)"ImptValidateHelperAuxptyParseErr", (String)"scmc-im-business", (Object[])new Object[0]), e.getMessage()));
            }
        }
        checkResult.put("isSuccess", Boolean.TRUE);
        checkResult.put("isNext", Boolean.FALSE);
        checkResult.put("isPBreak", Boolean.FALSE);
        return checkResult;
    }

    private static Map<String, Object> checkAuxptyByDecimal(String materialNum, Map<String, Object> auxSetup, String txtVal, String auxptyName) {
        if (!ImptValidateHelper.isNumeric(txtVal)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0d\u662f\u6570\u5b57\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyNumErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            return ImptValidateHelper.getCheckAuxErrResult(errMsg);
        }
        BigDecimal inputDec = new BigDecimal(txtVal);
        Double minValue = (Double)auxSetup.get("minValue");
        BigDecimal decMinVal = BigDecimal.valueOf(minValue);
        if (inputDec.compareTo(decMinVal) < 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0d\u80fd\u5c0f\u4e8e\u8bbe\u7f6e\u7684\u6700\u5c0f\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyMinErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            return ImptValidateHelper.getCheckAuxErrResult(errMsg);
        }
        Double maxValue = (Double)auxSetup.get("maxValue");
        BigDecimal decMaxVal = BigDecimal.valueOf(maxValue);
        if (inputDec.compareTo(decMaxVal) > 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0d\u80fd\u5927\u4e8e\u8bbe\u7f6e\u7684\u6700\u5927\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyMaxErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            return ImptValidateHelper.getCheckAuxErrResult(errMsg);
        }
        int precision = (Integer)auxSetup.get("precision");
        int scale = (Integer)auxSetup.get("scale");
        if (txtVal.contains(".")) {
            int dotIndex = txtVal.indexOf(".");
            String integers = txtVal.substring(0, dotIndex);
            if (integers.length() > precision) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0e\u6574\u4f53\u7cbe\u5ea6\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyPreciErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
                return ImptValidateHelper.getCheckAuxErrResult(errMsg);
            }
        } else if (txtVal.length() > precision) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u8f85\u52a9\u5c5e\u6027\u503c\u201c%2$s\u201d\u4e0e\u6574\u4f53\u7cbe\u5ea6\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ImptValidateHelperCkAuxptyPreciErr", (String)"scmc-im-business", (Object[])new Object[0]), materialNum, auxptyName);
            return ImptValidateHelper.getCheckAuxErrResult(errMsg);
        }
        inputDec = inputDec.setScale(scale, RoundingMode.DOWN);
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> getCheckAuxErrResult(String errMsg) {
        HashMap<String, Object> checkResult = new HashMap<String, Object>();
        checkResult.put("isSuccess", Boolean.FALSE);
        checkResult.put("isNext", Boolean.TRUE);
        checkResult.put("isPBreak", Boolean.TRUE);
        checkResult.put("errMsg", errMsg);
        return checkResult;
    }

    public static GeneralValResultInfo checkQty(BigDecimal qty, BigDecimal qtyunit2nd) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        BigDecimal maxValue = new BigDecimal("999999999999");
        if (maxValue.compareTo(qty) < 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c0\u2264\u6570\u91cf\u22649999999999999\u201d\u7684\u6570\u91cf\u3002", (String)"ImptValidateHelperCkQtyErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        if (maxValue.compareTo(qtyunit2nd) < 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u503c\u8303\u56f4\u4e3a\u201c0\u2264\u8f85\u52a9\u6570\u91cf\u22649999999999999\u201d\u7684\u8f85\u52a9\u6570\u91cf\u3002", (String)"ImptValidateHelperCkQty2ndErr", (String)"scmc-im-business", (Object[])new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkUnit(Set<Long> fixedConvUnits, Long unitId) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (fixedConvUnits == null || fixedConvUnits.isEmpty() || !fixedConvUnits.contains(unitId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u5fc5\u987b\u4e0e\u57fa\u672c\u5355\u4f4d\u6709\u56fa\u5b9a\u6362\u7b97\u5173\u7cfb\u3002", (String)"ImptValidateHelperCkUnitErr", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    @Deprecated
    public static GeneralValResultInfo checkLocation(DynamicObject entryObj, DynamicObject warehouse, String outLocation) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (warehouse == null) {
            return valResultInfo;
        }
        boolean isOpenlocation = warehouse.getBoolean("isopenlocation");
        Long locationId = entryObj.getLong(outLocation);
        String warehouseNum = warehouse.getString("number");
        if (locationId == null || locationId.equals(0L)) {
            return valResultInfo;
        }
        if (!isOpenlocation) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1s\u201d\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImptValidateHelperCkLocatErr_3", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        Long warehouseId = (Long)warehouse.getPkValue();
        boolean isContains = WarehouseHelper.containLocationInWarehouse(warehouseId, locationId);
        if (!isContains) {
            String locationNum = entryObj.getString("location.number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c%1$s\u201d\u4e0e\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ImptValidateHelperCkLocatErr_2", (String)"scmc-im-business", (Object[])new Object[0]), locationNum, warehouseNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkLocation(DynamicObject entryObj, DynamicObject warehouse, String outLocation, Map<Long, Set<Long>> whIdToLocationIdsMap) {
        boolean isContains;
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (warehouse == null) {
            return valResultInfo;
        }
        boolean isOpenlocation = warehouse.getBoolean("isopenlocation");
        Long locationId = entryObj.getLong(outLocation);
        String warehouseNum = warehouse.getString("number");
        if (locationId == null || locationId.equals(0L)) {
            return valResultInfo;
        }
        if (!isOpenlocation) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u201c%1s\u201d\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ImptValidateHelperCkLocatErr_3", (String)"scmc-im-business", (Object[])new Object[0]), warehouseNum);
            valResultInfo.setErrValResult(errMsg);
            return valResultInfo;
        }
        Long warehouseId = (Long)warehouse.getPkValue();
        boolean bl = isContains = whIdToLocationIdsMap.get(warehouseId) != null && whIdToLocationIdsMap.get(warehouseId).contains(locationId);
        if (!isContains) {
            String locationNum = entryObj.getString("location.number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4ed3\u4f4d\u201c%1$s\u201d\u4e0e\u4ed3\u5e93\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"ImptValidateHelperCkLocatErr_2", (String)"scmc-im-business", (Object[])new Object[0]), locationNum, warehouseNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkInvType(DynamicObject invType) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (invType != null) {
            boolean isEnableType = invType.getBoolean("enable");
            String invTypeNum = invType.getString("number");
            if (!isEnableType) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e93\u5b58\u7c7b\u578b\u4e0d\u53ef\u7528\u3002", (String)"ImptValidateHelperCkInvTypeErr_3", (String)"scmc-im-business", (Object[])new Object[0]), invTypeNum);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkInvStatus(DynamicObject invStatus) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (invStatus != null) {
            boolean isEnableStatus = invStatus.getBoolean("enable");
            String invStatusNum = invStatus.getString("number");
            if (!isEnableStatus) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e93\u5b58\u72b6\u6001\u4e0d\u53ef\u7528\u3002", (String)"ImptValidateHelperCkInvStatusErr", (String)"scmc-im-business", (Object[])new Object[0]), invStatusNum);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkOwner(DynamicObject billObj, String ownerType, DynamicObject owner, DynamicObject reqOrg, DynamicObject org, List<Object> accountOwners, String billType) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if ("bos_org".equals(ownerType) && owner != null) {
            Object ownerId = owner.getPkValue();
            String ownerNum = owner.getString("number");
            String orgNum = org.getString("number");
            if ("im_purinbill".equals(billType)) {
                Map orgMap = new HashMap(16);
                if (org != null) {
                    orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()), (Boolean)false, (Boolean)true);
                }
                if (orgMap == null) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u7c7b\u578b\u8d27\u4e3b\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u8be5\u8d27\u4e3b\u6570\u636e\u3002", (String)"ImptValidateHelperCkOwnerErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, ownerNum);
                    valResultInfo.setErrValResult(errMsg);
                } else if (!owner.getPkValue().equals(orgMap.get("id"))) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u7c7b\u578b\u8d27\u4e3b\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u8be5\u8d27\u4e3b\u6570\u636e\u3002", (String)"ImptValidateHelperCkOwnerErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, ownerNum);
                    valResultInfo.setErrValResult(errMsg);
                }
            } else if (!(accountOwners != null && !accountOwners.isEmpty() && accountOwners.contains(ownerId) || orgNum.equals(ownerNum))) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u6838\u7b97\u7ec4\u7ec7\u7c7b\u578b\u8d27\u4e3b\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u8be5\u8d27\u4e3b\u6570\u636e\u3002", (String)"ImptValidateHelperCkOwnerErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, ownerNum);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkReqOrg(DynamicObject billObj, DynamicObject reqOrg, Set<Long> bosOrgs) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        DynamicObject org = billObj.getDynamicObject("org");
        Long orgId = org.getLong("id");
        Long reqOrgId = reqOrg.getLong("id");
        String reqNum = reqOrg.getString("number");
        if (!bosOrgs.contains(reqOrgId) && !bosOrgs.contains(orgId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u9700\u6c42\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u5143\u8303\u56f4\u5185\u7684\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImptValidateHelperCkReqOrgErr", (String)"scmc-im-business", (Object[])new Object[0]), reqNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkBizType(Set<Long> bizTypeIds, DynamicObject bizType) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (bizType == null) {
            return valResultInfo;
        }
        Long bizTypeId = bizType.getLong("id");
        if (!bizTypeIds.contains(bizTypeId)) {
            String bizTypeNum = bizType.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u201c%s\u201d\u4e0e\u5355\u636e\u4e0d\u5339\u914d\u6216\u7981\u7528\u3002", (String)"ImptValidateHelperCkBizTypeErr", (String)"scmc-im-business", (Object[])new Object[0]), bizTypeNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkComment(Map<String, String> commentData) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (!ImptValidateHelper.checkLingualismTxtLen(commentData, 255)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5907\u6ce8\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26\u3002", (String)"ImptValidateHelperCkCommentErr", (String)"scmc-im-business", (Object[])new Object[0]), 255);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkDept(DynamicObject billObj, List<Long> deptIds) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        DynamicObject org = billObj.getDynamicObject("org");
        String orgNum = org == null ? "" : org.getString("number");
        DynamicObject dept = billObj.getDynamicObject("dept");
        Long deptId = dept == null ? 0L : dept.getLong("id");
        if (dept != null && deptIds != null && !deptIds.contains(deptId)) {
            String deptNum = dept.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u5e93\u7ba1\u90e8\u95e8\u201c%2$s\u201d\u6216\u8be5\u5e93\u7ba1\u90e8\u95e8\u5df2\u88ab\u5c01\u5b58\u3002", (String)"ImptValidateHelperCkDeptErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, deptNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkCustomer(DynamicObject billObj, Set<Long> customers) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        DynamicObject org = billObj.getDynamicObject("org");
        String orgNum = org.getString("number");
        DynamicObject customer = billObj.getDynamicObject("customer");
        Long customerId = customer == null ? 0L : customer.getLong("id");
        if (customer != null && !customers.contains(customerId)) {
            String customerNum = customer.getString("number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u5ba2\u6237\u201c%2$s\u201d\u3002", (String)"ImptValidateHelperCkCustomerErr", (String)"scmc-im-business", (Object[])new Object[0]), orgNum, customerNum);
            valResultInfo.setErrValResult(errMsg);
        }
        return valResultInfo;
    }

    public static GeneralValResultInfo checkInvschemes(DynamicObject invscheme, List<Long> invschemes) {
        GeneralValResultInfo valResultInfo = new GeneralValResultInfo();
        if (invscheme == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImptValidateHelperCkInvschemeEmpty", (String)"scmc-im-business", (Object[])new Object[0]), new Object[0]);
            valResultInfo.setErrValResult(errMsg);
        } else {
            Long invschemeId = invscheme.getLong("id");
            if (invschemes != null && !invschemes.isEmpty() && !invschemes.contains(invschemeId)) {
                String invschemeNum = invscheme.getString("number");
                String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4e8b\u52a1\u201c%s\u201d\u4e0e\u5355\u636e\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5e93\u5b58\u4e8b\u52a1\u3002", (String)"ImptValidateHelperCkInvschemeErr", (String)"scmc-im-business", (Object[])new Object[0]), invschemeNum);
                valResultInfo.setErrValResult(errMsg);
            }
        }
        return valResultInfo;
    }
}

