/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.invplan;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InvPlanHelper {
    private static final String MRP_MUTEX_GROUP_ID = "mmc.mrp";

    public static boolean isExistInvRunning(Long planId) {
        if (planId == null) {
            return false;
        }
        Map lockMap = MutexFactory.createDataMutex().getLockInfo(String.valueOf(planId), MRP_MUTEX_GROUP_ID, "mrp_planprogram");
        QFilter qFilter = new QFilter("plangram", "=", (Object)planId);
        qFilter.and(new QFilter("calculatestatus", "=", (Object)"D"));
        qFilter.and(new QFilter("runtype", "=", (Object)"F"));
        return lockMap != null || QueryServiceHelper.exists((String)"mrp_caculate_log", (QFilter[])new QFilter[]{qFilter});
    }

    public static String getPlanType(DynamicObject plangram) {
        if (plangram == null) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(4);
        if (plangram.getBoolean("ismrp")) {
            list.add("MRP");
        }
        if (plangram.getBoolean("ismps")) {
            list.add("MPS");
        }
        if (plangram.getBoolean("isreorderpoint")) {
            list.add(ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"InvPlanHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (plangram.getBoolean("hiloinv")) {
            list.add(ResManager.loadKDString((String)"\u6700\u5927\u6700\u5c0f\u5e93\u5b58", (String)"InvPlanHelper_2", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        String s = ((Object)list).toString();
        return s.replace("[", "").replace("]", "").replace(", ", "/");
    }
}

