/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.invplan;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.invplan.MRPDate;
import kd.scmc.im.business.helper.invplan.WorkCalendarDayType;
import kd.scmc.im.business.helper.invplan.WorkCalendarStatus;
import kd.scmc.im.errorcode.InvBillErrorCode;

public class OrgBasedCalendarModel {
    private MRPDate maxDate = null;
    private MRPDate minDate = null;
    private String orgId = null;
    private DynamicObject defCal;
    private List<MRPDate> dates;
    private HashMap<Date, Integer> periods;
    private boolean isSatRest;
    private boolean isSunRest;
    private boolean isMonRest;
    private boolean isTueRest;
    private boolean isWenRest;
    private boolean isThuRest;
    private boolean isFriRest;

    public OrgBasedCalendarModel(String orgId) {
        this.orgId = orgId;
        this.initData();
    }

    private void initData() {
        this.dates = new ArrayList<MRPDate>(16);
        this.periods = new HashMap(16);
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("createorg.id", "=", (Object)Long.valueOf(this.orgId)), new QFilter("isfault", "=", (Object)Character.valueOf('1')), new QFilter("status", "=", (Object)WorkCalendarStatus.AUDITED.getValue()), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        this.defCal = orm.queryOne("mrp_plancalendar", "id", filters);
        if (this.defCal == null) {
            return;
        }
        this.defCal = BusinessDataServiceHelper.loadSingle((Object)this.defCal.getLong("id"), (String)"mrp_plancalendar");
        this.isSatRest = this.defCal.getBoolean("issatrest");
        this.isSunRest = this.defCal.getBoolean("issunrest");
        this.isMonRest = this.defCal.getBoolean("ismonrest");
        this.isTueRest = this.defCal.getBoolean("istuerest");
        this.isWenRest = this.defCal.getBoolean("iswedrest");
        this.isThuRest = this.defCal.getBoolean("isthurest");
        this.isFriRest = this.defCal.getBoolean("isfrirest");
        if (this.isSatRest && this.isSunRest && this.isMonRest && this.isTueRest && this.isWenRest && this.isThuRest && this.isFriRest) {
            throw new KDBizException(new InvBillErrorCode().getNO_WORK_DAY_IN_CALENDAR(), new Object[0]);
        }
        DynamicObjectCollection entrys = this.defCal.getDynamicObjectCollection("dateentry");
        Collections.sort(entrys, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o1.getDate("workdate").compareTo(o2.getDate("workdate"));
            }
        });
        MRPDate previousWork = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Calendar cal = Calendar.getInstance();
            cal.setTime(entry.getDate("workdate"));
            OrgBasedCalendarModel.nomalize(cal);
            WorkCalendarDayType dt = WorkCalendarDayType.valueOf(entry.getInt("datetype"));
            MRPDate date = new MRPDate(cal, dt, i);
            this.dates.add(date);
            this.periods.put(cal.getTime(), i);
            date.setPreviousWorkDay(previousWork);
            if (!this.isWorkday(dt.getValue())) continue;
            previousWork = date;
            this.setNextWork(this.dates, previousWork, i);
            if (this.minDate == null) {
                this.minDate = date;
            }
            this.maxDate = date;
        }
    }

    private void setNextWork(List<MRPDate> dates, MRPDate nextDate, int len) {
        MRPDate date;
        for (int i = len - 1; i >= 0 && (date = dates.get(i)).getNextWorkDay() == null; --i) {
            date.setNextWorkDay(nextDate);
        }
    }

    public MRPDate getMaxDate() {
        return this.maxDate;
    }

    public boolean isEmpty() {
        return this.dates.isEmpty();
    }

    public Calendar getDate(Date date, boolean isBack) {
        MRPDate mrpDate;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        OrgBasedCalendarModel.nomalize(cal);
        date = cal.getTime();
        if (date.compareTo(this.dates.get(0).getDate().getTime()) < 0 || date.compareTo(this.dates.get(this.dates.size() - 1).getDate().getTime()) > 0) {
            this.search(isBack, cal, 1);
            return cal;
        }
        if (isBack) {
            for (mrpDate = this.dates.get(this.periods.get(date)); mrpDate != null && !this.isWorkday(mrpDate.getDayType().getValue()); mrpDate = mrpDate.getPreviousWorkDay()) {
            }
        } else {
            while (mrpDate != null && !this.isWorkday(mrpDate.getDayType().getValue())) {
                mrpDate = mrpDate.getNextWorkDay();
            }
        }
        return this.getWorkDate(cal, mrpDate, isBack, 1);
    }

    private Calendar getWorkDate(Calendar cal, MRPDate mrpDate, boolean isBack, int n) {
        if (mrpDate != null) {
            return mrpDate.getDate();
        }
        if (isBack) {
            MRPDate date = this.dates.get(0);
            cal = (Calendar)date.getDate().clone();
        } else {
            MRPDate date = this.dates.get(this.dates.size() - 1);
            cal = (Calendar)date.getDate().clone();
        }
        this.search(isBack, cal, n);
        return cal;
    }

    public Calendar getDate(Date date, boolean isBack, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        OrgBasedCalendarModel.nomalize(cal);
        date = cal.getTime();
        Date calStart = this.dates.get(0).getDate().getTime();
        Date calEnd = this.dates.get(this.dates.size() - 1).getDate().getTime();
        if (date.compareTo(calStart) < 0 || date.compareTo(calEnd) > 0) {
            this.search(isBack, cal, n);
            return cal;
        }
        MRPDate mrpDate = this.dates.get(this.periods.get(date));
        if (mrpDate != null) {
            if (isBack) {
                while (n > 0 && mrpDate != null) {
                    mrpDate = mrpDate.getPreviousWorkDay();
                    --n;
                }
            } else {
                while (n > 0 && mrpDate != null) {
                    mrpDate = mrpDate.getNextWorkDay();
                    --n;
                }
            }
        }
        if (mrpDate == null) {
            ++n;
        }
        return this.getWorkDate(cal, mrpDate, isBack, n);
    }

    private void search(boolean isBack, Calendar cal, int days) {
        if (this.isMonRest && this.isTueRest && this.isWenRest && this.isThuRest && this.isFriRest && this.isSatRest && this.isSunRest) {
            throw new KDBizException(new ErrorCode("NO_WORK_DAYS", ResManager.loadKDString((String)"\u65e5\u5386\u65e0\u5de5\u4f5c\u65e5\u8bbe\u7f6e\uff0c\u8d85\u51fa\u8ba1\u5212\u65e5\u5386\u65f6\u95f4\u8ba1\u7b97\u5931\u8d25\u3002", (String)"OrgBasedCalendarModel_1", (String)"scmc-im-business", (Object[])new Object[0])), new Object[0]);
        }
        block9: while (days > 0) {
            if (isBack) {
                cal.add(5, -1);
            } else {
                cal.add(5, 1);
            }
            int dayInWeek = cal.get(7);
            switch (dayInWeek) {
                case 2: {
                    if (!this.isMonRest) break;
                    continue block9;
                }
                case 3: {
                    if (!this.isTueRest) break;
                    continue block9;
                }
                case 4: {
                    if (!this.isWenRest) break;
                    continue block9;
                }
                case 5: {
                    if (!this.isThuRest) break;
                    continue block9;
                }
                case 6: {
                    if (!this.isFriRest) break;
                    continue block9;
                }
                case 7: {
                    if (!this.isSatRest) break;
                    continue block9;
                }
                case 1: {
                    if (!this.isSunRest) break;
                    continue block9;
                }
            }
            --days;
        }
    }

    private boolean isWorkday(int dateType) {
        return dateType == WorkCalendarDayType.WORKDAY.getValue() || dateType == WorkCalendarDayType.HALFWORKDAY.getValue();
    }

    public static void nomalize(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }
}

