/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.invquery;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.SupplierAndCustomerHelper;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.InvSchemeServiceFactory;
import kd.scmc.im.consts.BizTypeConsts;
import kd.sdk.scmc.im.extpoint.IInvQueryExpand;

public class DefaultInvQueryExpand
implements IInvQueryExpand {
    private static final String BIZTYPE_DOMAIN_VMI = "6";
    private static final String ENABLE_STATUS = "1";
    private static final String IM_PURINBILL_FARM = "im_PurInBill_FARM_BT_S";
    private static final String IM_PURRECBILL_FARM = "im_PurRecBill_FARM_BT_S";
    private static final String IM_OSPURINBILL = "im_ospurinbill_BT_S";

    public void getExpandFilter(IFormView view, String entrykey, int row, String operatekey, Map<String, QFilter> filterMap) {
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity();
        MainEntityType billtype = model.getDataEntityType();
        String billtypeName = billtype.getName();
        String appid = billtype.getAppId();
        DynamicObject entry = null;
        if (row > -1) {
            entry = (DynamicObject)model.getEntryEntity(entrykey).get(row);
        }
        QFilter filter = filterMap.get("filter");
        if ("im".equals(appid)) {
            DynamicObject bizType;
            Map allEntryFields;
            String domain;
            DynamicObject biztype;
            Map allFields = billtype.getAllFields();
            if (allFields.containsKey("biztype") && (biztype = bill.getDynamicObject("biztype")) != null && BIZTYPE_DOMAIN_VMI.equals(domain = biztype.getString("domain"))) {
                filter = this.andQFilter(filter, "material.enablevmi", "=", Boolean.TRUE);
            }
            if ((allEntryFields = ((EntityType)billtype.getAllEntities().get(entrykey)).getFields()).containsKey("linetype") && entry != null) {
                DynamicObject linetype = entry.getDynamicObject("linetype");
                Object material = entry.get("material");
                if (linetype != null && material == null) {
                    Object serviceattributePK = linetype.getDynamicObject("serviceattribute").getPkValue();
                    filter = this.andQFilter(filter, "material.serviceattribute.fbasedataid_id", "in", serviceattributePK);
                }
            }
            if ("im_locationtransfer".equals(billtypeName)) {
                filter = this.andQFilter(filter, "location", "!=", 0);
            }
            if ("im_adjustbill".equals(billtypeName) && (bizType = bill.getDynamicObject("biztype")) != null && bizType.getLong("id") == BizTypeConsts.BIZTYPE_SN_TRANSFORM.longValue()) {
                long orgId = bill.getDynamicObject("org").getLong("id");
                QFilter qFilter = new QFilter("enableserial", "=", (Object)true).and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId));
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])qFilter.toArray(), (String)"");
                HashSet<Long> masterIds = new HashSet<Long>();
                for (Row dataRow : dataSet) {
                    masterIds.add(dataRow.getLong("masterid"));
                }
                filter = this.andQFilter(filter, "material", "in", masterIds);
            }
            if (allFields.containsKey("billtype")) {
                String billTypeNum;
                DynamicObject billType = bill.getDynamicObject("billtype");
                String string = billTypeNum = billType == null ? "" : billType.getString("number");
                if (IM_PURRECBILL_FARM.equals(billTypeNum) || IM_PURINBILL_FARM.equals(billTypeNum)) {
                    filter = this.andQFilter(filter, "material.farmproducts", "=", ENABLE_STATUS);
                }
                if (IM_OSPURINBILL.equals(billTypeNum)) {
                    filter = this.andQFilter(filter, "material.enableoutsource", "=", ENABLE_STATUS);
                }
            }
        }
        filterMap.put("filter", filter);
    }

    public List<Map<String, String>> getExpandUpdateFields(IFormView view, String entrykey, int row, String operatekey) {
        String transtype;
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity();
        String billtypeName = bill.getDataEntityType().getName();
        if ("im_transdirbill".equals(billtypeName) && "A".equals(transtype = bill.getString("transtype"))) {
            HashMap<String, String> field = new HashMap<String, String>(3);
            field.put("key", "billentry.inlotnumber");
            field.put("type", "acc");
            field.put("formula", "lotnum");
            return Collections.singletonList(field);
        }
        return Collections.emptyList();
    }

    public void beforeCreateRow(IFormView view, String entrykey, int chooseRow, int currentRow, String operatekey) {
        DynamicObject scheme;
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity();
        String billtypeName = bill.getDataEntityType().getName();
        if ("im_transdirbill".equals(billtypeName) && (scheme = (DynamicObject)model.getValue("invscheme")) != null && scheme.getPkValue() != null) {
            DynamicObject invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
            InvSchemeHelper.initEntrysValue(view, invScheme, currentRow);
            InvSchemeService invSchemeService = InvSchemeServiceFactory.getService(view);
            InvSchemeHelper.setEntrySchemeEnable(invSchemeService, view, currentRow);
            InvSchemeHelper.setDefalutOwnerAndKeeeper(invSchemeService, view, currentRow);
        }
        if ("im_transoutbill".equals(billtypeName) && (scheme = (DynamicObject)model.getValue("invscheme")) != null && scheme.getPkValue() != null) {
            boolean isInUpdate = scheme.getBoolean("isinupdate");
            boolean isOutUpdate = scheme.getBoolean("isoutupdate");
            if (isInUpdate && isOutUpdate) {
                InvSchemeService invSchemeService = InvSchemeServiceFactory.getService(view);
                InvSchemeHelper.setDefalutOwnerAndKeeeper(invSchemeService, view, currentRow);
            }
        }
        if ("im_purinbill".equals(billtypeName) || "im_ospurinbill".equals(billtypeName) || "im_purreceivebill".equals(billtypeName)) {
            SupplierAndCustomerHelper.setSupplier(view, currentRow);
        }
        if ("im_saloutbill".equals(billtypeName)) {
            scheme = (DynamicObject)model.getValue("invscheme");
            if (scheme != null && scheme.getPkValue() != null) {
                InvSchemeService invSchemeService = InvSchemeServiceFactory.getService(view);
                InvSchemeHelper.initEntrysValue(view, scheme, currentRow);
                InvSchemeHelper.setEntrySchemeEnable(invSchemeService, view, currentRow);
                InvSchemeHelper.setDefalutOwnerAndKeeeper(invSchemeService, view, currentRow);
            }
            SupplierAndCustomerHelper.setCustomer(view, currentRow);
        }
        if ("im_invinspectbill".equals(billtypeName)) {
            model.setValue("entryreqorg", model.getValue("org", currentRow));
        }
    }

    protected final QFilter andQFilter(QFilter filter, String property, String cp, Object value) {
        if (filter != null) {
            return filter.and(property, cp, value);
        }
        return new QFilter(property, cp, value);
    }

    public void afterReturnRow(IFormView view, String entrykey, int chooseRow, int currentRow, String operatekey) {
        DynamicObject billentry;
        DynamicObjectCollection linkColl;
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity();
        String billtypeName = bill.getDataEntityType().getName();
        if (("im_mdc_mftfeedorder".equals(billtypeName) || "im_mdc_omfeedbill".equals(billtypeName)) && ((linkColl = (billentry = (DynamicObject)model.getEntryEntity("billentry").get(currentRow)).getDynamicObjectCollection("billentry_lk")) == null || linkColl.size() == 0)) {
            model.setValue("isadd", (Object)ENABLE_STATUS, currentRow);
        }
    }
}

