/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.linetype;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.linetype.LineTypeParam;

public class BillTypeMaterialHelper {
    private static final String BD_LINETYPE = "bd_linetype";
    private static final String BD_BIZTYPE = "bd_biztype";
    private static final String BD_MATERIAL = "bd_material";
    private static final String SQL = "SELECT FDATA FROM T_BAS_BILLTYPEPARAMETER WHERE FBILLTYPEID=";

    public static QFilter[] getQFilterByLineType(Long billTypeId, Long bizTypeId, Long lineTypeId, boolean isMaterialInfo) {
        QFilter[] resultQf = null;
        if (billTypeId == null || bizTypeId == null || lineTypeId == null) {
            return null;
        }
        ArrayList<QFilter> arQFilter = new ArrayList<QFilter>(2);
        DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)BD_LINETYPE);
        if (lineType != null && lineType.getDynamicObject("serviceattribute") != null) {
            DynamicObject serviceattribute = lineType.getDynamicObject("serviceattribute");
            if (BD_MATERIAL.equals(serviceattribute.getDynamicObject("entity").getString("number"))) {
                Long serviceAttributeId = (Long)lineType.getDynamicObject("serviceattribute").getPkValue();
                arQFilter.add(new QFilter((isMaterialInfo ? "masterid." : "") + "serviceattribute.fbasedataid_id", "in", (Object)serviceAttributeId));
            } else {
                arQFilter.add(new QFilter("1", "=", (Object)1));
            }
        }
        resultQf = arQFilter.toArray(new QFilter[arQFilter.size()]);
        return resultQf;
    }

    public static Map<Long, LineTypeParam> getLineTypeByBillType(List<Long> bizTypes) {
        HashMap map = new HashMap();
        HashMap<Long, Long> isDefaultMap = new HashMap<Long, Long>();
        HashMap<String, Boolean> statusMap = new HashMap<String, Boolean>();
        ArrayList<Long> arr = null;
        HashSet<Long> bizTypeIds = new HashSet<Long>(bizTypes);
        Map bizTypeMap = BusinessDataServiceHelper.loadFromCache((String)BD_BIZTYPE, (QFilter[])new QFilter[]{new QFilter("id", "in", bizTypeIds)});
        if (bizTypeMap != null && bizTypeMap.size() > 0) {
            for (Map.Entry m : bizTypeMap.entrySet()) {
                DynamicObjectCollection linetypeentry = ((DynamicObject)m.getValue()).getDynamicObjectCollection("linetypeentry");
                if (linetypeentry == null || linetypeentry.size() <= 0) continue;
                for (DynamicObject lyen : linetypeentry) {
                    DynamicObject lt = lyen.getDynamicObject("linetypeid");
                    if (lt == null) continue;
                    if (!isDefaultMap.containsKey(lyen.getLong("id")) && lyen.getBoolean("isdefault")) {
                        statusMap.put(((DynamicObject)m.getValue()).getString("id") + lt.getString("id"), lt.getBoolean("enable"));
                        isDefaultMap.put(((DynamicObject)m.getValue()).getLong("id"), lt.getLong("id"));
                    }
                    if (map.containsKey(((DynamicObject)m.getValue()).getLong("id"))) {
                        ((List)map.get(((DynamicObject)m.getValue()).getLong("id"))).add(lt.getLong("id"));
                        continue;
                    }
                    arr = new ArrayList<Long>();
                    arr.add(lt.getLong("id"));
                    map.put(((DynamicObject)m.getValue()).getLong("id"), arr);
                }
            }
        }
        HashMap<Long, LineTypeParam> result = new HashMap<Long, LineTypeParam>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            result.put((Long)entry.getKey(), new LineTypeParam((Long)isDefaultMap.get(entry.getKey()), (Boolean)statusMap.get(((Long)entry.getKey()).toString() + ((Long)isDefaultMap.get(entry.getKey())).toString()), new QFilter[]{new QFilter("id", "in", entry.getValue())}, new HashSet<Long>((Collection)entry.getValue())));
        }
        return result;
    }

    public static LineTypeParam getOneLineTypeByBillType(Long bizTypeId) {
        HashSet<Long> lineTypeIds = new HashSet<Long>(16);
        Long defaultLineTypeId = 0L;
        boolean isdeafultStatus = false;
        DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((String)BD_BIZTYPE, (String)"id,linetypeentry.linetypeentry,linetypeentry.isdefault,linetypeentry.linetypeid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizTypeId)});
        if (bizType == null) {
            return null;
        }
        DynamicObjectCollection linetypeentry = bizType.getDynamicObjectCollection("linetypeentry");
        if (linetypeentry != null && linetypeentry.size() > 0) {
            for (DynamicObject lyen : linetypeentry) {
                DynamicObject lt = lyen.getDynamicObject("linetypeid");
                if (lt == null) continue;
                if (lyen.getBoolean("isdefault")) {
                    defaultLineTypeId = lt.getLong("id");
                    isdeafultStatus = lt.getBoolean("enable");
                }
                lineTypeIds.add(lt.getLong("id"));
            }
        }
        return new LineTypeParam(defaultLineTypeId, isdeafultStatus, new QFilter[]{new QFilter("id", "in", lineTypeIds)}, lineTypeIds);
    }

    public static Map<Long, JSONObject> getBizTypeByBillTypeparameterId(Long billTypeId) {
        StringBuilder sql = new StringBuilder();
        sql.append(SQL);
        sql.append(billTypeId);
        HashMap<Long, JSONObject> result = new HashMap<Long, JSONObject>();
        DataSet ds = DB.queryDataSet((String)"getBizTypeByBillTypeparameterId", (DBRoute)DBRoute.basedata, (String)sql.toString());
        for (Row row : ds) {
            String fdata = row.getString("FDATA");
            if (StringUtils.isEmpty((String)fdata)) continue;
            Map map = (Map)JSON.parseObject((String)fdata, Map.class);
            if (map.get("entryentity") == null) {
                result.put(billTypeId, new JSONObject());
                return result;
            }
            JSONArray arrays = JSON.parseArray((String)map.get("entryentity").toString());
            if (map == null || arrays == null || arrays.size() <= 0) continue;
            JSONObject rs = new JSONObject();
            JSONArray bizTypes = new JSONArray();
            for (Object obj : arrays) {
                JSONObject data = JSONObject.parseObject((String)obj.toString());
                if ("true".equals(data.getString("isdefault"))) {
                    rs.put("defaultbiztypeid", (Object)data.getString("biztypenumber_id"));
                }
                if (data.getLong("biztypenumber_id") == null || data.getLong("biztypenumber_id") == 0L) continue;
                bizTypes.add((Object)data.getLong("biztypenumber_id"));
            }
            if (bizTypes.size() > 0) {
                Map bts = BusinessDataServiceHelper.loadFromCache((String)BD_BIZTYPE, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", (Object)bizTypes)});
                if (bts != null && bts.size() > 0) {
                    HashSet<Long> ids = new HashSet<Long>(bts.size());
                    for (Map.Entry m : bts.entrySet()) {
                        ids.add(Long.parseLong(m.getKey().toString()));
                    }
                    rs.put("biztypeids", ids);
                    if (!StringUtils.isEmpty((String)rs.getString("defaultbiztypeid")) && !ids.contains(Long.parseLong(rs.getString("defaultbiztypeid")))) {
                        rs.remove((Object)"defaultbiztypeid");
                    }
                } else {
                    rs.remove((Object)"defaultbiztypeid");
                }
            }
            result.put(billTypeId, rs);
        }
        return result;
    }
}

