/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.logisticsbill;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;

public class LogisticsBillMatch {
    private DynamicObject cfg;
    private String formId;
    private DynamicObject bill;
    DynamicObjectCollection entrys;
    private Integer priority;

    private LogisticsBillMatch(DynamicObject cfg, DynamicObject bill) {
        this.bill = bill;
        this.formId = bill.getDataEntityType().getName();
        this.cfg = cfg;
        this.priority = cfg.getInt("priority");
        this.entrys = bill.getDynamicObjectCollection("billentry");
    }

    public static LogisticsBillMatch getInstance(DynamicObject cfg, DynamicObject bill) {
        return new LogisticsBillMatch(cfg, bill);
    }

    public boolean isLogistcsBill() {
        String filterstr = this.cfg.getString("billfilterstr_tag");
        MainEntityType entityType = (MainEntityType)this.bill.getDataEntityType();
        if (StringUtils.isEmpty((CharSequence)filterstr)) {
            return true;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
        this.updateFilterCondition(condition);
        FilterBuilder fb = new FilterBuilder(entityType, condition);
        String[] script = fb.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            String[] sp = var.split("\\.");
            IDataEntityProperty property = entityType.findProperty(sp[0]);
            if (property == null || property instanceof EntryProp || property instanceof BillStatusProp) continue;
            if (property instanceof MuliLangTextProp) {
                ctx.put(var, this.bill.getLocaleString(var).getLocaleValue());
                continue;
            }
            ctx.put(var, this.getProValue(var));
        }
        boolean exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
        return exec;
    }

    public void execute() {
        String balanceorg = this.cfg.getString("balanceorg");
        String ownerorg = this.cfg.getString("ownerorg");
        if (StringUtils.isBlank((CharSequence)balanceorg) || StringUtils.isBlank((CharSequence)ownerorg)) {
            return;
        }
        MainEntityType entityType = (MainEntityType)this.bill.getDataEntityType();
        Map<Integer, DynamicObject> balanceMap = this.getOrgValueMap(entityType, balanceorg);
        Map<Integer, DynamicObject> ownerMap = this.getOrgValueMap(entityType, ownerorg);
        this.match(balanceMap, ownerMap);
    }

    private void match(Map<Integer, DynamicObject> balanceMap, Map<Integer, DynamicObject> ownerMap) {
        boolean isSalOutBill = "im_saloutbill".equals(this.formId);
        for (DynamicObject entry : this.entrys) {
            boolean isLogisitcsBill;
            DynamicObject balance = balanceMap.get(entry.getInt("seq"));
            DynamicObject owner = ownerMap.get(entry.getInt("seq"));
            boolean bl = isLogisitcsBill = balance != null && owner != null && !this.baseEquals(balance, owner);
            if (isLogisitcsBill && isSalOutBill) {
                this.checkKitMaterial(entry);
            }
            entry.set("logisticsbill", (Object)isLogisitcsBill);
        }
    }

    private void checkKitMaterial(DynamicObject entry) {
        String kitProType = entry.getString("kitproducttype");
        if ("kitparent".equals(kitProType) || "kitchild".equals(kitProType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5957\u4ef6\u7269\u6599\u6682\u4e0d\u652f\u6301\u53d1\u751f\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u4e1a\u52a1\u3002", (String)"LogisticsBillMatch_0", (String)"scmc-im-business", (Object[])new Object[0]));
        }
    }

    public Integer getPriority() {
        return this.priority;
    }

    private Map<Integer, DynamicObject> getOrgValueMap(MainEntityType entityType, String orgKey) {
        HashMap<Integer, DynamicObject> orgMap = new HashMap<Integer, DynamicObject>(this.entrys.size());
        String[] sp = orgKey.split("\\.");
        IDataEntityProperty prop = entityType.findProperty(sp[0]);
        if (prop == null) {
            return orgMap;
        }
        if (prop instanceof EntryProp) {
            orgKey = orgKey.substring(sp[0].length() + 1, orgKey.length());
            for (DynamicObject entry : this.entrys) {
                DynamicObject org = entry.getDynamicObject(orgKey);
                if (!this.isOrgType(org)) continue;
                orgMap.put(entry.getInt("seq"), org);
            }
            return orgMap;
        }
        DynamicObject org = this.bill.getDynamicObject(orgKey);
        if (this.isOrgType(org)) {
            for (DynamicObject entry : this.entrys) {
                orgMap.put(entry.getInt("seq"), org);
            }
        }
        return orgMap;
    }

    private boolean isOrgType(DynamicObject org) {
        return org != null && "bos_org".equals(org.getDataEntityType().getName());
    }

    private boolean baseEquals(DynamicObject arg1, DynamicObject arg2) {
        return arg1.getPkValue().equals(arg2.getPkValue());
    }

    private Object getProValue(String var) {
        String[] sp = var.split("\\.");
        Object value = null;
        for (int i = 0; i < sp.length; ++i) {
            if (i == 0) {
                value = this.bill.get(sp[i]);
                continue;
            }
            if (value == null) {
                return value;
            }
            value = ((DynamicObject)value).get(sp[i]);
        }
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }

    private void updateFilterCondition(FilterCondition condition) {
        List filterRow = condition.getFilterRow();
        Iterator it = filterRow.iterator();
        while (it.hasNext()) {
            SimpleFilterRow next = (SimpleFilterRow)it.next();
            String fieldName = next.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName) || !fieldName.contains("billentry") && !fieldName.contains("billstatus")) continue;
            it.remove();
        }
    }
}

