/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.matchout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MatchingRuleOutHelper;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import kd.scmc.im.business.helper.matchout.MatchingRuleOutOldFormBaseHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class MatchingRuleOutOldFormHelper
extends MatchingRuleOutOldFormBaseHelper {
    private static final List<String> relatedList = Arrays.asList("mainbillid", "mainbillentryid", "mainbillnumber", "mainbillentity", "srcbillid", "srcbillentryid", "srcbillnumber", "srcbillentity", "mainbillentryseq", "srcbillentryseq", "srcsysbillentryid", "srcsystem", "srcsysbillno", "srcsysbillid", "conbillentity", "conbillid", "conbillnumber", "conbillrownum", "conbillentryid", "kitproducttype", "kitproduct", "kittransfermodel", "kitpid", "pricemodel");

    public MatchingRuleOutOldFormHelper(AbstractBillPlugIn plugin, boolean isDrawBotp) {
        super(plugin, isDrawBotp);
    }

    public void matchingRuleOut(BeforeDoOperationEventArgs args) {
        EntryGrid control = (EntryGrid)this.getControl("billentry");
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImBillEditPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        NoUpdateFieldsAnalysisHelper.setNoUpdateFields(this.getModel(), "billentry", "material", "noupdateinvfields");
        String orgField = this.getMainOrgField();
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgField);
        ArrayList<Map<String, Object>> entryInfoList = new ArrayList<Map<String, Object>>(selectRows.length);
        ArrayList<String> ruleList = new ArrayList<String>(selectRows.length);
        EntityOperate op = (EntityOperate)args.getSource();
        String formId = op.getEntityId();
        IDataModel model = this.getModel();
        MatchingRuleOutHelper.copyMatchInfoPageCache(this.getView());
        boolean isUseLotMF = LotMainFileHelper.isUseLotMainFile();
        String entityName = model.getDataEntityType().getName();
        for (int index : selectRows) {
            Long materialmasterid;
            Object productType;
            if ("im_saloutbill".equals(entityName) && "kitparent".equals(productType = model.getValue("kitproducttype", index))) continue;
            DynamicObject material = (DynamicObject)model.getValue("material", index);
            if (null == material) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u8f93\u5165\u7269\u6599\uff0c\u65e0\u6cd5\u5339\u914d\u3002", (String)"ImBillEditPlugin_34", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1);
                this.getView().showTipNotification(msg);
                return;
            }
            if (!material.getBoolean("enablelot") && !material.getBoolean("enableshelflifemgr")) {
                entryInfoList.add(new HashMap(2));
                continue;
            }
            String rule = material.getString("outboundrules");
            if (StringUtils.isEmpty((CharSequence)rule)) {
                entryInfoList.add(new HashMap(2));
                continue;
            }
            ruleList.add(rule);
            String confirmMsg = this.matchingRuleOutValidateAlertMsg(model, index, rule);
            if (!confirmMsg.isEmpty()) {
                this.getView().showErrorNotification(confirmMsg);
                MatchingRuleOutHelper.resetMatchInfoPageCache(this.getView());
                return;
            }
            BigDecimal qty = (BigDecimal)model.getValue("qty", index);
            Map<String, Object> paramsMap = this.buildFilterParams(model, formId, index);
            paramsMap.put("org", org.getPkValue());
            List<String> orderByRule = MatchingRuleOutHelper.getOrderByRule(rule);
            ArrayList<QFilter> lotintrackFilter = new ArrayList<QFilter>(16);
            lotintrackFilter.add(new QFilter("material", "=", material.getPkValue()));
            lotintrackFilter.add(new QFilter("org", "=", org.getPkValue()));
            ArrayList<QFilter> lotidFilter = new ArrayList<QFilter>(1);
            Object materialm = model.getValue("materialmasterid");
            Long l = materialmasterid = materialm instanceof DynamicObject ? (Long)((DynamicObject)materialm).getPkValue() : (Long)materialm;
            if (materialmasterid == null) {
                materialmasterid = 0L;
            }
            lotidFilter.add(new QFilter("material", "=", (Object)materialmasterid));
            DataSet lotintracksSet = MatchingRuleOutHelper.getLotinTracksDataSet(lotintrackFilter, isUseLotMF, lotidFilter);
            Map<String, Object> matchFirstFieldMap = this.getMatchFirstFieldMap(model, index, formId);
            MatchingRuleOutHelper.deleteMatchInfoPageCache(index, this.getView(), this.getModel());
            Map<String, Object> singleEntryMap = MatchingRuleOutHelper.getInsertEntryInfo(lotintracksSet, qty, paramsMap, orderByRule, true, formId, matchFirstFieldMap, this.getView(), isUseLotMF);
            entryInfoList.add(singleEntryMap);
        }
        this.dealWithEntry(entryInfoList, ruleList);
        this.setBillEntryLkInfo();
    }

    private Map<String, Object> getMatchFirstFieldMap(IDataModel model, int index, String formId) {
        Date expirydate;
        Date producedate;
        HashMap<String, Object> matchFirstFieldMap = new HashMap<String, Object>(4);
        String lotNumber = (String)model.getValue(this.getIdentifyByFormId(formId, "lotnumber"), index);
        if (!"".equals(lotNumber)) {
            matchFirstFieldMap.put("lotnumber", lotNumber);
        }
        if (null != (producedate = (Date)model.getValue("producedate", index))) {
            matchFirstFieldMap.put("producedate", producedate);
        }
        if (null != (expirydate = (Date)model.getValue("expirydate", index))) {
            matchFirstFieldMap.put("expirydate", expirydate);
        }
        return matchFirstFieldMap;
    }

    private String matchingRuleOutValidateAlertMsg(IDataModel model, int index, String rule) {
        String formId = this.getModel().getDataEntityType().getName();
        DynamicObject material = (DynamicObject)model.getValue("material", index);
        DynamicObject unit = (DynamicObject)model.getValue("unit", index);
        BigDecimal qty = (BigDecimal)model.getValue("qty", index);
        DynamicObject outInvType = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outinvtype"), index);
        DynamicObject outInvStatus = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outinvstatus"), index);
        Object outOwnerType = model.getValue(this.getIdentifyByFormId(formId, "outownertype"), index);
        DynamicObject outOwner = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outowner"), index);
        Object outKeeperType = model.getValue(this.getIdentifyByFormId(formId, "outkeepertype"), index);
        DynamicObject outKeeper = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outkeeper"), index);
        StringBuilder alertMsg = new StringBuilder();
        if (null == material || null == unit || BigDecimal.ZERO.compareTo(qty) == 0 || null == outInvType || null == outInvStatus || null == outOwnerType || null == outOwner || null == outKeeperType || null == outKeeper) {
            if (null == material) {
                alertMsg.append(ResManager.loadKDString((String)"\u7269\u6599", (String)"ImBillEditPlugin_18", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == unit) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ImBillEditPlugin_19", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"ImBillEditPlugin_20", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == outInvType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"ImBillEditPlugin_26", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == outInvStatus) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"ImBillEditPlugin_27", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == outOwnerType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b", (String)"ImBillEditPlugin_28", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == outOwner) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b", (String)"ImBillEditPlugin_29", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == outKeeperType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b", (String)"ImBillEditPlugin_30", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == outKeeper) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005", (String)"ImBillEditPlugin_31", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            alertMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IM-E-405635", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"ImBillEditPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1);
            alertMsg.insert(0, msg);
        }
        if (alertMsg.length() > 0) {
            return alertMsg.toString();
        }
        if (material == null) {
            return "";
        }
        return alertMsg.toString();
    }

    private String getMainOrgField() {
        String orgField = "org";
        String formId = this.getModel().getDataEntityType().getName();
        if ("im_transdirbill".equals(formId)) {
            orgField = "outorg";
        }
        return orgField;
    }

    private Map<String, Object> buildFilterParams(IDataModel model, String formId, int index) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        DynamicObject auxpty = (DynamicObject)model.getValue("auxpty", index);
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", index);
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", index);
        DynamicObject warehouse = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "warehouse"), index);
        DynamicObject location = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "location"), index);
        DynamicObject outinvtype = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outinvtype"), index);
        DynamicObject outinvstatus = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outinvstatus"), index);
        Object ownertype = model.getValue(this.getIdentifyByFormId(formId, "outownertype"), index);
        DynamicObject owner = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outowner"), index);
        Object keepertype = model.getValue(this.getIdentifyByFormId(formId, "outkeepertype"), index);
        DynamicObject keeper = (DynamicObject)model.getValue(this.getIdentifyByFormId(formId, "outkeeper"), index);
        DynamicObject project = (DynamicObject)model.getValue("project", index);
        DynamicObject configuredcode = (DynamicObject)model.getValue("configuredcode", index);
        DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber", index);
        DynamicObject unit = (DynamicObject)model.getValue("unit", index);
        String entryNoUpdateFieldValue = (String)model.getValue("noupdateinvfields", index);
        List<String> entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
        paramsMap.put("material", null == material ? Integer.valueOf(0) : material.getPkValue());
        paramsMap.put("invstatus", null == outinvstatus ? Integer.valueOf(0) : outinvstatus.getPkValue());
        paramsMap.put("baseunit", null == baseUnit ? Integer.valueOf(0) : baseUnit.getPkValue());
        paramsMap.put("unit", null == unit ? Integer.valueOf(0) : unit.getPkValue());
        if (null != auxpty) {
            paramsMap.put("auxpty", auxpty.getPkValue());
        }
        if (null != warehouse) {
            paramsMap.put("warehouse", warehouse.getPkValue());
        }
        if (null != location) {
            paramsMap.put("location", location.getPkValue());
        }
        if (!entryNoUpdateFieldValueList.contains("project") && null != project) {
            paramsMap.put("project", project.getPkValue());
        }
        if (null != configuredcode) {
            paramsMap.put("configuredcode", configuredcode.getPkValue());
        }
        if (!entryNoUpdateFieldValueList.contains("tracknumber") && null != tracknumber) {
            paramsMap.put("tracknumber", tracknumber.getPkValue());
        }
        paramsMap.put("invtype", null == outinvtype ? Integer.valueOf(0) : outinvtype.getPkValue());
        paramsMap.put("ownertype", ownertype);
        paramsMap.put("owner", null == owner ? Integer.valueOf(0) : owner.getPkValue());
        paramsMap.put("keepertype", keepertype);
        paramsMap.put("keeper", null == keeper ? Integer.valueOf(0) : keeper.getPkValue());
        return paramsMap;
    }

    private String getIdentifyByFormId(String formId, String identify) {
        if ("im_locationtransfer".equals(formId)) {
            switch (identify) {
                case "outinvtype": {
                    identify = "invtype";
                    break;
                }
                case "outinvstatus": {
                    identify = "invstatus";
                    break;
                }
                case "outownertype": {
                    identify = "ownertype";
                    break;
                }
                case "outowner": {
                    identify = "owner";
                    break;
                }
                case "outkeepertype": {
                    identify = "keepertype";
                    break;
                }
                case "outkeeper": {
                    identify = "keeper";
                    break;
                }
                case "location": {
                    identify = "outlocation";
                    break;
                }
            }
        } else if ("im_transdirbill".equals(formId)) {
            switch (identify) {
                case "warehouse": {
                    identify = "outwarehouse";
                    break;
                }
                case "location": {
                    identify = "outlocation";
                    break;
                }
            }
        }
        return identify;
    }

    public void dealWithEntry(List<Map<String, Object>> insertEntryInfo, List<String> ruleList) {
        Boolean isEnough = Boolean.TRUE;
        EntryGrid control = (EntryGrid)this.getControl("billentry");
        int[] selectRows = control.getSelectRows();
        int selectRowIndex = 0;
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        StringBuilder alertMsg = new StringBuilder();
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            int index = selectRows[selectRowIndex];
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            if (insertEntry.isEmpty()) {
                ++selectRowIndex;
                continue;
            }
            BigDecimal qty = (BigDecimal)insertEntry.get("qty");
            BigDecimal invAccCounts = (BigDecimal)insertEntry.get("count");
            String materialName = (String)insertEntry.get("materialName");
            Integer precision = (Integer)insertEntry.get("precision");
            if (BigDecimal.ZERO.compareTo(invAccCounts) == 0) {
                Boolean matched = (Boolean)insertEntry.get("matched");
                String msg = matched != false ? String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599,\u5e93\u5b58\u8bb0\u5f55\u5747\u5df2\u88ab\u5339\u914d\u5b8c\uff0c\u65e0\u5269\u4f59\u53ef\u5339\u914d\u7684\u5e93\u5b58\u3002", (String)"ImBillEditPlugin_36", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1) : String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599\uff0c\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5206\u5f55\u6570\u636e\u548c\u5373\u65f6\u5e93\u5b58\u3002", (String)"IM-E-180737", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1);
                alertMsg.append(msg);
            } else if (qty.compareTo(invAccCounts) > 0) {
                isEnough = Boolean.FALSE;
                BigDecimal remainQty = qty.subtract(invAccCounts);
                if (precision != null) {
                    remainQty = remainQty.setScale((int)precision, 4);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("index", index);
                paramMap.put("remainQty", remainQty);
                paramMap.put("materialName", materialName);
                paramList.add(paramMap);
            }
            ++selectRowIndex;
        }
        if (alertMsg.length() > 0) {
            this.getView().showErrorNotification(alertMsg.toString());
            MatchingRuleOutHelper.resetMatchInfoPageCache(this.getView());
            return;
        }
        if (!isEnough.booleanValue()) {
            this.showConfirm(insertEntryInfo, paramList, ruleList);
        } else {
            this.insertEntry(insertEntryInfo);
        }
    }

    private void showConfirm(List<Map<String, Object>> entryInfoList, List<Map<String, Object>> paramList, List<String> ruleList) {
        if (null != entryInfoList) {
            StringBuilder detailMsg = new StringBuilder();
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> map = paramList.get(i);
                int index = (Integer)map.get("index");
                BigDecimal remainQty = (BigDecimal)map.get("remainQty");
                String materialName = (String)map.get("materialName");
                String outRule = MatchingRuleOutHelper.getOutRule(ruleList.get(i));
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s %3$s\u201d\uff0c\u6570\u91cf\u4e0d\u8db3\uff1a%4$s\u3002", (String)"ImBillEditPlugin_17", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1, materialName, outRule, remainQty);
                detailMsg.append(msg);
            }
            ConfirmCallBackListener cb = new ConfirmCallBackListener("bar_matchingrule", (IFormPlugin)this.getPlugin());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u662f\u5426\u6309\u73b0\u6709\u5e93\u5b58\u5339\u914d\uff1f", (String)"ImBillEditPlugin_15", (String)"scmc-im-formplugin", (Object[])new Object[0]), detailMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(entryInfoList));
        }
    }

    public void insertEntry(List<Map<String, Object>> insertEntryInfo) {
        this.getView().getFormShowParameter().setCustomParam("matchingrule", (Object)"1");
        String formId = this.getModel().getDataEntityType().getName();
        ArrayList<Map<Object, Object>> confirmList = new ArrayList<Map<Object, Object>>(16);
        int entryIndex = 0;
        IDataModel model = this.getModel();
        EntryGrid control = (EntryGrid)this.getControl("billentry");
        int[] selectRows = control.getSelectRows();
        int selectRowIndex = 0;
        int addRow = 0;
        ArrayList<Map<String, Object>> returnRows = new ArrayList<Map<String, Object>>(insertEntryInfo.size());
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            HashMap<String, Integer> returnRow = new HashMap<String, Integer>(2);
            if (insertEntry.isEmpty()) {
                returnRow.put("returnRowIndex", selectRows[selectRowIndex] + addRow);
                returnRow.put("returnRowNums", 0);
                returnRows.add(returnRow);
                ++selectRowIndex;
                continue;
            }
            int index = selectRows[selectRowIndex] + addRow;
            List entryInfoList = (List)insertEntry.get("entryInfo");
            int size = entryInfoList.size();
            entryIndex = index;
            for (int j = 0; j < size; ++j) {
                if (j != 0) {
                    model.beginInit();
                    model.insertEntryRow("billentry", entryIndex);
                    model.endInit();
                    ++addRow;
                }
                Map map = (Map)entryInfoList.get(j);
                Long entryId = (Long)((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("billentry").get(entryIndex)).getPkValue();
                if (null == entryId || entryId.equals(0L)) {
                    entryId = (Long)map.get("entryId");
                    ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("billentry").get(entryIndex)).set("id", (Object)entryId);
                } else {
                    MatchingRuleOutHelper.transformCache(entryId, (Long)map.get("entryId"), this.getView());
                }
                this.insertSingleEntry(map, index, entryIndex, model, formId);
                Date produceDate = this.parseDate((String)map.get("producedate"));
                Date expiryDate = this.parseDate((String)map.get("expirydate"));
                DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", entryIndex);
                HashMap<String, Comparable<Integer>> confirmMap = new HashMap<String, Comparable<Integer>>(4);
                confirmMap.put("entryIndex", Integer.valueOf(entryIndex));
                confirmMap.put("materialInvInfo", (Comparable<Integer>)materialInvInfo);
                confirmMap.put("expiryDate", expiryDate);
                confirmMap.put("produceDate", produceDate);
                confirmList.add(confirmMap);
                BigDecimal qty = BigDecimal.valueOf(Double.parseDouble(map.get("qty").toString()));
                model.setValue("qty", (Object)qty, entryIndex);
                ++entryIndex;
            }
            returnRow.put("returnRowIndex", index);
            returnRow.put("returnRowNums", size);
            returnRows.add(returnRow);
            ++selectRowIndex;
        }
        this.showExpiryDateConfirm(confirmList);
        this.setBillEntryLkInfo();
        this.getView().getPageCache().put("CheckDataChange", "true");
        MatchingRuleOutHelper.callMatchruleoutExpand(this.getView(), "billentry", returnRows);
        this.getView().updateView("billentry");
    }

    private void insertSingleEntry(Map<String, Object> map, int index, int entryIndex, IDataModel model, String formId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        Map billentryFields = ((EntityType)dt.getAllEntities().get("billentry")).getFields();
        Set<String> invaccFields = map.keySet();
        for (Map.Entry entry : billentryFields.entrySet()) {
            Object value;
            String field = (String)entry.getKey();
            IFieldHandle fieldHandle = (IFieldHandle)entry.getValue();
            boolean copyable = fieldHandle.isCopyable();
            if (!copyable && !relatedList.contains(field) || "id".equals(field) || "seq".equals(field) || "billentry_lk".equals(field) || "qty".equals(field) || "baseqty".equals(field) || "qtyunit2nd".equals(field)) continue;
            if (invaccFields.contains(field)) {
                value = map.get(field);
                String entryNoUpdateFieldValue = (String)model.getValue("noupdateinvfields", index);
                List<String> entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
                if (entryNoUpdateFieldValueList.contains(field)) {
                    value = model.getValue(field, index);
                    this.setValue(field, value, entryIndex, false);
                    continue;
                }
                if (field.equals("producedate") || field.equals("expirydate")) {
                    value = this.parseDate((String)value);
                    this.setValue(field, value, entryIndex, false);
                    continue;
                }
                if (field.equals("lotnumber")) {
                    String transType;
                    if ("im_transdirbill".equals(formId) && "A".equals(transType = (String)model.getValue("transtype"))) {
                        this.setValue("inlotnumber", value, entryIndex, false);
                    }
                    this.setValue(field, value, entryIndex, false);
                    continue;
                }
                if (field.equals("warehouse") || field.equals("outwarehouse") || field.equals("material")) {
                    field = this.getIdentifyByFormId(formId, field);
                    model.setValue(field, value, entryIndex);
                    continue;
                }
                if ("location".equals(field)) {
                    if ("im_locationtransfer".equals(formId)) {
                        field = "out" + field;
                    }
                    this.setValue(field, value, entryIndex, false);
                    continue;
                }
                this.setValue(field, value, entryIndex, false);
                continue;
            }
            value = model.getValue(field, index);
            boolean isTriggerChangeEvent = false;
            if ("im_transdirbill".equals(formId)) {
                if ("inlotnumber".equals(field)) continue;
                if (field.equals("warehouse")) {
                    isTriggerChangeEvent = true;
                }
            }
            this.setValue(field, value, entryIndex, isTriggerChangeEvent);
        }
    }

    private void showExpiryDateConfirm(List<Map<Object, Object>> confirmList) {
        ArrayList alertMsgList = new ArrayList(16);
        StringBuilder alertMsg = new StringBuilder();
        for (int i = 0; i < confirmList.size(); ++i) {
            Map<Object, Object> confirmMap = confirmList.get(i);
            int rowIndex = (Integer)confirmMap.get("entryIndex");
            DynamicObject materialInvInfo = (DynamicObject)confirmMap.get("materialInvInfo");
            Date newExpiryDate = (Date)confirmMap.get("expiryDate");
            Date newProduceDate = (Date)confirmMap.get("produceDate");
            if (newExpiryDate == null) {
                return;
            }
            String billName = this.getModel().getDataEntityType().getName();
            String entryName = "billentry";
            boolean isOutBill = InvBillHelper.isOutEntry(billName, entryName);
            boolean isInBill = InvBillHelper.isInEntry(billName, entryName);
            String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
            int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
            int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
            int dateOfOverdue = 0;
            if (isOutBill && isInBill) {
                dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
            } else if (isOutBill) {
                dateOfOverdue = dateOfOverdueForOut;
            } else if (isInBill) {
                dateOfOverdue = dateOfOverdueForIn;
            }
            Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
            Date nowDate = new Date();
            boolean dateOver = nowDate.after(overdueDate);
            if (!dateOver) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            String newExpiryDateStr = this.getDateStr(newExpiryDate);
            String newProduceDateStr = this.getDateStr(newProduceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d\u3002", (String)"ImBillPropChanged_10", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpiryDateStr) + "\uff0c";
            alertMsg.append(msg);
            params.put("newProduceDate", newProduceDateStr);
            params.put("oldProduceDate", null);
            params.put("newExpiryDate", newExpiryDateStr);
            params.put("oldExpiryDate", null);
            params.put("index", rowIndex);
            params.put("deleteEntry", true);
            alertMsgList.add(params);
        }
        if (alertMsg.length() > 0) {
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", (IFormPlugin)this.getPlugin());
            alertMsg.append(ResManager.loadKDString((String)"\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImBillPropChanged_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\u7269\u6599\u3002", (String)"ImBillPropChanged_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), alertMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
    }

    private void setBillEntryLkInfo() {
        boolean drawByBOTP = this.isDrawByBOTP();
        if (!drawByBOTP) {
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        if ("im_locationtransfer".equals(formId)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("billentry");
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(4);
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection linkRows = entry.getDynamicObjectCollection("billentry_lk");
            for (DynamicObject linkRow : linkRows) {
                sourceMap.put("billentry_lk_stableid", linkRow.get("billentry_lk_stableid"));
                sourceMap.put("billentry_lk_sbillid", linkRow.get("billentry_lk_sbillid"));
                sourceMap.put("billentry_lk_sid", linkRow.get("billentry_lk_sid"));
            }
            if (linkRows.size() > 0) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            linkRow.set("billentry_lk_stableid", sourceMap.get("billentry_lk_stableid"));
            linkRow.set("billentry_lk_sbillid", sourceMap.get("billentry_lk_sbillid"));
            linkRow.set("billentry_lk_sid", sourceMap.get("billentry_lk_sid"));
        }
    }
}

