/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.matchout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MatchingRuleOutHelper;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import kd.scmc.im.business.helper.matchout.MatchingRuleOutOldFormBaseHelper;
import kd.scmc.im.consts.TransformBillTplEntryConst;
import kd.scmc.im.helper.ShelfLifeDateUtil;

@Deprecated
public class MatchingRuleOutOldTransFormHelper
extends MatchingRuleOutOldFormBaseHelper {
    private static final List<String> relatedList = Arrays.asList("mainbillid", "mainbillentryid", "mainbillnumber", "mainbillentity", "srcbillid", "srcbillentryid", "srcbillnumber", "srcbillentity", "mainbillentryseq", "srcbillentryseq", "srcsysbillentryid", "srcsystem", "srcsysbillno", "srcsysbillid", "subsrcbillentity", "subsrcbillentryid", "subsrcbillid");

    public MatchingRuleOutOldTransFormHelper(AbstractBillPlugIn plugin) {
        super(plugin, false);
    }

    public void matchingRuleOut(BeforeDoOperationEventArgs args) {
        boolean after;
        String formId = this.getModel().getDataEntityType().getName();
        String entryKey = TransformBillTplEntryConst.getEntryByBillType((String)formId, (Boolean)(after = false));
        EntryGrid control = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImBillEditPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        NoUpdateFieldsAnalysisHelper.setNoUpdateFields(this.getModel(), entryKey, TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"material"), TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"noupdateinvfields"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Map<String, Object>> entryInfoList = new ArrayList<Map<String, Object>>(selectRows.length);
        ArrayList<String> ruleList = new ArrayList<String>(selectRows.length);
        MatchingRuleOutHelper.copyMatchInfoPageCache(this.getView());
        boolean isUseLotMF = LotMainFileHelper.isUseLotMainFile();
        for (int index : selectRows) {
            DynamicObject entry = this.getModel().getEntryRowEntity(TransformBillTplEntryConst.getEntryByBillType((String)formId, (Boolean)after), index);
            DynamicObject material = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"material"));
            if (null == material) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u8f93\u5165\u7269\u6599\uff0c\u65e0\u6cd5\u5339\u914d\u3002", (String)"ImBillEditPlugin_34", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1);
                this.getView().showTipNotification(msg);
                return;
            }
            if (!material.getBoolean("enablelot") && !material.getBoolean("enableshelflifemgr")) {
                entryInfoList.add(new HashMap(2));
                continue;
            }
            String rule = material.getString("outboundrules");
            if (StringUtils.isEmpty((CharSequence)rule)) {
                entryInfoList.add(new HashMap(2));
                continue;
            }
            ruleList.add(rule);
            BigDecimal qty = entry.getBigDecimal(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"qty"));
            String confirmMsg = this.matchingRuleOutValidate(entry, index, rule, formId, after);
            if (!confirmMsg.isEmpty()) {
                this.getView().showErrorNotification(confirmMsg);
                MatchingRuleOutHelper.resetMatchInfoPageCache(this.getView());
                return;
            }
            Map<String, Object> paramsMap = this.buildFilterParams(entry, after, formId);
            paramsMap.put("org", org.getPkValue());
            List<String> orderByRule = MatchingRuleOutHelper.getOrderByRule(rule);
            ArrayList<QFilter> lotintrackFilter = new ArrayList<QFilter>(16);
            lotintrackFilter.add(new QFilter("material", "=", material.getPkValue()));
            lotintrackFilter.add(new QFilter("org", "=", org.getPkValue()));
            DataSet lotintracksSet = MatchingRuleOutHelper.getLotinTracksDataSet(lotintrackFilter, isUseLotMF);
            Map<String, Object> matchFirstFieldMap = this.getMatchFirstFieldMap(this.getModel(), index, formId);
            MatchingRuleOutHelper.deleteMatchInfoPageCache(index, this.getView(), this.getModel());
            Map<String, Object> singleEntryMap = MatchingRuleOutHelper.getInsertEntryInfo(lotintracksSet, qty, paramsMap, orderByRule, false, formId, matchFirstFieldMap, this.getView(), isUseLotMF);
            entryInfoList.add(singleEntryMap);
        }
        this.dealWithEntry(entryInfoList, ruleList, after, formId);
    }

    private String matchingRuleOutValidate(DynamicObject entry, int index, String rule, String formId, boolean after) {
        DynamicObject material = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"material"));
        DynamicObject unit = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"unit"));
        BigDecimal qty = entry.getBigDecimal(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"qty"));
        DynamicObject invtype = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"invtype"));
        DynamicObject invstatus = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"invstatus"));
        Object ownertype = entry.get(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"ownertype"));
        DynamicObject owner = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"owner"));
        Object keepertype = entry.get(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"keepertype"));
        DynamicObject keeper = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"keeper"));
        StringBuilder alertMsg = new StringBuilder();
        if (null == material || null == unit || BigDecimal.ZERO.compareTo(qty) == 0 || null == invtype || null == invstatus || null == ownertype || null == owner || null == keepertype || null == keeper) {
            if (null == material) {
                alertMsg.append(ResManager.loadKDString((String)"\u7269\u6599", (String)"ImBillEditPlugin_18", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == unit) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ImBillEditPlugin_19", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"ImBillEditPlugin_20", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == invtype) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"ImBillEditPlugin_26", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == invstatus) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"ImBillEditPlugin_27", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == ownertype) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b", (String)"ImBillEditPlugin_28", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == owner) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b", (String)"ImBillEditPlugin_29", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == keepertype) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b", (String)"ImBillEditPlugin_30", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            if (null == keeper) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005", (String)"ImBillEditPlugin_31", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            alertMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IM-E-405635", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"ImBillEditPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1);
            alertMsg.insert(0, msg);
        }
        if (alertMsg.length() > 0) {
            return alertMsg.toString();
        }
        if (material == null) {
            return "";
        }
        return alertMsg.toString();
    }

    public void dealWithEntry(List<Map<String, Object>> insertEntryInfo, List<String> ruleList, boolean after, String formId) {
        Boolean isEnough = Boolean.TRUE;
        int index = 0;
        EntryGrid control = (EntryGrid)this.getControl(TransformBillTplEntryConst.getEntryByBillType((String)formId, (Boolean)after));
        int[] selectRows = control.getSelectRows();
        BigDecimal remainQty = BigDecimal.ZERO;
        int selectRowIndex = 0;
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        StringBuilder alertMsg = new StringBuilder();
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            index = selectRows[selectRowIndex];
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            if (insertEntry.isEmpty()) {
                ++selectRowIndex;
                continue;
            }
            BigDecimal qty = (BigDecimal)insertEntry.get("qty");
            BigDecimal invaccCounts = (BigDecimal)insertEntry.get("count");
            String materialName = (String)insertEntry.get("materialName");
            Integer precision = (Integer)insertEntry.get("precision");
            if (BigDecimal.ZERO.compareTo(invaccCounts) == 0) {
                Boolean matched = (Boolean)insertEntry.get("matched");
                String msg = matched != false ? String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599,\u5e93\u5b58\u8bb0\u5f55\u5747\u5df2\u88ab\u5339\u914d\u5b8c\uff0c\u65e0\u5269\u4f59\u53ef\u5339\u914d\u7684\u5e93\u5b58\u3002", (String)"ImBillEditPlugin_36", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1) : String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u7269\u6599\uff0c\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5206\u5f55\u6570\u636e\u548c\u5373\u65f6\u5e93\u5b58\u3002", (String)"IM-E-180737", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1);
                alertMsg.append(msg);
            } else if (qty.compareTo(invaccCounts) > 0) {
                isEnough = Boolean.FALSE;
                remainQty = qty.subtract(invaccCounts);
                if (precision != null) {
                    remainQty = remainQty.setScale((int)precision, 4);
                }
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                paramMap.put("index", index);
                paramMap.put("remainQty", remainQty);
                paramMap.put("materialName", materialName);
                paramList.add(paramMap);
            }
            ++selectRowIndex;
        }
        if (alertMsg.length() > 0) {
            this.getView().showErrorNotification(alertMsg.toString());
            MatchingRuleOutHelper.resetMatchInfoPageCache(this.getView());
            return;
        }
        if (!isEnough.booleanValue()) {
            this.showConfirm(insertEntryInfo, paramList, ruleList);
        } else {
            this.insertEntry(insertEntryInfo, after, formId);
        }
    }

    private Map<String, Object> buildFilterParams(DynamicObject entry, boolean after, String formId) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        DynamicObject materialInvInfo = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"material"));
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        DynamicObject warehouse = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"warehouse"));
        DynamicObject auxpty = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"auxpty"));
        DynamicObject baseunit = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"baseunit"));
        DynamicObject locaition = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"location"));
        DynamicObject outinvtype = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"invtype"));
        DynamicObject outinvstatus = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"invstatus"));
        Object ownertype = entry.get(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"ownertype"));
        DynamicObject owner = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"owner"));
        Object keepertype = entry.get(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"keepertype"));
        DynamicObject keeper = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"keeper"));
        DynamicObject project = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"project"));
        DynamicObject configuredcode = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"configuredcode"));
        DynamicObject tracknumber = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"tracknumber"));
        DynamicObject unit = entry.getDynamicObject(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"unit"));
        String entryNoUpdateFieldValue = entry.getString(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"noupdateinvfields"));
        List<String> entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
        paramsMap.put("material", null == material ? Integer.valueOf(0) : material.getPkValue());
        paramsMap.put("invstatus", null == outinvstatus ? Integer.valueOf(0) : outinvstatus.getPkValue());
        paramsMap.put("baseunit", null == baseunit ? Integer.valueOf(0) : baseunit.getPkValue());
        paramsMap.put("unit", null == unit ? Integer.valueOf(0) : unit.getPkValue());
        if (null != auxpty) {
            paramsMap.put("auxpty", auxpty.getPkValue());
        }
        if (null != warehouse) {
            paramsMap.put("warehouse", warehouse.getPkValue());
        }
        if (null != locaition) {
            paramsMap.put("location", locaition.getPkValue());
        }
        if (!entryNoUpdateFieldValueList.contains(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"project")) && null != project) {
            paramsMap.put("project", project.getPkValue());
        }
        if (!entryNoUpdateFieldValueList.contains(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"tracknumber")) && null != tracknumber) {
            paramsMap.put("tracknumber", tracknumber.getPkValue());
        }
        if (null != configuredcode) {
            paramsMap.put("configuredcode", configuredcode.getPkValue());
        }
        paramsMap.put("invtype", null == outinvtype ? Integer.valueOf(0) : outinvtype.getPkValue());
        paramsMap.put("ownertype", ownertype);
        paramsMap.put("owner", null == owner ? Integer.valueOf(0) : owner.getPkValue());
        paramsMap.put("keeper", null == keeper ? Integer.valueOf(0) : keeper.getPkValue());
        paramsMap.put("keepertype", null == keepertype ? Integer.valueOf(0) : keepertype);
        return paramsMap;
    }

    private void showConfirm(List<Map<String, Object>> entryInfoList, List<Map<String, Object>> paramList, List<String> ruleList) {
        if (null != entryInfoList) {
            StringBuilder detailMsg = new StringBuilder();
            for (int i = 0; i < paramList.size(); ++i) {
                Map<String, Object> map = paramList.get(i);
                int index = (Integer)map.get("index");
                BigDecimal remainQty = (BigDecimal)map.get("remainQty");
                String materialName = (String)map.get("materialName");
                String outRule = MatchingRuleOutHelper.getOutRule(ruleList.get(i));
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s %3$s\u201d\uff0c\u6570\u91cf\u4e0d\u8db3\uff1a%4$s\u3002", (String)"ImBillEditPlugin_17", (String)"scmc-im-formplugin", (Object[])new Object[0]), index + 1, materialName, outRule, remainQty);
                detailMsg.append(msg);
            }
            ConfirmCallBackListener cb = new ConfirmCallBackListener("bar_matchingrule", (IFormPlugin)this.getPlugin());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\u5e93\u5b58\u4e0d\u8db3\uff0c\u662f\u5426\u6309\u73b0\u6709\u5e93\u5b58\u5339\u914d\uff1f", (String)"ImBillEditPlugin_15", (String)"scmc-im-formplugin", (Object[])new Object[0]), detailMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(entryInfoList));
        }
    }

    public void insertEntry(List<Map<String, Object>> insertEntryInfo, boolean after, String formId) {
        IDataModel model = this.getModel();
        ArrayList<Map<Object, Object>> confirmList = new ArrayList<Map<Object, Object>>(16);
        int entryIndex = 0;
        String entryKey = TransformBillTplEntryConst.getEntryByBillType((String)formId, (Boolean)after);
        EntryGrid control = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = control.getSelectRows();
        int selectRowIndex = 0;
        int addRow = 0;
        ArrayList<Map<String, Object>> returnRows = new ArrayList<Map<String, Object>>(insertEntryInfo.size());
        for (int i = 0; i < insertEntryInfo.size(); ++i) {
            Map<String, Object> insertEntry = insertEntryInfo.get(i);
            HashMap<String, Integer> returnRow = new HashMap<String, Integer>(2);
            if (insertEntry.isEmpty()) {
                returnRow.put("returnRowIndex", selectRows[selectRowIndex] + addRow);
                returnRow.put("returnRowNums", 0);
                returnRows.add(returnRow);
                ++selectRowIndex;
                continue;
            }
            int index = selectRows[selectRowIndex] + addRow;
            List entryInfoList = (List)insertEntry.get("entryInfo");
            int size = entryInfoList.size();
            entryIndex = index;
            for (int j = 0; j < size; ++j) {
                if (j != 0) {
                    model.beginInit();
                    this.getModel().insertEntryRow(entryKey, entryIndex);
                    model.endInit();
                    ++addRow;
                }
                Map map = (Map)entryInfoList.get(j);
                Long entryId = formId.equals("im_assembbill") ? (Long)((DynamicObject)model.getEntryEntity(entryKey).get(entryIndex)).getPkValue() : (Long)((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryKey).get(entryIndex)).getPkValue();
                if (null == entryId || entryId.equals(0L)) {
                    entryId = (Long)map.get("entryId");
                    if (formId.equals("im_assembbill")) {
                        ((DynamicObject)model.getEntryEntity(entryKey).get(entryIndex)).set("id", (Object)entryId);
                    } else {
                        ((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection(entryKey).get(entryIndex)).set("id", (Object)entryId);
                    }
                } else {
                    MatchingRuleOutHelper.transformCache(entryId, (Long)map.get("entryId"), this.getView());
                }
                this.insertSingleEntry(map, after, entryIndex, model, formId, index);
                Date produceDate = this.parseDate((String)map.get("producedate"));
                Date expiryDate = this.parseDate((String)map.get("expirydate"));
                DynamicObject materialInvInfo = (DynamicObject)model.getValue(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"material"), entryIndex);
                String key = TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"expirydate");
                HashMap<String, Object> confirmMap = new HashMap<String, Object>(16);
                confirmMap.put("entryIndex", entryIndex);
                confirmMap.put("key", key);
                confirmMap.put("entryName", entryKey);
                confirmMap.put("materialInvInfo", materialInvInfo);
                confirmMap.put("oldExpiryDate", null);
                confirmMap.put("expiryDate", expiryDate);
                confirmMap.put("produceDate", produceDate);
                confirmList.add(confirmMap);
                BigDecimal qty = BigDecimal.valueOf(Double.parseDouble(map.get("qty").toString()));
                model.setValue(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"qty"), (Object)qty, entryIndex);
                ++entryIndex;
            }
            returnRow.put("returnRowIndex", index);
            returnRow.put("returnRowNums", size);
            returnRows.add(returnRow);
            ++selectRowIndex;
        }
        this.showExpiryDateConfirm(confirmList);
        MatchingRuleOutHelper.callMatchruleoutExpand(this.getView(), entryKey, returnRows);
        this.getView().updateView(entryKey);
    }

    private void insertSingleEntry(Map<String, Object> map, boolean after, int entryIndex, IDataModel model, String formId, int index) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        String entryName = this.getEntryName(formId);
        Map billentryFields = ((EntityType)dt.getAllEntities().get(entryName)).getFields();
        Set<String> invaccFields = map.keySet();
        for (Map.Entry entry : billentryFields.entrySet()) {
            String mapField = ((String)entry.getKey()).replace("1", "");
            String field = (String)entry.getKey();
            IFieldHandle fieldHandle = (IFieldHandle)entry.getValue();
            boolean copyable = fieldHandle.isCopyable();
            if (!copyable && !relatedList.contains(field)) continue;
            Object value = map.get(mapField);
            if (invaccFields.contains(mapField)) {
                String entryNoUpdateFieldValue = (String)model.getValue(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)after, (String)"noupdateinvfields"), index);
                List<String> entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
                if (entryNoUpdateFieldValueList.contains(field)) {
                    value = model.getValue(field, index);
                    this.setValue(field, value, entryIndex, false);
                    continue;
                }
                boolean isTriggerChangeEvent = true;
                if (null == value || "id".equals(mapField) || "qty".equals(mapField) || "baseqty".equals(mapField) || "qtyunit2nd".equals(mapField)) continue;
                if (mapField.equals("producedate") || mapField.equals("expirydate")) {
                    isTriggerChangeEvent = false;
                    value = this.parseDate((String)value);
                }
                if (mapField.equals("lotnumber")) {
                    isTriggerChangeEvent = false;
                }
                this.setValue(field, value, entryIndex, isTriggerChangeEvent);
                continue;
            }
            value = model.getValue(field, index);
            this.setValue(field, value, entryIndex, false);
        }
    }

    private Map<String, Object> getMatchFirstFieldMap(IDataModel model, int index, String formId) {
        Date expirydate;
        Date producedate;
        HashMap<String, Object> matchFirstFieldMap = new HashMap<String, Object>(4);
        String lotNumber = (String)model.getValue(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)false, (String)"lotnumber"), index);
        if (!"".equals(lotNumber)) {
            matchFirstFieldMap.put("lotnumber", lotNumber);
        }
        if (null != (producedate = (Date)model.getValue(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)false, (String)"producedate"), index))) {
            matchFirstFieldMap.put("producedate", producedate);
        }
        if (null != (expirydate = (Date)model.getValue(TransformBillTplEntryConst.getConstByBillType((String)formId, (Boolean)false, (String)"expirydate"), index))) {
            matchFirstFieldMap.put("expirydate", expirydate);
        }
        return matchFirstFieldMap;
    }

    private void showExpiryDateConfirm(List<Map<Object, Object>> confirmList) {
        StringBuilder alertMsg = new StringBuilder();
        ArrayList alertMsgList = new ArrayList(16);
        for (int i = 0; i < confirmList.size(); ++i) {
            Map<Object, Object> confirmMap = confirmList.get(i);
            int rowIndex = (Integer)confirmMap.get("entryIndex");
            String key = (String)confirmMap.get("key");
            String entryName = (String)confirmMap.get("entryName");
            DynamicObject materialInvInfo = (DynamicObject)confirmMap.get("materialInvInfo");
            Object oldExpiryDate = confirmMap.get("oldExpiryDate");
            Date newExpiryDate = (Date)confirmMap.get("expiryDate");
            Date producedate = (Date)confirmMap.get("produceDate");
            if (newExpiryDate == null) {
                return;
            }
            String billName = this.getModel().getDataEntityType().getName();
            boolean isOutBill = InvBillHelper.isOutEntry(billName, entryName);
            boolean isInBill = InvBillHelper.isInEntry(billName, entryName);
            String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
            int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
            int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
            int dateOfOverdue = 0;
            if (isOutBill && isInBill) {
                dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
            } else if (isOutBill) {
                dateOfOverdue = dateOfOverdueForOut;
            } else if (isInBill) {
                dateOfOverdue = dateOfOverdueForIn;
            }
            Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
            Date nowDate = new Date();
            boolean dateOver = nowDate.after(overdueDate);
            if (dateOver) {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                String dateStr = this.getDateStr(newExpiryDate);
                String oldDateStr = this.getDateStr((Date)oldExpiryDate);
                String producedateStr = this.getDateStr(producedate);
                params.put("newProduceDate", producedateStr);
                params.put("oldProduceDate", oldDateStr);
                params.put("newExpirydate", dateStr);
                params.put("index", rowIndex);
                params.put("changeKey", key);
                alertMsgList.add(params);
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImTransformBillEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), dateStr);
                alertMsg.append(msg);
                continue;
            }
            if ("expirydate".equals(key)) {
                this.setValue("producedate", producedate, rowIndex, false);
                continue;
            }
            this.setValue("producedate1", producedate, rowIndex, false);
        }
        if (alertMsg.length() > 0) {
            ConfirmCallBackListener cb = new ConfirmCallBackListener("expirydate", (IFormPlugin)this.getPlugin());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\u7269\u6599\u3002", (String)"ImBillPropChanged_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), alertMsg.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
    }

    private String getEntryName(String formId) {
        String entryName = "billentry";
        if ("im_assembbill".equals(formId)) {
            entryName = "afterentity";
        }
        return entryName;
    }
}

