/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.matchruleout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.matchruleout.DefaultMatchingRuleOutExpand;
import kd.sdk.scmc.im.extpoint.IInvMatchruleoutExpand;

public class MatchingRuleOutCallBack {
    private static final Set<String> relatedSet = new HashSet<String>(Arrays.asList("mainbillid", "mainbillentryid", "mainbillnumber", "mainbillentity", "srcbillid", "srcbillentryid", "srcbillnumber", "srcbillentity", "mainbillentryseq", "srcbillentryseq", "srcsysbillentryid", "srcsystem", "srcsysbillno", "srcsysbillid", "conbillentity", "conbillid", "conbillnumber", "conbillrownum", "conbillentryid", "kitproducttype", "kitproduct", "kittransfermodel", "kitpid", "pricemodel"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEntry(IFormView view, String formid, String entry, String operatekey, List<Integer> selectRows, List<Map<String, Object>> entryInfoList) {
        view.getFormShowParameter().setCustomParam("matchingrule", (Object)"1");
        List<String> copyFields = MatchingRuleOutCallBack.getCopyFields(formid, entry);
        IDataModel model = view.getModel();
        model.getDataEntity(true);
        String linkEntityKey = MatchingRuleOutCallBack.getEntryLinkEntityKey(formid, entry);
        boolean isDraw = MatchingRuleOutCallBack.isDrawByBOTP(model, entry, linkEntityKey);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entry);
        entryGrid.setStopUpdateCell(true);
        try {
            int entryIndex = 0;
            int selectRowIndex = 0;
            int addRow = 0;
            ArrayList<Map<String, Object>> returnRows = new ArrayList<Map<String, Object>>(entryInfoList.size());
            for (int i = 0; i < entryInfoList.size(); ++i) {
                Map<String, Object> entryInfoMap = entryInfoList.get(i);
                if (entryInfoMap.isEmpty()) {
                    ++selectRowIndex;
                    continue;
                }
                String qtyCol = (String)entryInfoMap.get("qtyCol");
                boolean isUseAuxQty = (Boolean)entryInfoMap.get("isUseAuxQty");
                String dQtyCol = (String)entryInfoMap.get("dQtyCol");
                BigDecimal qty = BigDecimal.ZERO;
                if (entryInfoMap.get("qty") != null) {
                    qty = new BigDecimal(entryInfoMap.get("qty").toString());
                }
                HashMap<String, Object> returnRow = new HashMap<String, Object>(5);
                returnRow.put("qtyCol", qtyCol);
                returnRow.put("qty", qty);
                if (entryInfoMap.isEmpty()) {
                    returnRow.put("returnRowIndex", selectRows.get(selectRowIndex) + addRow);
                    returnRow.put("returnRowNums", 0);
                    returnRow.put("expandNeedFieldValues", Collections.emptyMap());
                    returnRows.add(returnRow);
                    ++selectRowIndex;
                    continue;
                }
                int index = selectRows.get(selectRowIndex) + addRow;
                List singleEntryInfoList = (List)entryInfoMap.get("entryInfo");
                int size = singleEntryInfoList.size();
                DynamicObjectCollection srcEntryLks = null;
                if (isDraw) {
                    srcEntryLks = MatchingRuleOutCallBack.getSrcRowRelation(model, entry, index, linkEntityKey);
                }
                Boolean saveshortageRow = (Boolean)entryInfoMap.get("saveshortagerow");
                BigDecimal plusQty = new BigDecimal(entryInfoMap.get("plusQty").toString());
                boolean needPlusqtyRow = saveshortageRow != false && size > 0 && plusQty.compareTo(BigDecimal.ZERO) > 0;
                DynamicObject shortageEntryDyn = null;
                if (needPlusqtyRow) {
                    DynamicObject backSelectEntryDyn = (DynamicObject)model.getEntryEntity(entry).get(index);
                    shortageEntryDyn = (DynamicObject)OrmUtils.clone((IDataEntityBase)backSelectEntryDyn, (boolean)false, (boolean)true);
                } else if (plusQty.compareTo(qty) == 0) {
                    model.setValue(qtyCol, (Object)BigDecimal.ZERO, index);
                    if (isUseAuxQty && !StringUtils.isEmpty((CharSequence)dQtyCol)) {
                        model.setValue(dQtyCol, (Object)BigDecimal.ZERO, index);
                    }
                    returnRow.put("qty", qty.compareTo(plusQty) == 0 ? BigDecimal.ZERO : qty);
                }
                entryIndex = index;
                for (int j = 0; j < size; ++j) {
                    if (j != 0) {
                        model.beginInit();
                        model.insertEntryRow(entry, entryIndex);
                        if (isDraw) {
                            MatchingRuleOutCallBack.copyEntryRelation(model, entry, linkEntityKey, entryIndex, srcEntryLks);
                        }
                        model.endInit();
                        ++addRow;
                    }
                    Map entryMap = (Map)singleEntryInfoList.get(j);
                    DynamicObject entryDyn = (DynamicObject)model.getEntryEntity(entry).get(entryIndex);
                    Long entryId = (Long)entryDyn.getPkValue();
                    if (null == entryId || entryId.equals(0L)) {
                        entryId = (Long)entryMap.get("entryId");
                        entryDyn.set("id", (Object)entryId);
                    }
                    MatchingRuleOutCallBack.handleSingleEntry(model, index, entryIndex, entryMap, copyFields, qtyCol);
                    ++entryIndex;
                }
                if (needPlusqtyRow) {
                    model.beginInit();
                    model.insertEntryRow(entry, entryIndex);
                    if (isDraw) {
                        MatchingRuleOutCallBack.copyEntryRelation(model, entry, linkEntityKey, entryIndex, srcEntryLks);
                    }
                    model.endInit();
                    ++addRow;
                    MatchingRuleOutCallBack.handleShortageEntry(formid, entry, model, shortageEntryDyn, entryIndex, qtyCol, plusQty, isUseAuxQty);
                }
                returnRow.put("returnRowIndex", index);
                returnRow.put("returnRowNums", needPlusqtyRow ? size + 1 : size);
                returnRow.put("expandNeedFieldValues", entryInfoMap.get("expandNeedFieldValues"));
                returnRows.add(returnRow);
                ++selectRowIndex;
            }
            view.getPageCache().put("CheckDataChange", "true");
            MatchingRuleOutCallBack.callMatchruleoutExpand(view, entry, returnRows);
        }
        finally {
            entryGrid.setStopUpdateCell(false);
        }
        view.updateView(entry);
    }

    private static List<String> getCopyFields(String formid, String entry) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formid);
        Map entryFields = ((EntityType)entityType.getAllEntities().get(entry)).getFields();
        ArrayList<String> copyFields = new ArrayList<String>(entryFields.size());
        for (Map.Entry entryField : entryFields.entrySet()) {
            String field = (String)entryField.getKey();
            IFieldHandle fieldHandle = (IFieldHandle)entryField.getValue();
            boolean copyable = fieldHandle.isCopyable();
            if (!relatedSet.contains(field) && !copyable) continue;
            copyFields.add(field);
        }
        return copyFields;
    }

    private static void handleSingleEntry(IDataModel model, int index, int entryIndex, Map<String, Object> entryMap, List<String> copyFields, String qtyCol) {
        for (Map.Entry<String, Object> entryAttr : entryMap.entrySet()) {
            String entryKey = entryAttr.getKey();
            if ("entryId".equals(entryKey) || "invaccId".equals(entryKey) || qtyCol.equals(entryKey)) continue;
            Object entryValue = entryAttr.getValue();
            MatchingRuleOutCallBack.setValue(model, entryKey, entryValue, entryIndex, false);
        }
        if (index != entryIndex) {
            for (String copyField : copyFields) {
                if (entryMap.containsKey(copyField)) continue;
                Object entryValue = model.getValue(copyField, index);
                MatchingRuleOutCallBack.setValue(model, copyField, entryValue, entryIndex, false);
            }
        }
        BigDecimal qty = new BigDecimal(entryMap.get(qtyCol).toString());
        MatchingRuleOutCallBack.setValue(model, qtyCol, qty, entryIndex, true);
    }

    private static void handleShortageEntry(String formid, String entry, IDataModel model, DynamicObject shortageEntryDyn, int entryIndex, String qtyCol, BigDecimal plusQty, boolean isUseAuxQty) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formid);
        Map entryFields = ((EntityType)entityType.getAllEntities().get(entry)).getFields();
        for (String field : entryFields.keySet()) {
            if (!shortageEntryDyn.containsProperty(field)) continue;
            MatchingRuleOutCallBack.setValue(model, field, shortageEntryDyn.get(field), entryIndex, false);
        }
        MatchingRuleOutCallBack.setValue(model, qtyCol, plusQty, entryIndex, true);
    }

    private static boolean isDrawByBOTP(IDataModel model, String entrykey, String linkEntityKey) {
        DynamicObjectCollection entrys = model.getEntryEntity(entrykey);
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)model.getDataEntityType().getName());
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        IDataEntityProperty dataEntityProperty = model.getDataEntityType().findProperty(linkEntityKey);
        if (dataEntityProperty == null) {
            return false;
        }
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static String getEntryLinkEntityKey(String formid, String entrykey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formid);
        Map allEntities = mainType.getAllEntities();
        for (EntityType entity : allEntities.values()) {
            if (!(entity instanceof LinkEntryType) || !entrykey.equals(entity.getParent().getName())) continue;
            return entity.getName();
        }
        return "";
    }

    private static DynamicObjectCollection getSrcRowRelation(IDataModel model, String entrykey, int index, String linkEntityKey) {
        DynamicObjectCollection entrys = model.getEntryEntity(entrykey);
        DynamicObject srcEntry = (DynamicObject)entrys.get(index);
        return srcEntry.getDynamicObjectCollection(linkEntityKey);
    }

    private static void copyEntryRelation(IDataModel model, String entrykey, String entrykey_lk, int entryIndex, DynamicObjectCollection srcEntryLks) {
        if (srcEntryLks == null || srcEntryLks.isEmpty()) {
            return;
        }
        DynamicObject entry = (DynamicObject)model.getEntryEntity(entrykey).get(entryIndex);
        DynamicObjectCollection newEntryLk = entry.getDynamicObjectCollection(entrykey_lk);
        for (DynamicObject srcEntryLk : srcEntryLks) {
            DynamicObject newLk = new DynamicObject(srcEntryLk.getDynamicObjectType());
            newLk.set("seq", srcEntryLk.get("seq"));
            newLk.set(entrykey_lk + "_stableid", srcEntryLk.get(entrykey_lk + "_stableid"));
            newLk.set(entrykey_lk + "_sbillid", srcEntryLk.get(entrykey_lk + "_sbillid"));
            newLk.set(entrykey_lk + "_sid", srcEntryLk.get(entrykey_lk + "_sid"));
            newEntryLk.add((Object)newLk);
        }
    }

    private static void callMatchruleoutExpand(IFormView view, String entrykey, List<Map<String, Object>> returnRows) {
        PluginProxy pluginProxy = PluginProxy.create((Object)new DefaultMatchingRuleOutExpand(), IInvMatchruleoutExpand.class, (String)"SCMC_IM_INV_MATCHRULEOUT");
        pluginProxy.callAfter(p -> {
            p.handleAfter(view, entrykey, returnRows);
            return null;
        });
    }

    private static void setValue(IDataModel model, String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue(model, key, value, i, isTriggerChangeEvent);
    }
}

