/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper.settle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SettleBillHelper {
    public static Map<Long, Map<String, HashSet<Long>>> getGenerateSettleBills(List<Long> billids) {
        DynamicObject[] logs = SettleBillHelper.getSuccessLogByBillIds(billids);
        HashMap<Long, Map<String, HashSet<Long>>> settleBills = new HashMap<Long, Map<String, HashSet<Long>>>(16);
        if (logs == null || logs.length == 0) {
            return settleBills;
        }
        for (DynamicObject log : logs) {
            long srcbillId = log.getLong("sourceid");
            DynamicObjectCollection detail = log.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : detail) {
                HashSet<Long> settleBillIds;
                Long settlebillid = entry.getLong("settlebillid");
                if (settlebillid == null || settlebillid.equals(0L)) continue;
                String billNumber = entry.getDynamicObject("settlebilltype").getString("number");
                HashMap<String, HashSet<Long>> billSettleBills = (HashMap<String, HashSet<Long>>)settleBills.get(srcbillId);
                if (billSettleBills == null) {
                    billSettleBills = new HashMap<String, HashSet<Long>>(16);
                    settleBills.put(srcbillId, billSettleBills);
                }
                if ((settleBillIds = (HashSet<Long>)billSettleBills.get(billNumber)) == null) {
                    settleBillIds = new HashSet<Long>(billids.size());
                    billSettleBills.put(billNumber, settleBillIds);
                }
                settleBillIds.add(settlebillid);
            }
        }
        return settleBills;
    }

    private static DynamicObject[] getSuccessLogByBillIds(List<Long> billIds) {
        QFilter f = new QFilter("sourceid", "in", billIds);
        String fieldKeyes = "createstatus,entryentity.settlebillid,entryentity.settlebilltype,sourceid";
        DynamicObject[] settleLogs = BusinessDataServiceHelper.load((String)"ism_settlelog", (String)fieldKeyes, (QFilter[])f.toArray());
        return settleLogs;
    }
}

