/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.business.service.InspectInvSchemeService;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.MFTProOrderInvSchemeService;
import kd.scmc.im.business.service.MReqOutInvSchemeService;
import kd.scmc.im.business.service.ManuinInvSchemeService;
import kd.scmc.im.business.service.OmInInvSchemeService;
import kd.scmc.im.business.service.OtherInInvSchemeService;
import kd.scmc.im.business.service.OtherOutInvSchemeService;
import kd.scmc.im.business.service.ProductInvSchemeService;
import kd.scmc.im.business.service.PurInInvSchemeService;
import kd.scmc.im.business.service.PurReceInvSchemeService;
import kd.scmc.im.business.service.SaleOutInvSchemeService;
import kd.scmc.im.business.service.TransInvSchemeService;
import org.apache.commons.lang3.StringUtils;

public class InvSchemeServiceFactory {
    public static InvSchemeService getService(DynamicObject order) {
        if (order == null) {
            return null;
        }
        String entryName = order.getDataEntityType().getName();
        return InvSchemeServiceFactory.getService(entryName, order);
    }

    public static InvSchemeService getService(IFormView view) {
        String formId = view.getFormShowParameter().getFormConfig().getEntityTypeId();
        return InvSchemeServiceFactory.getService(formId, view);
    }

    public static InvSchemeService getService(String entryName, IFormView view) {
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return null;
        }
        entryName = view.getModel().getDataEntityType().getName();
        AbstractSchemeService service = null;
        switch (entryName) {
            case "im_saloutbill": {
                service = new SaleOutInvSchemeService(view);
                break;
            }
            case "im_purinbill": 
            case "im_mdc_omcmplinbill": 
            case "im_ospurinbill": {
                service = new PurInInvSchemeService(view);
                break;
            }
            case "im_transdirbill": 
            case "im_transinbill": 
            case "im_transoutbill": {
                service = new TransInvSchemeService(view);
                break;
            }
            case "im_purreceivebill": {
                service = new PurReceInvSchemeService(view);
                break;
            }
            case "im_invinspectbill": {
                service = new InspectInvSchemeService(view);
                break;
            }
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                service = new MReqOutInvSchemeService(view);
                break;
            }
            case "im_otheroutbill": {
                service = new OtherOutInvSchemeService(view);
                break;
            }
            case "im_otherinbill": {
                service = new OtherInInvSchemeService(view);
                break;
            }
            case "im_mdc_mftreturnorder": 
            case "im_mdc_mftfeedorder": 
            case "im_mdc_mftproorder": 
            case "im_mdc_omproorder": 
            case "im_mdc_omfeedorder": 
            case "im_mdc_omreturnorder": 
            case "im_mdc_omoutbill": 
            case "im_mdc_omfeedbill": 
            case "im_mdc_omreturnbill": {
                service = new MFTProOrderInvSchemeService(view);
                break;
            }
            case "im_mdc_mftmanuinbill": 
            case "im_mdc_mftreturnbill": {
                service = new ManuinInvSchemeService(view);
                break;
            }
            case "im_productinbill": {
                service = new ProductInvSchemeService(view);
                break;
            }
            case "im_mdc_ominbill": {
                service = new OmInInvSchemeService(view);
                break;
            }
        }
        return service;
    }

    public static InvSchemeService getService(String entryName) {
        AbstractSchemeService service = null;
        switch (entryName) {
            case "im_saloutbill": {
                service = new SaleOutInvSchemeService();
                break;
            }
            case "im_purinbill": 
            case "im_mdc_omcmplinbill": 
            case "im_ospurinbill": {
                service = new PurInInvSchemeService();
                break;
            }
            case "im_transdirbill": 
            case "im_transinbill": 
            case "im_transoutbill": {
                service = new TransInvSchemeService();
                break;
            }
            case "im_purreceivebill": {
                service = new PurReceInvSchemeService();
                break;
            }
            case "im_invinspectbill": {
                service = new InspectInvSchemeService();
                break;
            }
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                service = new MReqOutInvSchemeService();
                break;
            }
            case "im_otheroutbill": {
                service = new OtherOutInvSchemeService();
                break;
            }
            case "im_otherinbill": {
                service = new OtherInInvSchemeService();
                break;
            }
            case "im_mdc_mftreturnorder": 
            case "im_mdc_mftfeedorder": 
            case "im_mdc_mftproorder": 
            case "im_mdc_omproorder": 
            case "im_mdc_omfeedorder": 
            case "im_mdc_omreturnorder": 
            case "im_mdc_omoutbill": 
            case "im_mdc_omfeedbill": 
            case "im_mdc_omreturnbill": {
                service = new MFTProOrderInvSchemeService();
                break;
            }
            case "im_mdc_mftmanuinbill": 
            case "im_mdc_mftreturnbill": {
                service = new ManuinInvSchemeService();
                break;
            }
            case "im_productinbill": {
                service = new ProductInvSchemeService();
                break;
            }
            case "im_mdc_ominbill": {
                service = new OmInInvSchemeService();
                break;
            }
        }
        return service;
    }

    public static InvSchemeService getService(String entryName, DynamicObject bill) {
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return null;
        }
        AbstractSchemeService service = null;
        switch (entryName) {
            case "im_saloutbill": {
                service = new SaleOutInvSchemeService(bill);
                break;
            }
            case "im_purinbill": 
            case "im_mdc_omcmplinbill": 
            case "im_ospurinbill": {
                service = new PurInInvSchemeService(bill);
                break;
            }
            case "im_transdirbill": 
            case "im_transinbill": 
            case "im_transoutbill": {
                service = new TransInvSchemeService(bill);
                break;
            }
            case "im_purreceivebill": {
                service = new PurReceInvSchemeService(bill);
                break;
            }
            case "im_invinspectbill": {
                service = new InspectInvSchemeService(bill);
                break;
            }
            case "im_materialreqoutbill": 
            case "im_osmaterialreqoutbill": {
                service = new MReqOutInvSchemeService(bill);
                break;
            }
            case "im_otherinbill": {
                service = new OtherInInvSchemeService(bill);
                break;
            }
            case "im_otheroutbill": {
                service = new OtherOutInvSchemeService(bill);
                break;
            }
            case "im_mdc_ominbill": {
                service = new OmInInvSchemeService(bill);
                break;
            }
            case "im_mdc_mftmanuinbill": 
            case "im_mdc_mftreturnbill": {
                service = new ManuinInvSchemeService(bill);
                break;
            }
            case "im_mdc_mftproorder": 
            case "im_mdc_mftfeedorder": 
            case "im_mdc_mftreturnorder": 
            case "im_mdc_omproorder": 
            case "im_mdc_omfeedorder": 
            case "im_mdc_omreturnorder": 
            case "im_mdc_omoutbill": 
            case "im_mdc_omfeedbill": 
            case "im_mdc_omreturnbill": {
                service = new MFTProOrderInvSchemeService(bill);
                break;
            }
            case "im_productinbill": {
                service = new ProductInvSchemeService(bill);
                break;
            }
        }
        return service;
    }
}

