/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class OmInInvSchemeService
extends AbstractSchemeService {
    public OmInInvSchemeService() {
    }

    public OmInInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public OmInInvSchemeService(IFormView view) {
        super(view);
    }

    @Override
    public Object getDefalutOwner(String type, int i) {
        Long owner = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return owner;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject reqOrg = (DynamicObject)this.getValue("entryreqorg", i);
                if (reqOrg == null) break;
                owner = this.getCompanyByOrg((Long)reqOrg.getPkValue());
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                DynamicObject supplier = (DynamicObject)this.getValue("supplier");
                if (supplier == null) break;
                owner = (Long)supplier.getPkValue();
                break;
            }
        }
        return owner;
    }

    @Override
    public Object getDefalutKeeper(String type, int rowIndex) {
        Long keeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return keeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                keeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                DynamicObject supplier = (DynamicObject)this.getValue("supplier");
                if (supplier == null) break;
                keeperId = (Long)supplier.getPkValue();
                break;
            }
        }
        return keeperId;
    }

    @Override
    public Object getDefalutOutOwner(String type, int rowIndex) {
        Object outOwnerId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return outOwnerId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                outOwnerId = org.getPkValue();
                ArrayList<Object> orgIds = OwnerHelper.getOwners(Long.parseLong(org.getPkValue().toString()));
                if (orgIds == null || orgIds.size() <= 0) break;
                outOwnerId = orgIds.get(0);
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                DynamicObject supplier = (DynamicObject)this.getValue("supplier");
                if (supplier == null) break;
                outOwnerId = supplier.getPkValue();
                break;
            }
        }
        return outOwnerId;
    }

    @Override
    public Object getDefalutOutKeeper(String type, int i) {
        Long outKeeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return outKeeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                outKeeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                break;
            }
            case "bd_supplier": {
                DynamicObject supplier = (DynamicObject)this.getValue("supplier");
                if (supplier == null) break;
                outKeeperId = (Long)supplier.getPkValue();
                break;
            }
        }
        return outKeeperId;
    }

    @Override
    public void setOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter f = null;
        String type = (String)this.getValue("ownertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList(org));
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setKeeperF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("keepertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outownertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList(org));
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutKeeperF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outkeepertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    @Override
    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }

    @Override
    public void setOutOwnerEnable(int rowIndex) {
        String outOwnerType = (String)this.getValue("outownertype", rowIndex);
        this.setOutOwnerEnable(rowIndex, outOwnerType);
    }

    @Override
    public void setOutOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String outOwnerType = entry.getString("outownertype");
        this.setOutOwnerEnable(rowIndex, outOwnerType);
    }

    private void setOutOwnerEnable(int rowIndex, String outOwnerType) {
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"outowner"});
            return;
        }
        switch (outOwnerType) {
            case "bos_org": 
            case "bd_customer": 
            case "bd_supplier": {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"outowner"});
                break;
            }
        }
    }

    @Override
    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    @Override
    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    @Override
    public void setOwnerEnable(int rowIndex) {
        String ownerType = (String)this.getValue("ownertype", rowIndex);
        this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("ownertype");
        this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
    }
}

