/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class SaleOutInvSchemeService
extends AbstractSchemeService {
    private Long defOwnerOrgId = null;

    public SaleOutInvSchemeService() {
    }

    public SaleOutInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public SaleOutInvSchemeService(IFormView view) {
        super(view);
    }

    @Override
    public Object getDefalutOwner(String type, int i) {
        Object ownerId = null;
        DynamicObject outowner = (DynamicObject)this.getValue("outowner", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return ownerId;
        }
        switch (type) {
            case "bos_org": {
                if (outowner == null) break;
                ownerId = outowner.getPkValue();
                break;
            }
            case "bd_customer": {
                DynamicObject customer = (DynamicObject)this.getValue("customer");
                if (customer == null) break;
                ownerId = customer.getPkValue();
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return ownerId;
    }

    @Override
    public Object getDefalutKeeper(String type, int i) {
        Object keeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return keeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                keeperId = org.getPkValue();
                break;
            }
            case "bd_customer": {
                DynamicObject customer = (DynamicObject)this.getValue("customer");
                if (customer == null) break;
                keeperId = customer.getPkValue();
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return keeperId;
    }

    @Override
    public Object getDefalutOutOwner(String type, int rowIndex) {
        Long ownerId = null;
        String outOwnerType = (String)this.getValue("outownertype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            return ownerId;
        }
        switch (outOwnerType) {
            case "bos_org": {
                if (this.defOwnerOrgId == null) {
                    this.initDefOwnerOrgId();
                }
                if (this.defOwnerOrgId.equals(0L)) break;
                ownerId = this.defOwnerOrgId;
                break;
            }
            case "bd_customer": {
                DynamicObject customer = (DynamicObject)this.getValue("customer");
                if (customer == null) break;
                ownerId = (Long)customer.getPkValue();
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return ownerId;
    }

    @Override
    public Object getDefalutOutKeeper(String type, int i) {
        Long keeperId = null;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return keeperId;
        }
        switch (type) {
            case "bos_org": {
                DynamicObject org = (DynamicObject)this.getValue("org");
                if (org == null) break;
                keeperId = (Long)org.getPkValue();
                break;
            }
            case "bd_customer": {
                DynamicObject customer = (DynamicObject)this.getValue("customer");
                if (customer == null) break;
                keeperId = (Long)customer.getPkValue();
                break;
            }
            case "bd_supplier": {
                break;
            }
        }
        return keeperId;
    }

    @Override
    public void setOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter f = null;
        String type = (String)this.getValue("ownertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList(org));
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setKeeperF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("keepertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutOwnerF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outownertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        DynamicObject bizType = (DynamicObject)this.getValue("biztype");
        switch (type) {
            case "bos_org": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                f = new QFilter("id", "in", this.getOwnerList((Long)org.getPkValue()));
                showParameter.setCustomParam("orgFuncId", (Object)"10");
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org == null) {
                    this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                    e.setCancel(true);
                    return;
                }
                if (bizType == null || !"6".equals(bizType.get("domain"))) break;
                f = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
                break;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutKeeperF7Select(BeforeF7SelectEvent e, int i) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String type = (String)this.getValue("outkeepertype", i);
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        QFilter f = null;
        DynamicObject org = (DynamicObject)this.getValue("org");
        switch (type) {
            case "bos_org": {
                f = new QFilter("id", "=", org == null ? null : org.getPkValue());
                break;
            }
            case "bd_customer": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
            case "bd_supplier": {
                if (org != null) break;
                this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG()));
                e.setCancel(true);
                return;
            }
        }
        showParameter.getListFilterParameter().setFilter(f);
    }

    @Override
    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    @Override
    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }

    @Override
    public void setOutOwnerEnable(int rowIndex) {
        String outOwnerType = (String)this.getValue("outownertype", rowIndex);
        this.setOwnerEnable(rowIndex, outOwnerType, "outowner");
    }

    @Override
    public void setOutOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String outOwnerType = entry.getString("outownertype");
        this.setOwnerEnable(rowIndex, outOwnerType, "outowner");
    }

    @Override
    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    @Override
    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    @Override
    public void setOwnerEnable(int rowIndex) {
        String ownerType = (String)this.getValue("ownertype", rowIndex);
        this.setOwnerEnable(rowIndex, ownerType, "owner");
    }

    @Override
    public void setOwnerEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("ownertype");
        this.setOwnerEnable(rowIndex, ownerType, "owner");
    }

    private void setOwnerEnable(int rowIndex, String keeperOwnerType, String keeperOwnerKey) {
        if (StringUtils.isEmpty((CharSequence)keeperOwnerType)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{keeperOwnerKey});
            return;
        }
        switch (keeperOwnerType) {
            case "bos_org": 
            case "bd_customer": 
            case "bd_supplier": {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{keeperOwnerKey});
                break;
            }
        }
    }

    private void initDefOwnerOrgId() {
        DynamicObject bizOrg = (DynamicObject)this.getValue("bizorg");
        DynamicObject orgDyc = (DynamicObject)this.getValue("org");
        if (bizOrg != null && orgDyc != null) {
            if (this.view != null) {
                String key = orgDyc.getString("id") + "$" + bizOrg.getString("id");
                String cacheOwnerId = this.view.getPageCache().get(key);
                if (StringUtils.isBlank((CharSequence)cacheOwnerId)) {
                    this.defOwnerOrgId = this.getDefaultOwner(orgDyc, bizOrg);
                    this.view.getPageCache().put(key, this.defOwnerOrgId == null ? "0" : this.defOwnerOrgId.toString());
                } else {
                    this.defOwnerOrgId = Long.parseLong(cacheOwnerId);
                }
            } else {
                this.defOwnerOrgId = this.getDefaultOwner(orgDyc, bizOrg);
            }
        }
        if (this.defOwnerOrgId == null) {
            this.defOwnerOrgId = 0L;
        }
    }
}

